/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.util.CharArrayCharSequence;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.model.Dependency;

class DependencyTextBufferListener
implements TextBufferListener {
    private static final Map<URL, DependencyTextBufferListener> listeners = new HashMap<URL, DependencyTextBufferListener>();
    private static final Log LOCK_LOG = new Log("status-lock");
    private URL file;
    private List<Dependency> dependencies = new ArrayList<Dependency>();
    private static final Log LOG;
    private boolean compoundEditInProgress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDependency(Dependency dependency, URL file) {
        DependencyTextBufferListener listener;
        Map<URL, DependencyTextBufferListener> map = listeners;
        synchronized (map) {
            listener = listeners.get(file);
            if (listener == null) {
                listener = new DependencyTextBufferListener(file);
                listeners.put(file, listener);
            }
        }
        listener.bind(file, dependency);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDependency(Dependency dependency, URL file) {
        boolean removed;
        DependencyTextBufferListener listener;
        Map<URL, DependencyTextBufferListener> map = listeners;
        synchronized (map) {
            listener = listeners.get(file);
        }
        if (listener != null && (removed = listener.unbind(file, dependency))) {
            Map<URL, DependencyTextBufferListener> map2 = listeners;
            synchronized (map2) {
                listeners.remove(file);
            }
        }
    }

    public DependencyTextBufferListener(URL file) {
        this.file = file;
    }

    public void nodeOpened(TextNode node) {
        LOG.trace("******** adding text buffer listener (node opening) {0}", (Object)this);
        node.addTextBufferListener((TextBufferListener)this);
    }

    public void nodeWillClose(TextNode node) {
        if (node.isDirty()) {
            this.fireDependencyChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean bind(URL file, Dependency dependency) {
        Node node;
        boolean added;
        DependencyTextBufferListener dependencyTextBufferListener = this;
        synchronized (dependencyTextBufferListener) {
            added = this.dependencies.isEmpty();
            this.dependencies.add(dependency);
        }
        if (added && (node = NodeFactory.find((URL)file)) instanceof TextNode && node.isOpen()) {
            node.runUnderReadLock(new Runnable(){

                @Override
                public void run() {
                    if (node.isOpen()) {
                        LOG.trace("******** adding text buffer listener (node open) {0}", (Object)this);
                        ((TextNode)node).addTextBufferListener((TextBufferListener)DependencyTextBufferListener.this);
                    }
                }
            });
        }
        return added;
    }

    private synchronized boolean unbind(URL file, Dependency dependency) {
        if (this.dependencies.remove(dependency) && this.dependencies.isEmpty()) {
            LOG.trace("******** removing text buffer listener {0}", (Object)this);
            Node node = NodeFactory.find((URL)file);
            if (node instanceof TextNode) {
                ((TextNode)node).removeTextBufferListener((TextBufferListener)this);
            }
            return true;
        }
        return false;
    }

    public void attributeUpdate(TextBuffer buffer, int attribute) {
        switch (attribute) {
            case 6: {
                this.compoundEditInProgress = true;
                break;
            }
            case 7: {
                this.compoundEditInProgress = false;
                this.fireDependencyChanged();
            }
        }
    }

    public void insertUpdate(TextBuffer buffer, int offset, int count, char[] text) {
        LOCK_LOG.trace("text inserted in {0}: \"{1}\"", (Object)this, (Object)new CharArrayCharSequence(text, 0, Math.min(count, 16)));
        if (!this.compoundEditInProgress) {
            this.fireDependencyChanged();
        }
    }

    public void removeUpdate(TextBuffer buffer, int offset, int count, char[] text) {
        LOCK_LOG.trace("text removed in {0}: \"{1}\"", (Object)this, (Object)new CharArrayCharSequence(text, 0, Math.min(count, 16)));
        if (!this.compoundEditInProgress) {
            this.fireDependencyChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDependencyChanged() {
        Dependency[] dependencyArray = this;
        synchronized (this) {
            Dependency[] array = this.dependencies.toArray(new Dependency[this.dependencies.size()]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (Dependency dependency : array) {
                dependency.fireDependencyChanged(true);
            }
            return;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + URLFileSystem.getFileName((URL)this.file);
    }

    static {
        Node.addNodeListenerForTypeHierarchy(TextNode.class, (NodeListener)new NodeListener(){

            public void nodeOpened(NodeEvent e) {
                TextNode node = (TextNode)e.getNode();
                DependencyTextBufferListener listener = listeners.get(node.getURL());
                if (listener != null) {
                    listener.nodeOpened(node);
                }
            }

            public void nodeWillClose(NodeEvent e) {
                DependencyTextBufferListener listener;
                TextNode node = (TextNode)e.getNode();
                if (node.isDirty() && (listener = listeners.get(node.getURL())) != null) {
                    listener.nodeWillClose(node);
                }
            }
        });
        LOG = new Log("dependency");
    }
}

