/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.javatools.util.NullArgumentException;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.analyzer.Severity;
import oracle.jdeveloper.audit.extension.BeanDefinition;
import oracle.jdeveloper.audit.extension.CategoryDefinition;
import oracle.jdeveloper.audit.extension.DefinitionContext;
import oracle.jdeveloper.audit.extension.ExtensionBean;
import oracle.jdeveloper.audit.extension.ExtensionBundle;
import oracle.jdeveloper.audit.extension.HasCategory;
import oracle.jdeveloper.audit.extension.HasTransformBindings;
import oracle.jdeveloper.audit.extension.ParameterDefinition;
import oracle.jdeveloper.audit.extension.TransformBinding;
import oracle.jdeveloper.audit.extension.Value;

public class RuleDefinition
extends BeanDefinition<Rule>
implements HasCategory,
HasTransformBindings {
    public static final String MESSAGE_KEY = "message";
    public static final String HTML_MESSAGE_KEY = "html-message";
    private CategoryDefinition category;
    private boolean mandatoryError;
    private Collection<ParameterDefinition> parameters = NO_PARAMETERS;
    private Collection<String> variations = NO_VARIATIONS;
    private Collection<TransformBinding<? extends BeanDefinition<? extends ExtensionBean>>> transformBindings = NO_BINDINGS;
    private Collection<String> suppressionIds = NO_IDS;
    private static final List<ParameterDefinition> NO_PARAMETERS = new ArrayList<ParameterDefinition>();
    private static final List<String> NO_VARIATIONS = new ArrayList<String>();
    private static final List<TransformBinding<? extends BeanDefinition<? extends ExtensionBean>>> NO_BINDINGS = new ArrayList<TransformBinding<? extends BeanDefinition<? extends ExtensionBean>>>();
    private static final List<String> NO_IDS = new ArrayList<String>();

    public RuleDefinition(String id, CategoryDefinition category, ExtensionBundle bundle, DefinitionContext context) {
        super(id, bundle, context);
        this.category = category;
    }

    @Override
    public Class<Rule> getDefaultImplementationClass() {
        return Rule.class;
    }

    @Override
    public CategoryDefinition getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(CategoryDefinition category) {
        this.category = category;
    }

    @Override
    public boolean hasEnabledProperty() {
        return true;
    }

    public Severity getSeverity() {
        if (this.mandatoryError) {
            return Severity.ERROR;
        }
        Value value = this.getValue("severity");
        if (value == null) {
            return Severity.ADVISORY;
        }
        Severity severity = Severity.valueOf(value.getText());
        if (severity == null) {
            severity = Severity.ADVISORY;
        }
        return severity;
    }

    public boolean isAssist() {
        return this.getSeverity() == Severity.ASSIST;
    }

    public void setSeverity(Severity severity) {
        this.setValue(new Value("severity", severity.toString(), new DefinitionContext(this.getExtensionId(), this)));
    }

    public Collection<ParameterDefinition> getParameters() {
        return this.parameters;
    }

    public void setParameters(Collection<ParameterDefinition> parameters) {
        if (parameters == null) {
            throw new NullArgumentException("parameters null");
        }
        if (this.parameters != NO_PARAMETERS) {
            throw new IllegalStateException("parameters already set");
        }
        this.parameters = parameters;
    }

    public Collection<String> getVariations() {
        return this.variations;
    }

    public void setVariations(Collection<String> variations) {
        if (variations == null) {
            throw new NullArgumentException("variations null");
        }
        if (this.variations != NO_VARIATIONS) {
            throw new IllegalStateException("variations already set");
        }
        this.variations = variations;
    }

    @Override
    public Collection<TransformBinding<? extends BeanDefinition<? extends ExtensionBean>>> getTransformBindings() {
        return this.transformBindings;
    }

    @Override
    public void addTransformBinding(TransformBinding<? extends BeanDefinition<? extends ExtensionBean>> binding) {
        if (this.transformBindings == NO_BINDINGS) {
            this.transformBindings = new ArrayList<TransformBinding<? extends BeanDefinition<? extends ExtensionBean>>>();
        }
        this.transformBindings.add(binding);
    }

    public boolean isMandatoryError() {
        return this.mandatoryError;
    }

    public void setMandatoryError(boolean mandatoryError) {
        if (this.mandatoryError && !mandatoryError) {
            throw new IllegalStateException("mandatoryError cannot be cleared once set");
        }
        this.mandatoryError = mandatoryError;
    }

    public Collection<String> getSuppressionIds() {
        return this.suppressionIds;
    }

    public void setSuppressionIds(Collection<String> suppressionIds) {
        if (suppressionIds == null) {
            throw new NullArgumentException("suppression ids null");
        }
        if (this.suppressionIds != NO_IDS) {
            throw new IllegalStateException("suppression ids already set");
        }
        this.suppressionIds = suppressionIds;
    }

    public String message(String variation) {
        String string = this.string(this.variationKey(MESSAGE_KEY, variation));
        if (string == null) {
            string = this.string(MESSAGE_KEY);
        }
        return string;
    }

    public String htmlMessage(String variation) {
        String message = this.string(this.variationKey(HTML_MESSAGE_KEY, variation));
        if (message == null) {
            message = this.string(this.variationKey(MESSAGE_KEY, variation));
        }
        if (message == null) {
            message = this.string(HTML_MESSAGE_KEY);
        }
        if (message == null) {
            message = this.string(MESSAGE_KEY);
        }
        if (message == null) {
            this.reportMissingString(MESSAGE_KEY);
        }
        return message;
    }

    public String[] messages() {
        ArrayList<String> list = new ArrayList<String>();
        String message = this.string(MESSAGE_KEY);
        if (message != null) {
            list.add(message);
        }
        for (String variation : this.variations) {
            message = this.string(this.variationKey(MESSAGE_KEY, variation));
            if (message == null) continue;
            list.add(message);
        }
        message = this.string(HTML_MESSAGE_KEY);
        if (message != null) {
            list.add(message);
        }
        for (String variation : this.variations) {
            message = this.string(this.variationKey(HTML_MESSAGE_KEY, variation));
            if (message == null) continue;
            list.add(message);
        }
        if (list.isEmpty()) {
            this.reportMissingString(MESSAGE_KEY);
        }
        return list.toArray(new String[list.size()]);
    }

    private String variationKey(String key, String variation) {
        return variation != null ? variation + "." + key : key;
    }
}

