/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.extension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.logging.Level;
import javax.ide.extension.DeferredElementVisitorHook;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.extension.ElementVisitorFactory2;
import javax.ide.extension.ExtensionDependency;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.UnrecognizedElementException;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.feature.Feature;
import oracle.ide.extension.feature.FeatureCategory;
import oracle.ide.extension.feature.FeatureRegistry;
import oracle.javatools.util.ArrayMap;
import oracle.javatools.util.ArraySortedSet;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.analyzer.Analyzer;
import oracle.jdeveloper.audit.analyzer.Severity;
import oracle.jdeveloper.audit.extension.AnalyzerDefinition;
import oracle.jdeveloper.audit.extension.BeanDefinition;
import oracle.jdeveloper.audit.extension.CategoryDefinition;
import oracle.jdeveloper.audit.extension.Condition;
import oracle.jdeveloper.audit.extension.ConverterDefinition;
import oracle.jdeveloper.audit.extension.Definition;
import oracle.jdeveloper.audit.extension.DefinitionContext;
import oracle.jdeveloper.audit.extension.ExtensionBean;
import oracle.jdeveloper.audit.extension.ExtensionBundle;
import oracle.jdeveloper.audit.extension.HasCategory;
import oracle.jdeveloper.audit.extension.HasTransformBindings;
import oracle.jdeveloper.audit.extension.MetricDefinition;
import oracle.jdeveloper.audit.extension.ModelDefinition;
import oracle.jdeveloper.audit.extension.ParameterDefinition;
import oracle.jdeveloper.audit.extension.ProfileDefinition;
import oracle.jdeveloper.audit.extension.RuleDefinition;
import oracle.jdeveloper.audit.extension.SuppressionSchemeDefinition;
import oracle.jdeveloper.audit.extension.TopLevelDefinition;
import oracle.jdeveloper.audit.extension.TransformBinding;
import oracle.jdeveloper.audit.extension.TransformDefinition;
import oracle.jdeveloper.audit.extension.Trigger;
import oracle.jdeveloper.audit.extension.TypeDefinition;
import oracle.jdeveloper.audit.extension.Value;
import oracle.jdeveloper.audit.model.ContentRootFactory;
import oracle.jdeveloper.audit.service.Converter;
import oracle.jdevimpl.audit.util.Strings;
import org.xml.sax.Locator;

public class AuditHook
extends ExtensionHook {
    private static volatile AuditHook hook;
    private final DefinitionScope<BeanDefinition<?>> extensionBeanDefinitions = new DefinitionScope();
    private final DefinitionScope<ProfileDefinition> profileDefinitions = new DefinitionScope();
    private final Map<String, ModelDefinition> modelDefinitions = new LinkedHashMap<String, ModelDefinition>();
    private String extensionId;
    private ClassLoader extensionClassLoader;
    private Set<String> extensionDependencies;
    private String hookId;
    private ExtensionBundle hookBundle;
    private final UnexpectedElementVisitor unexpectedElementVisitor = new UnexpectedElementVisitor();
    private final TextVisitor textVisitor = new TextVisitor();
    private final BundleVisitor bundleVisitor = new BundleVisitor();
    private final TriggerVisitor triggerVisitor = new TriggerVisitor();
    private final ProfileDefinitionVisitor profileDefinitionVisitor = new ProfileDefinitionVisitor(this.profileDefinitions);
    private final SuppressionAliasVisitor suppressionAliasVisitor = new SuppressionAliasVisitor(this.extensionBeanDefinitions);
    private final CategoryReferenceVisitor categoryReferenceVisitor = new CategoryReferenceVisitor(this.extensionBeanDefinitions);
    private final CategoryDefinitionVisitor<CategoryDefinition> categoryDefinitionVisitor = new CategoryDefinitionVisitor<CategoryDefinition>(CategoryDefinition.class, this.extensionBeanDefinitions, this.categoryReferenceVisitor);
    private final ModelDefinitionVisitor modelDefinitionVisitor = new ModelDefinitionVisitor(this.extensionBeanDefinitions, this.categoryReferenceVisitor);
    private final TransformDefinitionVisitor transformDefinitionVisitor = new TransformDefinitionVisitor(this.extensionBeanDefinitions);
    private final RuleDefinitionVisitor ruleDefinitionVisitor = new RuleDefinitionVisitor(this.extensionBeanDefinitions, this.categoryReferenceVisitor);
    private final SchemeDefinitionVisitor schemeDefinitionVisitor = new SchemeDefinitionVisitor(this.extensionBeanDefinitions, this.categoryReferenceVisitor);
    private final TransformBindingVisitor transformBindingVisitor = new TransformBindingVisitor(this.extensionBeanDefinitions);
    private final MetricDefinitionVisitor metricDefinitionVisitor = new MetricDefinitionVisitor(this.extensionBeanDefinitions, this.categoryReferenceVisitor);
    private AnalyzerDefinitionVisitor analyzerDefinitionVisitor = new AnalyzerDefinitionVisitor();
    private TypesDefinitionVisitor<ContentRootFactory> rootFactoryDefinitionVisitor = new TypesDefinitionVisitor();
    private ConverterDefinitionVisitor converterDefinitionVisitor = new ConverterDefinitionVisitor();
    private Collection<Trigger> unloadedTriggers;

    private static ElementName newElementName(String name) {
        return new ElementName("http://xmlns.oracle.com/ide/extension", name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AuditHook getAuditHook() {
        Class<AuditHook> clazz = AuditHook.class;
        synchronized (AuditHook.class) {
            if (hook == null) {
                hook = new AuditHook();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
            ExtensionHook deferredHook = registry.getHook(AuditHook.newElementName("audit-hook"));
            ((DeferredElementVisitorHook)deferredHook).attachElementVisitor((ElementVisitor)hook);
            return hook;
        }
    }

    public <T> void mapDeprecatedIds(Map<String, T> map) {
        for (Map.Entry<String, BeanDefinition<?>> entry : this.extensionBeanDefinitions.getDeprecated().entrySet()) {
            String currentId;
            String deprecatedId = entry.getKey();
            T value = map.remove(deprecatedId);
            if (value == null || (currentId = entry.getValue().getId()) == null || map.containsKey(currentId)) continue;
            map.put(currentId, value);
        }
    }

    public synchronized Collection<Trigger> getUnloadedTriggers() {
        ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
        Collection<Trigger> oldList = this.unloadedTriggers == null ? this.triggerVisitor.getTriggers() : this.unloadedTriggers;
        ArrayList<Trigger> newList = new ArrayList<Trigger>(oldList.size());
        for (Trigger trigger : oldList) {
            if (registry.isFullyLoaded(trigger.getExtensionId())) continue;
            newList.add(trigger);
        }
        this.unloadedTriggers = newList;
        return this.unloadedTriggers;
    }

    public Map<String, BeanDefinition<?>> getBeansById() {
        return this.extensionBeanDefinitions.getDefinitions();
    }

    public BeanDefinition<?>[] getBeansByIdOrDeprecatedId(String ... ids) {
        BeanDefinition[] definitions = new BeanDefinition[ids.length];
        int count = 0;
        for (String id : ids) {
            BeanDefinition definition = this.getBeanByIdOrDeprecatedId(id);
            if (definition == null) continue;
            definitions[count++] = definition;
        }
        if (count < definitions.length) {
            BeanDefinition[] beanDefinitionArray = definitions;
            definitions = new BeanDefinition[count];
            System.arraycopy(beanDefinitionArray, 0, definitions, 0, count);
        }
        return definitions;
    }

    public BeanDefinition getBeanByIdOrDeprecatedId(String id) {
        BeanDefinition<?> definition = this.extensionBeanDefinitions.get(id);
        return definition != null ? definition : this.extensionBeanDefinitions.getDeprecated(id);
    }

    public Map<String, ProfileDefinition> getProfilesById() {
        return this.profileDefinitions.getDefinitions();
    }

    public ProfileDefinition getProfileByIdOrDeprecatedId(String id) {
        ProfileDefinition definition = this.profileDefinitions.get(id);
        if (definition == null) {
            definition = this.profileDefinitions.getDeprecated(id);
        }
        return definition;
    }

    public List<SuppressionSchemeDefinition> getSuppressionSchemes() {
        return this.schemeDefinitionVisitor.getDefinitions();
    }

    public Set<RuleDefinition> getSuppressionRules(String suppressionName) {
        return this.suppressionAliasVisitor.getBindings().get(suppressionName);
    }

    public Set<String> getSuppressionNames(RuleDefinition definition) {
        return this.suppressionAliasVisitor.getReverseBindings().get(definition);
    }

    public Collection<ModelDefinition> getModels() {
        return this.modelDefinitions.values();
    }

    public ModelDefinition getModel(String typeName) {
        return this.modelDefinitions.get(typeName);
    }

    public Collection<AnalyzerDefinition> getAnalyzers() {
        if (this.analyzerDefinitionVisitor == null) {
            throw new IllegalStateException("analyzer definitions already processed");
        }
        List<AnalyzerDefinition> definitions = this.analyzerDefinitionVisitor.getAnalyzerClasses();
        this.analyzerDefinitionVisitor = null;
        return definitions;
    }

    public Collection<TypeDefinition<ContentRootFactory>> getRootFactories() {
        if (this.rootFactoryDefinitionVisitor == null) {
            throw new IllegalStateException("root factory definitions already processed");
        }
        List<TypeDefinition<ContentRootFactory>> definitions = this.rootFactoryDefinitionVisitor.getTypes();
        this.rootFactoryDefinitionVisitor = null;
        return definitions;
    }

    public Collection<ConverterDefinition> getConverters() {
        if (this.converterDefinitionVisitor == null) {
            throw new IllegalStateException("converter definitions already processed");
        }
        List<ConverterDefinition> definitions = this.converterDefinitionVisitor.getDefinitions();
        this.converterDefinitionVisitor = null;
        return definitions;
    }

    public void start(ElementStartContext context) {
        this.extensionBeanDefinitions.beginLocal();
        this.profileDefinitions.beginLocal();
        this.triggerVisitor.reset();
        context.registerVisitorFactory((ElementVisitorFactory)this.unexpectedElementVisitor);
        context.registerChildVisitor(AuditHook.newElementName("trigger"), (ElementVisitor)this.triggerVisitor);
        context.registerChildVisitor(AuditHook.newElementName("bundle"), (ElementVisitor)this.bundleVisitor);
        context.registerChildVisitor(AuditHook.newElementName("rsbundle-class"), (ElementVisitor)this.bundleVisitor);
        context.registerChildVisitor(AuditHook.newElementName("profile-definition"), (ElementVisitor)this.profileDefinitionVisitor);
        context.registerChildVisitor(AuditHook.newElementName("category-definition"), this.categoryDefinitionVisitor);
        context.registerChildVisitor(AuditHook.newElementName("model-definition"), (ElementVisitor)this.modelDefinitionVisitor);
        context.registerChildVisitor(AuditHook.newElementName("transform-definition"), (ElementVisitor)this.transformDefinitionVisitor);
        context.registerChildVisitor(AuditHook.newElementName("rule-definition"), (ElementVisitor)this.ruleDefinitionVisitor);
        context.registerChildVisitor(AuditHook.newElementName("suppression-scheme-definition"), (ElementVisitor)this.schemeDefinitionVisitor);
        context.registerChildVisitor(AuditHook.newElementName("metric-definition"), (ElementVisitor)this.metricDefinitionVisitor);
        context.registerChildVisitor(AuditHook.newElementName("analyzer-definition"), (ElementVisitor)this.analyzerDefinitionVisitor);
        context.registerChildVisitor(AuditHook.newElementName("root-factory-definition"), this.rootFactoryDefinitionVisitor);
        context.registerChildVisitor(AuditHook.newElementName("converter-definition"), (ElementVisitor)this.converterDefinitionVisitor);
        context.registerChildVisitor(AuditHook.newElementName("transform-binding"), (ElementVisitor)this.transformBindingVisitor);
        context.registerChildVisitor(AuditHook.newElementName("suppression-alias"), (ElementVisitor)this.suppressionAliasVisitor);
        this.extensionId = context.getExtension().getID();
        this.extensionClassLoader = (ClassLoader)context.getScopeData().get("classLoader");
        this.extensionDependencies = new HashSet<String>();
        for (ExtensionDependency dependency : context.getExtension().getDependencies()) {
            this.extensionDependencies.add(dependency.getID());
        }
        this.extensionDependencies.add(this.extensionId);
        this.hookId = context.getAttributeValue("id");
        if (this.hookId != null && this.hookId.isEmpty()) {
            this.hookId = null;
            this.log((ElementContext)context, Level.SEVERE, "<audit-hook> \"id\" attribute value must not be empty");
        }
        this.hookBundle = new ExtensionBundle(new DefinitionContext((ElementContext)context), this.extensionClassLoader, this.getRSBundleClass((ElementContext)context), AuditHook.getResourceBundle((ElementContext)context));
        String auditExtension = this.getProvider();
        if (!this.extensionDependencies.contains(auditExtension)) {
            this.log((ElementContext)context, Level.SEVERE, "Extension \"{0}\" uses <audit-hook> without depending on the \"{1}\" extension", new Object[]{this.extensionId, auditExtension});
        }
    }

    public void end(ElementEndContext context) {
        this.extensionBeanDefinitions.endLocal();
        this.profileDefinitions.endLocal();
    }

    private <T extends TopLevelDefinition> T resolveReference(ElementContext referenceContext, String referenceAttribute, String referenceId, DefinitionScope definitionScope, Class<T> definitionType) {
        Object definition = !referenceId.contains(".") && definitionScope.containsLocal(referenceId) ? definitionScope.getLocal(referenceId) : (definitionScope.contains(referenceId) ? definitionScope.get(referenceId) : definitionScope.getDeprecated(referenceId));
        if (definition == null) {
            String referenceKind;
            String message;
            String referenceElement = referenceContext.getElementName().getLocalName();
            if (referenceAttribute == null) {
                message = "<{0}> references undefined {2} \"{3}\"";
                referenceKind = referenceElement;
            } else {
                message = "<{0}> references undefined {2} \"{3}\"";
                referenceKind = referenceAttribute;
            }
            this.log(referenceContext, Level.SEVERE, message, new Object[]{referenceElement, referenceAttribute, referenceKind, referenceId});
            return null;
        }
        if (!definitionType.isAssignableFrom(definition.getClass())) {
            String referenceKind;
            String message;
            String referenceElement = referenceContext.getElementName().getLocalName();
            String definitionId = ((TopLevelDefinition)definition).getId();
            String definitionKind = definitionType.getSimpleName();
            definitionKind = Strings.separateCamelCase(definitionKind.substring(0, definitionKind.length() - "Definition".length()), ' ').toLowerCase();
            if (definitionId.equals(referenceId)) {
                if (referenceAttribute == null) {
                    message = "<{0}> references {2} \"{5}\" but found {4} \"{5}\"";
                    referenceKind = referenceElement;
                } else {
                    message = "<{0}> references {2} \"{5}\" but found {4} \"{5}\"";
                    referenceKind = referenceAttribute;
                }
            } else if (referenceAttribute == null) {
                message = "<{0}> references {2} \"{5}\" (by deprecated id \"{3}\") but found {4} \"{5}\"";
                referenceKind = referenceElement;
            } else {
                message = "<{0}> references {2} \"{5}\" (by deprecated id \"{3}\") but found {4} \"{5}\"";
                referenceKind = referenceAttribute;
            }
            this.log(referenceContext, Level.SEVERE, message, new Object[]{referenceElement, referenceAttribute, referenceKind, referenceId, definitionKind, definitionId});
            return null;
        }
        String definitionExtensionId = ((Definition)definition).getExtensionId();
        if (!this.extensionDependencies.contains(definitionExtensionId)) {
            String referenceExtensionId = this.extensionId;
            String referenceElement = referenceContext.getElementName().getLocalName();
            String referenceKind = referenceAttribute == null ? referenceElement : referenceAttribute;
            String definitionId = ((TopLevelDefinition)definition).getId();
            if (definitionId.equals(referenceId)) {
                String message = "Extension \"{0}\" references {1} \"{4}\" with no dependency on defining extension \"{3}\"";
                this.log(referenceContext, Level.SEVERE, message, new Object[]{referenceExtensionId, referenceKind, referenceId, definitionExtensionId, definitionId});
            } else {
                this.log(referenceContext, Level.SEVERE, "Extension \"{0}\" references {1} \"{4}\" (by deprecated id \"{2}\") with no dependency on defining extension \"{3}\"", new Object[]{referenceExtensionId, referenceKind, referenceId, definitionExtensionId, definitionId});
            }
        }
        return (T)((TopLevelDefinition)definitionType.cast(definition));
    }

    private String nullTrimmedText(String text) {
        if (text == null) {
            return null;
        }
        if ((text = text.trim()).isEmpty()) {
            return null;
        }
        return text;
    }

    private static class DefinitionScope<T extends TopLevelDefinition> {
        private final Map<String, T> definitions = new LinkedHashMap<String, T>();
        private final Map<String, T> local = new HashMap<String, T>();
        private final Map<String, T> deprecated = new LinkedHashMap<String, T>();

        private DefinitionScope() {
        }

        public boolean contains(String id) {
            return this.definitions.containsKey(id);
        }

        public T get(String id) {
            return (T)((TopLevelDefinition)this.definitions.get(id));
        }

        public T put(TopLevelDefinition definition) {
            return (T)this.definitions.put(definition.getId(), definition);
        }

        public Map<String, T> getDefinitions() {
            return this.definitions;
        }

        public void beginLocal() {
            this.local.clear();
        }

        public boolean containsLocal(String name) {
            return this.local.containsKey(name);
        }

        public T getLocal(String name) {
            return (T)((TopLevelDefinition)this.local.get(name));
        }

        public T putLocal(String name, TopLevelDefinition definition) {
            return (T)this.local.put(name, definition);
        }

        public void endLocal() {
            this.local.clear();
        }

        public boolean containsDeprecated(String id) {
            return this.deprecated.containsKey(id);
        }

        public T getDeprecated(String id) {
            return (T)((TopLevelDefinition)this.deprecated.get(id));
        }

        public T putDeprecated(String id, TopLevelDefinition definition) {
            return (T)this.deprecated.put(id, definition);
        }

        public Map<String, T> getDeprecated() {
            return this.deprecated;
        }
    }

    private static class UnexpectedElementVisitor
    implements ElementVisitorFactory2 {
        private UnexpectedElementVisitor() {
        }

        public boolean isDescending() {
            return false;
        }

        public ElementVisitor getVisitor(ElementName name) throws UnrecognizedElementException {
            throw new UnrecognizedElementException("element <" + name.getLocalName() + "> not expected");
        }

        public ElementVisitor getVisitor(ElementContext context, ElementName name) throws UnrecognizedElementException {
            throw new UnrecognizedElementException("element <" + name.getLocalName() + "> not expected");
        }
    }

    private class TextVisitor
    extends ElementVisitor {
        private String text;

        private TextVisitor() {
        }

        public void reset() {
            this.text = null;
        }

        public void start(ElementStartContext context) {
            super.start(context);
            context.registerVisitorFactory((ElementVisitorFactory)AuditHook.this.unexpectedElementVisitor);
        }

        public void end(ElementEndContext context) {
            super.end(context);
            this.text = AuditHook.this.nullTrimmedText(context.getText());
            if (this.text == null) {
                this.log((ElementContext)context, Level.SEVERE, "<{0}> element value missing", new Object[]{context.getElementName().getLocalName()});
            }
        }

        public String getText() {
            return this.text;
        }
    }

    private class BundleVisitor
    extends ElementVisitor {
        private boolean suppressWarnings;

        private BundleVisitor() {
        }

        public void start(ElementStartContext context) {
            super.start(context);
            context.registerVisitorFactory((ElementVisitorFactory)AuditHook.this.unexpectedElementVisitor);
            this.suppressWarnings = Boolean.parseBoolean(context.getAttributeValue("suppress-warnings"));
        }

        public void end(ElementEndContext context) {
            super.end(context);
            String bundleName = AuditHook.this.nullTrimmedText(context.getText());
            DefinitionContext definitionContext = new DefinitionContext((ElementContext)context);
            AuditHook.this.hookBundle = bundleName != null ? new ExtensionBundle(definitionContext, AuditHook.this.extensionClassLoader, bundleName, !this.suppressWarnings) : new ExtensionBundle(definitionContext, !this.suppressWarnings);
        }
    }

    private class TriggerVisitor
    extends ElementVisitor {
        private final List<Trigger> triggers = new ArrayList<Trigger>();
        private final ElementName technologyElementName = AuditHook.newElementName("technology");
        private final ElementName matchElementName = AuditHook.newElementName("match");
        private final TechnologyVisitor technologyVisitor = new TechnologyVisitor();
        private final MatchVisitor matchVisitor = new MatchVisitor();
        private Trigger trigger;
        private boolean error;

        private TriggerVisitor() {
        }

        public void reset() {
            this.trigger = null;
        }

        public void start(ElementStartContext context) {
            super.start(context);
            context.registerVisitorFactory((ElementVisitorFactory)AuditHook.this.unexpectedElementVisitor);
            this.technologyVisitor.reset();
            context.registerChildVisitor(this.technologyElementName, (ElementVisitor)this.technologyVisitor);
            this.matchVisitor.reset();
            context.registerChildVisitor(this.matchElementName, (ElementVisitor)this.matchVisitor);
            if (this.trigger == null) {
                this.trigger = new Trigger(new DefinitionContext((ElementContext)context));
                this.error = false;
            } else {
                this.log((ElementContext)context, Level.SEVERE, "only one <trigger> element allowed");
                this.error = true;
            }
        }

        public void end(ElementEndContext context) {
            super.end(context);
            if (this.error) {
                return;
            }
            Set<String> technologies = this.technologyVisitor.getTechnologies();
            if (technologies != null) {
                if (!technologies.isEmpty()) {
                    this.trigger.setTechnologies(technologies);
                    this.trigger.setMatch(this.matchVisitor.getMatch());
                    this.triggers.add(this.trigger);
                }
            } else {
                this.log((ElementContext)context, Level.WARNING, "<technology> element required");
            }
        }

        public List<Trigger> getTriggers() {
            return this.triggers;
        }

        private class TechnologyVisitor
        extends ElementVisitor {
            private Set<String> technologies;

            private TechnologyVisitor() {
            }

            public void reset() {
                this.technologies = null;
            }

            public void start(ElementStartContext context) {
                super.start(context);
                context.registerVisitorFactory((ElementVisitorFactory)AuditHook.this.unexpectedElementVisitor);
            }

            public void end(ElementEndContext context) {
                String text;
                super.end(context);
                if (this.technologies == null) {
                    this.technologies = new HashSet<String>();
                }
                if ((text = AuditHook.this.nullTrimmedText(context.getText())) != null) {
                    FeatureRegistry registry = ExtensionRegistry.getExtensionRegistry().getFeatureRegistry();
                    if (registry.getFeatureAssociatedWithTechnology(text) != null) {
                        boolean added = this.technologies.add(text);
                        if (!added) {
                            this.log((ElementContext)context, Level.WARNING, "<{0}> element value \"{1}\" duplicated", new Object[]{context.getElementName().getLocalName(), text});
                        }
                    } else if (AuditManager.isDevelopment()) {
                        this.log((ElementContext)context, Level.WARNING, "Technology \"{0}\" not registered", new Object[]{text});
                    }
                } else {
                    this.log((ElementContext)context, Level.SEVERE, "<{0}> element text required", new Object[]{context.getElementName().getLocalName()});
                }
            }

            public Set<String> getTechnologies() {
                return this.technologies;
            }
        }

        private class MatchVisitor
        extends ElementVisitor {
            private Trigger.Match match;

            private MatchVisitor() {
            }

            public void reset() {
                this.match = null;
            }

            public void start(ElementStartContext context) {
                super.start(context);
                context.registerVisitorFactory((ElementVisitorFactory)AuditHook.this.unexpectedElementVisitor);
                if (this.match != null) {
                    this.log((ElementContext)context, Level.SEVERE, "only one <{0}> element allowed", new Object[]{context.getElementName().getLocalName()});
                }
            }

            public void end(ElementEndContext context) {
                super.end(context);
                String text = AuditHook.this.nullTrimmedText(context.getText());
                if (text != null) {
                    for (Trigger.Match match : Trigger.Match.values()) {
                        if (!text.equalsIgnoreCase(match.toString())) continue;
                        this.match = match;
                    }
                    if (this.match == null) {
                        this.log((ElementContext)context, Level.SEVERE, "<{0}> element text must be one of ANY or ALL", new Object[]{context.getElementName().getLocalName()});
                    }
                } else {
                    this.log((ElementContext)context, Level.SEVERE, "<{0}> element text required", new Object[]{context.getElementName().getLocalName()});
                }
            }

            public Trigger.Match getMatch() {
                return this.match;
            }
        }
    }

    private class ProfileDefinitionVisitor
    extends TopLevelDefinitionVisitor<ProfileDefinition, ProfileDefinition> {
        private final ElementName pathElementName;

        public ProfileDefinitionVisitor(DefinitionScope<ProfileDefinition> definitionScope) {
            super(definitionScope);
            this.pathElementName = AuditHook.newElementName("path");
            this.addRequiredStringElements("label", "description");
        }

        @Override
        public void start(ElementStartContext context) {
            super.start(context);
            this.setDefinition(new ProfileDefinition(this.getId(), AuditHook.this.hookBundle, new DefinitionContext((ElementContext)context)));
            context.registerChildVisitor(this.pathElementName, (ElementVisitor)AuditHook.this.textVisitor);
            AuditHook.this.textVisitor.reset();
        }

        @Override
        public void end(ElementEndContext context) {
            ProfileDefinition definition = (ProfileDefinition)this.getDefinition();
            super.end(context);
            String path = AuditHook.this.textVisitor.getText();
            if (path != null) {
                definition.setPath(path);
            } else {
                this.log((ElementContext)context, Level.WARNING, "<path> element required");
            }
        }
    }

    private class SuppressionAliasVisitor
    extends ElementVisitor {
        private final ElementName ruleElementName = AuditHook.newElementName("rule");
        private final TopLevelReferencesVisitor<RuleDefinition> rulesVisitor;
        private final Map<String, Set<RuleDefinition>> bindings = new HashMap<String, Set<RuleDefinition>>();
        private final Map<RuleDefinition, Set<String>> reverseBindings = new HashMap<RuleDefinition, Set<String>>();
        private String name;

        public SuppressionAliasVisitor(DefinitionScope scope) {
            this.rulesVisitor = new TopLevelReferencesVisitor<RuleDefinition>(RuleDefinition.class, scope);
        }

        public void start(ElementStartContext context) {
            super.start(context);
            context.registerChildVisitor(this.ruleElementName, this.rulesVisitor);
            this.rulesVisitor.reset();
            context.registerVisitorFactory((ElementVisitorFactory)AuditHook.this.unexpectedElementVisitor);
            this.name = AuditHook.this.nullTrimmedText(context.getAttributeValue("name"));
        }

        public void end(ElementEndContext context) {
            super.end(context);
            if (this.name == null) {
                this.log((ElementContext)context, Level.SEVERE, "name attribute required");
                return;
            }
            Set<RuleDefinition> rules = this.rulesVisitor.getDefinitions();
            if (rules.isEmpty()) {
                this.log((ElementContext)context, Level.SEVERE, "<rule> element required");
                return;
            }
            for (RuleDefinition rule : rules) {
                if (!rule.isMandatoryError()) continue;
                this.log((ElementContext)context, Level.WARNING, "rule " + rule.getId() + " is a mandatory error and not suppressible");
            }
            if (this.bindings.containsKey(this.name)) {
                this.bindings.get(this.name).addAll(rules);
            } else {
                this.bindings.put(this.name, rules);
            }
            for (RuleDefinition rule : rules) {
                ArraySortedSet names = this.reverseBindings.get(rule);
                if (names == null) {
                    names = new ArraySortedSet();
                    this.reverseBindings.put(rule, (Set<String>)names);
                }
                names.add((String)this.name);
            }
        }

        public Map<String, Set<RuleDefinition>> getBindings() {
            return this.bindings;
        }

        public Map<RuleDefinition, Set<String>> getReverseBindings() {
            return this.reverseBindings;
        }
    }

    private class CategoryReferenceVisitor
    extends TopLevelReferenceVisitor<CategoryDefinition> {
        private final Map<String, CategoryDefinition> features;
        private final Map<List<String>, CategoryDefinition> featureCategories;

        private CategoryReferenceVisitor(DefinitionScope scope) {
            super(CategoryDefinition.class, scope, true);
            this.features = new HashMap<String, CategoryDefinition>();
            this.featureCategories = new HashMap<List<String>, CategoryDefinition>();
        }

        @Override
        protected CategoryDefinition resolve(String id, ElementEndContext context, DefinitionScope scope) {
            CategoryDefinition definition;
            if ("category".equals(context.getElementName().getLocalName())) {
                definition = (CategoryDefinition)super.resolve(id, context, scope);
            } else {
                definition = this.resolveFeatureOrFeatureCategory(AuditHook.this.categoryDefinitionVisitor, id, null, null, null, scope);
                if (definition == null) {
                    this.log((ElementContext)context, Level.SEVERE, "<feature> references undefined feature or feature category \"{0}\"", new Object[]{id});
                }
            }
            return definition;
        }

        private CategoryDefinition resolveFeatureOrFeatureCategory(CategoryDefinitionVisitor<? extends CategoryDefinition> factory, String featureId, String id, ExtensionBundle bundle, ElementContext context, DefinitionScope<CategoryDefinition> scope) {
            CategoryDefinition definition = this.features.get(featureId);
            if (definition == null) {
                Feature feature = ExtensionRegistry.getExtensionRegistry().getFeatureRegistry().getFeature(featureId);
                if (feature != null) {
                    List<String> categoryPath = this.path(feature.getCategory());
                    CategoryDefinition parentDefinition = this.resolveFeatureCategory(factory, categoryPath, null, null, scope);
                    ArrayList<String> path = new ArrayList<String>(categoryPath);
                    path.add(featureId);
                    if (id != null) {
                        DefinitionContext definitionContext = new DefinitionContext(context);
                        if (bundle == null) {
                            bundle = new ExtensionBundle(definitionContext);
                        }
                        definition = factory.newDefinition(id, path, null, feature, parentDefinition, bundle, definitionContext);
                    } else {
                        DefinitionContext definitionContext = new DefinitionContext(feature.getOwningExtensionId(), (Locator)feature.getLocator());
                        if (bundle == null) {
                            bundle = new ExtensionBundle(definitionContext);
                        }
                        definition = factory.newDefinition("feature:" + featureId, path, null, feature, parentDefinition, bundle, definitionContext);
                        scope.put(definition);
                    }
                    this.features.put(featureId, definition);
                } else {
                    definition = this.resolveFeatureCategory(factory, Arrays.asList(featureId.split("\\s+")), id, context, scope);
                }
            }
            return definition;
        }

        private List<String> path(List<FeatureCategory> categories) {
            ArrayList<String> ids = new ArrayList<String>(categories.size());
            for (FeatureCategory category : categories) {
                ids.add(category.getId());
            }
            return ids;
        }

        private CategoryDefinition resolveFeatureCategory(CategoryDefinitionVisitor factory, List<String> path, String id, ElementContext context, DefinitionScope<CategoryDefinition> scope) {
            String featureId;
            Feature feature;
            FeatureRegistry registry = ExtensionRegistry.getExtensionRegistry().getFeatureRegistry();
            int pathRemaining = path.size();
            StringBuilder cumulativeId = new StringBuilder("feature:");
            CategoryDefinition definition = null;
            FeatureCategory category = null;
            for (int i = 0; i < path.size(); ++i) {
                CategoryDefinition parentDefinition = definition;
                List<String> childPath = path.subList(0, i + 1);
                definition = this.featureCategories.get(childPath);
                if (definition != null) continue;
                String childName = path.get(i);
                FeatureCategory featureCategory = category = category == null ? registry.getCategory(childName) : category.getSubCategory(childName);
                if (category == null) break;
                --pathRemaining;
                if (i > 0) {
                    cumulativeId.append(" ");
                }
                cumulativeId.append(childName);
                if (pathRemaining == 1 && id != null) {
                    definitionContext = new DefinitionContext(context);
                    definition = factory.newDefinition(id, childPath, category, null, parentDefinition, new ExtensionBundle(definitionContext), definitionContext);
                } else {
                    definitionContext = new DefinitionContext(category.getOwningExtensionId(), (Locator)category.getLocator());
                    definition = factory.newDefinition(cumulativeId.toString(), childPath, category, null, parentDefinition, new ExtensionBundle(definitionContext), definitionContext);
                    scope.put(definition);
                }
                this.featureCategories.put(childPath, definition);
            }
            if (definition == null && pathRemaining == 1 && (feature = registry.getFeature(featureId = path.get(path.size() - 1))) != null && path.equals(this.path(feature.getCategory()))) {
                if (id != null) {
                    definitionContext = new DefinitionContext(context);
                    definition = factory.newDefinition(id, path, null, feature, null, new ExtensionBundle(definitionContext), definitionContext);
                } else {
                    definitionContext = new DefinitionContext(feature.getOwningExtensionId(), (Locator)feature.getLocator());
                    definition = factory.newDefinition("feature:" + featureId, path, null, feature, null, new ExtensionBundle(definitionContext), definitionContext);
                    scope.put(definition);
                }
                this.features.put(featureId, definition);
            }
            return definition;
        }
    }

    private class CategoryDefinitionVisitor<T extends CategoryDefinition>
    extends CategorizedDefinitionVisitor<T> {
        protected CategoryDefinitionVisitor(Class<T> definitionType, DefinitionScope definitionScope, ValueVisitor valueVisitor, CategoryReferenceVisitor categoryVisitor) {
            super(definitionType, definitionScope, valueVisitor, categoryVisitor);
        }

        public CategoryDefinitionVisitor(Class<T> definitionType, DefinitionScope definitionScope, CategoryReferenceVisitor categoryVisitor) {
            this(definitionType, definitionScope, auditHook.new ValueVisitor(), categoryVisitor);
        }

        @Override
        public void start(ElementStartContext context) {
            super.start(context);
        }

        @Override
        protected T newDefinition(ElementStartContext context) {
            Object definition;
            String id = this.getId();
            String featureId = context.getAttributeValue("feature");
            if (featureId == null) {
                definition = this.newDefinition(id, this.getCategory(), AuditHook.this.hookBundle, new DefinitionContext((ElementContext)context));
            } else {
                definition = this.getCategoryVisitor().resolveFeatureOrFeatureCategory(this, featureId, id, AuditHook.this.hookBundle, (ElementContext)context, this.getDefinitionScope());
                if (definition == null) {
                    this.log((ElementContext)context, Level.SEVERE, "feature attribute references undefined feature or feature category \"{0}\"", new Object[]{featureId});
                }
            }
            return definition;
        }

        T newDefinition(String id, CategoryDefinition category, ExtensionBundle bundle, DefinitionContext context) {
            return (T)new CategoryDefinition(id, category, bundle, context);
        }

        T newDefinition(String id, List<String> featurePath, FeatureCategory featureCategory, Feature feature, CategoryDefinition category, ExtensionBundle bundle, DefinitionContext context) {
            CategoryDefinition definition = new CategoryDefinition(id, featurePath, featureCategory, feature, category, bundle, context);
            return (T)definition;
        }

        @Override
        public void end(ElementEndContext context) {
            super.end(context);
        }
    }

    private class ModelDefinitionVisitor
    extends CategoryDefinitionVisitor<ModelDefinition> {
        private String content;
        private final TypeDefinitionVisitor modelClassVisitor;
        private final ElementName modelClassElementName;

        public ModelDefinitionVisitor(DefinitionScope definitionScope, CategoryReferenceVisitor categoryVisitor) {
            super(ModelDefinition.class, definitionScope, categoryVisitor);
            this.modelClassVisitor = new TypeDefinitionVisitor();
            this.modelClassElementName = AuditHook.newElementName("model-class");
            this.addRequiredAttributes("content");
        }

        @Override
        ModelDefinition newDefinition(String id, CategoryDefinition category, ExtensionBundle bundle, DefinitionContext context) {
            return new ModelDefinition(id, category, bundle, context);
        }

        @Override
        ModelDefinition newDefinition(String id, List<String> featurePath, FeatureCategory featureCategory, Feature feature, CategoryDefinition category, ExtensionBundle bundle, DefinitionContext context) {
            return new ModelDefinition(id, featurePath, featureCategory, feature, category, bundle, context);
        }

        @Override
        public void start(ElementStartContext context) {
            super.start(context);
            context.registerChildVisitor(this.modelClassElementName, (ElementVisitor)this.modelClassVisitor);
            this.modelClassVisitor.reset();
            this.content = context.getAttributeValue("content");
        }

        @Override
        public void end(ElementEndContext context) {
            ModelDefinition definition = (ModelDefinition)this.getDefinition();
            super.end(context);
            definition.setContent(this.content);
            TypeDefinition type = this.modelClassVisitor.getType();
            if (type != null) {
                definition.setModelType(this.modelClassVisitor.getType());
                String typeName = definition.getModelType().getTypeName();
                ModelDefinition old = AuditHook.this.modelDefinitions.get(typeName);
                if (old == null) {
                    AuditHook.this.modelDefinitions.put(typeName, definition);
                } else {
                    definition.log(Level.SEVERE, "Model class {0} already registered by extension {1} ({2}:{3})", typeName, old.getExtensionId(), old.getSystemId(), old.getLineNumber());
                }
            } else {
                this.log((ElementContext)context, Level.SEVERE, "<model-class> element required");
            }
        }
    }

    private class TransformDefinitionVisitor
    extends BeanDefinitionVisitor<TransformDefinition> {
        private final ComponentTransformVisitor componentTransformVisitor;
        private final ElementName componentTransformElementName;

        public TransformDefinitionVisitor(DefinitionScope definitionScope) {
            super(definitionScope, new ValueVisitor());
            this.componentTransformVisitor = new ComponentTransformVisitor();
            this.componentTransformElementName = AuditHook.newElementName("component-transform");
            this.addOptionalStringElements("bound-label");
        }

        @Override
        public void start(ElementStartContext context) {
            super.start(context);
            this.setDefinition(new TransformDefinition(this.getId(), AuditHook.this.hookBundle, new DefinitionContext((ElementContext)context)));
            context.registerChildVisitor(this.componentTransformElementName, (ElementVisitor)this.componentTransformVisitor);
            this.componentTransformVisitor.reset();
        }

        @Override
        public void end(ElementEndContext context) {
            TransformDefinition definition = (TransformDefinition)this.getDefinition();
            super.end(context);
            Collection<TransformDefinition> components = this.componentTransformVisitor.getComponentTransforms();
            if (this.isError()) {
                return;
            }
            if (definition.getImplementationClass() != null || !components.isEmpty()) {
                definition.setTransforms(components);
            } else {
                this.log((ElementContext)context, Level.SEVERE, "<transform-class> element or <component-transform> elements required");
            }
        }

        private class ComponentTransformVisitor
        extends ElementVisitor {
            private final ElementName implementationClassElementName = AuditHook.newElementName("transform-class");
            private final ElementName beanClassElementName = AuditHook.newElementName("bean-class");
            private final ElementName valueElementName = AuditHook.newElementName("value");
            private final ImplementationClassVisitor implementationClassVisitor;
            private final ValueVisitor valueVisitor;
            private Collection<TransformDefinition> componentTransforms;

            private ComponentTransformVisitor() {
                this.implementationClassVisitor = new ImplementationClassVisitor(this.implementationClassElementName);
                this.valueVisitor = new ValueVisitor();
            }

            public void reset() {
                this.componentTransforms = new ArrayList<TransformDefinition>();
            }

            public void start(ElementStartContext context) {
                super.start(context);
                context.registerChildVisitor(this.implementationClassElementName, (ElementVisitor)this.implementationClassVisitor);
                context.registerChildVisitor(this.beanClassElementName, (ElementVisitor)this.implementationClassVisitor);
                this.implementationClassVisitor.reset();
                context.registerChildVisitor(this.valueElementName, (ElementVisitor)this.valueVisitor);
                this.valueVisitor.reset();
            }

            public void end(ElementEndContext context) {
                super.end(context);
                TransformDefinition transform = new TransformDefinition(TransformDefinitionVisitor.this.getId(), AuditHook.this.hookBundle, new DefinitionContext((ElementContext)context));
                TypeDefinition type = this.implementationClassVisitor.getType();
                if (type != null) {
                    transform.setImplementationClass(type);
                    transform.setValues(this.valueVisitor.getValues());
                    this.componentTransforms.add(transform);
                } else {
                    this.log((ElementContext)context, Level.SEVERE, "<transform-class> element required");
                }
            }

            public Collection<TransformDefinition> getComponentTransforms() {
                return this.componentTransforms;
            }
        }
    }

    private class RuleDefinitionVisitor
    extends CategorizedDefinitionVisitor<RuleDefinition> {
        private final ParameterVisitor parameterVisitor;
        private final VariationVisitor variationVisitor;
        private final TransformVisitor<RuleDefinition> transformVisitor;
        private final ElementName enabledElementName;
        private final ElementName severityElementName;
        private final ElementName mandatoryErrorElementName;
        private final ElementName assistElementName;
        private final ElementName parameterElementName;
        private final ElementName variationElementName;
        private final ElementName transformBindingElementName;
        private final ElementName transformElementName;

        public RuleDefinitionVisitor(DefinitionScope definitionScope, CategoryReferenceVisitor categoryVisitor) {
            super(RuleDefinition.class, definitionScope, new SeverityValueVisitor(), categoryVisitor);
            this.parameterVisitor = new ParameterVisitor();
            this.variationVisitor = new VariationVisitor();
            this.enabledElementName = AuditHook.newElementName("enabled");
            this.severityElementName = AuditHook.newElementName("severity");
            this.mandatoryErrorElementName = AuditHook.newElementName("mandatory-error");
            this.assistElementName = AuditHook.newElementName("assist");
            this.parameterElementName = AuditHook.newElementName("parameter");
            this.variationElementName = AuditHook.newElementName("variation");
            this.transformBindingElementName = AuditHook.newElementName("transform-binding");
            this.transformElementName = AuditHook.newElementName("transform");
            this.addAllowedAttributes("category");
            this.addRequiredStringElements("message");
            this.addOptionalStringElements("tip", "html-message");
            this.addRequiredStringElements("");
            this.transformVisitor = new TransformVisitor(definitionScope);
        }

        @Override
        public void start(ElementStartContext context) {
            super.start(context);
            ValueVisitor valueVisitor = this.getValueVisitor();
            context.registerChildVisitor(this.enabledElementName, (ElementVisitor)valueVisitor);
            context.registerChildVisitor(this.severityElementName, (ElementVisitor)valueVisitor);
            context.registerChildVisitor(this.assistElementName, (ElementVisitor)valueVisitor);
            context.registerChildVisitor(this.mandatoryErrorElementName, (ElementVisitor)valueVisitor);
            context.registerChildVisitor(this.parameterElementName, (ElementVisitor)this.parameterVisitor);
            this.parameterVisitor.reset();
            context.registerChildVisitor(this.variationElementName, (ElementVisitor)this.variationVisitor);
            this.variationVisitor.reset();
            context.registerChildVisitor(this.transformBindingElementName, (ElementVisitor)AuditHook.this.transformBindingVisitor);
            AuditHook.this.transformBindingVisitor.beginRule((RuleDefinition)this.getDefinition());
            context.registerChildVisitor(this.transformElementName, this.transformVisitor);
            this.transformVisitor.beginTarget((RuleDefinition)this.getDefinition());
        }

        @Override
        public void end(ElementEndContext context) {
            RuleDefinition rule = (RuleDefinition)this.getDefinition();
            super.end(context);
            this.transformVisitor.endTarget();
            AuditHook.this.transformBindingVisitor.endRule();
            if (rule.getValue("severity") == null) {
                this.log((ElementContext)context, Level.SEVERE, "<severity>, <mandatory-error>, or <assist> element required");
                rule.setSeverity(Severity.ADVISORY);
            }
            rule.setMandatoryError(((SeverityValueVisitor)this.getValueVisitor()).isMandatoryError());
            rule.setParameters(this.parameterVisitor.getParameters());
            rule.setVariations(this.variationVisitor.getVariations());
        }

        @Override
        protected RuleDefinition newDefinition(ElementStartContext context) {
            return new RuleDefinition(this.getId(), this.getCategory(), AuditHook.this.hookBundle, new DefinitionContext((ElementContext)context));
        }

        private class VariationVisitor
        extends ElementVisitor {
            private final ElementName messageElementName = AuditHook.newElementName("message");
            private final ElementName htmlMessageElementName = AuditHook.newElementName("html-message");
            private List<String> variations;
            private String name;

            private VariationVisitor() {
            }

            public void reset() {
                this.variations = null;
            }

            public void start(ElementStartContext context) {
                super.start(context);
                context.registerVisitorFactory((ElementVisitorFactory)AuditHook.this.unexpectedElementVisitor);
                this.name = context.getAttributeValue("name");
                if (this.name != null) {
                    if (this.variations == null || !this.variations.contains(this.name)) {
                        RuleDefinitionVisitor.this.stringVisitor.setVariant(this.name);
                        context.registerChildVisitor(this.messageElementName, (ElementVisitor)RuleDefinitionVisitor.this.stringVisitor);
                        context.registerChildVisitor(this.htmlMessageElementName, (ElementVisitor)RuleDefinitionVisitor.this.stringVisitor);
                    } else {
                        this.log((ElementContext)context, Level.SEVERE, "variation \"{0}\" redefined", new Object[]{this.name});
                    }
                } else {
                    this.log((ElementContext)context, Level.SEVERE, "\"name\" attribute required");
                }
            }

            public void end(ElementEndContext context) {
                super.end(context);
                RuleDefinitionVisitor.this.stringVisitor.setVariant(null);
                if (this.variations == null) {
                    this.variations = new ArrayList<String>();
                }
                this.variations.add(this.name);
            }

            public List<String> getVariations() {
                return this.variations == null ? Collections.emptyList() : this.variations;
            }
        }
    }

    private class SchemeDefinitionVisitor
    extends CategorizedDefinitionVisitor<SuppressionSchemeDefinition> {
        List<SuppressionSchemeDefinition> definitions;
        private final ParameterVisitor parameterVisitor;
        private final TransformVisitor transformVisitor;
        private final ElementName enabledElementName;
        private final ElementName parameterElementName;
        private final ElementName transformElementName;

        public SchemeDefinitionVisitor(DefinitionScope definitionScope, CategoryReferenceVisitor categoryVisitor) {
            super(SuppressionSchemeDefinition.class, definitionScope, new ValueVisitor(), categoryVisitor);
            this.definitions = new ArrayList<SuppressionSchemeDefinition>();
            this.parameterVisitor = new ParameterVisitor();
            this.enabledElementName = AuditHook.newElementName("enabled");
            this.parameterElementName = AuditHook.newElementName("parameter");
            this.transformElementName = AuditHook.newElementName("transform");
            this.addAllowedAttributes("category");
            this.addRequiredStringElements("message");
            this.addOptionalStringElements("html-message");
            this.addRequiredStringElements("");
            this.transformVisitor = new TransformVisitor(definitionScope);
        }

        @Override
        public void start(ElementStartContext context) {
            super.start(context);
            ValueVisitor valueVisitor = this.getValueVisitor();
            context.registerChildVisitor(this.enabledElementName, (ElementVisitor)valueVisitor);
            context.registerChildVisitor(this.parameterElementName, (ElementVisitor)this.parameterVisitor);
            this.parameterVisitor.reset();
            context.registerChildVisitor(this.transformElementName, (ElementVisitor)this.transformVisitor);
            this.transformVisitor.beginTarget((BeanDefinition)this.getDefinition());
        }

        @Override
        public void end(ElementEndContext context) {
            SuppressionSchemeDefinition definition = (SuppressionSchemeDefinition)this.getDefinition();
            super.end(context);
            this.transformVisitor.endTarget();
            definition.setParameters(this.parameterVisitor.getParameters());
            this.definitions.add(definition);
        }

        @Override
        protected SuppressionSchemeDefinition newDefinition(ElementStartContext context) {
            return new SuppressionSchemeDefinition(this.getId(), this.getCategory(), AuditHook.this.hookBundle, new DefinitionContext((ElementContext)context));
        }

        public List<SuppressionSchemeDefinition> getDefinitions() {
            return this.definitions;
        }
    }

    private class TransformBindingVisitor
    extends ElementVisitor {
        private final TopLevelReferenceVisitor<RuleDefinition> ruleVisitor;
        private final TopLevelReferenceVisitor<TransformDefinition> transformVisitor;
        private final ConditionVisitor conditionVisitor;
        private final ValueVisitor valueVisitor;
        private final ElementName ruleElementName;
        private final ElementName transformElementName;
        private final ElementName ifElementName;
        private final ElementName valueElementName;
        private final ElementName propertyElementName;
        private RuleDefinition rule;
        private TransformBinding<RuleDefinition> binding;

        public TransformBindingVisitor(DefinitionScope scope) {
            this.conditionVisitor = new ConditionVisitor();
            this.valueVisitor = new ValueVisitor();
            this.ruleElementName = AuditHook.newElementName("rule");
            this.transformElementName = AuditHook.newElementName("transform");
            this.ifElementName = AuditHook.newElementName("if");
            this.valueElementName = AuditHook.newElementName("value");
            this.propertyElementName = AuditHook.newElementName("property");
            this.ruleVisitor = new TopLevelReferenceVisitor<RuleDefinition>(RuleDefinition.class, scope, true);
            this.transformVisitor = new TopLevelReferenceVisitor<TransformDefinition>(TransformDefinition.class, scope, true);
        }

        public void beginRule(RuleDefinition rule) {
            this.rule = rule;
        }

        public void endRule() {
            this.rule = null;
        }

        public void start(ElementStartContext context) {
            boolean defaultTransform;
            super.start(context);
            context.registerVisitorFactory((ElementVisitorFactory)AuditHook.this.unexpectedElementVisitor);
            if (this.rule != null) {
                defaultTransform = Boolean.parseBoolean(context.getAttributeValue("default"));
            } else if (context.getAttributeValue("default") != null) {
                this.log((ElementContext)context, Level.WARNING, "\"default\" attribute allowed only on transform binding within a <rule-definition> element");
                defaultTransform = false;
            } else {
                defaultTransform = false;
            }
            this.binding = new TransformBinding(defaultTransform, new DefinitionContext((ElementContext)context));
            if (this.rule == null) {
                context.registerChildVisitor(this.ruleElementName, this.ruleVisitor);
                this.ruleVisitor.reset();
            }
            context.registerChildVisitor(this.transformElementName, this.transformVisitor);
            this.transformVisitor.reset();
            context.registerChildVisitor(this.ifElementName, (ElementVisitor)this.conditionVisitor);
            this.conditionVisitor.reset();
            context.registerChildVisitor(this.valueElementName, (ElementVisitor)this.valueVisitor);
            context.registerChildVisitor(this.propertyElementName, (ElementVisitor)this.valueVisitor);
            this.valueVisitor.reset();
        }

        public void end(ElementEndContext context) {
            super.end(context);
            RuleDefinition rule = this.rule != null ? this.rule : this.ruleVisitor.getDefinition();
            TransformDefinition transform = this.transformVisitor.getDefinition();
            if (rule == null || transform == null) {
                return;
            }
            this.binding.setTarget(rule);
            this.binding.setTransform(transform);
            this.binding.setCondition(this.conditionVisitor.getCondition());
            this.binding.setValues(this.valueVisitor.getValues());
            rule.addTransformBinding(this.binding);
        }
    }

    private class MetricDefinitionVisitor
    extends CategorizedDefinitionVisitor<MetricDefinition> {
        private final TypeDefinitionVisitor valueTypeVisitor;
        private final ElementName valueTypeElementName;
        private final ElementName enabledElementName;
        private final ElementName thresholdElementName;

        public MetricDefinitionVisitor(DefinitionScope definitionScope, CategoryReferenceVisitor categoryVisitor) {
            super(MetricDefinition.class, definitionScope, categoryVisitor);
            this.valueTypeVisitor = new TypeDefinitionVisitor();
            this.valueTypeElementName = AuditHook.newElementName("value-type");
            this.enabledElementName = AuditHook.newElementName("enabled");
            this.thresholdElementName = AuditHook.newElementName("threshold");
            this.addOptionalStringElements("short-label", "tip");
        }

        @Override
        public void start(ElementStartContext context) {
            super.start(context);
            context.registerChildVisitor(this.valueTypeElementName, (ElementVisitor)this.valueTypeVisitor);
            this.valueTypeVisitor.reset();
            ValueVisitor valueVisitor = this.getValueVisitor();
            context.registerChildVisitor(this.enabledElementName, (ElementVisitor)valueVisitor);
            context.registerChildVisitor(this.thresholdElementName, (ElementVisitor)valueVisitor);
        }

        @Override
        public void end(ElementEndContext context) {
            MetricDefinition metric = (MetricDefinition)this.getDefinition();
            super.end(context);
            metric.setValueType(this.valueTypeVisitor.getType());
        }

        @Override
        protected MetricDefinition newDefinition(ElementStartContext context) {
            return new MetricDefinition(this.getId(), this.getCategory(), AuditHook.this.hookBundle, new DefinitionContext((ElementContext)context));
        }
    }

    private class AnalyzerDefinitionVisitor
    extends ElementVisitor {
        private final List<AnalyzerDefinition> analyzerClasses = new ArrayList<AnalyzerDefinition>();
        private final ElementName analyzerClassElementName = AuditHook.newElementName("analyzer-class");
        private final TypeDefinitionVisitor<Analyzer> analyzerClassVisitor = new TypeDefinitionVisitor();

        private AnalyzerDefinitionVisitor() {
        }

        public void start(ElementStartContext context) {
            super.start(context);
            context.registerVisitorFactory((ElementVisitorFactory)AuditHook.this.unexpectedElementVisitor);
            this.analyzerClassVisitor.reset();
            context.registerChildVisitor(this.analyzerClassElementName, this.analyzerClassVisitor);
        }

        public void end(ElementEndContext context) {
            super.end(context);
            String text = AuditHook.this.nullTrimmedText(context.getText());
            TypeDefinition<Analyzer> analyzerClass = this.analyzerClassVisitor.getType();
            if (text != null && analyzerClass != null) {
                this.log((ElementContext)context, Level.SEVERE, "only one of <analyzer-class> element and text allowed");
                return;
            }
            if (text == null && analyzerClass == null) {
                this.log((ElementContext)context, Level.SEVERE, "one of <analyzer-class> element or text required");
                return;
            }
            if (text != null) {
                analyzerClass = new TypeDefinition(AuditHook.this.extensionClassLoader, new DefinitionContext((ElementContext)context));
                analyzerClass.setTypeName(text);
            }
            this.analyzerClasses.add(new AnalyzerDefinition(analyzerClass));
        }

        public List<AnalyzerDefinition> getAnalyzerClasses() {
            return this.analyzerClasses;
        }
    }

    private class TypesDefinitionVisitor<T>
    extends TypeDefinitionVisitor<T> {
        private final List<TypeDefinition<T>> types;

        private TypesDefinitionVisitor() {
            this.types = new ArrayList<TypeDefinition<T>>();
        }

        @Override
        public void start(ElementStartContext context) {
            super.start(context);
        }

        @Override
        public void end(ElementEndContext context) {
            super.end(context);
            TypeDefinition type = this.getType();
            if (type.getTypeName() != null) {
                this.types.add(type);
            }
        }

        public List<TypeDefinition<T>> getTypes() {
            return this.types;
        }
    }

    private class ConverterDefinitionVisitor
    extends ElementVisitor {
        private final List<ConverterDefinition> definitions = new ArrayList<ConverterDefinition>();
        private ConverterDefinition definition;
        private final ElementName valueTypeElementName = AuditHook.newElementName("value-type");
        private final ElementName converterTypeElementName = AuditHook.newElementName("converter-type");
        private final TypeDefinitionVisitor<Object> valueTypeVisitor = new TypeDefinitionVisitor();
        private final TypeDefinitionVisitor<Converter> converterTypeVisitor = new TypeDefinitionVisitor();

        private ConverterDefinitionVisitor() {
        }

        public void start(ElementStartContext context) {
            super.start(context);
            context.registerVisitorFactory((ElementVisitorFactory)AuditHook.this.unexpectedElementVisitor);
            this.valueTypeVisitor.reset();
            context.registerChildVisitor(this.valueTypeElementName, this.valueTypeVisitor);
            this.converterTypeVisitor.reset();
            context.registerChildVisitor(this.converterTypeElementName, this.converterTypeVisitor);
            this.definition = new ConverterDefinition(new DefinitionContext((ElementContext)context));
        }

        public void end(ElementEndContext context) {
            super.end(context);
            TypeDefinition<Object> valueType = this.valueTypeVisitor.getType();
            TypeDefinition<Converter> converterType = this.converterTypeVisitor.getType();
            if (valueType == null) {
                this.log((ElementContext)context, Level.WARNING, "<value-type> element required");
            } else if (converterType == null) {
                this.log((ElementContext)context, Level.WARNING, "<converter-type> element required");
            } else {
                this.definition.setValueType(valueType);
                this.definition.setConverterType(converterType);
                this.definitions.add(this.definition);
            }
            this.definition = null;
        }

        public List<ConverterDefinition> getDefinitions() {
            return this.definitions;
        }
    }

    private class StringVisitor
    extends ElementVisitor {
        private String variant;
        private Map<String, String> strings = new ArrayMap();

        private StringVisitor() {
        }

        public void reset() {
            this.variant = null;
            if (!this.strings.isEmpty()) {
                this.strings = new ArrayMap();
            }
        }

        public void setVariant(String variant) {
            this.variant = variant;
        }

        public void start(ElementStartContext context) {
            super.start(context);
            context.registerVisitorFactory((ElementVisitorFactory)AuditHook.this.unexpectedElementVisitor);
        }

        public void end(ElementEndContext context) {
            super.end(context);
            Object key = context.getElementName().getLocalName();
            String text = AuditHook.this.nullTrimmedText(context.getText());
            if (text != null) {
                if (this.variant != null) {
                    key = this.variant + "." + (String)key;
                }
                this.strings.put((String)key, text);
            } else {
                this.log((ElementContext)context, Level.SEVERE, "<{0}> element text required", new Object[]{context.getElementName().getLocalName()});
            }
        }

        public Map<String, String> getStrings() {
            return this.strings;
        }
    }

    private class ConditionVisitor
    extends ElementVisitor {
        private Condition condition;

        private ConditionVisitor() {
        }

        public void reset() {
            this.condition = null;
        }

        public void start(ElementStartContext context) {
            super.start(context);
            context.registerVisitorFactory((ElementVisitorFactory)AuditHook.this.unexpectedElementVisitor);
            this.condition = new Condition(new DefinitionContext((ElementContext)context));
        }

        public void end(ElementEndContext context) {
            super.end(context);
            String text = AuditHook.this.nullTrimmedText(context.getText());
            if (text != null) {
                this.condition.setText(text);
            } else {
                this.log((ElementContext)context, Level.SEVERE, "<{0}> element text required", new Object[]{context.getElementName().getLocalName()});
            }
        }

        public Condition getCondition() {
            return this.condition;
        }
    }

    private class ValueVisitor
    extends ElementVisitor {
        private List<Value> values;
        private final Stack<Value> valueStack = new Stack();
        private Set<String> names;

        private ValueVisitor() {
        }

        public void reset() {
            this.values = null;
            this.valueStack.clear();
            this.names = null;
        }

        public void start(ElementStartContext context) {
            super.start(context);
            context.registerVisitorFactory((ElementVisitorFactory)AuditHook.this.unexpectedElementVisitor);
            String elementName = context.getElementName().getLocalName();
            String name = context.getAttributeValue("name");
            Value.Kind kind = null;
            if ("OBJECT".equalsIgnoreCase(context.getAttributeValue("kind"))) {
                kind = Value.Kind.OBJECT;
            } else if ("ARRAY".equalsIgnoreCase(context.getAttributeValue("kind"))) {
                kind = Value.Kind.ARRAY;
            } else if (context.getAttributeValue("kind") != null) {
                this.log((ElementContext)context, Level.SEVERE, "<value> kind attribute value \"[0]\" must be \"OBJECT\", or \"ARRAY\"");
            }
            if ("value".equals(elementName) || "property".equals(elementName)) {
                if ("property".equals(elementName)) {
                    this.log((ElementContext)context, Level.WARNING, "<property> element deprecated: use <value> element instead");
                }
            } else {
                if (name != null) {
                    this.log((ElementContext)context, Level.SEVERE, "\"name\" attribute unexpected");
                    this.valueStack.push(null);
                    return;
                }
                name = elementName;
                if (this.names == null) {
                    this.names = new HashSet<String>();
                }
                this.names.add(name);
            }
            Value value = new Value(name, kind, new DefinitionContext((ElementContext)context));
            if (this.valueStack.isEmpty()) {
                boolean added = this.addValue(value);
                if (added) {
                    this.valueStack.push(value);
                    context.registerChildVisitor(AuditHook.newElementName("value"), (ElementVisitor)this);
                    context.registerChildVisitor(AuditHook.newElementName("property"), (ElementVisitor)this);
                } else if (this.names != null && this.names.contains(name)) {
                    this.log((ElementContext)context, Level.SEVERE, "only one <{0}> or <value name=\"{0}\"> element allowed", new Object[]{name});
                    this.valueStack.push(null);
                } else {
                    this.log((ElementContext)context, Level.SEVERE, "only one <value name=\"{0}\"> element allowed", new Object[]{name});
                    this.valueStack.push(null);
                }
            } else {
                Value enclosingValue = this.valueStack.peek();
                Value.Kind enclosingKind = enclosingValue.getKind();
                if (name != null && enclosingKind == Value.Kind.ARRAY) {
                    this.log((ElementContext)context, Level.SEVERE, "<value> ''name'' attribute not expected for array element value");
                }
                if (name == null && enclosingKind == Value.Kind.OBJECT) {
                    this.log((ElementContext)context, Level.SEVERE, "<value> ''name'' attribute expected for object property value");
                }
                if (kind == Value.Kind.OBJECT || kind == null && name != null) {
                    boolean added = enclosingValue.addNamedValue(value);
                    if (added) {
                        this.valueStack.push(value);
                        context.registerChildVisitor(AuditHook.newElementName("value"), (ElementVisitor)this);
                        context.registerChildVisitor(AuditHook.newElementName("property"), (ElementVisitor)this);
                    } else {
                        this.log((ElementContext)context, Level.SEVERE, "only one <value name=\"{0}\"> element allowed", new Object[]{name});
                        this.valueStack.push(null);
                    }
                } else {
                    enclosingValue.addUnnamedValue(value);
                    this.valueStack.push(value);
                    context.registerChildVisitor(AuditHook.newElementName("value"), (ElementVisitor)this);
                    context.registerChildVisitor(AuditHook.newElementName("property"), (ElementVisitor)this);
                }
            }
        }

        public void end(ElementEndContext context) {
            super.end(context);
            Value value = this.valueStack.pop();
            if (value == null) {
                return;
            }
            Value.Kind kind = value.getKind();
            String text = AuditHook.this.nullTrimmedText(context.getText());
            if (text != null) {
                if (kind == null || kind == Value.Kind.TEXT) {
                    value.setText(text);
                } else {
                    this.log((ElementContext)context, Level.SEVERE, "nested <value> elements or text allowed, but not both");
                }
            } else if (kind == null) {
                this.log((ElementContext)context, Level.SEVERE, "text, nested <value> elements, or kind attribute required");
            }
        }

        public boolean addValue(Value value) {
            if (this.values == null) {
                this.values = new ArrayList<Value>();
                this.values.add(value);
                return true;
            }
            assert (!this.values.isEmpty());
            for (int i = 0; i < this.values.size(); ++i) {
                int comparison = value.compareTo(this.values.get(i));
                if (comparison > 0) continue;
                if (comparison == 0) {
                    return false;
                }
                this.values.add(i, value);
                return true;
            }
            assert (value.compareTo(this.values.get(this.values.size() - 1)) > 0);
            this.values.add(value);
            return true;
        }

        public Collection<Value> getValues() {
            return this.values;
        }

        public Value getValue(String name) {
            if (this.values == null) {
                return null;
            }
            for (Value value : this.values) {
                if (!name.equals(value.getName())) continue;
                return value;
            }
            return null;
        }
    }

    private class TransformVisitor<T extends BeanDefinition<? extends ExtensionBean>>
    extends TopLevelReferenceVisitor<TransformDefinition> {
        private T target;
        private TransformBinding<T> binding;

        private TransformVisitor(DefinitionScope scope) {
            super(TransformDefinition.class, scope, false);
        }

        public void beginTarget(T rule) {
            this.target = rule;
            this.reset();
        }

        public void endTarget() {
            this.target = null;
        }

        @Override
        public void start(ElementStartContext context) {
            super.start(context);
            context.registerVisitorFactory((ElementVisitorFactory)AuditHook.this.unexpectedElementVisitor);
            boolean defaultTransform = Boolean.parseBoolean(context.getAttributeValue("default"));
            this.binding = new TransformBinding(defaultTransform, new DefinitionContext((ElementContext)context));
        }

        @Override
        public void end(ElementEndContext context) {
            super.end(context);
            TransformDefinition transform = (TransformDefinition)this.getDefinition();
            this.binding.setTarget(this.target);
            this.binding.setTransform(transform);
            ((HasTransformBindings)this.target).addTransformBinding(this.binding);
        }
    }

    private class ParameterVisitor
    extends TypeDefinitionVisitor {
        private SortedSet<ParameterDefinition> parameters;
        private String name;
        private boolean required;

        private ParameterVisitor() {
        }

        @Override
        public void reset() {
            this.parameters = null;
        }

        @Override
        public void start(ElementStartContext context) {
            super.start(context);
            context.registerVisitorFactory((ElementVisitorFactory)AuditHook.this.unexpectedElementVisitor);
            this.name = context.getAttributeValue("name");
            if (this.name == null) {
                this.log((ElementContext)context, Level.SEVERE, "\"name\" attribute required");
            }
            this.required = Boolean.parseBoolean(context.getAttributeValue("required"));
        }

        @Override
        public void end(ElementEndContext context) {
            boolean added;
            super.end(context);
            if (this.parameters == null) {
                this.parameters = new ArraySortedSet();
            }
            if (!(added = this.parameters.add(new ParameterDefinition(this.name, this.getType(), this.required, new DefinitionContext((ElementContext)context))))) {
                this.log((ElementContext)context, Level.SEVERE, "parameter \"{0}\" redefined", new Object[]{this.name});
            }
        }

        public Collection<ParameterDefinition> getParameters() {
            return this.parameters != null ? this.parameters : Collections.emptySet();
        }
    }

    private class SeverityValueVisitor
    extends ValueVisitor {
        private boolean mandatoryError;
        private boolean assist;
        private boolean severity;
        private boolean error;
        private int depth;

        private SeverityValueVisitor() {
        }

        @Override
        public void reset() {
            this.depth = 0;
            this.error = false;
            super.reset();
        }

        @Override
        public void start(ElementStartContext context) {
            if (this.error) {
                return;
            }
            if (this.depth++ == 0) {
                String elementName = context.getElementName().getLocalName();
                this.assist = "assist".equals(elementName);
                this.mandatoryError = "mandatory-error".equals(elementName);
                boolean bl = this.severity = "severity".equals(elementName) || "value".equals(elementName) && "severity".equals(context.getAttributeValue("name"));
                if (this.mandatoryError) {
                    boolean added = this.addValue(new Value("severity", "error", new DefinitionContext((ElementContext)context)));
                    if (!added) {
                        this.log((ElementContext)context, Level.SEVERE, "only one <severity> (or <mandatory-error> or <assist>) element allowed");
                        this.error = true;
                    }
                } else if (this.assist) {
                    boolean added = this.addValue(new Value("severity", "assist", new DefinitionContext((ElementContext)context)));
                    if (!added) {
                        this.log((ElementContext)context, Level.SEVERE, "only one <severity> (or <mandatory-error> or <assist>) element allowed");
                        this.error = true;
                    }
                } else if (this.severity) {
                    if (this.getValue("severity") == null) {
                        super.start(context);
                    } else {
                        this.log((ElementContext)context, Level.SEVERE, "only one <severity> (or <mandatory-error> or <assist>) element allowed");
                        this.error = true;
                    }
                } else {
                    super.start(context);
                }
            } else if (this.mandatoryError | this.assist || this.severity) {
                this.log((ElementContext)context, Level.SEVERE, "nested <value> elements not expected");
                this.error = true;
            } else {
                super.start(context);
            }
        }

        @Override
        public void end(ElementEndContext context) {
            --this.depth;
            if (this.error) {
                return;
            }
            if (this.mandatoryError || this.assist) {
                String text = AuditHook.this.nullTrimmedText(context.getText());
                if (text != null) {
                    this.log((ElementContext)context, Level.WARNING, "<{0}> element text ignored", new Object[]{context.getElementName().getLocalName()});
                }
            } else if (this.severity) {
                String text = AuditHook.this.nullTrimmedText(context.getText());
                if (text != null) {
                    if ("error".equals(text = text.toLowerCase()) || "warning".equals(text) || "incomplete".equals(text) || "advisory".equals(text) || "assist".equals(text)) {
                        if ("assist".equals(text)) {
                            this.log((ElementContext)context, Level.WARNING, "use <assist/> element rather than <severity> element to specify an assist");
                        }
                        super.end(context);
                    } else {
                        this.log((ElementContext)context, Level.SEVERE, "severity \"{0}\" not recognized: expected one of \"error\", \"warning\", \"incomplete', or \"advisory\"", new Object[]{text});
                    }
                } else {
                    this.log((ElementContext)context, Level.SEVERE, "<{0}> element text required", new Object[]{context.getElementName().getLocalName()});
                }
            } else {
                super.end(context);
            }
        }

        public boolean isMandatoryError() {
            return this.mandatoryError;
        }
    }

    private abstract class CategorizedDefinitionVisitor<T extends BeanDefinition>
    extends BeanDefinitionVisitor<T> {
        private final Class<T> definitionType;
        private final DefinitionScope definitionScope;
        private final CategoryReferenceVisitor categoryVisitor;
        private final ElementName categoryElementName;
        private final ElementName featureElementName;

        protected CategorizedDefinitionVisitor(Class<T> definitionType, DefinitionScope definitionScope, ValueVisitor valueVisitor, CategoryReferenceVisitor categoryVisitor) {
            super(definitionScope, valueVisitor);
            this.categoryElementName = AuditHook.newElementName("category");
            this.featureElementName = AuditHook.newElementName("feature");
            this.definitionType = definitionType;
            this.definitionScope = definitionScope;
            this.categoryVisitor = categoryVisitor;
            this.addAllowedAttributes("feature", "category");
            this.addRequiredStringElements("label", "description");
        }

        public CategorizedDefinitionVisitor(Class<T> definitionType, DefinitionScope definitionScope, CategoryReferenceVisitor categoryVisitor) {
            this(definitionType, definitionScope, auditHook.new ValueVisitor(), categoryVisitor);
        }

        public Class<T> getDefinitionType() {
            return this.definitionType;
        }

        public DefinitionScope getDefinitionScope() {
            return this.definitionScope;
        }

        public CategoryReferenceVisitor getCategoryVisitor() {
            return this.categoryVisitor;
        }

        @Override
        public void start(ElementStartContext context) {
            this.categoryVisitor.reset();
            context.registerChildVisitor(this.categoryElementName, (ElementVisitor)this.categoryVisitor);
            context.registerChildVisitor(this.featureElementName, (ElementVisitor)this.categoryVisitor);
            super.start(context);
            this.setDefinition((BeanDefinition)this.definitionType.cast(this.newDefinition(context)));
        }

        protected abstract T newDefinition(ElementStartContext var1);

        @Override
        public void end(ElementEndContext context) {
            BeanDefinition definition = (BeanDefinition)this.getDefinition();
            super.end(context);
            CategoryDefinition attributeCategory = this.getCategory();
            if (this.categoryVisitor.isPresent()) {
                CategoryDefinition category = (CategoryDefinition)this.categoryVisitor.getDefinition();
                if (category != null) {
                    if (attributeCategory != null) {
                        ((CategoryDefinition)this.categoryVisitor.getDefinition()).log(Level.SEVERE, "only one of <category> element and (deprecated) \"category\" attribute allowed", new Object[0]);
                    }
                } else {
                    category = attributeCategory != null ? attributeCategory : AuditHook.this.resolveReference((ElementContext)context, "category", "oracle.ide.audit.undefined", this.definitionScope, CategoryDefinition.class);
                }
                ((HasCategory)((Object)definition)).setCategory(category);
            } else if (attributeCategory == null && !CategoryDefinition.class.isAssignableFrom(this.definitionType)) {
                this.log((ElementContext)context, Level.SEVERE, "<category> element required");
            }
        }
    }

    private abstract class BeanDefinitionVisitor<T extends BeanDefinition>
    extends TopLevelDefinitionVisitor<TopLevelDefinition, T> {
        private final TypeDefinitionVisitor implementationClassVisitor;
        private final ValueVisitor valueVisitor;
        private final ElementName implementationClassElementName;
        private final ElementName beanClassElementName;
        private final ElementName valueElementName;
        private final ElementName propertyElementName;

        public BeanDefinitionVisitor(DefinitionScope definitionScope, ValueVisitor valueVisitor) {
            super(definitionScope);
            this.beanClassElementName = AuditHook.newElementName("bean-class");
            this.valueElementName = AuditHook.newElementName("value");
            this.propertyElementName = AuditHook.newElementName("property");
            this.addRequiredStringElements("label", "description");
            String name = ((Object)((Object)this)).getClass().getName();
            this.implementationClassElementName = AuditHook.newElementName(name.substring(AuditHook.class.getName().length() + 1, name.length() - "DefinitionVisitor".length()).toLowerCase() + "-class");
            this.implementationClassVisitor = new ImplementationClassVisitor(this.implementationClassElementName);
            this.valueVisitor = valueVisitor;
        }

        @Override
        public void start(ElementStartContext context) {
            super.start(context);
            context.registerChildVisitor(this.beanClassElementName, (ElementVisitor)this.implementationClassVisitor);
            context.registerChildVisitor(this.implementationClassElementName, (ElementVisitor)this.implementationClassVisitor);
            this.implementationClassVisitor.reset();
            context.registerChildVisitor(this.valueElementName, (ElementVisitor)this.valueVisitor);
            context.registerChildVisitor(this.propertyElementName, (ElementVisitor)this.valueVisitor);
            this.valueVisitor.reset();
        }

        @Override
        public void end(ElementEndContext context) {
            BeanDefinition bean = (BeanDefinition)this.getDefinition();
            super.end(context);
            if (this.isError()) {
                return;
            }
            bean.setImplementationClass(this.implementationClassVisitor.getType());
            bean.setValues(this.valueVisitor.getValues());
        }

        public ValueVisitor getValueVisitor() {
            return this.valueVisitor;
        }
    }

    private class ImplementationClassVisitor
    extends TypeDefinitionVisitor {
        private final ElementName elementName;

        private ImplementationClassVisitor(ElementName elementName) {
            this.elementName = elementName;
        }

        @Override
        public void start(ElementStartContext context) {
            super.start(context);
            if ("bean-class".equals(context.getElementName().getLocalName())) {
                this.log((ElementContext)context, Level.WARNING, "<bean-class> element deprecated: use <{0}> element instead", new Object[]{this.elementName.getLocalName()});
            }
        }

        @Override
        public void end(ElementEndContext context) {
            super.end(context);
        }
    }

    private class TypeDefinitionVisitor<T>
    extends ElementVisitor {
        private TypeDefinition<T> type;

        private TypeDefinitionVisitor() {
        }

        protected void reset() {
            this.type = null;
        }

        public void start(ElementStartContext context) {
            super.start(context);
            context.registerVisitorFactory((ElementVisitorFactory)AuditHook.this.unexpectedElementVisitor);
            this.type = new TypeDefinition(AuditHook.this.extensionClassLoader, new DefinitionContext((ElementContext)context));
        }

        public void end(ElementEndContext context) {
            super.end(context);
            String className = AuditHook.this.nullTrimmedText(context.getText());
            if (className != null) {
                this.type.setTypeName(className);
            } else {
                this.log((ElementContext)context, Level.SEVERE, "<{0}> element text required", new Object[]{context.getElementName().getLocalName()});
            }
        }

        public TypeDefinition<T> getType() {
            return this.type;
        }
    }

    private class TopLevelReferencesVisitor<T extends TopLevelDefinition>
    extends TopLevelReferenceVisitor<T> {
        private Set<T> definitions;

        private TopLevelReferencesVisitor(Class<T> type, DefinitionScope scope) {
            super(type, scope, false);
        }

        @Override
        public void reset() {
            this.definitions = new HashSet<T>();
        }

        @Override
        public void start(ElementStartContext context) {
            super.start(context);
            context.registerVisitorFactory((ElementVisitorFactory)AuditHook.this.unexpectedElementVisitor);
        }

        @Override
        public void end(ElementEndContext context) {
            super.end(context);
            Object definition = this.getDefinition();
            if (definition != null) {
                this.definitions.add(definition);
            }
        }

        public Set<T> getDefinitions() {
            return this.definitions;
        }
    }

    private class TopLevelReferenceVisitor<T extends TopLevelDefinition>
    extends ElementVisitor {
        private final Class<T> definitionType;
        private final DefinitionScope<T> scope;
        private final boolean singleton;
        private T definition;
        private int count;

        public TopLevelReferenceVisitor(Class<T> definitionType, DefinitionScope scope, boolean singleton) {
            this.definitionType = definitionType;
            this.scope = scope;
            this.singleton = singleton;
        }

        public void reset() {
            this.definition = null;
            this.count = 0;
        }

        public void start(ElementStartContext context) {
            if (this.count++ > 0 && this.singleton) {
                this.log((ElementContext)context, Level.SEVERE, "only one <{0}> element allowed", new Object[]{context.getElementName().getLocalName()});
            }
            super.start(context);
            context.registerVisitorFactory((ElementVisitorFactory)AuditHook.this.unexpectedElementVisitor);
        }

        public void end(ElementEndContext context) {
            super.end(context);
            if (this.count == 1 || !this.singleton) {
                String id = AuditHook.this.nullTrimmedText(context.getText());
                if (id != null) {
                    this.definition = this.resolve(id, context, this.scope);
                } else {
                    this.log((ElementContext)context, Level.SEVERE, "<{0}> element text required", new Object[]{context.getElementName().getLocalName()});
                }
            }
        }

        protected T resolve(String id, ElementEndContext context, DefinitionScope<T> scope) {
            return AuditHook.this.resolveReference((ElementContext)context, null, id, scope, this.definitionType);
        }

        T getDefinition() {
            return this.definition;
        }

        boolean isPresent() {
            return this.count > 0;
        }
    }

    private abstract class TopLevelDefinitionVisitor<S extends TopLevelDefinition, T extends S>
    extends ElementVisitor {
        private final DefinitionScope<S> definitionScope;
        private final Set<String> allowedAttributes = new HashSet<String>();
        private final List<String> requiredAttributes = new ArrayList<String>();
        private final List<ElementName> requiredStringElements = new ArrayList<ElementName>();
        private final List<ElementName> optionalStringElements = new ArrayList<ElementName>();
        private String id;
        private CategoryDefinition category;
        private String name;
        private T definition;
        private boolean error;
        protected IdsVisitor deprecatedIdsVisitor = new IdsVisitor();
        protected StringVisitor stringVisitor = new StringVisitor();
        private final ElementName deprecatedIdsElementName = AuditHook.newElementName("deprecated-id");

        protected TopLevelDefinitionVisitor(DefinitionScope<S> scope) {
            this.definitionScope = scope;
            this.allowedAttributes.add("id");
            this.allowedAttributes.add("name");
        }

        protected void addRequiredAttributes(String ... names) {
            this.requiredAttributes.addAll(Arrays.asList(names));
            this.allowedAttributes.addAll(Arrays.asList(names));
        }

        protected void addAllowedAttributes(String ... names) {
            this.allowedAttributes.addAll(Arrays.asList(names));
        }

        protected void addRequiredStringElements(String ... names) {
            for (String name : names) {
                this.requiredStringElements.add(AuditHook.newElementName(name));
            }
        }

        protected void addOptionalStringElements(String ... names) {
            for (String name : names) {
                this.optionalStringElements.add(AuditHook.newElementName(name));
            }
        }

        protected String getId() {
            return this.id;
        }

        protected CategoryDefinition getCategory() {
            return this.category;
        }

        public T getDefinition() {
            return this.definition;
        }

        public void setDefinition(T definition) {
            this.definition = definition;
        }

        protected boolean isError() {
            return this.error;
        }

        public void start(ElementStartContext context) {
            super.start(context);
            context.registerVisitorFactory((ElementVisitorFactory)AuditHook.this.unexpectedElementVisitor);
            this.error = false;
            for (String attributeName : context.getAttributeNames()) {
                if (this.allowedAttributes.contains(attributeName)) continue;
                this.log((ElementContext)context, Level.WARNING, "\"{0}\" attribute not allowed", new Object[]{attributeName});
            }
            for (String attributeName : this.requiredAttributes) {
                String value = context.getAttributeValue(attributeName);
                if (value != null) continue;
                this.log((ElementContext)context, Level.SEVERE, "\"{0}\" attribute required", new Object[]{attributeName});
                this.error = true;
            }
            String categoryId = context.getAttributeValue("category");
            if (categoryId != null && this.allowedAttributes.contains("category")) {
                this.log((ElementContext)context, Level.WARNING, "\"category\" attribute deprecated, use <category> element instead");
                this.category = AuditHook.this.resolveReference((ElementContext)context, "category", categoryId, this.definitionScope, CategoryDefinition.class);
                if (this.category == null) {
                    this.category = AuditHook.this.resolveReference((ElementContext)context, "category", "oracle.ide.audit.undefined", this.definitionScope, CategoryDefinition.class);
                }
            } else {
                this.category = null;
            }
            this.id = context.getAttributeValue("id");
            this.name = context.getAttributeValue("name");
            if (this.id != null && this.id.startsWith("feature:")) {
                this.log((ElementContext)context, Level.SEVERE, "\"id\" must not begin with \"feature:\"");
                this.id = this.id.substring("feature:".length());
                this.error = true;
            }
            if (this.id != null && this.name == null) {
                if (!this.id.isEmpty()) {
                    if (!this.id.contains(".")) {
                        if (AuditHook.this.hookId != null) {
                            this.id = AuditHook.this.hookId + "." + this.id;
                        } else {
                            this.log((ElementContext)context, Level.WARNING, "id \"{0}\" should be qualified (contain \".\") or <audit-hook> \"id\" attribute should be supplied", new Object[]{this.id});
                        }
                    }
                    this.name = this.id.substring(this.id.lastIndexOf(46) + 1);
                } else {
                    this.name = "";
                    this.log((ElementContext)context, Level.SEVERE, "\"id\" attribute must not be empty");
                    this.error = true;
                }
            } else if (this.id == null && this.name != null) {
                if (AuditHook.this.hookId != null) {
                    this.log((ElementContext)context, Level.WARNING, "\"name\" attribute deprecated, use \"id=''" + this.name + "''\" instead");
                    this.id = AuditHook.this.hookId + "." + this.name;
                } else if (categoryId != null) {
                    this.id = categoryId + "." + this.name;
                    this.log((ElementContext)context, Level.WARNING, "\"name\" attribute deprecated, use \"id=''" + this.id + "''\" instead");
                } else {
                    this.log((ElementContext)context, Level.SEVERE, "deprecated \"name\" attribute requires qualifying id, use \"id='" + this.name + "'\" instead");
                    this.error = true;
                }
            } else if (this.id != null) {
                this.log((ElementContext)context, Level.SEVERE, "only one of \"id\" and \"name\" attributes allowed");
                this.name = this.id.substring(this.id.lastIndexOf(46) + 1);
                this.error = true;
            } else {
                this.log((ElementContext)context, Level.SEVERE, "\"id\" attribute required");
                this.error = true;
            }
            context.registerChildVisitor(this.deprecatedIdsElementName, (ElementVisitor)this.deprecatedIdsVisitor);
            this.deprecatedIdsVisitor.reset();
            for (ElementName elementName : this.requiredStringElements) {
                context.registerChildVisitor(elementName, (ElementVisitor)this.stringVisitor);
            }
            for (ElementName elementName : this.optionalStringElements) {
                context.registerChildVisitor(elementName, (ElementVisitor)this.stringVisitor);
            }
            this.stringVisitor.reset();
        }

        public void end(ElementEndContext context) {
            super.end(context);
            if (this.error) {
                return;
            }
            if (this.definition == null) {
                this.log((ElementContext)context, Level.SEVERE, "internal error: definition null");
                this.error = true;
                return;
            }
            T definition = this.definition;
            this.definition = null;
            if (this.definitionScope.contains(this.id)) {
                String previousElementName;
                S previousDefinition = this.definitionScope.get(this.id);
                String elementName = ((TopLevelDefinition)definition).getElementName();
                String message = elementName.equals(previousElementName = ((TopLevelDefinition)previousDefinition).getElementName()) ? "<{0}> \"{1}\" already defined in extension {3} ({4}:{5})" : "<{0}> \"{1}\" already defined (as <{2}>) in extension {3} ({4}:{5})";
                ((Definition)definition).log(Level.SEVERE, message, elementName, this.id, previousElementName, ((Definition)previousDefinition).getExtensionId(), ((Definition)previousDefinition).getSystemId(), ((Definition)previousDefinition).getLineNumber());
                this.error = true;
                return;
            }
            this.definitionScope.put((TopLevelDefinition)definition);
            if (!this.definitionScope.containsLocal(this.name)) {
                this.definitionScope.putLocal(this.name, (TopLevelDefinition)definition);
            } else {
                ((Definition)definition).log(Level.WARNING, "local name \"{0}\" duplicated in <audit-hook>", this.name);
            }
            List<String> deprecatedIds = this.deprecatedIdsVisitor.getIds();
            for (String deprecatedId : deprecatedIds) {
                String message;
                String previousElementName;
                String elementName;
                S previousDefinition;
                if (this.definitionScope.contains(deprecatedId)) {
                    previousDefinition = this.definitionScope.get(deprecatedId);
                    elementName = ((TopLevelDefinition)definition).getElementName();
                    message = elementName.equals(previousElementName = ((TopLevelDefinition)previousDefinition).getElementName()) ? "<{0}> deprecated id \"{1}\" already defined in extension {3} ({4}:{5})" : "<{0}> deprecated id \"{1}\" already defined (as <{2}>) in extension {3} ({4}:{5})";
                    ((Definition)definition).log(Level.SEVERE, message, elementName, deprecatedId, previousElementName, ((Definition)previousDefinition).getExtensionId(), ((Definition)previousDefinition).getSystemId(), ((Definition)previousDefinition).getLineNumber());
                    continue;
                }
                if (this.definitionScope.containsDeprecated(deprecatedId)) {
                    previousDefinition = this.definitionScope.getDeprecated(deprecatedId);
                    elementName = ((TopLevelDefinition)definition).getElementName();
                    message = elementName.equals(previousElementName = ((TopLevelDefinition)previousDefinition).getElementName()) ? "<{0}> deprecated id \"{1}\" already defined (deprecated) in extension {3} ({4}:{5})" : "<{0}> deprecated id \"{1}\" already defined (deprecated, as <{2}>) in extension {3} ({4}:{5})";
                    ((Definition)definition).log(Level.SEVERE, message, elementName, deprecatedId, previousElementName, ((Definition)previousDefinition).getExtensionId(), ((Definition)previousDefinition).getSystemId(), ((Definition)previousDefinition).getLineNumber());
                    continue;
                }
                this.definitionScope.putDeprecated(deprecatedId, (TopLevelDefinition)definition);
                ((TopLevelDefinition)definition).addDeprecatedId(deprecatedId);
            }
            ((TopLevelDefinition)definition).setStrings(this.stringVisitor.getStrings());
        }

        private class IdsVisitor
        extends ElementVisitor {
            private List<String> ids = new ArrayList<String>();

            private IdsVisitor() {
            }

            private void reset() {
                this.ids.clear();
            }

            public void start(ElementStartContext context) {
                super.start(context);
            }

            public void end(ElementEndContext context) {
                super.end(context);
                String id = AuditHook.this.nullTrimmedText(context.getText());
                if (id != null) {
                    if (this.ids == null) {
                        this.ids = new ArrayList<String>();
                    }
                    this.ids.add(id);
                } else {
                    this.log((ElementContext)context, Level.SEVERE, "<{0}> element text required", new Object[]{context.getElementName().getLocalName()});
                }
            }

            public List<String> getIds() {
                return this.ids;
            }
        }
    }
}

