/*
 * Decompiled with CFR 0.152.
 */
package oracle.viz.util.svg.internal;

import java.awt.Color;
import oracle.viz.util.svg.internal.Util;

public class SVGStyle {
    int fontSize = -1;
    String fontWeight = null;
    String fontStyle = null;
    String fontFamily = null;
    String fill = null;
    String svg_stroke = null;
    String svg_display = null;
    String svg_transform = null;
    float lineWidth = -1.0f;
    String dashArray = null;
    String dashPhase = null;

    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setDashPhase(float dashPhase) {
        if (dashPhase != 0.0f) {
            this.dashPhase = Float.toString(dashPhase);
        }
    }

    public String getDashPhase() {
        return this.dashPhase;
    }

    public void setDashArray(float[] dashArray) {
        if (dashArray != null) {
            StringBuffer sbuf = new StringBuffer();
            this.dashArray = "";
            int i = 0;
            while (i < dashArray.length - 1) {
                sbuf.append(dashArray[i]).append(",");
                ++i;
            }
            sbuf.append(dashArray[dashArray.length - 1]);
            this.dashArray = sbuf.toString();
        }
    }

    public String getDashArray() {
        return this.dashArray;
    }

    public void setFontSize(int points) {
        this.fontSize = points;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontStyle(int style) {
        switch (style) {
            case 1: {
                this.fontWeight = "bold";
                break;
            }
            case 0: {
                this.fontWeight = "normal";
                break;
            }
            case 2: {
                this.fontStyle = "italic";
            }
        }
    }

    public void setFontFamily(String Family) {
        this.fontFamily = Family;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setDisplay(String display) {
        this.svg_display = display;
    }

    public String getDisplay() {
        return this.svg_display;
    }

    public void setTransform(String transform) {
        this.svg_transform = transform;
    }

    public String getTransform() {
        return this.svg_transform;
    }

    public void setFill(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        StringBuffer fillSB = new StringBuffer();
        fillSB.append(Util.intToHex(r)).append(Util.intToHex(g)).append(Util.intToHex(b));
        this.fill = fillSB.toString();
    }

    public String getFill() {
        return this.fill;
    }

    public void setStroke(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        StringBuffer strokeSB = new StringBuffer();
        strokeSB.append(Util.intToHex(r)).append(Util.intToHex(g)).append(Util.intToHex(b));
        this.svg_stroke = strokeSB.toString();
    }

    public String getStroke() {
        return this.svg_stroke;
    }

    public String getSVG() {
        StringBuffer sbuf = new StringBuffer(this.getSVGInline());
        sbuf.append("/>");
        sbuf.append("\n");
        return sbuf.toString();
    }

    public String getSVGInline() {
        StringBuffer svg_inline_buf = new StringBuffer();
        svg_inline_buf.append(this.getSVGStyle()).append(" ");
        svg_inline_buf.append(this.getSVGTransform());
        return svg_inline_buf.toString();
    }

    public String getSVGStyle() {
        if (this.fill == null && this.svg_display == null && this.svg_transform == null && this.fontSize == -1 && this.fontWeight == null && this.fontStyle == null && this.fontFamily == null) {
            return "";
        }
        StringBuffer sbuf = new StringBuffer(" style=\"");
        if (this.svg_display != null) {
            sbuf.append("display:").append(this.svg_display).append("; ");
        }
        if (this.fill != null) {
            sbuf.append("fill: #").append(this.fill).append("; ");
        }
        if (this.svg_stroke != null) {
            sbuf.append("stroke: #").append(this.svg_stroke).append("; ");
        }
        if (this.fontSize != -1) {
            sbuf.append("font-size:").append(this.fontSize).append("; ");
        }
        if (this.fontStyle != null) {
            sbuf.append("font-style:").append(this.fontStyle).append("; ");
        }
        if (this.fontWeight != null) {
            sbuf.append("font-weight:").append(this.fontWeight).append("; ");
        }
        if (this.fontFamily != null) {
            sbuf.append("font-family:").append(this.fontFamily).append("; ");
        }
        sbuf.append("\"");
        if (this.lineWidth != -1.0f) {
            sbuf.append(" stroke-width=").append("\"").append(this.lineWidth).append("\"");
        }
        if (this.dashArray != null) {
            sbuf.append(" stroke-dasharray=").append("\"").append(this.dashArray).append("\"");
        }
        if (this.dashPhase != null) {
            sbuf.append(" stroke-dashoffset=").append("\"").append(this.dashPhase).append("\"");
        }
        return sbuf.toString();
    }

    public String getSVGTransform() {
        if (this.svg_transform == null) {
            return "";
        }
        StringBuffer sbuf = new StringBuffer(" transform=\"");
        if (this.svg_transform != null) {
            sbuf.append(this.svg_transform);
        }
        sbuf.append("\"");
        return sbuf.toString();
    }
}

