/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.status.window;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.EventObject;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.Editors;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockableWindow;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.status.IssueListener;
import oracle.ide.status.StatusBundle;
import oracle.ide.status.StatusManager;
import oracle.ide.status.window.StatusTable;
import oracle.ide.status.window.StatusTableModel;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.status.Issue;
import oracle.javatools.status.IssueList;
import oracle.javatools.status.Severity;
import oracle.javatools.util.FormatBundle;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdevimpl.audit.util.Cache;

public class StatusWindow
extends DockableWindow
implements Controller,
ContextMenuListener,
ActiveViewListener,
ViewSelectionListener,
IssueListener,
Observer,
MouseListener,
ListSelectionListener {
    public static final String VIEW_ID = "STATUS.STATUS";
    private View focusedView;
    private View activeView;
    private Workspace workspace;
    private Project project;
    private Node node;
    private URL file;
    private String label;
    private NodeListener nodeListener = new FocusNodeListener();
    private JPanel component;
    private Toolbar toolbar;
    private StatusTable table;
    private ContextMenu contextMenu;
    private IdeAction fixAction;
    private IdeAction gotoSourceAction;
    private List<IdeAction> filterActions;
    private final EnumSet<Severity> SEVERITIES = EnumSet.range(Severity.ERROR, Severity.ADVISORY);
    private final EnumSet<Severity> DEFAULT_FILTER = EnumSet.range(Severity.ERROR, Severity.INCOMPLETE);
    private EnumSet<Severity> filter;
    private static final String CACHE_PREFIX = "status.window.";
    private StatusTableModel EMPTY_MODEL;
    private static final FormatBundle BUNDLE = new FormatBundle(StatusBundle.class);
    private static final Log LOG = new Log("status-ui");

    public StatusWindow() {
        super(VIEW_ID);
        this.setType(32);
    }

    public String getTabName() {
        return BUNDLE.get("status.window.tab.label");
    }

    public Icon getTabIcon() {
        return OracleIcons.getIcon((String)"unknownstatus.png");
    }

    public String getTitleName() {
        if (this.label == null) {
            return BUNDLE.get("status.window.null.title");
        }
        return BUNDLE.get("status.window.title", new Object[]{this.label});
    }

    public Toolbar getToolbar() {
        return this.toolbar;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_idestatuswindow_html");
    }

    public ContextMenu getContextMenu() {
        if (this.contextMenu == null) {
            this.contextMenu = new ContextMenu();
        }
        return this.contextMenu;
    }

    public Component getGUI() {
        LOG.trace("getting UI");
        if (this.component == null) {
            this.filter = EnumSet.noneOf(Severity.class);
            for (Severity severity : this.SEVERITIES) {
                if (!Cache.get((String)(CACHE_PREFIX + severity.toString().toLowerCase()), (boolean)this.DEFAULT_FILTER.contains(severity))) continue;
                this.filter.add(severity);
            }
            LOG.trace("creating actions");
            this.filterActions = new ArrayList<IdeAction>();
            for (Severity severity : this.SEVERITIES) {
                String name = "show-" + severity.toString().toLowerCase();
                int cid = Ide.findOrCreateCmdID((String)("status." + name));
                Integer mnemonic = null;
                String label = BUNDLE.get(name + ".label");
                IdeAction action = IdeAction.get((int)cid, null, (String)label, null, mnemonic, (Icon)severity.getIcon(), null, (boolean)true);
                action.addController((Controller)this);
                action.putValue("Check", (Object)Boolean.TRUE);
                action.putValue("State", (Object)this.filter.contains(severity));
                action.putValue("ShortDescription", (Object)label);
                action.putValue(Severity.class.getName(), (Object)severity);
                this.filterActions.add(action);
            }
            this.fixAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"status.fix"), null, (String)BUNDLE.get("fix.label"), null, null, (Icon)OracleIcons.getIcon((String)"fix.png"), null, (boolean)false);
            this.fixAction.addController((Controller)this);
            this.gotoSourceAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"status.goto-source"), null, (String)BUNDLE.get("goto-source.label"), null, null, null, null, (boolean)false);
            this.gotoSourceAction.addController((Controller)this);
            LOG.trace("creating UI");
            this.component = new JPanel(new BorderLayout());
            LOG.trace("creating status panel");
            this.toolbar = new Toolbar();
            for (IdeAction action : this.filterActions) {
                this.toolbar.addToggleButton((ToggleAction)action);
            }
            this.toolbar.addSeparator();
            MenuToolButton fixButton = new MenuToolButton((ToggleAction)this.fixAction);
            fixButton.addPopupMenuListener((PopupMenuListener)new FixButtonListener(fixButton));
            this.toolbar.add((Component)fixButton);
            this.EMPTY_MODEL = new StatusTableModel(null, null, null, this.filter, null);
            this.table = new StatusTable(this.EMPTY_MODEL);
            ListSelectionModel selectionModel = this.table.getSelectionModel();
            selectionModel.setSelectionMode(2);
            selectionModel.addListSelectionListener(this);
            this.table.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "goto-source");
            this.table.getActionMap().put("goto-source", (Action)this.gotoSourceAction);
            JScrollPane scrollPane = new JScrollPane((Component)((Object)this.table));
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
            JViewport viewport = scrollPane.getViewport();
            viewport.setBackground(this.table.getBackground());
            scrollPane.setViewportBorder(BorderFactory.createEmptyBorder(2, 1, 2, 1));
            this.component.add((Component)this.toolbar, "North");
            this.component.add((Component)scrollPane, "Center");
            this.getContextMenu().addContextMenuListener((ContextMenuListener)this);
            Ide.getWorkspaces().attach((Observer)this);
            this.table.addMouseListener(this);
            this.table.getTableHeader().addMouseListener(this);
            this.component.addMouseListener(this);
            viewport.addMouseListener(this);
            this.component.putClientProperty("print.printable", Boolean.TRUE);
        }
        return this.component;
    }

    private void setIssues(URL file, Project project, Workspace workspace, IssueList issues) {
        this.updateIssues(file, project, workspace, issues);
        this.fireTitleChangeListener();
    }

    public Context getContext(EventObject event) {
        Context context = new Context((View)this, this.workspace, this.project, this.node);
        context.setEvent(event);
        return context;
    }

    public void stateChange(int newState) {
        LOG.trace("state changed to {0}", newState);
        super.stateChange(newState);
        switch (newState) {
            case 1: {
                LOG.trace("status window shown");
                Ide.getMainWindow().addActiveViewListener((ActiveViewListener)this);
                this.setView(Ide.getMainWindow().getLastActiveView());
                break;
            }
            case 2: {
                LOG.trace("status window hidden");
                break;
            }
            case 3: {
                LOG.trace("status window closed");
                Ide.getMainWindow().removeActiveViewListener((ActiveViewListener)this);
                this.clearView();
            }
        }
    }

    public void update(Object observed, UpdateMessage change) {
        if (change.getMessageID() == UpdateMessage.CHILD_REMOVED) {
            for (Object object : change.getRemoveObjects()) {
                if (object == this.workspace) {
                    LOG.trace("workspace {0} removed", (Object)this.workspace);
                    this.clearFocus();
                    continue;
                }
                if (object != this.project) continue;
                LOG.trace("project {0} removed", (Object)this.project);
                this.clearFocus();
            }
        }
    }

    public void activeViewChanged(ActiveViewEvent event) {
        View view = event.getNewView();
        LOG.trace("active view changed to {0}", (Object)view);
        if (view != this) {
            this.setView(view);
        }
    }

    public void viewSelectionChanged(ViewSelectionEvent event) {
        View view = event.getView();
        LOG.trace("view selection changed in {0} to {1}", (Object)view, (Object)event.getSelection());
        this.setView(view);
    }

    @Override
    public void statusChanged(final URL file, final Project project, final Workspace workspace, final IssueList issues) {
        LOG.trace("status changed {0}", (Object)issues);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (URLFileSystem.equals((URL)StatusWindow.this.file, (URL)file) && StatusWindow.this.project == project && StatusWindow.this.workspace == workspace) {
                    LOG.trace("updating table for status changed {0}", (Object)issues);
                    StatusWindow.this.setIssues(file, project, workspace, issues);
                }
            }
        });
    }

    private void setView(View view) {
        Context context = view.getContext();
        LOG.trace("setting view {0}, context {1}", (Object)view, (Object)context);
        if (this.isFocusable(context)) {
            if (view != this.activeView) {
                if (this.activeView != null) {
                    this.activeView.removeViewSelectionListener((ViewSelectionListener)this);
                }
                view.addViewSelectionListener((ViewSelectionListener)this);
            }
            if (view != this.focusedView && this.focusedView != this.activeView && this.focusedView != null) {
                this.focusedView.removeViewSelectionListener((ViewSelectionListener)this);
            }
            this.setFocus(context);
            this.focusedView = view;
            LOG.trace("focused and active view {0}", (Object)view);
        } else {
            if (view != this.activeView) {
                if (this.activeView != null) {
                    this.activeView.removeViewSelectionListener((ViewSelectionListener)this);
                }
                view.addViewSelectionListener((ViewSelectionListener)this);
            }
            LOG.trace("focused view {0}, active view {1}", (Object)this.focusedView, (Object)view);
        }
        this.activeView = view;
    }

    private void clearView() {
        LOG.trace("clearing focused view {0}, active view {1}", (Object)this.focusedView, (Object)this.activeView);
        if (this.activeView != null) {
            this.activeView.removeViewSelectionListener((ViewSelectionListener)this);
        }
        if (this.focusedView != null) {
            this.focusedView.removeViewSelectionListener((ViewSelectionListener)this);
            this.clearFocus();
            this.focusedView = null;
        }
        this.activeView = null;
    }

    private boolean isFocusable(Context context) {
        return this.focusableNode(context) != null;
    }

    private Node focusableNode(Context context) {
        Workspace workspace = context.getWorkspace();
        if (workspace == null) {
            return null;
        }
        Project project = context.getProject();
        Element[] selection = context.getSelection();
        Node node = context.getNode();
        switch (selection.length) {
            case 0: {
                if (node != null && node != project && node != workspace) break;
                return null;
            }
            case 1: {
                if (!(selection[0] instanceof Node)) break;
                node = (Node)selection[0];
                break;
            }
            default: {
                if (!(selection[0] instanceof Node)) break;
                return null;
            }
        }
        if (node == null || node.getURL() == null || node == project || node == workspace) {
            return null;
        }
        return node;
    }

    private void setFocus(Context context) {
        Node node = this.focusableNode(context);
        URL file = node.getURL();
        Project project = context.getProject();
        Workspace workspace = context.getWorkspace();
        this.setFocus(file, node, project, workspace);
    }

    private void setFocus(URL file, Node node, Project project, Workspace workspace) {
        if (URLFileSystem.equals((URL)file, (URL)this.file) && project == this.project && workspace == this.workspace) {
            return;
        }
        LOG.trace("setting focus to {0}", (Object)file);
        StatusManager manager = StatusManager.getStatusManager();
        LOG.trace("clearing old focus from {0}", (Object)this.file);
        manager.removeIssueListener(this.file, this.project, this.workspace, this);
        if (this.node != null) {
            this.node.removeNodeListener(this.nodeListener);
        }
        if (this.workspace != null) {
            this.workspace.detach((Observer)this);
        }
        workspace.attach((Observer)this);
        node.addNodeListener(this.nodeListener);
        IssueList issues = manager.addIssueListener(file, project, workspace, this, (View)this);
        this.workspace = workspace;
        this.project = project;
        this.node = node;
        this.file = file;
        this.label = node.getShortLabel();
        this.setIssues(file, project, workspace, issues);
        this.fireTitleChangeListener();
    }

    private void clearFocus() {
        LOG.trace("clearing focus from {0}", (Object)this.file);
        StatusManager.getStatusManager().removeIssueListener(this.file, this.project, this.workspace, this);
        if (this.node != null) {
            this.node.removeNodeListener(this.nodeListener);
        }
        if (this.workspace != null) {
            this.workspace.detach((Observer)this);
        }
        this.file = null;
        this.node = null;
        this.project = null;
        this.workspace = null;
        this.label = null;
        this.updateIssues(this.file, this.project, this.workspace, null);
        this.fireTitleChangeListener();
    }

    public void updateIssues(URL file, Project project, Workspace workspace, IssueList issues) {
        StatusTableModel model = issues == null ? this.EMPTY_MODEL : new StatusTableModel(file, project, workspace, this.filter, issues);
        this.table.setModel(model);
    }

    private void gotoSourceAtRow(int row) {
        boolean success;
        if (row < 0 || row >= this.table.getRowCount()) {
            return;
        }
        StatusTableModel model = this.table.getStatusModel();
        Issue issue = model.getIssueAt(row);
        if (issue instanceof Violation) {
            Violation violation = (Violation)issue;
            Location location = violation.getFocusLocation();
            if (location == null) {
                location = violation.getLocation();
            }
            success = location.getModel().edit(location);
        } else {
            URL file = model.getFile();
            Node node = NodeFactory.find((URL)file);
            LOG.trace("opening {0} in code editor", (Object)file);
            success = Editors.editNode((Workspace)model.getWorkspace(), (Project)model.getProject(), (Node)node, (int)issue.getOffset(), (int)issue.getLength(), (boolean)false);
        }
        if (!success) {
            Ide.getStatusBar().setText(BUNDLE.get("goto-source.uneditable-file.message"));
            Toolkit.getDefaultToolkit().beep();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && e.getSource() == this.table) {
            this.gotoSourceAtRow(this.table.rowAtPoint(e.getPoint()));
        } else if (e.isPopupTrigger()) {
            this.getContextMenu().show(this.getContext(e));
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.getContextMenu().show(this.getContext(e));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.getContextMenu().show(this.getContext(e));
        }
    }

    public boolean update(IdeAction action, Context context) {
        if (action.getValue(Severity.class.getName()) != null) {
            return true;
        }
        if (action == this.fixAction) {
            int[] rows = this.table.getSelectedRows();
            this.fixAction.setEnabled(rows.length == 1 && rows[0] >= 0 && rows[0] < this.table.getRowCount() && this.table.getStatusModel().getIssueAt(rows[0]).hasTransforms());
            return true;
        }
        if (action == this.gotoSourceAction) {
            int[] rows = this.table.getSelectedRows();
            this.gotoSourceAction.setEnabled(context.getEvent().getSource() == this.table && rows.length == 1 && rows[0] >= 0 && rows[0] < this.table.getRowCount());
            return true;
        }
        return action.getValue(Action.class.getName()) != null;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        Severity severity = (Severity)action.getValue(Severity.class.getName());
        if (severity != null) {
            boolean selected = (Boolean)action.getValue("State");
            if (selected) {
                this.filter.add(severity);
            } else {
                this.filter.remove(severity);
            }
            this.table.getStatusModel().setFilter(this.filter);
            Cache.put((String)(CACHE_PREFIX + severity.toString().toLowerCase()), (boolean)selected);
            return true;
        }
        if (action == this.fixAction) {
            return true;
        }
        if (action == this.gotoSourceAction) {
            int[] rows = this.table.getSelectedRows();
            if (rows.length == 1 && rows[0] >= 0 && rows[0] < this.table.getRowCount()) {
                this.gotoSourceAtRow(rows[0]);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
            return true;
        }
        if (action.getValue(Action.class.getName()) != null) {
            ((Action)action.getValue(Action.class.getName())).actionPerformed(null);
            return true;
        }
        return false;
    }

    public boolean handleDefaultAction(Context context) {
        LOG.trace("handle default action {0}, context {1}", (Object)this, (Object)context);
        return false;
    }

    public void menuWillHide(ContextMenu menu) {
    }

    public void menuWillShow(ContextMenu menu) {
        Issue issue;
        if (menu == null) {
            return;
        }
        Context context = menu.getContext();
        if (context == null || context.getView() != this) {
            return;
        }
        float FIX_SECTION = 1.0f;
        float FILTER_SECTION = 2.0f;
        float GOTO_SOURCE_SECTION = 3.0f;
        int[] rows = this.table.getSelectedRows();
        if (rows.length == 1 && rows[0] >= 0 && rows[0] < this.table.getRowCount() && (issue = this.table.getStatusModel().getIssueAt(rows[0])).hasTransforms()) {
            for (Action transform : issue.getTransforms()) {
                JMenuItem menuItem = menu.createMenuItem((ToggleAction)new FixAction(transform));
                menuItem.setToolTipText((String)transform.getValue("ShortDescription"));
                menu.add((Component)menuItem, FIX_SECTION);
            }
        }
        for (IdeAction action : this.filterActions) {
            JMenuItem menuItem = menu.createMenuItem((ToggleAction)new IconlessToggleAction(action));
            menu.add((Component)menuItem, FILTER_SECTION);
        }
        menu.add((Component)menu.createMenuItem((ToggleAction)this.gotoSourceAction), GOTO_SOURCE_SECTION);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int[] rows = this.table.getSelectedRows();
        if (rows.length == 1 && rows[0] >= 0 && rows[0] < this.table.getRowCount()) {
            this.fixAction.setEnabled(this.table.getStatusModel().getIssueAt(rows[0]).hasTransforms());
            this.gotoSourceAction.setEnabled(true);
        } else {
            this.fixAction.setEnabled(false);
            this.gotoSourceAction.setEnabled(false);
        }
    }

    private class FocusNodeListener
    extends NodeListener {
        private FocusNodeListener() {
        }

        public void nodeDeleted(NodeEvent e) {
            StatusWindow.this.clearFocus();
        }

        public void nodeWillClose(NodeEvent e) {
            StatusWindow.this.clearFocus();
        }

        public void nodeRenamed(NodeEvent e, URL oldUrl, URL newUrl) {
            Node newNode = NodeFactory.find((URL)newUrl);
            if (newNode != null) {
                StatusWindow.this.setFocus(newUrl, newNode, StatusWindow.this.project, StatusWindow.this.workspace);
            } else {
                StatusWindow.this.clearFocus();
            }
        }
    }

    private class FixButtonListener
    implements PopupMenuListener {
        private MenuToolButton button;

        public FixButtonListener(MenuToolButton button) {
            this.button = button;
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            this.button.removeAllPopupItems();
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            this.button.removeAllPopupItems();
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.button.removeAllPopupItems();
            int row = StatusWindow.this.table.getSelectedRow();
            if (row < 0) {
                return;
            }
            Issue issue = StatusWindow.this.table.getStatusModel().getIssueAt(row);
            if (issue.hasTransforms()) {
                for (Action transform : issue.getTransforms()) {
                    this.button.addPopupItem((ToggleAction)new FixAction(transform));
                }
            }
        }
    }

    private static class FixAction
    extends ToggleAction {
        private Action delegate;

        public FixAction(Action delegate) {
            super((String)delegate.getValue("Name"), (Icon)delegate.getValue("SmallIcon"));
            this.delegate = delegate;
            this.putValue("ShortDescription", delegate.getValue("ShortDescription"));
            this.setEnabled(delegate.isEnabled());
        }

        public void actionPerformed(ActionEvent e) {
            this.delegate.actionPerformed(e);
        }
    }

    private class IconlessToggleAction
    extends ToggleAction {
        private IdeAction action;

        public IconlessToggleAction(IdeAction action) {
            super((ToggleAction)action);
            this.action = action;
        }

        public void actionPerformed(ActionEvent e) {
            this.action.actionPerformed(e);
        }

        public Object getValue(String key) {
            if (this.action == null || key == "SmallIcon") {
                return null;
            }
            return this.action.getValue(key);
        }

        public void putValue(String key, Object newValue) {
            if (this.action == null) {
                return;
            }
            this.action.putValue(key, newValue);
        }

        public Object[] getKeys() {
            if (this.action == null) {
                return new Object[0];
            }
            return this.action.getKeys();
        }
    }
}

