/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.mapviewer.model;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.spatial.mapviewer.components.MapViewerHelper;
import oracle.dbtools.spatial.mapviewer.view.SpatialDelayedComboBox;
import oracle.dbtools.util.Logger;

public class SpatialComboBoxLoader {
    private LoaderTask _loaderTask;
    private boolean _taskStarted;
    private String queryString;
    private Connection connection;

    public SpatialComboBoxLoader(Connection connection) {
        this.connection = connection;
    }

    public void setQuery(String string) {
        this.queryString = string;
    }

    public void init(SpatialDelayedComboBox spatialDelayedComboBox, Object object) {
        this._loaderTask = new LoaderTask(spatialDelayedComboBox, object);
        this._taskStarted = false;
    }

    public String getConnectionName() {
        return "";
    }

    public void start() {
        if (!this._taskStarted) {
            RaptorTaskManager.getInstance().addTask((RaptorTask)this._loaderTask);
            this._taskStarted = true;
        }
    }

    public void addListener(IRaptorTaskListener iRaptorTaskListener) {
        this._loaderTask.getDescriptor().addListener(iRaptorTaskListener);
    }

    public List<Object> getComboContents() throws TaskException {
        List<Object> list = Collections.emptyList();
        if (this.queryString == null || this.queryString.length() < 1) {
            return Collections.emptyList();
        }
        if (MapViewerHelper.isConnectionValid(this.connection)) {
            Object[] objectArray;
            this.queryString = MapViewerHelper.purgeLastSemicolon(this.queryString);
            try {
                objectArray = MapViewerHelper.getColumnNames(this.queryString, this.connection);
            }
            catch (Exception exception) {
                System.err.println("SpatialComboboxLoader.getComboContents(): " + exception.getMessage());
                return Collections.emptyList();
            }
            if (objectArray == null || objectArray.length <= 0) {
                return Collections.emptyList();
            }
            Arrays.sort(objectArray);
            list = new ArrayList<Object>(Arrays.asList(objectArray));
        }
        return list;
    }

    private class LoaderTask
    extends DatabaseQueryTask<List<Object>> {
        private static final String NAME_SFX = " SpatialDelayedLoadingComboBox.Loader";
        private SpatialDelayedComboBox _combo;
        private Object _value;

        public LoaderTask(SpatialDelayedComboBox spatialDelayedComboBox, Object object) {
            super(spatialDelayedComboBox.getName() + NAME_SFX, IRaptorTaskRunMode.NO_GUI, false, true, true);
            this.getDescriptor().addListener((IRaptorTaskListener)new WaitOver());
            this._combo = spatialDelayedComboBox;
            this._value = object;
        }

        public String getConnectionName() {
            return SpatialComboBoxLoader.this.getConnectionName();
        }

        public String getQuery() {
            return this.getDescriptor().getName();
        }

        protected List<Object> doWork() throws TaskException {
            try {
                return SpatialComboBoxLoader.this.getComboContents();
            }
            catch (TaskException taskException) {
                throw taskException;
            }
            catch (Exception exception) {
                Logger.warn(((Object)((Object)this)).getClass(), (Throwable)exception);
                throw new TaskException((Throwable)exception);
            }
        }

        protected void invokeLater() {
            try {
                this._combo.populate((List)this.getResult(), this._value);
            }
            catch (Exception exception) {
                Logger.warn(((Object)((Object)this)).getClass(), (Throwable)exception);
            }
        }

        private class WaitOver
        extends RaptorTaskAdapter {
            private WaitOver() {
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        LoaderTask.this.invokeLater();
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
    }
}

