/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.markers;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import oracle.ide.adapters.AdapterManager;
import oracle.ide.markers.Markable;
import oracle.ide.markers.Marker;
import oracle.ide.markers.MarkerException;
import oracle.ide.markers.MarkerTypeFilter;
import oracle.ide.net.URLFileSystem;
import oracle.ideimpl.markers.MarkerImpl;
import oracle.ideimpl.markers.MarkerStore;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Filter;

public class MarkableImpl
implements Markable {
    public static final int MARKABLE_RANK_OFFSET = 100;
    private static final String UNAUTH_MARKER_IMPL_MSG = "Unauthorized Marker implementation: {0}";
    private static final int DEFAULT_RANK = Integer.MAX_VALUE;
    private final Markable facade;
    private final URL resource;
    private final List<Marker> rankedMarkers = new CopyOnWriteArrayList<Marker>();
    private boolean dirty = false;
    private int rank = Integer.MAX_VALUE;
    private MarkerStore store;

    public MarkableImpl(URL resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Resource URL must not be null!");
        }
        this.facade = null;
        this.resource = resource;
    }

    public MarkableImpl(Markable facade) {
        if (facade == null) {
            throw new IllegalArgumentException("Facade Markable must not be null");
        }
        this.facade = facade;
        this.resource = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMarkers(Marker ... markers) throws MarkerException {
        if (null == markers || markers.length == 0) {
            return;
        }
        try {
            for (Marker marker : markers) {
                if (!Proxy.isProxyClass(marker.getClass())) {
                    throw new MarkerException(MessageFormat.format(UNAUTH_MARKER_IMPL_MSG, marker.getClass()));
                }
                try {
                    InvocationHandler handler = Proxy.getInvocationHandler(marker);
                    if (!(handler instanceof MarkerImpl)) {
                        throw new MarkerException(MessageFormat.format(UNAUTH_MARKER_IMPL_MSG, handler.getClass()));
                    }
                }
                catch (IllegalArgumentException iae) {
                    throw new MarkerException(MessageFormat.format(UNAUTH_MARKER_IMPL_MSG, marker.getClass()));
                }
                marker.setMarkable(null != this.facade ? this.facade : this);
                this.rankedMarkers.add(marker);
            }
            MarkerStore store = this.getMarkerStore();
            if (null == store) {
                throw new MarkerException("Unable to access marker store");
            }
            store.addMarkers(markers);
        }
        finally {
            this.setDirty(true);
        }
    }

    private MarkerStore getMarkerStore() {
        if (null == this.store) {
            this.store = MarkerStore.Factory.getMarkerStore(this.facade);
        }
        return this.store;
    }

    @Override
    public List<Marker> getMarkers() {
        Filter filter = Filter.Instances.acceptsAll();
        return this.getMarkers((Filter<Marker>)filter);
    }

    @Override
    public List<Marker> getMarkers(Filter<Marker> filter) {
        MarkerStore store = this.getMarkerStore();
        if (null == store) {
            return Collections.emptyList();
        }
        Collection<Marker> storedMarkers = store.getMarkers(null != this.facade ? this.facade : this);
        ArrayList<Marker> allMarkers = new ArrayList<Marker>(storedMarkers);
        if (null == filter) {
            return allMarkers;
        }
        ArrayList<Marker> filteredMarkers = new ArrayList<Marker>();
        for (Marker marker : allMarkers) {
            if (!filter.matches((Object)marker)) continue;
            filteredMarkers.add(marker);
        }
        return filteredMarkers;
    }

    @Override
    public List<Marker> removeMarkers() throws MarkerException {
        return this.removeMarkers(this.getMarkers().toArray(new Marker[0]));
    }

    @Override
    public <M extends Marker> List<M> removeMarkers(Class<M> type, boolean includeSubtypes) throws MarkerException {
        List<M> toRemove = this.getMarkers(type, includeSubtypes);
        Marker[] array = toRemove.toArray((Marker[])Array.newInstance(type, toRemove.size()));
        return this.removeMarkers(array);
    }

    @Override
    public List<Marker> removeMarkers(Filter<Marker> filter) throws MarkerException {
        List<Marker> filteredMarkers = this.getMarkers(filter);
        return this.removeMarkers(filteredMarkers.toArray(new Marker[0]));
    }

    @Override
    public <M extends Marker> List<M> removeMarkers(M ... markers) throws MarkerException {
        if (null == markers || markers.length == 0) {
            return Collections.emptyList();
        }
        MarkerStore store = this.getMarkerStore();
        if (null == store) {
            throw new MarkerException("Unable to access marker store");
        }
        ArrayList removedMarkers = new ArrayList(store.removeMarkers((Marker[])markers));
        this.rankedMarkers.removeAll(removedMarkers);
        this.setDirty(true);
        return removedMarkers;
    }

    @Override
    public URL getUrl() {
        return this.resource != null ? this.resource : this.facade.getUrl();
    }

    @Override
    public <M extends Marker> List<M> getMarkers(Class<M> type, boolean includeSubtypes) {
        return this.getMarkers(new MarkerTypeFilter(type, includeSubtypes));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MarkableImpl)) {
            return false;
        }
        MarkableImpl other = (MarkableImpl)object;
        String s1 = String.valueOf(this.resource);
        String s2 = String.valueOf(other.resource);
        return s1.equals(s2);
    }

    @Override
    public int hashCode() {
        int PRIME = 37;
        int result = 1;
        result = 37 * result + (this.resource == null ? 0 : String.valueOf(this.resource).hashCode());
        return result;
    }

    @Override
    public int compareTo(Markable o) {
        Comparator comparator = (Comparator)AdapterManager.Factory.getAdapterManager().adapt((Object)this.facade, Comparator.class);
        if (null == comparator) {
            return 0;
        }
        return comparator.compare(this.facade, o);
    }

    public synchronized int getRank() {
        if (this.rankedMarkers.isEmpty()) {
            return this.computeRank(this.getMarkers());
        }
        if (this.isDirty()) {
            this.rank = this.computeRank(this.rankedMarkers);
            this.setDirty(false);
        }
        return this.rank;
    }

    private int computeRank(List<Marker> markers) {
        if (null == markers || markers.isEmpty()) {
            return Integer.MAX_VALUE;
        }
        ArrayList<Marker> sortedMarkers = new ArrayList<Marker>(markers);
        Collections.sort(sortedMarkers);
        Marker topMarker = (Marker)sortedMarkers.get(0);
        long markerRank = topMarker.rank();
        int majorRank = (int)markerRank & 0xFFFFFFFF;
        return majorRank - 100;
    }

    public synchronized boolean isDirty() {
        return this.dirty;
    }

    public synchronized void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public String getShortLabel() {
        return URLFileSystem.getFileName((URL)this.getUrl());
    }

    public String getLongLabel() {
        return URLFileSystem.toDisplayString((URL)this.getUrl());
    }

    public Icon getIcon() {
        return OracleIcons.getIcon((String)"file.png");
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }
}

