/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.markers;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.markers.MarkerJob;
import oracle.ide.markers.MarkerJobNodeOperator;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;

public class MarkerJobForFileScope
implements MarkerJob,
MarkerJobNodeOperator,
ActiveViewListener,
ViewSelectionListener {
    private final BlockingQueue<Node> nodes = new LinkedBlockingQueue<Node>();
    private final MarkerJobNodeOperator nodeOperator;

    public MarkerJobForFileScope(MarkerJobNodeOperator nodeOperator) {
        if (null == nodeOperator) {
            throw new IllegalArgumentException("Node operator must not be null");
        }
        this.nodeOperator = nodeOperator;
        IdeMainWindow mainWindow = Ide.getMainWindow();
        if (null != mainWindow) {
            mainWindow.addActiveViewListener((ActiveViewListener)this);
        }
    }

    @Override
    public final void run() {
        while (!Thread.interrupted()) {
            try {
                Node node = this.nodes.take();
                this.operate(node);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public final void activeViewChanged(ActiveViewEvent e) {
        View newView;
        View oldView = e.getOldView();
        if (null != oldView) {
            oldView.removeViewSelectionListener((ViewSelectionListener)this);
        }
        if (null == (newView = e.getNewView())) {
            newView = Ide.getMainWindow().getLastActiveView();
        }
        newView.addViewSelectionListener((ViewSelectionListener)this);
        Context context = new Context(newView.getContext());
        context.setView(null);
        Node node = this.getNode(context);
        this.processContextNode(node);
    }

    public final void viewSelectionChanged(ViewSelectionEvent e) {
        View view = e.getView();
        if (Ide.getMainWindow().getLastActiveView() == view) {
            Context context = new Context(view.getContext());
            context.setView(null);
            Node node = this.getNode(context);
            this.processContextNode(node);
        }
    }

    protected Node getNode(Context context) {
        if (null == context) {
            return null;
        }
        Workspace workspace = context.getWorkspace();
        Project project = context.getProject();
        Element[] selection = context.getSelection();
        Node node = context.getNode();
        switch (selection.length) {
            case 0: {
                if (node != null && node != project && node != workspace) break;
                View view = context.getView();
                if (null == view) {
                    return null;
                }
                Context viewContext = new Context(view.getContext());
                viewContext.setView(null);
                return this.getNode(viewContext);
            }
            case 1: {
                if (!(selection[0] instanceof Node)) break;
                node = (Node)selection[0];
                break;
            }
            default: {
                if (!(selection[0] instanceof Node)) break;
                return null;
            }
        }
        if (node == null || node.getURL() == null || node == project || node == workspace) {
            View view = context.getView();
            if (null == view) {
                return null;
            }
            Context viewContext = new Context(view.getContext());
            viewContext.setView(null);
            return this.getNode(viewContext);
        }
        return node;
    }

    protected final void processContextNode(Node node) {
        if (null == node) {
            return;
        }
        if (this.isInteresting(node)) {
            try {
                this.nodes.put(node);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isInteresting(Node node) {
        if (this.nodes.contains(node)) {
            return false;
        }
        return this.nodeOperator.isInteresting(node);
    }

    public Void operate(Node node) {
        return (Void)this.nodeOperator.operate(node);
    }
}

