/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.validate;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.ValidationMessageModel;
import oracle.bali.ewt.validate.ValidationPainter;
import oracle.bali.share.collection.StringKey;

public class DefaultValidationPainter
implements ValidationPainter {
    private static final Object _VALIDATION_BORDER_KEY = new StringKey("_EWTValidationBorder");
    private static final Border _ERROR_BORDER = new ValidationBorder((Border)new LineBorder(new Color(153, 0, 0)), new LineBorder(new Color(255, 51, 51)));
    private static final Border _WARN_BORDER = new ValidationBorder((Border)new LineBorder(new Color(255, 141, 39)), new LineBorder(new Color(255, 204, 51)));
    private static ValidationPainter _sValidationPainter;

    protected DefaultValidationPainter() {
    }

    public static ValidationPainter getValidationPainter() {
        if (_sValidationPainter == null) {
            _sValidationPainter = new DefaultValidationPainter();
        }
        return _sValidationPainter;
    }

    @Override
    public void paintComponent(ValidationComponent comp) {
        if (comp.isValid()) {
            this.paintValidState(comp);
        } else {
            this.paintInValidState(comp);
        }
    }

    public void paintInValidState(ValidationComponent vComp) {
        ValidationMessageModel model;
        Component comp = vComp.getComponent();
        if (!(comp instanceof JComponent)) {
            throw new IllegalArgumentException();
        }
        JComponent jcomp = (JComponent)comp;
        Border prevValidBorder = jcomp.getBorder();
        if (!(prevValidBorder instanceof ValidationBorder)) {
            jcomp.putClientProperty(_VALIDATION_BORDER_KEY, prevValidBorder);
        }
        if ((model = vComp.getValidationMessageModel()).getMessageCount(1) > 0) {
            jcomp.setBorder(_ERROR_BORDER);
        } else if (model.getMessageCount(2) > 0) {
            jcomp.setBorder(_WARN_BORDER);
        }
    }

    public void paintValidState(ValidationComponent vComp) {
        Component comp = vComp.getComponent();
        if (!(comp instanceof JComponent)) {
            throw new IllegalArgumentException();
        }
        JComponent jcomp = (JComponent)comp;
        if (jcomp.getBorder() instanceof ValidationBorder) {
            jcomp.setBorder((Border)jcomp.getClientProperty(_VALIDATION_BORDER_KEY));
        }
    }

    private static class ValidationBorder
    extends CompoundBorder {
        public ValidationBorder(Border outsideBorder, LineBorder insideBorder) {
            super(outsideBorder, insideBorder);
        }
    }
}

