/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.validate;

import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.ValidationPainter;
import oracle.ideimpl.db.validate.DBValidationComponent;
import oracle.ideimpl.db.validate.DBValidationManager;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.StatusIndicator;
import oracle.javatools.ui.infotip.templates.Template;
import oracle.javatools.ui.table.TableToolbar;

class IconValidationPainter
implements ValidationPainter {
    IconValidationPainter() {
    }

    public void paintComponent(ValidationComponent validationComponent) {
        Component component = validationComponent.getComponent();
        if (component instanceof JComponent) {
            StatusIndicator statusIndicator = (StatusIndicator)((JComponent)component).getClientProperty("status-indicator");
            if (statusIndicator == null) {
                if (component instanceof TableToolbar) {
                    statusIndicator = new StatusIndicator();
                    ((TableToolbar)component).setStatusIndicator(statusIndicator);
                } else if (component instanceof ComponentWithTitlebar) {
                    statusIndicator = new StatusIndicator();
                    ((ComponentWithTitlebar)component).setStatusIndicator(statusIndicator);
                }
            }
            if (statusIndicator != null) {
                statusIndicator.setStatus(validationComponent.isValid() ? StatusIndicator.Status.OK : StatusIndicator.Status.ERROR);
                Template template = null;
                if (!validationComponent.isValid() && validationComponent instanceof DBValidationComponent) {
                    template = DBValidationManager.createInfoTipContent(((DBValidationComponent)validationComponent).getValidationExceptions());
                }
                statusIndicator.setInfoTipContent(template);
            } else if (component instanceof JLabel) {
                ((JLabel)component).setIcon(DBValidationManager.getLabelIcon(((JLabel)component).getIcon(), validationComponent.isValid()));
            } else if (component instanceof JButton) {
                ((JButton)component).setIcon(DBValidationManager.getLabelIcon(((JButton)component).getIcon(), validationComponent.isValid()));
            }
        }
    }

    public static boolean supportsComponent(ValidationComponent validationComponent) {
        Component component = validationComponent.getComponent();
        return component instanceof JComponent && ((JComponent)component).getClientProperty("status-indicator") != null || component instanceof JLabel || component instanceof JButton || component instanceof TableToolbar || component instanceof ComponentWithTitlebar;
    }
}

