/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import java.awt.Component;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.IncrementerPanel;
import oracle.ideimpl.db.panels.MutExChildObjectEditorPanel;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IdentityColumnProperties;
import oracle.javatools.db.Table;
import oracle.javatools.db.property.Property;

public class IdentityColumnPanel
extends MutExChildObjectEditorPanel<Column, Table> {
    private IdentityColumnIncrementerPanel m_subPanel = new IdentityColumnIncrementerPanel();

    IdentityColumnPanel() {
        super("IdentityColumnPanel", Property.createPath((String[])new String[]{"columns", "identityProperties"}));
    }

    @Override
    public String getChildValidationProperty() {
        return "identityProperties";
    }

    @Override
    public void initialiseProperty(Column column, DBEditorConfig dBEditorConfig) {
        IdentityColumnProperties identityColumnProperties = new IdentityColumnProperties();
        identityColumnProperties.setGenerated(IdentityColumnProperties.GeneratedType.ALWAYS);
        column.setIdentityProperties(identityColumnProperties);
        if (!column.isNotNull()) {
            column.setNotNull(true);
        }
    }

    @Override
    public void clearProperty(Column column) {
        column.setIdentityProperties(null);
    }

    @Override
    public boolean accept(Column column) {
        return column.getIdentityProperties() != null;
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        this.m_subPanel.onEntry((TraversableContext)this.getDataContext());
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        this.m_subPanel.onExit((TraversableContext)this.getDataContext());
    }

    @Override
    protected void initialiseChildComponents() {
        DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
        dBUILayoutHelper.add((Component)((Object)this.m_subPanel), 1, 1, true, true);
        dBUILayoutHelper.layout();
    }

    @Override
    protected DBObject getComponentFactoryOriginalObject() {
        Column column = (Column)this.getOriginalChildObject();
        if (column != null) {
            return column.getIdentityProperties();
        }
        return null;
    }

    @Override
    protected DBObject getComponentFactoryUpdatedObject() {
        Column column = (Column)this.getChildObject();
        if (column != null) {
            return column.getIdentityProperties();
        }
        return null;
    }

    private static class IdentityColumnIncrementerPanel
    extends IncrementerPanel<IdentityColumnProperties> {
        IdentityColumnIncrementerPanel() {
            super(Property.createPath((String[])new String[]{"columns", "identityProperties"}), true);
        }

        @Override
        protected void initialiseComponents() {
            ComponentWrapper componentWrapper = this.getOrCreateWrapper("generated");
            DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
            dBUILayoutHelper.add(componentWrapper.getLabel());
            dBUILayoutHelper.add(componentWrapper.getComponent(), 3, 1);
            dBUILayoutHelper.nextRow();
            super.initialiseComponents();
        }
    }
}

