/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.DBNavigable;
import oracle.ideimpl.db.panels.DBTabbedPanel;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.property.Property;

public abstract class ChildTableTabPanel<C extends ChildDBObject, P extends DBObject>
extends ChildObjectEditorPanel<C, P> {
    private TableColumnsTabbedPanel m_tabPane;
    private Map<Class, Navigable> m_tabsMap;
    private final List<TabSelectedListener> m_listeners = new ArrayList<TabSelectedListener>();
    private Integer m_defaultTabIndex;
    private TraversableContext m_tabContext;

    protected ChildTableTabPanel(String string, String string2, Integer n) {
        super(string, string2);
        this.m_defaultTabIndex = n;
    }

    protected ChildTableTabPanel(String string, String string2) {
        this(string, string2, -1);
    }

    @Override
    protected void initialiseChildComponents() {
        this.addTabs();
        DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
        dBUILayoutHelper.add((Component)((Object)this.m_tabPane));
        dBUILayoutHelper.layout();
    }

    @Override
    protected void initialisePanel() {
        DBEditorConfig dBEditorConfig;
        DBObject dBObject;
        super.initialisePanel();
        if (!this.isInitialSelectionProcessed() && (dBObject = (dBEditorConfig = this.getEditorConfig()).getChildObject()) != null) {
            int n;
            String string = null;
            Object c = this.getChildObject();
            if (dBObject == c) {
                string = dBEditorConfig.getProperty();
            } else if (c != null && !dBObject.getClass().equals(c.getClass())) {
                String string2 = null;
                DBObject dBObject2 = null;
                DBObject dBObject3 = dBObject;
                while (dBObject3 != null) {
                    dBObject2 = dBObject3.getParent();
                    String string3 = DBUtil.getParentProperty((DBObject)dBObject3);
                    string2 = Property.createPath((String[])new String[]{string3, string2});
                    if (dBObject2 == c) {
                        string = string2;
                        break;
                    }
                    dBObject3 = dBObject2;
                }
            }
            if (string != null && (n = this.m_tabPane.findNavigableIndex(string)) >= 0) {
                this.m_defaultTabIndex = n;
                this.setInitialSelectionProcessed();
            }
        }
        this.onTabEntry();
    }

    @Override
    public boolean requestFocusForEditorConfig() {
        boolean bl = false;
        if (this.isInitialSelectionProcessed()) {
            bl = this.m_tabPane.requestFocusForEditorConfig();
        }
        if (!bl) {
            bl = super.requestFocusForEditorConfig();
        }
        return bl;
    }

    @Override
    protected void commitPanel() throws TraversalException {
        if (this.m_tabContext != null) {
            this.m_tabPane.ignoreListeners(true);
            this.m_tabPane.onExit(this.m_tabContext);
            this.m_tabPane.ignoreListeners(false);
        }
        super.commitPanel();
    }

    protected void onTabEntry() {
        if (this.m_tabPane != null) {
            boolean bl;
            boolean bl2 = bl = this.m_tabContext == null;
            if (bl) {
                this.m_tabContext = new TraversableContext(this.getDataContext(), 0);
            } else {
                this.enableTabs();
            }
            if (this.m_defaultTabIndex != null) {
                this.m_tabContext.putDesignTimeObject("TabbedPanel.DEFAULT_TAB_INDEX", (Object)this.m_defaultTabIndex);
            }
            this.m_tabPane.ignoreListeners(true);
            this.m_tabPane.onEntry(this.m_tabContext);
            this.m_tabPane.ignoreListeners(false);
            if (bl) {
                this.enableTabs();
            }
            this.validate();
            this.repaint();
            this.m_defaultTabIndex = null;
        }
    }

    protected abstract Collection<Navigable> getTabs();

    private void addTabs() {
        this.m_tabsMap = new HashMap<Class, Navigable>();
        this.m_tabPane = new TableColumnsTabbedPanel(this.getTabNavs());
    }

    private Navigable[] getTabNavs() {
        Collection<Navigable> collection = this.getTabs();
        for (Navigable navigable : collection) {
            this.m_tabsMap.put(navigable.getTraversableClass(), navigable);
        }
        Navigable[] navigableArray = collection.toArray(new Navigable[collection.size()]);
        return navigableArray;
    }

    protected void refreshTabs() {
        if (this.m_tabPane != null) {
            this.m_tabPane.setRootNavigables(this.getTabNavs());
            this.m_tabContext = null;
        }
    }

    protected Navigable createNavigable(String string, Class clazz, String ... stringArray) {
        Navigable navigable = this.m_tabsMap.get(clazz);
        if (navigable == null) {
            navigable = new DBNavigable(string, clazz);
            if (stringArray != null) {
                ((DBNavigable)navigable).setProperties(Arrays.asList(stringArray));
            }
        }
        return navigable;
    }

    protected void setEnabledTab(Class clazz, boolean bl) {
        Navigable navigable = this.m_tabsMap.get(clazz);
        if (navigable != null) {
            this.m_tabPane.enableTabForNavigable(navigable, bl);
        }
    }

    public final void addTabSelectedListener(TabSelectedListener tabSelectedListener) {
        this.m_listeners.add(tabSelectedListener);
    }

    public final void removeTabSelectedListener(TabSelectedListener tabSelectedListener) {
        this.m_listeners.remove(tabSelectedListener);
    }

    protected void notifyTabListeners() {
        for (TabSelectedListener tabSelectedListener : this.m_listeners) {
            tabSelectedListener.tabSelected();
        }
    }

    public void selectDefaultTab(int n) {
        int n2 = this.m_tabPane.getSelectedIndex();
        this.m_defaultTabIndex = n;
        if (n2 != n && (n == -1 || n2 == -1)) {
            this.onTabEntry();
        }
    }

    protected void enableTabs() {
    }

    private class TableColumnsTabbedPanel
    extends DBTabbedPanel {
        private boolean m_ignoreListeners;

        public TableColumnsTabbedPanel(Navigable[] navigableArray) {
            super(navigableArray);
            this.setBaseEditorPanel(ChildTableTabPanel.this);
        }

        @Override
        public Navigable getCurrentNavigable() {
            if (!this.m_ignoreListeners) {
                ChildTableTabPanel.this.notifyTabListeners();
            }
            return super.getCurrentNavigable();
        }

        public void ignoreListeners(boolean bl) {
            this.m_ignoreListeners = bl;
        }
    }

    public static interface TabSelectedListener {
        public void tabSelected();
    }
}

