/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;
import oracle.ide.db.components.ComponentContext;
import oracle.ideimpl.db.components.EnumPropertyComponentWrapper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleTablePartitions;

public class IndexPartitionTypePropertyWrapper
extends EnumPropertyComponentWrapper {
    @Override
    protected ItemListener createItemListener() {
        return new TypeComboListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPropertyValue(Object object) {
        DefaultComboBoxModel defaultComboBoxModel;
        Object object2;
        IndexPartitionTypeComboItem indexPartitionTypeComboItem = IndexPartitionTypeComboItem.NONE;
        if (object instanceof OracleIndexPartitions.PartitionType) {
            object2 = (OracleIndexPartitions.PartitionType)object;
            indexPartitionTypeComboItem = this.getPartitionTypeComboItem((OracleIndexPartitions.PartitionType)object2);
        }
        if ((defaultComboBoxModel = (DefaultComboBoxModel)((JComboBox)(object2 = (JComboBox)this.getActiveComponent())).getModel()).getIndexOf((Object)indexPartitionTypeComboItem) == -1) {
            defaultComboBoxModel.insertElementAt(indexPartitionTypeComboItem, 0);
        }
        boolean bl = this.isActive();
        this.setActive(false);
        try {
            ((JComboBox)this.getActiveComponent()).setSelectedItem((Object)indexPartitionTypeComboItem);
        }
        finally {
            this.setActive(bl);
        }
    }

    private IndexPartitionTypeComboItem getPartitionTypeComboItem(OracleIndexPartitions.PartitionType partitionType) {
        IndexPartitionTypeComboItem indexPartitionTypeComboItem = partitionType == OracleIndexPartitions.PartitionType.GLOBAL_RANGE ? IndexPartitionTypeComboItem.GLOBAL_RANGE : (partitionType == OracleIndexPartitions.PartitionType.GLOBAL_HASH ? IndexPartitionTypeComboItem.GLOBAL_HASH : IndexPartitionTypeComboItem.LOCAL);
        return indexPartitionTypeComboItem;
    }

    @Override
    public Object getPropertyValue() {
        IndexPartitionTypeComboItem indexPartitionTypeComboItem = (IndexPartitionTypeComboItem)((Object)((JComboBox)this.getActiveComponent()).getSelectedItem());
        OracleIndexPartitions.PartitionType partitionType = null;
        if (indexPartitionTypeComboItem == IndexPartitionTypeComboItem.GLOBAL_RANGE) {
            partitionType = OracleIndexPartitions.PartitionType.GLOBAL_RANGE;
        } else if (indexPartitionTypeComboItem == IndexPartitionTypeComboItem.GLOBAL_HASH) {
            partitionType = OracleIndexPartitions.PartitionType.GLOBAL_HASH;
        } else if (indexPartitionTypeComboItem == IndexPartitionTypeComboItem.LOCAL) {
            boolean bl;
            Index index = (Index)this.getUpdatedObject();
            Table table = (Table)index.getParent();
            OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)table.getProperty("OracleTablePartitions");
            boolean bl2 = bl = oracleTablePartitions.getSubpartitionModel() != null;
            if (oracleTablePartitions == null) {
                partitionType = null;
            } else {
                OracleTablePartitions.PartitionType partitionType2 = oracleTablePartitions.getPartitionType();
                partitionType = bl ? OracleIndexPartitions.PartitionType.LOCAL_COMP : (partitionType2 == OracleTablePartitions.PartitionType.HASH ? OracleIndexPartitions.PartitionType.LOCAL_HASH : OracleIndexPartitions.PartitionType.LOCAL_OTHER);
            }
        }
        return partitionType;
    }

    @Override
    protected Collection getAllowedValues() {
        ArrayList<IndexPartitionTypeComboItem> arrayList = new ArrayList<IndexPartitionTypeComboItem>();
        Index index = (Index)this.getUpdatedObject();
        Table table = (Table)DBUtil.findParentOfType((DBObject)index, Table.class);
        boolean bl = table != null && Boolean.TRUE.equals(table.getProperty("PARTITIONED TABLE"));
        OracleIndexPartitions oracleIndexPartitions = (OracleIndexPartitions)index.getProperty("OracleIndexPartitions");
        if (index.getIndexType() == Index.IndexType.DOMAIN || index.getIndexType() == Index.IndexType.BITMAP) {
            arrayList.add(IndexPartitionTypeComboItem.NONE);
            if (bl) {
                arrayList.add(IndexPartitionTypeComboItem.LOCAL);
            }
        } else if (table != null) {
            for (IndexPartitionTypeComboItem indexPartitionTypeComboItem : IndexPartitionTypeComboItem.values()) {
                if (oracleIndexPartitions == null && !bl && indexPartitionTypeComboItem.isLocal()) continue;
                arrayList.add(indexPartitionTypeComboItem);
            }
        }
        return arrayList;
    }

    @Override
    protected ListCellRenderer getRenderer() {
        return null;
    }

    private OracleIndexPartitions getPartitions() {
        Index index = (Index)this.getUpdatedObject();
        OracleIndexPartitions oracleIndexPartitions = (OracleIndexPartitions)index.getProperty("OracleIndexPartitions");
        if (oracleIndexPartitions == null) {
            oracleIndexPartitions = (OracleIndexPartitions)this.getProvider().getObjectFactory().newObject(OracleIndexPartitions.class, (DBObject)index);
        }
        return oracleIndexPartitions;
    }

    private class TypeComboListener
    implements ItemListener {
        private TypeComboListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1 && IndexPartitionTypePropertyWrapper.this.isActive() && IndexPartitionTypePropertyWrapper.this.getPartitions() != null) {
                Object object;
                OracleIndexPartitions oracleIndexPartitions = IndexPartitionTypePropertyWrapper.this.getPartitions();
                if (oracleIndexPartitions.getParent() == null) {
                    object = IndexPartitionTypePropertyWrapper.this.getComponentContext().getParentComponentContext();
                    oracleIndexPartitions.setParent(((ComponentContext)object).getUpdatedObject());
                }
                object = oracleIndexPartitions.getParent();
                IndexPartitionTypeComboItem indexPartitionTypeComboItem = (IndexPartitionTypeComboItem)((Object)itemEvent.getItem());
                OracleIndexPartitions oracleIndexPartitions2 = (OracleIndexPartitions)object.getProperty("OracleIndexPartitions");
                OracleIndexPartitions oracleIndexPartitions3 = oracleIndexPartitions;
                if (oracleIndexPartitions2 != null && indexPartitionTypeComboItem == IndexPartitionTypeComboItem.NONE) {
                    oracleIndexPartitions3 = null;
                } else if (indexPartitionTypeComboItem != IndexPartitionTypeComboItem.LOCAL) {
                    oracleIndexPartitions.setPartitions(new IndexPartition[0]);
                }
                object.setProperty("OracleIndexPartitions", (Object)oracleIndexPartitions3);
                IndexPartitionTypePropertyWrapper.this.fireChangeEvent();
            }
        }
    }

    private static enum IndexPartitionTypeComboItem {
        NONE(UIBundle.get("INDEX_PARTITIONS_LIST_NONE"), false),
        GLOBAL_RANGE(UIBundle.get("INDEX_PARTITIONS_LIST_GLOBAL_RANGE"), false),
        GLOBAL_HASH(UIBundle.get("INDEX_PARTITIONS_LIST_GLOBAL_HASH"), false),
        LOCAL(UIBundle.get("INDEX_PARTITIONS_LIST_LOCAL"), true);

        private final String m_text;
        private final boolean m_local;

        private IndexPartitionTypeComboItem(String string2, boolean bl) {
            this.m_text = string2;
            this.m_local = bl;
        }

        public String toString() {
            return this.m_text;
        }

        public boolean isLocal() {
            return this.m_local;
        }
    }
}

