/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.model;

import java.net.URL;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.composite.CompositeFileElementRegistry;
import oracle.ide.db.DBURLFactory;
import oracle.ide.db.model.BaseDBObjectTextNode;
import oracle.ide.db.model.ConnectionStoreNode;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ideimpl.db.model.DatabaseNodeRecognizer;
import oracle.ideimpl.db.model.ProviderNodeRecognizer;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.plsql.PlSqlSchemaObject;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.util.ModelUtil;

public final class DBObjectNodeUtil {
    private DBObjectNodeUtil() {
    }

    public static DBObjectProvider findProvider(Object object) {
        Object object2;
        String string;
        DBObjectProvider dBObjectProvider = null;
        ProviderNodeRecognizer<Object> providerNodeRecognizer = ProviderNodeRecognizer.findRecognizer(object);
        if (providerNodeRecognizer != null && (string = providerNodeRecognizer.getProviderType(object)) != null && (object2 = providerNodeRecognizer.getProviderIdentifier(object)) != null) {
            dBObjectProvider = DBObjectProviderFactory.findProvider((String)string, (Object)object2);
        }
        return dBObjectProvider;
    }

    public static String getProviderType(Object object) {
        String string = null;
        ProviderNodeRecognizer<Object> providerNodeRecognizer = ProviderNodeRecognizer.findRecognizer(object);
        if (providerNodeRecognizer != null) {
            string = providerNodeRecognizer.getProviderType(object);
        }
        return string;
    }

    public static Object getProviderIdentifier(Object object) {
        Object object2 = null;
        ProviderNodeRecognizer<Object> providerNodeRecognizer = ProviderNodeRecognizer.findRecognizer(object);
        if (providerNodeRecognizer != null) {
            object2 = providerNodeRecognizer.getProviderIdentifier(object);
        }
        return object2;
    }

    public static boolean isConnectionNode(Object object) {
        boolean bl = false;
        DatabaseNodeRecognizer<Object> databaseNodeRecognizer = DatabaseNodeRecognizer.findRecognizer(object);
        if (databaseNodeRecognizer != null) {
            bl = databaseNodeRecognizer.isConnectionNode(object);
        }
        return bl;
    }

    public static boolean isStoreNode(Object object) {
        boolean bl = false;
        DatabaseNodeRecognizer<Object> databaseNodeRecognizer = DatabaseNodeRecognizer.findRecognizer(object);
        if (databaseNodeRecognizer != null) {
            bl = databaseNodeRecognizer.isStoreNode(object);
        }
        return bl;
    }

    public static boolean isNodeOfType(String string, Object object) {
        if (object instanceof DBObjectNode) {
            return string.equals(DBObjectNodeUtil.normalizeType((DBObjectNode)object));
        }
        return false;
    }

    public static boolean isOnlineNodeOfType(String string, Object object) {
        if (DBObjectNodeUtil.isNodeOfType(string, object)) {
            return DBObjectNodeUtil.isOnlineNode(object);
        }
        return false;
    }

    public static boolean isOnlineNode(Object object) {
        return "db".equals(DBObjectNodeUtil.getProviderType(object));
    }

    public static boolean isRelationNode(Object object) {
        if (object instanceof DBObjectNode) {
            String string = ((DBObjectNode)object).getObjectType();
            return "TABLE".equals(string) || "VIEW".equals(string) || "MATERIALIZED VIEW".equals(string);
        }
        return false;
    }

    public static boolean isRelationNode(Object object, boolean bl) {
        if (bl && DBObjectNodeUtil.isSynonymNode(object)) {
            try {
                DBObjectID dBObjectID;
                DBObject dBObject = ((DBObjectNode)object).getDBObject();
                if (dBObject instanceof Synonym && (dBObjectID = ((Synonym)dBObject).getReference()) != null) {
                    DBObject dBObject2 = dBObjectID.resolveID();
                    return dBObject2 instanceof Relation;
                }
            }
            catch (DBException dBException) {
                DBLog.getLogger(DBObjectNodeUtil.class).warning("Could not unwrap Synonym : " + dBException.getMessage());
            }
        }
        return DBObjectNodeUtil.isRelationNode(object);
    }

    public static boolean isSynonymNode(Object object) {
        if (object instanceof DBObjectNode) {
            String string = ((DBObjectNode)object).getObjectType();
            return "SYNONYM".equals(string) || "PUBLIC_SYNONYM".equals(string);
        }
        return false;
    }

    public static boolean isOnlineRelationNode(Object object) {
        if (DBObjectNodeUtil.isRelationNode(object)) {
            return DBObjectNodeUtil.isOnlineNode(object);
        }
        return false;
    }

    public static boolean isOnlineRelationNode(Object object, boolean bl) {
        if (DBObjectNodeUtil.isRelationNode(object, bl)) {
            return DBObjectNodeUtil.isOnlineNode(object);
        }
        return false;
    }

    public static String getStoreName(Object object) {
        String string = null;
        if (object instanceof ConnectionStoreNode) {
            string = ((ConnectionStoreNode)object).getStoreName();
        } else {
            DatabaseNodeRecognizer<Object> databaseNodeRecognizer = DatabaseNodeRecognizer.findRecognizer(object);
            if (databaseNodeRecognizer != null) {
                string = databaseNodeRecognizer.getStoreName(object);
            }
        }
        return string;
    }

    public static String getConnectionName(Object object) {
        String string = null;
        DatabaseNodeRecognizer<Object> databaseNodeRecognizer = DatabaseNodeRecognizer.findRecognizer(object);
        if (databaseNodeRecognizer != null) {
            string = databaseNodeRecognizer.getConnectionName(object);
        }
        return string;
    }

    public static <T extends Element> T getSelectedElement(Context context, Class<T> clazz) {
        Element[] elementArray;
        T t = null;
        if (context != null && (elementArray = context.getSelection()) != null && elementArray.length == 1) {
            t = DBObjectNodeUtil.getElementOfType(elementArray[0], clazz);
        }
        return t;
    }

    public static <T extends Element> T getElementOfType(Element element, Class<T> clazz) {
        Element element2 = null;
        if (element != null) {
            if (clazz.isAssignableFrom(element.getClass())) {
                element2 = element;
            } else {
                URL[] uRLArray = CompositeFileElementRegistry.getCompositeFileURLs((Element)element);
                if (uRLArray != null) {
                    for (URL uRL : uRLArray) {
                        Node node = NodeFactory.find((URL)uRL);
                        if (node == null || !clazz.isAssignableFrom(node.getClass())) continue;
                        element2 = node;
                        break;
                    }
                }
            }
        }
        return (T)element2;
    }

    public static Element getTreeNodeElement(Object object) {
        Object object2;
        Element element = null;
        if (object instanceof TNode) {
            element = ((TNode)object).getData();
        } else if (object instanceof DefaultMutableTreeNode && (object2 = ((DefaultMutableTreeNode)object).getUserObject()) instanceof Element) {
            element = (Element)object2;
        }
        return element;
    }

    public static Schema getSchema(DBObjectTypeNode dBObjectTypeNode, boolean bl) {
        Schema schema = null;
        try {
            DBObjectProvider dBObjectProvider = DBObjectProviderFactory.findOrCreateProvider((String)dBObjectTypeNode.getProviderType(), (Object)dBObjectTypeNode.getProviderIdentifier());
            if (dBObjectProvider != null) {
                String string = DBObjectNodeUtil.getSchemaName(dBObjectTypeNode);
                if (ModelUtil.hasLength((String)string)) {
                    schema = new Schema(string);
                }
                if (schema == null && bl) {
                    schema = dBObjectProvider.getDefaultSchema();
                }
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return schema;
    }

    public static String getSchemaName(DBObjectTypeNode dBObjectTypeNode) {
        String string;
        String string2 = dBObjectTypeNode.getSchemaName();
        String string3 = dBObjectTypeNode.getObjectType();
        if (ModelUtil.areDifferent((Object)string3, (Object)(string = DBObjectNodeUtil.normalizeType(dBObjectTypeNode))) && string3.contains("PUBLIC")) {
            string2 = "PUBLIC";
        }
        return string2 == null ? null : string2.trim();
    }

    public static String normalizeType(DBObjectTypeNode dBObjectTypeNode) {
        return dBObjectTypeNode == null ? null : DBObjectNodeUtil.normalizeType(dBObjectTypeNode.getObjectType());
    }

    public static String normalizeType(String string) {
        String string2 = string;
        if (string2 != null) {
            if (string2.startsWith("PUBLIC_")) {
                string2 = string2.replaceFirst("PUBLIC_", "");
            } else if (string2.startsWith("PUBLIC ")) {
                string2 = string2.replaceFirst("PUBLIC ", "");
            } else if (string2.equals("ALIASES")) {
                string2 = "ALIAS";
            }
        }
        return string2;
    }

    public static boolean containsDBObject(Object object) {
        boolean bl = false;
        ProviderNodeRecognizer<Object> providerNodeRecognizer = ProviderNodeRecognizer.findRecognizer(object);
        if (providerNodeRecognizer != null) {
            bl = providerNodeRecognizer.isDBObjectNode(object);
        }
        return bl;
    }

    public static DBObject getDBObject(Object object) {
        DBObject dBObject = null;
        ProviderNodeRecognizer<Object> providerNodeRecognizer = ProviderNodeRecognizer.findRecognizer(object);
        if (providerNodeRecognizer != null) {
            dBObject = providerNodeRecognizer.getDBObject(object);
        }
        return dBObject;
    }

    @Deprecated
    public static BaseDBObjectTextNode getCompanionNode(PlSqlSchemaObject plSqlSchemaObject, DBObjectProvider dBObjectProvider) {
        Node node;
        BaseDBObjectTextNode baseDBObjectTextNode = null;
        URL uRL = DBURLFactory.getURL(dBObjectProvider, (SystemObject)plSqlSchemaObject);
        if (uRL != null && (node = NodeFactory.find((URL)uRL)) instanceof BaseDBObjectTextNode) {
            try {
                baseDBObjectTextNode = DBObjectNodeUtil.getCompanionNode((BaseDBObjectTextNode)node);
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return baseDBObjectTextNode;
    }

    public static BaseDBObjectTextNode getCompanionNode(BaseDBObjectTextNode baseDBObjectTextNode) throws DBException {
        BaseDBObjectTextNode baseDBObjectTextNode2 = null;
        BaseDBObjectTextNode baseDBObjectTextNode3 = baseDBObjectTextNode.getCompanionNode();
        if (baseDBObjectTextNode3 != null) {
            Node node = NodeFactory.find((URL)baseDBObjectTextNode3.getURL());
            if (node == baseDBObjectTextNode3) {
                baseDBObjectTextNode2 = baseDBObjectTextNode3;
            } else if (node instanceof BaseDBObjectTextNode) {
                baseDBObjectTextNode2 = (BaseDBObjectTextNode)node;
                baseDBObjectTextNode.setCompanionNode(baseDBObjectTextNode2);
            }
        } else {
            Object object;
            PlSqlSchemaObject plSqlSchemaObject = null;
            DBObjectProvider dBObjectProvider = baseDBObjectTextNode.getProvider();
            if (dBObjectProvider instanceof Database) {
                object = PlSqlUtil.getCompanionObjectType((String)baseDBObjectTextNode.getObjectType());
                if (object != null) {
                    try {
                        plSqlSchemaObject = (PlSqlSchemaObject)Metadata.getInstance().getObjectClass((String)object).newInstance();
                        plSqlSchemaObject.setSchema(new Schema(baseDBObjectTextNode.getSchemaName()));
                        plSqlSchemaObject.setName(baseDBObjectTextNode.getObjectName());
                    }
                    catch (Exception exception) {
                        throw new IllegalStateException(exception);
                    }
                }
            } else {
                object = baseDBObjectTextNode.getDBObjectFromBuffer();
                if (object instanceof PlSqlSchemaObject) {
                    plSqlSchemaObject = PlSqlUtil.getCompanionObject((PlSqlSchemaObject)((PlSqlSchemaObject)object), (DBObjectProvider)dBObjectProvider);
                }
            }
            if (plSqlSchemaObject != null && (object = DBURLFactory.getURL(dBObjectProvider, (SystemObject)plSqlSchemaObject)) != null) {
                try {
                    baseDBObjectTextNode2 = (BaseDBObjectTextNode)NodeFactory.find((URL)object);
                    if (baseDBObjectTextNode2 == null) {
                        boolean bl = true;
                        if (dBObjectProvider instanceof Database) {
                            bl = ((Database)dBObjectProvider).exists(plSqlSchemaObject.getType(), DBUtil.getSchemaName((DBObject)plSqlSchemaObject), plSqlSchemaObject.getName());
                        }
                        if (bl) {
                            baseDBObjectTextNode2 = (BaseDBObjectTextNode)NodeFactory.findOrCreate((URL)object);
                        }
                    }
                }
                catch (Exception exception) {
                    throw new DBException((DBObject)plSqlSchemaObject, exception.getMessage(), (Throwable)exception);
                }
            }
        }
        baseDBObjectTextNode.setCompanionNode(baseDBObjectTextNode2);
        return baseDBObjectTextNode2;
    }

    public static BaseDBObjectTextNode getNodeFromEditorPane(BasicEditorPane basicEditorPane) {
        Node node;
        BaseDBObjectTextNode baseDBObjectTextNode = null;
        CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)basicEditorPane);
        if (codeEditor != null && (node = codeEditor.getContext().getNode()) instanceof BaseDBObjectTextNode) {
            baseDBObjectTextNode = (BaseDBObjectTextNode)node;
        }
        return baseDBObjectTextNode;
    }
}

