/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.graphics.FontUtils;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.bali.inspector.PropertyModel;

class InspectorAppearance
implements PropertyChangeListener {
    private JTable _table;
    private Font _conflictFont;
    private Font _headingFont;
    private boolean _isOracleLookAndFeel;
    private static final int _CONFLICTING_BIT = 1;
    private static final int _READWRITE_BIT = 2;
    private static final int _NUM_BIT_APPEARANCES = 4;
    private static final int _GROUPHEADING_INDEX = 4;
    private static final int _NUM_COLORS = 5;
    private Color[] _backgrounds = new Color[5];
    private Color[] _foregrounds = new Color[5];
    private int _levelColumnIndex = -1;
    private int _valueColumnIndex = -1;
    private int _writableColumnIndex = -1;
    private int _nameColumnIndex = -1;

    public InspectorAppearance(JTable table) {
        this._table = table;
        this._table.addPropertyChangeListener(this);
        this._computeInfo();
    }

    public void setIndicies(int nameIndex, int levelIndex, int valueIndex, int writableIndex) {
        this._nameColumnIndex = nameIndex;
        this._levelColumnIndex = levelIndex;
        this._valueColumnIndex = valueIndex;
        this._writableColumnIndex = writableIndex;
    }

    public void prepareRenderer(JTable table, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex, Component c) {
        if (columnIndex >= table.getColumnCount()) {
            return;
        }
        int realColumnIndex = table.convertColumnIndexToModel(columnIndex);
        PropertyModel model = (PropertyModel)this._table.getModel();
        int colorIndex = 0;
        int levelIndex = -1;
        if (this._levelColumnIndex != -1) {
            Object level = model.getValueAt(rowIndex, this._levelColumnIndex);
            int n = levelIndex = level != PropertyModel.DOES_NOT_EXIST && level != null ? (Integer)level : -1;
        }
        if (levelIndex == 0) {
            colorIndex = 4;
            this._setFont(c, this._headingFont);
        } else {
            if (model.isDataConflicting(realColumnIndex, rowIndex)) {
                this._setFont(c, this._conflictFont);
                ++colorIndex;
            } else {
                this._setFont(c, table.getFont());
            }
            if (realColumnIndex != this._valueColumnIndex || this._writableColumnIndex == -1 || Boolean.TRUE.equals(model.getValueAt(rowIndex, this._writableColumnIndex))) {
                colorIndex += 2;
            }
        }
        if (!table.isEnabled()) {
            this._setForeground(c, UIManager.getColor(LookAndFeel.TEXT_INACTIVE_TEXT));
            this._setBackground(c, table.getBackground());
        } else if (hasFocus) {
            if (this._isOracleLookAndFeel) {
                this._setForeground(c, UIManager.getColor(LookAndFeel.TEXT_TEXT));
                Color gray = new Color(0x999999);
                this._setBackground(c, gray);
            } else if (realColumnIndex == this._nameColumnIndex) {
                this._setForeground(c, this._foregrounds[4]);
                this._setBackground(c, this._backgrounds[4]);
            } else {
                this._setForeground(c, this._foregrounds[colorIndex]);
                this._setBackground(c, this._backgrounds[colorIndex]);
            }
        } else if (isSelected) {
            this._setForeground(c, UIManager.getColor(LookAndFeel.TEXT_HIGHLIGHT_TEXT));
            this._setBackground(c, UIManager.getColor(LookAndFeel.TEXT_HIGHLIGHT));
        } else if (realColumnIndex == this._nameColumnIndex) {
            this._setForeground(c, this._foregrounds[4]);
            this._setBackground(c, this._backgrounds[4]);
        } else {
            this._setForeground(c, this._foregrounds[colorIndex]);
            this._setBackground(c, this._backgrounds[colorIndex]);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if ("font".equals(name)) {
            this._computeFonts();
        } else if ("UI".equals(name)) {
            this._computeInfo();
        }
    }

    private void _computeInfo() {
        this._isOracleLookAndFeel = UIManager.getLookAndFeel() instanceof OracleLookAndFeel;
        Color readOnly = UIManager.getColor(LookAndFeel.CONTROL);
        Color window = UIManager.getColor(LookAndFeel.WINDOW);
        Color textText = UIManager.getColor(LookAndFeel.TEXT_TEXT);
        if (this._isOracleLookAndFeel) {
            this._table.setBackground(readOnly);
        } else {
            this._table.setBackground(window);
        }
        this._computeFonts();
        for (int i = 0; i < 4; ++i) {
            this._foregrounds[i] = textText;
            this._backgrounds[i] = this._isOracleLookAndFeel ? UIManager.getColor(LookAndFeel.TEXT) : window;
            if ((i & 2) != 0) continue;
            this._backgrounds[i] = readOnly;
            this._foregrounds[i] = UIManager.getColor(LookAndFeel.TEXT_INACTIVE_TEXT);
        }
        this._foregrounds[i] = textText;
        this._backgrounds[i] = this._isOracleLookAndFeel ? readOnly : window;
    }

    private void _computeFonts() {
        Insets i;
        Font defaultFont = this._table.getFont();
        if (defaultFont == null) {
            defaultFont = UIManager.getFont("Table.font");
        }
        if (defaultFont == null) {
            defaultFont = FontUtils.getDefaultSansSerifFont();
        }
        this._conflictFont = FontUtils.deriveFontUsingStyle((Font)defaultFont, (int)2, (int)2);
        this._headingFont = FontUtils.deriveFontUsingStyle((Font)defaultFont, (int)1, (int)1);
        FontMetrics metrics = this._table.getFontMetrics(defaultFont);
        int size = metrics.getHeight();
        Border b = UIManager.getBorder("Table.focusCellHighlightBorder");
        Insets insets = i = b == null ? null : b.getBorderInsets(this._table);
        if (i != null) {
            size += i.top + i.bottom;
        }
        this._table.setRowHeight(size);
        this._table.setRowMargin(1);
    }

    private void _setFont(Component c, Font font) {
        c.setFont(font);
        if (c instanceof Container) {
            Container cont = (Container)c;
            int count = cont.getComponentCount();
            for (int i = 0; i < count; ++i) {
                this._setFont(cont.getComponent(i), font);
            }
        }
    }

    private void _setForeground(Component c, Color color) {
        c.setForeground(color);
        if (c instanceof Container) {
            Container cont = (Container)c;
            int count = cont.getComponentCount();
            for (int i = 0; i < count; ++i) {
                this._setForeground(cont.getComponent(i), color);
            }
        }
    }

    private void _setBackground(Component c, Color color) {
        c.setBackground(color);
        if (c instanceof Container) {
            Container cont = (Container)c;
            int count = cont.getComponentCount();
            for (int i = 0; i < count; ++i) {
                this._setBackground(cont.getComponent(i), color);
            }
        }
    }
}

