/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scope.module;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.jdbc.JDBCCall;
import oracle.dbtools.common.service.model.Property;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.stmt.jdbc.BindableCallResults;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.plugin.api.i18n.Translatable;
import oracle.dbtools.rt.ResourceTemplateMessages;
import oracle.dbtools.rt.home.EntityStorage;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.jdbc.entity.JDBCEntityProviderBase;
import oracle.dbtools.rt.jdbc.entity.JDBCIdentifiers;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;
import oracle.dbtools.scope.module.ModuleScope;
import oracle.dbtools.scope.module.ModuleScopeReader;
import oracle.dbtools.scope.module.ModuleScopeStatements;
import oracle.dbtools.scope.module.ModuleScopeWriter;
import oracle.dbtools.scope.module.ModuleScopesProvider;

@Service(provides={ModuleScopesProvider.class, EntityStorage.class}, properties={@Property(name="oracle.dbtools.rt.home.EntityStorage", value="oracle.dbtools.scope.module.ModuleScope")})
public class ModuleScopes
extends JDBCEntityProviderBase<ModuleScope>
implements ModuleScopesProvider {
    private final ModuleScopeStatements stmts = STATEMENTS;
    private final ModuleScopeWriter writer = MODULE_SCOPE_WRITER;
    private static final ModuleScopeReader MODULE_SCOPE_READER = new ModuleScopeReader();
    private static final ModuleScopeWriter MODULE_SCOPE_WRITER = new ModuleScopeWriter();
    private static final ModuleScopeStatements STATEMENTS = new ModuleScopeStatements();

    public ModuleScopes() {
        super(STATEMENTS, MODULE_SCOPE_READER, MODULE_SCOPE_WRITER);
    }

    @Override
    public ModuleScope insert(Transaction txn, CompoundPrincipal principal, ModuleScope instance) {
        ModuleScope moduleScope;
        JDBCCall insert = null;
        try {
            String creator = Text.upper((String)principal.getName());
            Timestamp now = new Timestamp(System.currentTimeMillis());
            insert = this.jdbc().call(txn, this.stmts.insert());
            Map<String, Object> params = this.writer.apply(instance);
            JDBCIdentifiers.bind(params, principal);
            if (creator != null) {
                params.put("created_by", creator);
                params.put("updated_by", creator);
            }
            params.put("created_on", now);
            params.put("updated_on", now);
            insert.bind(params);
            BindableCallResults keys = insert.execute();
            Object key = keys.get("ID");
            if (key == null) {
                throw WebException.badRequest(Reason.reason("scope", (Translatable)new TranslatableMessage(ResourceTemplateMessages.class, "ModuleScopes.1", "The specified privilege mapping already exists", new Object[0])));
            }
            Object privilegeId = keys.get("privilege_id");
            if (privilegeId == null) {
                throw WebException.badRequest(Reason.reason("scope", (Translatable)new TranslatableMessage(ResourceTemplateMessages.class, "ModuleScopes.0", "The named privilege does not exist", new Object[0])));
            }
            TenantIdentifier id = JDBCIdentifiers.generatedId(principal, (Map<String, Object>)keys);
            instance.id(id);
            moduleScope = this.inserted(txn, principal, instance);
        }
        catch (SQLException e) {
            try {
                throw WebException.internalError(e, new Reason[0]);
            }
            catch (Throwable throwable) {
                Closeables.close(insert);
                throw throwable;
            }
        }
        Closeables.close((Object)insert);
        return moduleScope;
    }

    @Override
    public ModuleScope update(Transaction txn, CompoundPrincipal principal, ModuleScope instance) {
        return super.update(txn, principal, instance);
    }
}

