/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth.jdbc;

import java.security.Principal;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.common.jdbc.ConnectionPoolException;
import oracle.dbtools.common.jdbc.JDBCCall;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCException;
import oracle.dbtools.common.jdbc.JDBCQuery;
import oracle.dbtools.common.query.ColumnIterator;
import oracle.dbtools.common.query.QueryProvider;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.stmt.StatementBuilder;
import oracle.dbtools.common.stmt.jdbc.BindableCallResults;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.jdbc.entity.JDBCIdentifiers;
import oracle.dbtools.rt.oauth.AccessTokens;
import oracle.dbtools.rt.oauth.ApprovalRequest;
import oracle.dbtools.rt.oauth.BearerTokenVerification;
import oracle.dbtools.rt.oauth.OAuthAuthorization;
import oracle.dbtools.rt.oauth.OAuthDataAccess;
import oracle.dbtools.rt.oauth.jdbc.RowToOAuthScope;
import oracle.dbtools.rt.resource.templates.jdbc.ApexListenerJDBCPrincipal;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

@Service(provides={JDBCOAuthDataAccess.class, OAuthDataAccess.class}, priority=1)
public class JDBCOAuthDataAccess
implements OAuthDataAccess {
    @Reference
    private JDBCCallProvider jdbc;
    @Reference
    private QueryProvider query;
    private static final String GET_CLIENT_SCOPES = "select s.security_group_id, s.id, s.name, s.label, s.description from wwv_flow_rt$privileges s, wwv_flow_rt$client_privileges cs where s.id = cs.privilege_id and cs.client_id = :id and s.security_group_id in (10,:tenant_id)";
    static final Statement GET_CLIENT_SCOPES_STMT = JDBCIdentifiers.keyParameter(StatementBuilder.query().append((CharSequence)"select s.security_group_id, s.id, s.name, s.label, s.description from wwv_flow_rt$privileges s, wwv_flow_rt$client_privileges cs where s.id = cs.privilege_id and cs.client_id = :id and s.security_group_id in (10,:tenant_id)")).build();
    private static final String __DUMMY_PENDING_PROJECTION = ", cast(null as integer), cast(null as varchar(255))";
    private static final String _APPROVAL_PROJECTION = "select a.security_group_id, a.id, a.user_name, c.id, a.status, c.name, c.description, c.response_type, c.client_id, c.client_secret, c.redirect_uri, c.support_email, cast(null as integer), cast(null as varchar(255))";
    private static final String _APPROVAL_SELECT = "select a.security_group_id, a.id, a.user_name, c.id, a.status, c.name, c.description, c.response_type, c.client_id, c.client_secret, c.redirect_uri, c.support_email, cast(null as integer), cast(null as varchar(255)) from wwv_flow_rt$approvals a, wwv_flow_rt$clients c where c.id = a.client_id";
    private static final String APPROVAL_BY_APPROVAL_ID = "select a.security_group_id, a.id, a.user_name, c.id, a.status, c.name, c.description, c.response_type, c.client_id, c.client_secret, c.redirect_uri, c.support_email, cast(null as integer), cast(null as varchar(255)) from wwv_flow_rt$approvals a, wwv_flow_rt$clients c where c.id = a.client_id and a.user_name =:user_id and c.client_id = :client_id";
    private static final String APPROVAL_BY_CLIENT_STATE = JDBCOAuthDataAccess.addPendingApprovalColumns("select a.security_group_id, a.id, a.user_name, c.id, a.status, c.name, c.description, c.response_type, c.client_id, c.client_secret, c.redirect_uri, c.support_email, cast(null as integer), cast(null as varchar(255))") + " from wwv_flow_rt$approvals a, wwv_flow_rt$clients c, wwv_flow_rt$pending_approvals p where c.id = a.client_id" + " and p.client_state = :client_state and p.security_group_id = :tenant_id and a.id = p.approval_id";
    private static final Statement APPROVAL_BY_CLIENT_STATE_STMT = JDBCIdentifiers.tenantKeyParameter(StatementBuilder.query().append((CharSequence)APPROVAL_BY_CLIENT_STATE)).parameter("client_state").build();
    private static final String APPROVAL_BY_PENDING_ID = JDBCOAuthDataAccess.addPendingApprovalColumns("select a.security_group_id, a.id, a.user_name, c.id, a.status, c.name, c.description, c.response_type, c.client_id, c.client_secret, c.redirect_uri, c.support_email, cast(null as integer), cast(null as varchar(255))") + " from wwv_flow_rt$approvals a, wwv_flow_rt$clients c, wwv_flow_rt$pending_approvals p where c.id = a.client_id" + " and p.id = :id and p.security_group_id = :tenant_id and a.id = p.approval_id";
    private static final Statement APPROVAL_BY_PENDING_ID_STMT = JDBCIdentifiers.keyParameter(StatementBuilder.query().append((CharSequence)APPROVAL_BY_PENDING_ID)).build();
    private static final String APPROVAL_BY_REFRESH_TOKEN = "select a.security_group_id, a.id, a.user_name, c.id, a.status, c.name, c.description, c.response_type, c.client_id, c.client_secret, c.redirect_uri, c.support_email, cast(null as integer), cast(null as varchar(255)), us.id  from wwv_flow_rt$approvals a, wwv_flow_rt$clients c, wwv_flow_rt$user_sessions us where c.id = a.client_id and us.refresh_token = :refresh_token and a.id = us.approval_id";
    private static final Statement APPROVAL_BY_REFRESH_TOKEN_STMT = StatementBuilder.query().append((CharSequence)"select a.security_group_id, a.id, a.user_name, c.id, a.status, c.name, c.description, c.response_type, c.client_id, c.client_secret, c.redirect_uri, c.support_email, cast(null as integer), cast(null as varchar(255)), us.id  from wwv_flow_rt$approvals a, wwv_flow_rt$clients c, wwv_flow_rt$user_sessions us where c.id = a.client_id and us.refresh_token = :refresh_token and a.id = us.approval_id").parameter("refresh_token").build();
    private static final Statement APPROVAL_STMT = StatementBuilder.query((String)"select a.security_group_id, a.id, a.user_name, c.id, a.status, c.name, c.description, c.response_type, c.client_id, c.client_secret, c.redirect_uri, c.support_email, cast(null as integer), cast(null as varchar(255)) from wwv_flow_rt$approvals a, wwv_flow_rt$clients c where c.id = a.client_id and a.user_name =:user_id and c.client_id = :client_id", (String[])new String[]{"user_id", "client_id"});
    private static final String BEARER_TOKEN = "select a.security_group_id, a.id, us.token_expiry, systimestamp, a.user_name from wwv_flow_rt$approvals a, wwv_flow_rt$user_sessions us where us.bearer_token = :bearer_token and us.approval_id = a.id";
    private static final Statement BEARER_TOKEN_STMT = StatementBuilder.query((String)"select a.security_group_id, a.id, us.token_expiry, systimestamp, a.user_name from wwv_flow_rt$approvals a, wwv_flow_rt$user_sessions us where us.bearer_token = :bearer_token and us.approval_id = a.id", (String[])new String[]{"bearer_token"});
    private static final String CREATE_APPROVAL = "insert into wwv_flow_rt$approvals (user_name,status,client_id,security_group_id,created_by,created_on,updated_by,updated_on) values(:user_id,:status,:client_id,:tenant_id,upper(:user_id),:created,upper(:user_id),:created)";
    private static final String CREATE_APPROVAL_SCOPE = "insert into wwv_flow_rt$approval_privs (approval_id,privilege_id,security_group_id,created_by,created_on,updated_by,updated_on) values(:approval_id,:scope_id,:tenant_id,upper(:user_id),:created,upper(:user_id),:created)";
    private static final Statement CREATE_APPROVAL_SCOPE_STMT = JDBCIdentifiers.keyParameter(StatementBuilder.call().append((CharSequence)"insert into wwv_flow_rt$approval_privs (approval_id,privilege_id,security_group_id,created_by,created_on,updated_by,updated_on) values(:approval_id,:scope_id,:tenant_id,upper(:user_id),:created,upper(:user_id),:created)"), "approval_id", "scope_id").parameter("created", Timestamp.class).build();
    private static final Statement CREATE_APPROVAL_STMT = JDBCIdentifiers.keyParameter(StatementBuilder.call().append((CharSequence)"insert into wwv_flow_rt$approvals (user_name,status,client_id,security_group_id,created_by,created_on,updated_by,updated_on) values(:user_id,:status,:client_id,:tenant_id,upper(:user_id),:created,upper(:user_id),:created)"), "client_id", new String[0]).parameter("user_id").parameter("status", ApprovalRequest.Status.class).parameter("created", Timestamp.class).build();
    private static final String CREATE_PENDING_APPROVAL = "insert into wwv_flow_rt$pending_approvals (approval_id,client_state,security_group_id,created_by,created_on,updated_by,updated_on) values(:approval_id,:client_state,:tenant_id,upper(:user_id),:created,upper(:user_id),:created)";
    private static final Statement CREATE_PENDING_APPROVAL_STMT = JDBCIdentifiers.keyParameter(StatementBuilder.call().append((CharSequence)"insert into wwv_flow_rt$pending_approvals (approval_id,client_state,security_group_id,created_by,created_on,updated_by,updated_on) values(:approval_id,:client_state,:tenant_id,upper(:user_id),:created,upper(:user_id),:created)"), "approval_id", new String[0]).parameter("client_state").parameter("created", Timestamp.class).build();
    private static final String CREATE_USER_SESSION = "insert into wwv_flow_rt$user_sessions (approval_id,bearer_token,refresh_token,token_expiry,refresh_expiry,security_group_id,created_by,created_on,updated_by,updated_on) values(:id,:bearer_token,:refresh_token,:token_expiry,:refresh_expiry,:tenant_id,upper(:user_id),:created,upper(:user_id),:created)";
    private static final Statement CREATE_USER_SESSION_STMT = JDBCIdentifiers.keyParameter(StatementBuilder.call().append((CharSequence)"insert into wwv_flow_rt$user_sessions (approval_id,bearer_token,refresh_token,token_expiry,refresh_expiry,security_group_id,created_by,created_on,updated_by,updated_on) values(:id,:bearer_token,:refresh_token,:token_expiry,:refresh_expiry,:tenant_id,upper(:user_id),:created,upper(:user_id),:created)")).parameter("bearer_token").parameter("token_expiry", Timestamp.class).parameter("refresh_token").parameter("refresh_expiry", Timestamp.class).parameter("user_id").parameter("created", Timestamp.class).build();
    private static final String DELETE_USER_SESSION = "delete from wwv_flow_rt$user_sessions where security_group_id = :tenant_id and id = :id";
    private static final Statement DELETE_USER_SESSION_STMT = JDBCIdentifiers.keyParameter(StatementBuilder.call().append((CharSequence)"delete from wwv_flow_rt$user_sessions where security_group_id = :tenant_id and id = :id")).build();
    private static final String DELETE_APPROVAL = "delete from wwv_flow_rt$approvals where security_group_id = :tenant_id and id = :id";
    private static final Statement DELETE_APPROVAL_STMT = JDBCIdentifiers.keyParameter(StatementBuilder.call().append((CharSequence)"delete from wwv_flow_rt$approvals where security_group_id = :tenant_id and id = :id")).build();
    private static final String DELETE_PENDING_APPROVAL = "delete from wwv_flow_rt$pending_approvals where security_group_id = :tenant_id and id = :id";
    private static final Statement DELETE_PENDING_APPROVAL_STMT = JDBCIdentifiers.keyParameter(StatementBuilder.call().append((CharSequence)"delete from wwv_flow_rt$pending_approvals where security_group_id = :tenant_id and id = :id")).build();
    private static final String GET_APPROVAL_SCOPES = "select s.security_group_id, s.id, s.name, s.label, s.description from wwv_flow_rt$privileges s, wwv_flow_rt$approval_privs p where s.id = p.privilege_id and p.approval_id = :id";
    private static final Statement GET_APPROVAL_SCOPES_STMT = JDBCIdentifiers.keyParameter(StatementBuilder.query().append((CharSequence)"select s.security_group_id, s.id, s.name, s.label, s.description from wwv_flow_rt$privileges s, wwv_flow_rt$approval_privs p where s.id = p.privilege_id and p.approval_id = :id")).build();
    private static final Log LOG = Log.get(JDBCOAuthDataAccess.class);
    private static final String UPDATE_STATUS = "update wwv_flow_rt$approvals set status = :status where security_group_id = :tenant_id and id = :id";
    private static final Statement UPDATE_STATUS_STMT = JDBCIdentifiers.keyParameter(StatementBuilder.call().append((CharSequence)"update wwv_flow_rt$approvals set status = :status where security_group_id = :tenant_id and id = :id")).parameter("status", String.class).build();
    private static final String VERIFY_CLIENT = "select security_group_id,id,name,description,auth_flow,response_type,client_id,client_secret,redirect_uri,support_email from wwv_flow_rt$clients where client_id = :client_id";
    private static final Statement VERIFY_CLIENT_STMT = StatementBuilder.query((String)"select security_group_id,id,name,description,auth_flow,response_type,client_id,client_secret,redirect_uri,support_email from wwv_flow_rt$clients where client_id = :client_id", (String[])new String[]{"client_id"});

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BearerTokenVerification accessGranted(CompoundPrincipal principal, TenantIdentifier scopeId, String bearerToken) {
        Iterator<ResultRow> matches;
        Transaction txn;
        block5: {
            BearerTokenVerification bearerTokenVerification;
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("bearer_token", bearerToken);
            txn = null;
            matches = null;
            try {
                txn = this.newTransaction(principal);
                matches = this.query(txn, BEARER_TOKEN_STMT, parameters);
                if (!matches.hasNext()) break block5;
                ResultRow match = matches.next();
                TenantIdentifier id = JDBCIdentifiers.valueOf(match, 1);
                Timestamp expiry = (Timestamp)match.get(3, Timestamp.class);
                Timestamp now = (Timestamp)match.get(4, Timestamp.class);
                String userId = (String)match.get(5, String.class);
                List<ApprovalRequest.Scope> scopes = this.approvalScopes(txn, principal, id);
                ArrayList<TenantIdentifier> scopeIds = new ArrayList<TenantIdentifier>(scopes.size());
                for (ApprovalRequest.Scope scope : scopes) {
                    scopeIds.add(scope.id());
                }
                bearerTokenVerification = OAuthAuthorization.verifyApproval(scopeId, expiry, now, userId, scopeIds);
            }
            catch (ConnectionPoolException e) {
                BearerTokenVerification bearerTokenVerification2;
                try {
                    bearerTokenVerification2 = BearerTokenVerification.unknown();
                }
                catch (Throwable throwable) {
                    Closeables.close((Object[])new Object[]{matches, txn});
                    throw throwable;
                }
                Closeables.close((Object[])new Object[]{matches, txn});
                return bearerTokenVerification2;
            }
            Closeables.close((Object[])new Object[]{matches, txn});
            return bearerTokenVerification;
        }
        Closeables.close((Object[])new Object[]{matches, txn});
        return BearerTokenVerification.unknown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApprovalRequest approvalRequest(CompoundPrincipal principal, Transaction txn, String userId, String clientId) {
        ApprovalRequest existing = null;
        Iterator<ResultRow> matches = null;
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("user_id", userId);
            parameters.put("client_id", clientId);
            matches = this.query(txn, APPROVAL_STMT, parameters);
            if (matches.hasNext()) {
                ResultRow row = matches.next();
                existing = this.approvalRequest(row);
            }
            if (existing != null) {
                List<ApprovalRequest.Scope> scopes = this.approvalScopes(txn, principal, existing.id());
                existing.scopes().addAll(scopes);
            }
        }
        catch (ConnectionPoolException e) {
            ApprovalRequest approvalRequest = null;
            return approvalRequest;
        }
        finally {
            Closeables.close(matches);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OAuthAuthorization.OAuthClient client(CompoundPrincipal principal, Transaction txn, String clientId) {
        OAuthAuthorization.OAuthClient expected = null;
        Iterator<ResultRow> matches = null;
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("client_id", clientId);
            matches = this.query(txn, VERIFY_CLIENT_STMT, parameters);
            if (matches.hasNext()) {
                expected = new OAuthAuthorization.OAuthClient();
                ResultRow row = matches.next();
                ColumnIterator columns = new ColumnIterator(row);
                expected.id = JDBCIdentifiers.valueOf(columns);
                expected.name = (String)columns.next(String.class);
                expected.description = (String)columns.next(String.class);
                expected.authFlow = ApprovalRequest.AuthFlow.valueOf((String)columns.next(String.class));
                expected.responseType = ApprovalRequest.ResponseType.valueOf((String)columns.next(String.class));
                expected.clientId = (String)columns.next(String.class);
                expected.secret = (String)columns.next(String.class);
                expected.redirectUri = (String)columns.next(String.class);
                expected.email = (String)columns.next(String.class);
                expected.scopes = this.clientScopes(txn, principal, expected.id);
            }
        }
        catch (ConnectionPoolException e) {
            OAuthAuthorization.OAuthClient oAuthClient = null;
            return oAuthClient;
        }
        finally {
            Closeables.close(matches);
        }
        return expected;
    }

    @Override
    public void createApprovalRequest(CompoundPrincipal principal, Transaction txn, ApprovalRequest ar) {
        ApprovalRequest.Status status = ApprovalRequest.Status.PENDING;
        this.createApproval(principal, txn, ar, status);
    }

    @Override
    public void createApprovedRequest(CompoundPrincipal principal, Transaction txn, ApprovalRequest ar) {
        this.createApproval(principal, txn, ar, ApprovalRequest.Status.APPROVED);
    }

    @Override
    public void createPendingApproval(CompoundPrincipal principal, Transaction txn, ApprovalRequest ar) {
        Timestamp created = new Timestamp(System.currentTimeMillis());
        JDBCCall insertPendingApproval = null;
        try {
            String clientState = ar.state();
            if (clientState != null) {
                insertPendingApproval = this.jdbc.insert(txn, CREATE_PENDING_APPROVAL_STMT, new String[]{"ID"});
                HashMap<String, Object> pendingParams = new HashMap<String, Object>();
                JDBCIdentifiers.bind(pendingParams, principal, ar.id(), "approval_id");
                pendingParams.put("client_state", clientState);
                pendingParams.put("user_id", ar.userId());
                pendingParams.put("created", created);
                insertPendingApproval.bind(pendingParams);
                BindableCallResults keys = insertPendingApproval.execute();
                ar.pendingId(JDBCIdentifiers.generatedId(principal, (Map<String, Object>)keys));
            }
        }
        catch (SQLException e) {
            if (e instanceof SQLIntegrityConstraintViolationException) {
                return;
            }
            throw WebException.internalError(e, new Reason[0]);
        }
        finally {
            Closeables.close(insertPendingApproval);
        }
    }

    @Override
    public TenantIdentifier createUserSession(CompoundPrincipal principal, Transaction txn, ApprovalRequest ar, AccessTokens accessTokens) {
        TenantIdentifier tenantIdentifier;
        Timestamp created = new Timestamp(System.currentTimeMillis());
        JDBCCall setBearer = null;
        try {
            TenantIdentifier userSessionId;
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            JDBCIdentifiers.bind(parameters, principal, ar.id());
            parameters.put("created", created);
            parameters.put("bearer_token", accessTokens.accessToken());
            parameters.put("refresh_token", accessTokens.refreshToken());
            parameters.put("token_expiry", new Timestamp(accessTokens.accessExpiry()));
            parameters.put("refresh_expiry", new Timestamp(accessTokens.refreshExpiry()));
            setBearer = this.jdbc.insert(txn, CREATE_USER_SESSION_STMT, new String[]{"ID"});
            setBearer.bind(parameters);
            BindableCallResults keys = setBearer.execute();
            tenantIdentifier = userSessionId = JDBCIdentifiers.generatedId(principal, (Map<String, Object>)keys);
        }
        catch (SQLException e) {
            try {
                throw WebException.internalError(e, new Reason[0]);
            }
            catch (Throwable throwable) {
                Closeables.close(setBearer);
                throw throwable;
            }
        }
        Closeables.close((Object)setBearer);
        return tenantIdentifier;
    }

    @Override
    public void deleteApprovalRequest(CompoundPrincipal principal, Transaction txn, TenantIdentifier id) {
        JDBCCall stmt = null;
        try {
            stmt = this.jdbc.call(txn, DELETE_APPROVAL_STMT);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            JDBCIdentifiers.bind(parameters, principal, id);
            stmt.bind(parameters);
            stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw WebException.internalError(e, new Reason[0]);
            }
            catch (Throwable throwable) {
                Closeables.close(stmt);
                throw throwable;
            }
        }
        Closeables.close((Object)stmt);
    }

    @Override
    public void deleteUserSession(CompoundPrincipal principal, Transaction txn, TenantIdentifier id) {
        JDBCCall stmt = null;
        try {
            stmt = this.jdbc.call(txn, DELETE_USER_SESSION_STMT);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            JDBCIdentifiers.bind(parameters, principal, id);
            stmt.bind(parameters);
            stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw WebException.internalError(e, new Reason[0]);
            }
            catch (Throwable throwable) {
                Closeables.close(stmt);
                throw throwable;
            }
        }
        Closeables.close((Object)stmt);
    }

    @Override
    public Transaction newTransaction(CompoundPrincipal principal) {
        try {
            return this.jdbc.transaction((Principal)ApexListenerJDBCPrincipal.apexListener(principal));
        }
        catch (SQLException e) {
            throw JDBCException.wrap((SQLException)e);
        }
        catch (ConnectionPoolException e) {
            LOG.fine((Throwable)e);
            return null;
        }
    }

    @Override
    public TenantIdentifier parseId(String text) {
        return JDBCIdentifiers.parseId(text);
    }

    @Override
    public ApprovalRequest pendingApproval(CompoundPrincipal principal, Transaction txn, String state) {
        ApprovalRequest ar = null;
        JDBCQuery query = null;
        Iterator matches = null;
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            JDBCIdentifiers.bind(parameters, principal);
            parameters.put("client_state", state);
            query = this.jdbc.query(txn, APPROVAL_BY_CLIENT_STATE_STMT, false);
            query.bind(parameters);
            matches = query.execute();
            if (matches.hasNext()) {
                ResultRow row = (ResultRow)matches.next();
                ar = this.approvalRequest(row);
            }
        }
        catch (SQLException e) {
            try {
                throw WebException.internalError(e, new Reason[0]);
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new Object[]{matches, query});
                throw throwable;
            }
        }
        Closeables.close((Object[])new Object[]{matches, query});
        return ar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pair<TenantIdentifier, ApprovalRequest> sessionAndApproval(CompoundPrincipal principal, Transaction txn, OAuthAuthorization.OAuthClient client, String refreshToken) {
        Pair sessionAndApproval = null;
        Iterator<ResultRow> matches = null;
        try {
            ResultRow row;
            ApprovalRequest existing;
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("refresh_token", refreshToken);
            matches = this.query(txn, APPROVAL_BY_REFRESH_TOKEN_STMT, parameters);
            if (matches.hasNext() && (existing = this.approvalRequest(row = matches.next())) != null) {
                TenantIdentifier userSessionId = JDBCIdentifiers.valueOf(row, 1, row.size());
                List<ApprovalRequest.Scope> scopes = this.approvalScopes(txn, principal, existing.id());
                existing.scopes().addAll(scopes);
                sessionAndApproval = Pair.pair((Object)userSessionId, (Object)existing);
            }
        }
        catch (ConnectionPoolException e) {
            Pair<TenantIdentifier, ApprovalRequest> pair = null;
            return pair;
        }
        finally {
            Closeables.close(matches);
        }
        return sessionAndApproval;
    }

    @Override
    public ApprovalRequest updatePendingApproval(CompoundPrincipal principal, Transaction txn, TenantIdentifier pendingId, String expectedUserId, ApprovalRequest.Status newStatus, ApprovalRequest.Status ... expectedStatus) {
        ApprovalRequest ar = null;
        JDBCQuery query = null;
        Iterator matches = null;
        JDBCCall update = null;
        JDBCCall deletePending = null;
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            JDBCIdentifiers.bind(parameters, principal, pendingId);
            query = this.jdbc.query(txn, APPROVAL_BY_PENDING_ID_STMT, false);
            query.bind(parameters);
            matches = query.execute();
            if (matches.hasNext()) {
                ResultRow row = (ResultRow)matches.next();
                ar = this.approvalRequest(row).userId(expectedUserId);
                ar.pendingId(pendingId);
                if (!this.expectedStatus(ar.status(), expectedStatus)) {
                    throw WebException.badRequest(new Reason[0]);
                }
                JDBCIdentifiers.bind(parameters, principal, ar.id());
                parameters.put("status", newStatus.toString());
                update = this.jdbc.call(txn, UPDATE_STATUS_STMT);
                update.bind(parameters);
                update.execute();
                ar.status(newStatus);
                deletePending = this.jdbc.call(txn, DELETE_PENDING_APPROVAL_STMT);
                deletePending.bind(parameters);
                deletePending.execute();
            }
        }
        catch (SQLException e) {
            try {
                throw WebException.internalError(e, new Reason[0]);
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new Object[]{deletePending, update, matches, query});
                throw throwable;
            }
        }
        Closeables.close((Object[])new Object[]{deletePending, update, matches, query});
        return ar;
    }

    private ApprovalRequest approvalRequest(ResultRow row) {
        return ApprovalRequest.approvalRequest(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ApprovalRequest.Scope> approvalScopes(Transaction txn, CompoundPrincipal principal, TenantIdentifier id) {
        ArrayList<ApprovalRequest.Scope> scopes = new ArrayList<ApprovalRequest.Scope>();
        Iterator<ResultRow> matches = null;
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            JDBCIdentifiers.bind(parameters, principal, id);
            matches = this.query(txn, GET_APPROVAL_SCOPES_STMT, parameters);
            Iterator allScopes = null;
            allScopes = Iterators.transform(matches, (Transform)new RowToOAuthScope());
            Iterators.add(scopes, (Iterator)allScopes, (boolean)false);
        }
        finally {
            Closeables.close(matches);
        }
        return scopes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ApprovalRequest.Scope> clientScopes(Transaction txn, CompoundPrincipal principal, TenantIdentifier id) {
        ArrayList<ApprovalRequest.Scope> scopes = new ArrayList<ApprovalRequest.Scope>();
        Iterator<ResultRow> matches = null;
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            JDBCIdentifiers.bind(parameters, principal, id);
            matches = this.query(txn, GET_CLIENT_SCOPES_STMT, parameters);
            Iterator allScopes = null;
            allScopes = Iterators.transform(matches, (Transform)new RowToOAuthScope());
            Iterators.add(scopes, (Iterator)allScopes, (boolean)false);
        }
        finally {
            Closeables.close(matches);
        }
        return scopes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createApproval(CompoundPrincipal principal, Transaction txn, ApprovalRequest ar, ApprovalRequest.Status status) {
        JDBCCall insert = null;
        try {
            Timestamp created = new Timestamp(System.currentTimeMillis());
            insert = this.jdbc.insert(txn, CREATE_APPROVAL_STMT, new String[]{"ID"});
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("user_id", ar.userId());
            JDBCIdentifiers.bind(params, principal, ar.clientKey(), "client_id");
            params.put("created", created);
            params.put("status", status.toString());
            insert.bind(params);
            BindableCallResults keys = insert.execute();
            ar.id(JDBCIdentifiers.generatedId(principal, (Map<String, Object>)keys));
            if (ar.state() != null) {
                this.createPendingApproval(principal, txn, ar);
            }
            JDBCCall insertScope = null;
            try {
                for (ApprovalRequest.Scope scope : ar.scopes()) {
                    insertScope = this.jdbc.insert(txn, CREATE_APPROVAL_SCOPE_STMT, new String[0]);
                    HashMap<String, Object> parameters = new HashMap<String, Object>();
                    parameters.put("created", created);
                    parameters.put("user_id", ar.userId());
                    JDBCIdentifiers.bind(parameters, principal, scope.id(), "scope_id");
                    JDBCIdentifiers.bind(parameters, principal, ar.id(), "approval_id");
                    insertScope.bind(parameters);
                    insertScope.batch();
                }
                if (insertScope != null) {
                    insertScope.execute();
                }
            }
            finally {
                Closeables.close(insertScope);
            }
        }
        catch (SQLException e) {
            try {
                throw WebException.internalError(e, new Reason[0]);
            }
            catch (Throwable throwable) {
                Closeables.close(insert);
                throw throwable;
            }
        }
        Closeables.close((Object)insert);
    }

    private boolean expectedStatus(ApprovalRequest.Status actualStatus, ApprovalRequest.Status ... expectedStatuses) {
        for (ApprovalRequest.Status expectedStatus : expectedStatuses) {
            if (!expectedStatus.equals((Object)actualStatus)) continue;
            return true;
        }
        return false;
    }

    private Iterator<ResultRow> query(Transaction txn, Statement stmt, Map<String, Object> parameters) {
        return this.query.query(txn, stmt, parameters, false);
    }

    private static final String addPendingApprovalColumns(String projection) {
        return projection.replace(__DUMMY_PENDING_PROJECTION, ", p.id, p.client_state");
    }
}

