/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.common.util.Timestamps;
import oracle.dbtools.json.JSONParser;
import oracle.dbtools.plugin.api.i18n.Translatable;
import oracle.dbtools.plugin.api.json.JSONToken;
import oracle.dbtools.rt.ResourceTemplateMessages;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.WebException;

public abstract class JSONPayload {
    public static boolean isJson(RequestEntity request) {
        ContentType requestContentType = request.contentType();
        return ContentType.matches(ContentTypes.JSON_TYPES, requestContentType);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Pair<String, Object>> toFields(RequestEntity request) {
        ArrayList<Pair<String, Object>> fields = new ArrayList<Pair<String, Object>>();
        InputStream body = null;
        Reader r = null;
        Iterator json = null;
        try {
            body = request.body();
            r = Text.reader((InputStream)body);
            json = JSONParser.read((Reader)r);
            if (json.hasNext()) {
                boolean finished = false;
                JSONToken event = (JSONToken)json.next();
                if (event.type() != JSONToken.Type.START_OBJECT) {
                    throw WebException.badRequest(Reason.reason("json", (Translatable)new TranslatableMessage(ResourceTemplateMessages.class, "JSONPayload.2", "Expected an object but got: ", new Object[]{event.type()})));
                }
                block11: while (!finished && json.hasNext()) {
                    event = (JSONToken)json.next();
                    if (event.type() == JSONToken.Type.END_OBJECT) {
                        finished = true;
                        continue;
                    }
                    if (event.type() != JSONToken.Type.PROPERTY_NAME) {
                        throw WebException.badRequest(Reason.reason("json", (Translatable)new TranslatableMessage(ResourceTemplateMessages.class, "JSONPayload.1", "Expected a property but got: ", new Object[]{event.type()})));
                    }
                    String name = event.propertyName();
                    event = (JSONToken)json.next();
                    switch (event.type()) {
                        case NULL_VALUE: {
                            continue block11;
                        }
                        case BOOLEAN_VALUE: {
                            fields.add((Pair<String, Object>)Pair.pair((Object)name, (Object)event.booleanValue()));
                            continue block11;
                        }
                        case NUMERIC_VALUE: {
                            fields.add((Pair<String, Object>)Pair.pair((Object)name, (Object)event.numberValue()));
                            continue block11;
                        }
                        case STRING_VALUE: {
                            String text = event.stringValue();
                            Object value = text;
                            if (Timestamps.isTimestamp((CharSequence)text)) {
                                value = new Timestamp(Timestamps.valueOf((String)text));
                            }
                            fields.add((Pair<String, Object>)Pair.pair((Object)name, (Object)value));
                            continue block11;
                        }
                    }
                    throw WebException.badRequest(Reason.reason("json", (Translatable)new TranslatableMessage(ResourceTemplateMessages.class, "JSONPayload.0", "Expected a value but got: ", new Object[]{event.type()})));
                }
            }
        }
        catch (IOException e) {
            try {
                throw WebException.internalError(e, new Reason[0]);
                catch (IllegalStateException e2) {
                    throw WebException.badRequest(Reason.reason("json", (Translatable)new TranslatableMessage(e2.getMessage())));
                }
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new Object[]{json, r, body});
                throw throwable;
            }
        }
        Closeables.close((Object[])new Object[]{json, r, body});
        return fields;
    }
}

