/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.jdbc.entity;

import java.security.Principal;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.EntityHeaders;
import oracle.dbtools.rt.tenants.TenantPrincipal;
import oracle.dbtools.rt.web.ReTargetingDispatcher;
import oracle.dbtools.rt.web.RedirectException;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.Requests;

abstract class TenantDispatcherBase
extends ReTargetingDispatcher<TenantTarget> {
    protected abstract TenantPrincipal tenant(RequestEntity var1, String var2);

    @Override
    protected TenantTarget target(RequestEntity request) {
        TenantPrincipal tenant = null;
        Requests.log(request, "Determining if request can be dispatched as a Tenanted RESTful Service");
        String path = request.path();
        String basePath = this.basePath(path);
        boolean hasSlash = this.hasSlash(path);
        if (NullOrEmpty.nullOrEmpty((CharSequence)basePath)) {
            Requests.log(request, "Request path does not have a path segment, cannot dispatch");
        } else {
            Requests.log(request, "Request path has one path segment, continuing processing");
            tenant = this.tenant(request, basePath);
        }
        TenantTarget tenantTarget = null;
        if (tenant != null) {
            String base = request.base() + basePath + "/";
            if (hasSlash) {
                String target = path.substring(basePath.length() + 1);
                Requests.log(request, "Dispatching as tenanted request, with base: " + base + ", target: " + target + ", tenant: " + tenant);
                tenantTarget = new TenantTarget(base, tenant, target);
            } else {
                Requests.log(request, "Request path is missing trailing slash, redirecting");
                throw RedirectException.permanentRedirect(base);
            }
        }
        return tenantTarget;
    }

    private boolean hasSlash(String path) {
        String[] segments = path.split("/");
        return segments.length > 1 && !NullOrEmpty.nullOrEmpty((CharSequence)segments[0]) || segments.length == 1 && !NullOrEmpty.nullOrEmpty((CharSequence)segments[0]) && path.endsWith("/");
    }

    private String basePath(String path) {
        String[] segments = path.split("/");
        if (segments.length >= 1 && !NullOrEmpty.nullOrEmpty((CharSequence)segments[0])) {
            return segments[0];
        }
        return null;
    }

    @Override
    protected CompoundPrincipal modifyRequestPrincipal(TenantTarget target, RequestEntity request) {
        return request.principal().replace(TenantPrincipal.class, (Principal)target.tenant);
    }

    @Override
    protected EntityHeaders modifyRequestHeaders(TenantTarget target, RequestEntity request) {
        return Entities.headers("X-APEX-PATH", target.target(), "X-APEX-BASE", target.base);
    }

    protected class TenantTarget
    extends ReTargetingDispatcher.Target {
        final String base;
        final TenantPrincipal tenant;

        TenantTarget(String base, TenantPrincipal tenant, String target) {
            super(target);
            this.base = base;
            this.tenant = tenant;
        }
    }
}

