/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.jdbc.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import oracle.dbtools.common.jdbc.ConnectionPoolException;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.rt.home.NestedEntityStorage;
import oracle.dbtools.rt.home.tenants.TenantEntity;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.jdbc.entity.JDBCEntityMetaData;
import oracle.dbtools.rt.jdbc.entity.JDBCEntityProviderBase;
import oracle.dbtools.rt.jdbc.entity.JDBCIdentifiers;
import oracle.dbtools.rt.jdbc.entity.JDBCNestedEntityStatements;

public class JDBCNestedEntityProviderBase<T extends TenantEntity, C extends TenantEntity>
extends JDBCEntityProviderBase<T>
implements NestedEntityStorage<T, C> {
    private final boolean deleteChildrenOnUpdate;
    private final JDBCEntityMetaData<T> metadata;

    protected JDBCNestedEntityProviderBase(JDBCEntityMetaData<T> metadata, boolean deleteChildrenOnUpdate) {
        super(metadata);
        this.metadata = metadata;
        this.deleteChildrenOnUpdate = deleteChildrenOnUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<C> children(Transaction txn, CompoundPrincipal principal, TenantIdentifier id) {
        JDBCEntityMetaData<?> metadata = this.metadata.childEntity();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        this.creator(parameters, principal);
        ArrayList<TenantEntity> results = new ArrayList<TenantEntity>();
        try {
            JDBCIdentifiers.bind(parameters, principal, id, "parent_id");
            Iterator<ResultRow> matches = null;
            try {
                matches = this.query(txn, ((JDBCNestedEntityStatements)this.stmts()).children(), parameters);
                Iterator entities = Iterators.transform(matches, metadata.reader());
                while (entities.hasNext()) {
                    TenantEntity retrieved;
                    TenantEntity child = (TenantEntity)entities.next();
                    if (child == null || (retrieved = this.retrievedChild(txn, principal, child)) == null) continue;
                    results.add(retrieved);
                }
            }
            finally {
                Closeables.close(matches);
            }
        }
        catch (ConnectionPoolException e) {
            return null;
        }
        return results;
    }

    @Override
    protected void deleteChildren(Transaction txn, CompoundPrincipal principal, T instance) {
        if (this.deleteChildrenOnUpdate) {
            super.deleteChildren(txn, principal, instance);
        }
    }

    protected C retrievedChild(Transaction txn, CompoundPrincipal principal, C child) {
        return child;
    }
}

