/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.search;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.list.SimpleListModel;
import oracle.javatools.ui.search.PromptedTextField;
import oracle.javatools.ui.search.SearchField;

public final class SearchHistoryPopup {
    private final SearchField searchField;
    private final HistoryProvider historyProvider;
    private JPopupMenu popupMenu = new JPopupMenu();
    private JList list;

    public SearchHistoryPopup(SearchField searchField, HistoryProvider historyProvider) {
        this.popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                SearchHistoryPopup.this.popupWillShow();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (SearchHistoryPopup.this.list != null) {
                    SearchHistoryPopup.this.popupWillHide();
                }
                SearchHistoryPopup.this.popupMenu.removeAll();
                SearchHistoryPopup.this.list = null;
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                SearchHistoryPopup.this.popupMenu.removeAll();
                SearchHistoryPopup.this.list = null;
            }
        });
        assert (searchField != null);
        assert (historyProvider != null);
        this.historyProvider = historyProvider;
        this.searchField = searchField;
        searchField.setPopDownAction(new HistoryPopDownAction());
        searchField.setCategoriesPopup(this.popupMenu);
    }

    private void popupWillShow() {
        this.popupMenu.removeAll();
        if (this.historyProvider == null) {
            return;
        }
        List<String> history = this.historyProvider.getHistory();
        if (history == null || history.size() == 0) {
            return;
        }
        SimpleListModel<String> items = new SimpleListModel<String>(history);
        this.list = new JList<String>(items);
        JScrollPane sp = new JScrollPane(this.list);
        sp.setBorder(null);
        this.list.setVisibleRowCount(Math.min(20, history.size()));
        this.list.setSelectedIndex(0);
        this.list.setPrototypeCellValue("WWWWWWWWWWWWW");
        this.popupMenu.add(sp);
        this.popupMenu.setBorder(UIManager.getBorder("PopupMenu.noMarginBorder"));
        String ENTER = "enter";
        this.list.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "enter");
        this.list.getActionMap().put("enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchHistoryPopup.this.popupMenu.setVisible(false);
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SearchHistoryPopup.this.popupMenu.setVisible(false);
            }
        });
        this.list.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int i = SearchHistoryPopup.this.list.locationToIndex(e.getPoint());
                if (i > -1) {
                    SearchHistoryPopup.this.list.setSelectedIndex(i);
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchHistoryPopup.this.list.requestFocus();
            }
        });
    }

    private void popupWillHide() {
        String item = (String)this.list.getSelectedValue();
        if (item != null) {
            this.searchField.setText(item);
        }
    }

    public static interface HistoryProvider {
        public List<String> getHistory();
    }

    private class HistoryPopDownAction
    extends AbstractAction {
        HistoryPopDownAction() {
            this.putValue("ShortDescription", UIBundle.get("HISTORY_SEARCH"));
            this.putValue("SmallIcon", new Icon(){

                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                }

                @Override
                public int getIconWidth() {
                    return 0;
                }

                @Override
                public int getIconHeight() {
                    return 16;
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SearchHistoryPopup.this.historyProvider != null && SearchHistoryPopup.this.historyProvider.getHistory().size() > 0) {
                PromptedTextField tf = SearchHistoryPopup.this.searchField.getTextField();
                Insets ins = tf.getInsets();
                SearchHistoryPopup.this.popupMenu.show(tf, ins.left, SearchHistoryPopup.this.searchField.getHeight() - ins.bottom);
            }
        }
    }
}

