/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.builders;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTree;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import oracle.javatools.ui.builders.BuiltTree;
import oracle.javatools.ui.builders.ExAppBasicPanel;
import oracle.javatools.ui.builders.TreeBuilder;

class ExAppTreePanel
extends ExAppBasicPanel {
    private static BuiltTree<String> tc;
    protected VisibleRows visiblerows = new VisibleRows();

    ExAppTreePanel() {
    }

    @Override
    protected JComponent createControlPanel() {
        JPanel controlPanel = new JPanel((LayoutManager)new MigLayout("aligny top, nogrid, ins 5 5 5 16, gapy 2"));
        JButton buildButton = new JButton("Build");
        buildButton.setFont(buildButton.getFont().deriveFont(1));
        buildButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExAppTreePanel.this.build();
            }
        });
        JButton dumpButton = new JButton("Dump");
        dumpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExAppTreePanel.this.dump();
            }
        });
        controlPanel.add((Component)new JLabel("Select your configuration, then press:"), "gapbottom 16, span, split");
        controlPanel.add((Component)buildButton, "wrap");
        controlPanel.add((Component)new JLabel("Selection Mode:"), "");
        controlPanel.add((Component)SELECTION_MODE.combo, "wrap");
        controlPanel.add((Component)this.resize.cb, "wrap");
        controlPanel.add((Component)this.doubleclick.cb, "span, wrap");
        controlPanel.add((Component)new JLabel("Visible Rows:"), "");
        controlPanel.add((Component)this.visiblerows.sp, "span, wrap");
        controlPanel.add((Component)this.actions.cb, "span, wrap");
        controlPanel.add((Component)this.moreactions.cb, "");
        controlPanel.add((Component)this.moreactions.tf, "span, wrap");
        controlPanel.add((Component)this.emptytext.cb, "");
        controlPanel.add((Component)this.emptytext.tf, "");
        controlPanel.add((Component)this.emptytext.lcb, "wrap");
        controlPanel.add((Component)this.label.cb, "");
        controlPanel.add((Component)this.label.tf, "wrap");
        controlPanel.add((Component)this.titlebar.cb, "span, wrap");
        return controlPanel;
    }

    private void build() {
        TreeBuilder builder = new TreeBuilder();
        builder.setModel(new JTree().getModel());
        StringBuilder createSB = new StringBuilder("");
        StringBuilder selectSB = new StringBuilder("");
        createSB.append("TreeBuilder<String> builder = new TreeBuilder<String>();\n");
        createSB.append("builder.model(model);\n");
        SELECTION_MODE.build(builder, createSB, selectSB);
        this.resize.build(builder, createSB, selectSB);
        this.visiblerows.build(builder, createSB, selectSB);
        this.emptytext.build(builder, createSB, selectSB);
        this.doubleclick.build(builder, createSB, selectSB);
        this.label.build(builder, createSB, selectSB);
        this.titlebar.build(builder, createSB, selectSB);
        this.actions.build(builder, createSB, selectSB);
        this.moreactions.build(builder, createSB, selectSB);
        createSB.append("\nBuiltTree<String> builtTree = builder.build();\n\nadd(builtTree.getGUI());");
        this.constructTextArea.setText(createSB.toString());
        this.selectTextArea.setText(selectSB.toString());
        this.updateComponent(builder.build().getGUI());
    }

    @Override
    protected void dump() {
        if (tc == null) {
            return;
        }
        System.out.println("---------------------------------");
    }

    protected class VisibleRows {
        int def = -1;
        JSpinner sp = new JSpinner(new SpinnerNumberModel(this.def, -1, 20, -1));

        protected VisibleRows() {
            this.sp.setToolTipText("The default number of rows initially visible");
        }

        void build(TreeBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            int i = (Integer)this.sp.getValue();
            if (i != this.def) {
                builder.setVisibleRows(i);
                createSB.append("builder.setVisibleRows(" + i + ");\n");
            }
        }
    }

    private static enum SELECTION_MODE {
        SINGLE(1),
        RANGE(2),
        MULTIPLE(4);

        int selectionMode;
        private static JComboBox combo;

        private SELECTION_MODE(int selectionMode) {
            this.selectionMode = selectionMode;
        }

        public String toString() {
            switch (this) {
                case SINGLE: {
                    return "Single";
                }
                case RANGE: {
                    return "Range";
                }
                case MULTIPLE: {
                    return "Multiple";
                }
            }
            return super.toString();
        }

        private static void build(TreeBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            SELECTION_MODE mode = (SELECTION_MODE)((Object)combo.getSelectedItem());
            builder.selectionMode(mode.selectionMode);
            if (mode == RANGE) {
                createSB.append("builder.selectionMode(TreeSelectionModel.SINGLE_INTERVAL_SELECTION);\n");
            } else if (mode == MULTIPLE) {
                createSB.append("builder.selectionMode(TreeSelectionModel.DISCONTIGUOUS_TREE_SELECTION );\n");
            }
        }

        static {
            combo = new JComboBox<SELECTION_MODE>(SELECTION_MODE.values());
        }
    }
}

