/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JToolBar;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.ui.resources.MessagesBundle;

public class PrevNextCoveragePanel
extends JToolBar {
    protected int maxItems = 10;
    protected Vector<AreaDefinition> areas = new Vector();
    protected JButton prevButton = new JButton(Icons.getIcon("shuttleleft_ena.png"));
    protected JButton nextButton = new JButton(Icons.getIcon("shuttleright_ena.png"));
    protected int currentArea = -1;

    public PrevNextCoveragePanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.setRollover(true);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.prevButton.setToolTipText(MessagesBundle.getMessage("Tooltip_previous_map"));
        this.prevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrevNextCoveragePanel.this.prevButton_actionPerformed(e);
            }
        });
        this.nextButton.setToolTipText(MessagesBundle.getMessage("Tooltip_next_map"));
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrevNextCoveragePanel.this.nextButton_actionPerformed(e);
            }
        });
        this.add((Component)this.prevButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.nextButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.updateButtonStatus();
    }

    public void setMaxItems(int items) {
        if (items < 1) {
            return;
        }
        this.maxItems = items;
        this.clear();
    }

    public void clear() {
        this.areas.clear();
        this.currentArea = -1;
        this.updateButtonStatus();
    }

    public double getCenterX() {
        if (this.currentArea < 0) {
            return Double.NaN;
        }
        AreaDefinition area = this.areas.get(this.currentArea);
        return area.centerX;
    }

    public double getCenterY() {
        if (this.currentArea < 0) {
            return Double.NaN;
        }
        AreaDefinition area = this.areas.get(this.currentArea);
        return area.centerY;
    }

    public double getAreaSize() {
        if (this.currentArea < 0) {
            return Double.NaN;
        }
        AreaDefinition area = this.areas.get(this.currentArea);
        return area.size;
    }

    public boolean isScaleSize() {
        if (this.currentArea < 0) {
            return false;
        }
        AreaDefinition area = this.areas.get(this.currentArea);
        return area.scaleSize;
    }

    public void prev() {
        if (this.currentArea <= 0) {
            return;
        }
        --this.currentArea;
        this.updateButtonStatus();
    }

    public void next() {
        if (this.currentArea >= this.areas.size() - 1) {
            return;
        }
        ++this.currentArea;
        this.updateButtonStatus();
    }

    public void addArea(double centerX, double centerY, double size, boolean scaleSize) {
        if (this.currentArea > -1) {
            AreaDefinition area = this.areas.get(this.currentArea);
            if (area.centerX == centerX && area.centerY == centerY && area.size == size && area.scaleSize == scaleSize) {
                return;
            }
        }
        AreaDefinition newarea = new AreaDefinition();
        newarea.centerX = centerX;
        newarea.centerY = centerY;
        newarea.size = size;
        newarea.scaleSize = scaleSize;
        this.areas.add(this.currentArea + 1, newarea);
        if (this.currentArea == this.maxItems - 1) {
            this.areas.remove(0);
        } else {
            ++this.currentArea;
        }
        this.updateButtonStatus();
    }

    public JButton getPreviousButton() {
        return this.prevButton;
    }

    public JButton getNextButton() {
        return this.nextButton;
    }

    private void prevButton_actionPerformed(ActionEvent e) {
    }

    private void nextButton_actionPerformed(ActionEvent e) {
    }

    public boolean hasValidArea() {
        return this.currentArea > -1;
    }

    public void updateButtonStatus() {
        if (this.currentArea < 0 || this.currentArea > this.areas.size() - 1 || this.areas.size() <= 1) {
            this.prevButton.setEnabled(false);
            this.nextButton.setEnabled(false);
        } else if (this.currentArea == 0) {
            this.prevButton.setEnabled(false);
            this.nextButton.setEnabled(true);
        } else if (this.currentArea == this.areas.size() - 1) {
            this.prevButton.setEnabled(true);
            this.nextButton.setEnabled(false);
        } else {
            this.prevButton.setEnabled(true);
            this.nextButton.setEnabled(true);
        }
    }

    private class AreaDefinition {
        public double centerX = Double.NaN;
        public double centerY = Double.NaN;
        public double size = Double.NaN;
        public boolean scaleSize = false;

        private AreaDefinition() {
        }
    }
}

