/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.multi.SelectionModel;
import oracle.ide.controller.Command;
import oracle.ide.inspector.InspectorContext;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;

public class PropertySetCommand
extends Command {
    private static final String NAME = IdeArb.getString((int)168);
    private SelectionModel selection;
    private Object id;
    private int col;
    private String propName;
    private String propDisplayName;
    private Object[] newValues;
    private Object[] oldValues;
    private Node[] nodes;

    public PropertySetCommand(SelectionModel selection, Object id, int col, Object data) {
        super(45, 0, NAME);
        this.selection = selection;
        this.id = id;
        this.col = col;
        int count = selection.getSelectedItemCount();
        this.oldValues = new Object[count];
        this.newValues = new Object[count];
        if (count > 0) {
            int row;
            PropertyModel model = (PropertyModel)selection.getSelectedItem(0);
            int n = row = model != null ? model.getPropertyIndex(id) : -1;
            if (row >= 0) {
                this.propName = model.getPropertyName(row);
                this.propDisplayName = model.getPropertyDisplayName(row);
            }
        }
        for (int i = 0; i < count; ++i) {
            PropertyModel model = (PropertyModel)selection.getSelectedItem(i);
            this.oldValues[i] = data;
            this.newValues[i] = model.getPropertyByID(col, id);
        }
    }

    public int doit() throws Exception {
        int count = this.selection.getSelectedItemCount();
        Object[] temp = this.oldValues;
        this.oldValues = this.newValues;
        this.newValues = temp;
        for (int i = 0; i < count; ++i) {
            try {
                PropertyModel model = (PropertyModel)this.selection.getSelectedItem(i);
                model.setPropertyByID(this.col, this.id, this.newValues[i]);
                continue;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                for (int j = 0; j < i; ++j) {
                    try {
                        PropertyModel model = (PropertyModel)this.selection.getSelectedItem(j);
                        model.setPropertyByID(this.col, this.id, temp[j]);
                        continue;
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                throw t instanceof RuntimeException ? (RuntimeException)t : new IllegalArgumentException(t.getLocalizedMessage());
            }
        }
        this.sendUpdates();
        return 0;
    }

    protected void sendUpdates() {
        Element[] elements = this.context.getSelection();
        Integer[] offsets = InspectorContext.getInspectableOffsets(this.context);
        View origin = this.context.getView();
        if (null != elements && elements.length > 0 && elements[0] instanceof Subject) {
            for (int i = 0; i < offsets.length; ++i) {
                int offset = offsets[i];
                if (!(elements[offset] instanceof Subject)) continue;
                UpdateMessage msg = new UpdateMessage(UpdateMessage.PROPERTY_SET, (Object)origin);
                Subject subject = (Subject)elements[offset];
                PropertyChangeEvent data = new PropertyChangeEvent(subject, this.propName, this.propName != null ? this.oldValues[i] : null, this.propName != null ? this.newValues[i] : null);
                msg.getModifyObjects().add(data);
                subject.notifyObservers((Object)subject, msg);
            }
        } else if (this.context.getNode() != null) {
            UpdateMessage msg = new UpdateMessage(UpdateMessage.PROPERTY_SET, (Object)origin);
            Node subject = this.context.getNode();
            for (int i = 0; i < offsets.length; ++i) {
                int offset = offsets[i];
                PropertyChangeEvent data = new PropertyChangeEvent(elements[offset], this.propName, this.propName != null ? this.oldValues[i] : null, this.propName != null ? this.newValues[i] : null);
                msg.getModifyObjects().add(data);
            }
            subject.notifyObservers((Object)subject, msg);
        }
    }

    public int undo() throws Exception {
        this.context.setView(null);
        return this.doit();
    }

    public synchronized Node[] getAffectedNodes() {
        if (this.nodes == null) {
            if (this.context.getNode() == null) {
                Element[] elements = this.context.getSelection();
                if (elements == null || elements.length <= 1 || !(elements[0] instanceof Subject)) {
                    this.nodes = new Node[0];
                } else {
                    ArrayList<Element> list = new ArrayList<Element>();
                    Integer[] offsets = InspectorContext.getInspectableOffsets(this.context);
                    for (int i = 0; i < offsets.length; ++i) {
                        int offset = offsets[i];
                        if (!(elements[offset] instanceof Node)) continue;
                        list.add(elements[offset]);
                    }
                    this.nodes = new Node[list.size()];
                    list.toArray(this.nodes);
                }
            } else {
                this.nodes = new Node[0];
            }
        }
        return this.nodes;
    }

    public String getName() {
        return this.propDisplayName != null ? this.propDisplayName : NAME;
    }
}

