/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.util;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.TextNode;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.util.SourceVisitor;

public class JavaTransferableBuffer
implements Transferable {
    public static final DataFlavor FLAVOR;
    private static final DataFlavor[] _flavors;
    private String _text;
    private List<UseEntry> _entries;

    public static JavaTransferableBuffer createJavaTransferableBuffer(SourceFile sourceFile, int from, int to) {
        TextBuffer textBuffer = sourceFile.getTextBuffer();
        if (textBuffer == null) {
            URL url = sourceFile.getURL();
            TextNode textNode = (TextNode)NodeFactory.find((URL)url);
            textBuffer = textNode.acquireTextBuffer();
        }
        String text = textBuffer.getString(from, to - from);
        List<Object> useEntries = JavaTransferableBuffer.containsImportsOrPackageDirective(sourceFile, from, to) ? Collections.emptyList() : JavaTransferableBuffer.extractImports((SourceElement)sourceFile, from, to);
        JavaTransferableBuffer buffer = new JavaTransferableBuffer(text, useEntries);
        buffer.setText(text);
        return buffer;
    }

    private static boolean containsImportsOrPackageDirective(SourceFile sourceFile, final int from, final int to) {
        SourceVisitor v = new SourceVisitor(){

            private void checkEl(SourceElement el) {
                if (from <= el.getStartOffset() && el.getEndOffset() <= to) {
                    this.data = el;
                    this.cancelAll();
                }
            }

            public void whenEnterClass(SourceClass sourceClass) {
                this.cancelSubtree();
            }

            public void whenEnterImportDeclaration(SourceImport el) {
                this.checkEl((SourceElement)el);
            }

            public void whenEnterPackageDeclaration(SourcePackage el) {
                this.checkEl((SourceElement)el);
            }
        };
        v.visit((SourceElement)sourceFile);
        return v.data != null;
    }

    public static String[] getNecessaryImports(SourceFile sourceFile, int from, int to) {
        List<UseEntry> imps = JavaTransferableBuffer.extractImports((SourceElement)sourceFile, from, to);
        String[] res = JavaTransferableBuffer.getFullyQualifiedNames(imps, false);
        return res;
    }

    public static String[] getNecessaryStaticImports(SourceFile sourceFile, int from, int to) {
        List<UseEntry> imps = JavaTransferableBuffer.extractImports((SourceElement)sourceFile, from, to);
        String[] res = JavaTransferableBuffer.getFullyQualifiedNames(imps, true);
        return res;
    }

    private static String[] getFullyQualifiedNames(List<UseEntry> entries, boolean staticOnes) {
        ArrayList<String> names = new ArrayList<String>(entries.size());
        for (UseEntry entry : entries) {
            if (staticOnes != entry.isStaticEntry()) continue;
            names.add(entry.fqName);
        }
        return names.toArray(new String[names.size()]);
    }

    private static List<UseEntry> extractImports(SourceElement sourceElement, final int from, final int to) {
        ArrayList<UseEntry> entries = new ArrayList<UseEntry>();
        final HashMap foundEntries = new HashMap();
        final HashSet foundDeclarations = new HashSet();
        new SourceVisitor(){

            private void addSourceType(SourceTypeReference sourceType) {
                JavaType resolvedType;
                SourceName nameElement = sourceType.getNameElement();
                if (nameElement != null && from <= nameElement.getStartOffset() && nameElement.getEndOffset() <= to && (resolvedType = sourceType.getResolvedType()) != null) {
                    if (resolvedType.isPrivate() && resolvedType.isMemberClass()) {
                        return;
                    }
                    String importName = resolvedType.getRawName();
                    if (this.addedAsStaticImport(importName, (SourceElement)nameElement)) {
                        return;
                    }
                    UseEntry cue = (UseEntry)foundEntries.get(importName);
                    if (cue != null) {
                        cue.addPos(nameElement.getStartOffset() - from, nameElement.getEndOffset() - from);
                        return;
                    }
                    String packageName = resolvedType.getPackageName();
                    if (importName.indexOf(46) == -1 || !importName.equals(sourceType.getText()) || packageName.equals("")) {
                        String name = nameElement.getName();
                        this.addJavaType(resolvedType, (SourceElement)nameElement, name.indexOf(46) > 0);
                    }
                }
            }

            private boolean isStaticImport(String fullyQualifiedName, SourceFile sourceFile) {
                Object starName = fullyQualifiedName;
                int index = ((String)starName).lastIndexOf(46);
                if (index > 0) {
                    starName = ((String)starName).substring(0, index + 1) + "*";
                }
                List imports = sourceFile.getSourceImports();
                for (SourceImport sourceImport : imports) {
                    if (!sourceImport.isStatic()) continue;
                    String importName = sourceImport.getName();
                    if (importName.equals(fullyQualifiedName) || importName.equals(starName)) {
                        return true;
                    }
                    Collection importedElements = sourceImport.getImportedElements();
                    for (JavaHasType element : importedElements) {
                        JavaClass owner;
                        Object shortName = null;
                        if (element.getElementKind() != 5 && element.getElementKind() != 8 || (owner = ((JavaMember)element).getOwningClass()) == null || !fullyQualifiedName.equals(owner.getRawName() + "." + ((JavaMember)element).getName())) continue;
                        return true;
                    }
                }
                return false;
            }

            private void addJavaType(JavaType resolvedType, SourceElement element, boolean hasQualifier) {
                String importName;
                while (resolvedType != null && resolvedType.isArray()) {
                    resolvedType = resolvedType.getComponentType();
                }
                if (resolvedType == null || resolvedType.isPrimitive()) {
                    return;
                }
                String packageName = resolvedType.getPackageName();
                if (packageName.equals("java.lang")) {
                    return;
                }
                JavaClass jc = resolvedType.getOwningClass();
                if (jc != null && hasQualifier) {
                    JavaClass owner = jc.getOwningClass();
                    while (owner != null) {
                        jc = owner;
                        owner = jc.getOwningClass();
                    }
                    importName = jc.getRawName();
                } else {
                    importName = resolvedType.getRawName();
                    UseEntry cue = (UseEntry)foundEntries.get(importName);
                    if (cue != null) {
                        if (element != null) {
                            cue.addPos(element.getStartOffset() - from, element.getEndOffset() - from);
                        }
                        return;
                    }
                }
                if (element != null) {
                    foundEntries.put(importName, new ClassUseEntry(importName, element.getStartOffset() - from, element.getEndOffset() - from));
                } else {
                    foundEntries.put(importName, new ClassUseEntry(importName, 0, 0));
                }
            }

            public void whenEnterDotExpression(SourceDotExpression sourceDotExpression) {
                if (from <= sourceDotExpression.getStartOffset() && sourceDotExpression.getEndOffset() <= to) {
                    String txt = sourceDotExpression.getText();
                    JavaHasType tp = sourceDotExpression.getResolvedObject();
                    if (tp != null) {
                        if (tp.getElementKind() != 3) {
                            return;
                        }
                        JavaType jt = sourceDotExpression.getResolvedType();
                        if (jt != null && jt.getElementKind() == 3 && !jt.getRawName().equals(txt)) {
                            this.addJavaType(jt, null, txt.indexOf(46) > 0);
                        }
                    }
                }
            }

            public void whenEnterName(SourceName sourceName) {
                if (from <= sourceName.getStartOffset() && sourceName.getEndOffset() <= to) {
                    SourceElement parent = sourceName.getParent();
                    String importName = null;
                    if (parent != null && parent.getSymbolKind() == 3) {
                        SourceClass sc = (SourceClass)parent;
                        importName = sc.getRawName();
                    } else if (parent != null && parent.getSymbolKind() == 6) {
                        SourceMethod sm = (SourceMethod)parent;
                        JavaClass javaClass = sm.getOwningClass();
                        importName = javaClass.getRawName();
                    }
                    if (importName != null) {
                        UseEntry cue = (UseEntry)foundEntries.get(importName);
                        if (cue == null) {
                            cue = new ClassUseEntry(importName, 0, 0);
                            foundEntries.put(importName, cue);
                        }
                        cue.addPos(sourceName.getStartOffset() - from, sourceName.getEndOffset() - from);
                    }
                }
            }

            private boolean addedAsStaticImport(JavaHasType tp, SourceElement sourceElement) {
                JavaMember member;
                JavaClass cls;
                return tp instanceof JavaMember && (cls = (member = (JavaMember)tp).getOwningClass()) != null && this.addedAsStaticImport(cls.getRawName() + "." + member.getName(), sourceElement);
            }

            private boolean addedAsStaticImport(String name, SourceElement sourceElement) {
                if (this.isStaticImport(name, sourceElement.getOwningSourceFile())) {
                    UseEntry useEntry = (UseEntry)foundEntries.get(name);
                    if (useEntry == null) {
                        useEntry = new StaticUseEntry(name, 0, 0);
                        foundEntries.put(name, useEntry);
                    }
                    useEntry.addPos(sourceElement.getStartOffset() - from, sourceElement.getEndOffset() - from);
                    return true;
                }
                return false;
            }

            public void whenEnterMethodCallExpression(SourceMethodCallExpression sourceMethodCallExpression) {
                if (from <= sourceMethodCallExpression.getStartOffset() && sourceMethodCallExpression.getEndOffset() <= to && sourceMethodCallExpression.getLhsOperand() == null) {
                    JavaHasType tp = sourceMethodCallExpression.getResolvedObject();
                    this.addedAsStaticImport(tp, (SourceElement)sourceMethodCallExpression);
                }
            }

            public void whenEnterSimpleNameExpression(SourceSimpleNameExpression sourceSimpleNameExpression) {
                if (from <= sourceSimpleNameExpression.getStartOffset() && sourceSimpleNameExpression.getEndOffset() <= to) {
                    String txt = sourceSimpleNameExpression.getText();
                    JavaHasType tp = sourceSimpleNameExpression.getResolvedObject();
                    if (tp != null) {
                        boolean hasQualifier = txt.indexOf(46) > 0;
                        boolean isSwitchLabel = false;
                        JavaType jt = sourceSimpleNameExpression.getResolvedType();
                        SourceElement parent = sourceSimpleNameExpression.getParent();
                        if (parent != null && parent.getSymbolKind() == 23 && jt != null && jt.isEnum()) {
                            hasQualifier = true;
                            isSwitchLabel = true;
                        }
                        if (!isSwitchLabel && this.addedAsStaticImport(tp, (SourceElement)sourceSimpleNameExpression)) {
                            return;
                        }
                        if (tp.getElementKind() != 3) {
                            return;
                        }
                        if (jt != null && jt.getElementKind() == 3) {
                            String rawName = jt.getRawName();
                            if (rawName.equals(txt)) {
                                return;
                            }
                            UseEntry cue = (UseEntry)foundEntries.get(rawName);
                            if (cue != null) {
                                cue.addPos(sourceSimpleNameExpression.getStartOffset() - from, sourceSimpleNameExpression.getEndOffset() - from);
                                return;
                            }
                            this.addJavaType(jt, (SourceElement)sourceSimpleNameExpression, txt.indexOf(46) > 0);
                        }
                    }
                }
            }

            public void whenEnterClass(SourceClass sourceClass) {
                SourceClassBody blk;
                int end;
                if (from <= sourceClass.getStartOffset() && to >= sourceClass.getEndOffset() && !sourceClass.isAnonymousClass() && (end = (blk = sourceClass.getSourceBody()) != null ? blk.getStartOffset() : sourceClass.getEndOffset()) <= to) {
                    foundDeclarations.add(sourceClass.getRawName());
                }
            }

            public void whenEnterTypeRef(SourceTypeReference sourceType) {
                this.addSourceType(sourceType);
            }

            public void whenEnterAnnotation(SourceAnnotation sourceAnnotation) {
                if (from <= sourceAnnotation.getStartOffset() && to >= sourceAnnotation.getEndOffset()) {
                    JavaType javaType = sourceAnnotation.getAnnotationType();
                    SourceName nameElement = sourceAnnotation.getNameElement();
                    if (javaType != null && nameElement != null) {
                        String name = nameElement.getName();
                        this.addJavaType(javaType, (SourceElement)nameElement, name.indexOf(46) > 0);
                    }
                }
            }
        }.visit(sourceElement);
        String[] toRemove = foundDeclarations.toArray(new String[foundDeclarations.size()]);
        for (int i = 0; i < toRemove.length; ++i) {
            foundEntries.remove(toRemove[i]);
        }
        Object[] finalEntries = foundEntries.values().toArray(new UseEntry[foundEntries.size()]);
        Arrays.sort(finalEntries);
        for (Object entry : finalEntries) {
            entries.add((UseEntry)entry);
        }
        return entries;
    }

    private JavaTransferableBuffer(String text, List<UseEntry> entries) {
        this._text = text;
        this._entries = entries;
    }

    private void dump() {
        String[] fqClassNames = this.getFQClassNames();
        for (int i = 0; i < fqClassNames.length; ++i) {
            String fqClassName = fqClassNames[i];
            System.out.println("import " + fqClassName + ";");
        }
        System.out.print("\n\n");
        System.out.println(this._text);
    }

    public String getText() {
        return this._text;
    }

    public void setText(String text) {
        this._text = text;
    }

    public String getFqText(String[] namesToExpand) {
        ArrayList<ReplaceItem> toAdjust = new ArrayList<ReplaceItem>();
        for (int i = 0; i < namesToExpand.length; ++i) {
            for (UseEntry entry : this._entries) {
                if (!namesToExpand[i].equals(entry.fqName)) continue;
                ArrayList<TextSegment> foundPos = entry.usedPos;
                for (TextSegment seg : foundPos) {
                    toAdjust.add(new ReplaceItem(namesToExpand[i], seg.start, seg.end));
                }
            }
        }
        Object[] ts = toAdjust.toArray(new ReplaceItem[toAdjust.size()]);
        Arrays.sort(ts);
        StringBuffer sb = new StringBuffer(this._text.length() * 2);
        int cpos = 0;
        for (int i = 0; i < ts.length; ++i) {
            Object ri = ts[i];
            if (cpos < ((ReplaceItem)ri).start) {
                sb.append(this._text.substring(cpos, ((ReplaceItem)ri).start));
            }
            sb.append(((ReplaceItem)ri).text);
            cpos = ((ReplaceItem)ri).end;
        }
        if (cpos < this._text.length()) {
            sb.append(this._text.substring(cpos));
        }
        return sb.toString();
    }

    public String[] getFQClassNames() {
        return JavaTransferableBuffer.getFullyQualifiedNames(this._entries, false);
    }

    public String[] getFQStaticImportNames() {
        return JavaTransferableBuffer.getFullyQualifiedNames(this._entries, true);
    }

    public String[] getMissingImports(SourceFile sourceFile) {
        String[] fqClassNames = this.getFQClassNames();
        return JavaTransferableBuffer.getMissingImports(sourceFile, fqClassNames, false);
    }

    public String[] getMissingStaticImports(SourceFile sourceFile) {
        String[] fqStaticImportNames = this.getFQStaticImportNames();
        return JavaTransferableBuffer.getMissingImports(sourceFile, fqStaticImportNames, true);
    }

    public static String[] getMissingImports(SourceFile sourceFile, String[] fqClassNames) {
        return JavaTransferableBuffer.getMissingImports(sourceFile, fqClassNames, false);
    }

    public static String[] getMissingStaticImports(SourceFile sourceFile, String[] fqStaticImportNames) {
        return JavaTransferableBuffer.getMissingImports(sourceFile, fqStaticImportNames, true);
    }

    private static String[] getMissingImports(SourceFile sourceFile, String[] fqNames, boolean staticImports) {
        ArrayList<String> missingImports = new ArrayList<String>();
        List imports = sourceFile.getSourceImports();
        HashSet<String> existingImports = new HashSet<String>(imports.size());
        for (SourceImport sourceImport : imports) {
            if (staticImports != sourceImport.isStatic()) continue;
            String name = sourceImport.getName();
            existingImports.add(name);
        }
        String sourcePackage = sourceFile.getPackageName();
        for (int i = 0; i < fqNames.length; ++i) {
            String pkg;
            String pkgDotStar;
            int lastDot;
            String fqName = fqNames[i];
            if (existingImports.contains(fqName) || (lastDot = fqName.lastIndexOf(46)) == -1 || existingImports.contains(pkgDotStar = (pkg = fqName.substring(0, lastDot)) + ".*") || !staticImports && sourcePackage.equals(pkg)) continue;
            missingImports.add(fqName);
        }
        return missingImports.toArray(new String[missingImports.size()]);
    }

    public static int getAddedImports(BasicDocument document, String[] needImports, SourceFile sourceFile, HashSet<String> toImport, HashSet<String> conflictingImports) {
        return JavaTransferableBuffer.getAddedImports(document, needImports, sourceFile, toImport, conflictingImports, false);
    }

    public static int getAddedStaticImports(BasicDocument document, String[] needImports, SourceFile sourceFile, HashSet<String> toImport, HashSet<String> conflictingImports) {
        return JavaTransferableBuffer.getAddedImports(document, needImports, sourceFile, toImport, conflictingImports, true);
    }

    /*
     * WARNING - void declaration
     */
    private static int getAddedImports(BasicDocument document, String[] needImports, SourceFile sourceFile, HashSet<String> toImport, HashSet<String> conflictingImports, boolean staticImports) {
        List importsCo = sourceFile.getSourceImports();
        String curPack = sourceFile.getPackageName();
        JavaProvider mgr = sourceFile.getProvider();
        Collection topLevelClasses = sourceFile.getClasses();
        ArrayList<CallSite> topLevelClassNames = new ArrayList<CallSite>(topLevelClasses.size());
        for (JavaClass topLevelClass : topLevelClasses) {
            topLevelClassNames.add((CallSite)((Object)(topLevelClass.getRawName() + ".")));
        }
        String[] importQualifiers = new String[needImports.length];
        if (mgr != null) {
            block1: for (int i = 0; i < needImports.length; ++i) {
                String s = needImports[i];
                int index = s.lastIndexOf(46);
                String string = importQualifiers[i] = index > 0 ? s.substring(0, index) : s;
                if (staticImports) {
                    toImport.add(s);
                    continue;
                }
                JavaClass cls = mgr.getClass(s);
                if (cls == null || curPack.equals(importQualifiers[i]) || "java.lang".equals(importQualifiers[i])) continue;
                for (String string2 : topLevelClassNames) {
                    if (!s.startsWith(string2)) continue;
                    continue block1;
                }
                toImport.add(s);
            }
        }
        LineMap lineMap = document != null ? document.getLineMap() : null;
        int newImportInsertionPoint = 0;
        if (!importsCo.isEmpty()) {
            SourceImport[] imports = importsCo.toArray(new SourceImport[importsCo.size()]);
            for (int i = 0; i < imports.length; ++i) {
                SourceImport sourceImport = imports[i];
                String string = sourceImport.getName();
                if (string.endsWith("*")) {
                    String pName = string.substring(0, string.lastIndexOf(46));
                    for (int j = 0; j < importQualifiers.length; ++j) {
                        if (!pName.equals(importQualifiers[j])) continue;
                        toImport.remove(needImports[j]);
                    }
                    continue;
                }
                toImport.remove(string);
            }
            SourceImport lastImport = imports[imports.length - 1];
            int endOffset = lastImport.getEndOffset();
            if (lineMap != null) {
                int n = lineMap.getLineFromOffset(endOffset);
                newImportInsertionPoint = lineMap.getLineEndOffset(n);
            }
        } else {
            SourcePackage packageStatement = sourceFile.getSourcePackage();
            if (packageStatement != null && lineMap != null) {
                int endOffset = packageStatement.getEndOffset();
                int lineFromOffset = lineMap.getLineFromOffset(endOffset);
                newImportInsertionPoint = lineMap.getLineEndOffset(lineFromOffset);
            }
        }
        if (toImport.size() != 0) {
            void var17_35;
            HashSet<String> importedClasses = new HashSet<String>();
            JavaTransferableBuffer.addAllImportedClasses(mgr, curPack, importedClasses);
            SourceImport[] imports = importsCo.toArray(new SourceImport[importsCo.size()]);
            for (int i = 0; i < imports.length; ++i) {
                SourceImport sourceImport = imports[i];
                String iName = sourceImport.getName();
                if (iName.endsWith("*")) {
                    String pName = iName.substring(0, iName.lastIndexOf(46));
                    JavaTransferableBuffer.addAllImportedClasses(mgr, pName, importedClasses);
                    continue;
                }
                JavaClass cls = mgr.getClass(iName);
                if (cls == null) continue;
                importedClasses.add(cls.getName());
            }
            String[] itlist = toImport.toArray(new String[toImport.size()]);
            boolean bl = false;
            while (var17_35 < itlist.length) {
                String importName;
                String shortName = importName = itlist[var17_35];
                if (staticImports) {
                    int index = shortName.lastIndexOf(46);
                    if (index > 0) {
                        shortName = shortName.substring(index + 1);
                    }
                } else {
                    JavaClass cls = mgr.getClass(shortName);
                    if (cls != null) {
                        shortName = cls.getName();
                    }
                }
                if (importedClasses.contains(shortName)) {
                    toImport.remove(importName);
                    conflictingImports.add(importName);
                }
                ++var17_35;
            }
        }
        return newImportInsertionPoint;
    }

    private static void addAllImportedClasses(JavaProvider mgr, String packageName, HashSet importedClasses) {
        Collection lcls = mgr.getPackage(packageName).getDeclaredClasses();
        for (JavaClass cls : lcls) {
            importedClasses.add(cls.getName());
        }
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return _flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return FLAVOR.equals(flavor) || flavor.equals(DataFlavor.stringFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (FLAVOR.equals(flavor)) {
            return this;
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return this._text;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    static {
        DataFlavor ourFlavor;
        try {
            ourFlavor = new DataFlavor("application/x-java-jvm-local-objectref; class=" + JavaTransferableBuffer.class.getName(), "Java Code", JavaTransferableBuffer.class.getClassLoader());
        }
        catch (ClassNotFoundException cfe) {
            ourFlavor = DataFlavor.stringFlavor;
        }
        FLAVOR = ourFlavor;
        _flavors = FLAVOR != DataFlavor.stringFlavor ? new DataFlavor[]{FLAVOR, DataFlavor.stringFlavor} : new DataFlavor[]{FLAVOR};
    }

    private static abstract class UseEntry
    implements Comparable {
        private String fqName;
        private ArrayList<TextSegment> usedPos;

        public UseEntry(String name, int start, int end) {
            this.fqName = name;
            this.usedPos = new ArrayList(2);
            if (start != 0 && end != 0) {
                this.addPos(start, end);
            }
        }

        void addPos(int start, int end) {
            this.usedPos.add(new TextSegment(start, end));
        }

        public int compareTo(Object o) {
            UseEntry cu = (UseEntry)o;
            return this.fqName.compareTo(cu.fqName);
        }

        abstract boolean isStaticEntry();
    }

    static class TextSegment {
        int start;
        int end;

        public TextSegment(int s, int e) {
            this.start = s;
            this.end = e;
        }
    }

    private static class ReplaceItem
    implements Comparable {
        String text;
        int start;
        int end;

        public ReplaceItem(String s, int st, int e) {
            this.text = s;
            this.start = st;
            this.end = e;
        }

        public int compareTo(Object o) {
            ReplaceItem ri = (ReplaceItem)o;
            return this.start - ri.start;
        }
    }

    private static class StaticUseEntry
    extends UseEntry {
        public StaticUseEntry(String name, int start, int end) {
            super(name, start, end);
        }

        @Override
        boolean isStaticEntry() {
            return true;
        }
    }

    private static class ClassUseEntry
    extends UseEntry {
        public ClassUseEntry(String name, int start, int end) {
            super(name, start, end);
        }

        @Override
        boolean isStaticEntry() {
            return false;
        }
    }
}

