/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cmtimpl;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.swing.JComponent;
import oracle.ide.Ide;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.cmt.CmtComponent;
import oracle.jdeveloper.cmt.CmtComponentSource;
import oracle.jdeveloper.cmt.CmtProperty;
import oracle.jdeveloper.cmt.CmtPropertyAccessor;
import oracle.jdeveloper.cmt.CmtPropertyChangeException;
import oracle.jdeveloper.cmt.CmtPropertyEditor;
import oracle.jdeveloper.cmt.CmtPropertySetting;
import oracle.jdeveloper.cmt.CmtPropertyState;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdeveloper.java.legacy.Jot2Utils;
import oracle.jdevimpl.cmtimpl.JbMethod;
import oracle.jdevimpl.cmtimpl.JbMethodCall;
import oracle.jdevimpl.cmtimpl.JbProperty;
import oracle.jdevimpl.cmtimpl.JbPropertySetting;
import oracle.jdevimpl.cmtimpl.JbSubcomponent;
import oracle.jdevimpl.cmtimpl.PropertyEditorSupportProxy;
import oracle.jdevimpl.cmtimpl.Res;
import oracle.jdevimpl.propertyeditor.ResetsOnNull;

class JbPropertyState
implements CmtPropertyState,
CmtPropertyAccessor {
    JbSubcomponent subcomponent;
    protected JbProperty property;
    JbPropertySetting propertySetting;
    Object defaultValue;
    boolean haveDefault;
    CmtPropertyAccessor propertyAccessor;
    CmtPropertyEditor editor;
    private static String[] containerProps = new String[]{"layout"};
    private static String UNSUPPORTED_JAVA_INIT_STRING = null;

    public JbPropertyState(JbSubcomponent subcomponent, CmtProperty property) {
        this.subcomponent = subcomponent;
        this.property = (JbProperty)property;
        this.propertyAccessor = this;
    }

    @Override
    public final CmtPropertySetting getPropertySetting() {
        return this.propertySetting;
    }

    @Override
    public final void refresh(CmtPropertySetting setting) {
        if (setting != null && setting.getProperty() != this.property) {
            return;
        }
        this.getValue();
        this.propertySetting = (JbPropertySetting)setting;
        this.initLive();
    }

    @Override
    public void release() {
        this.subcomponent = null;
        this.property = null;
        this.propertySetting = null;
        this.defaultValue = null;
        this.haveDefault = false;
        this.propertyAccessor = null;
        this.editorAttached(null);
    }

    @Override
    public void editorAttached(CmtPropertyEditor editor) {
        if (this.editor != null && this.editor != editor) {
            this.editor.setPropertyState(null);
        }
        this.editor = editor;
    }

    @Override
    public final Object getObject() {
        return this.getSubcomponent();
    }

    @Override
    public final CmtSubcomponent getSubcomponent() {
        return this.subcomponent;
    }

    @Override
    public final CmtProperty getProperty() {
        return this.property;
    }

    @Override
    public final Object getValue() {
        block7: {
            if (this.property.isReadable()) {
                try {
                    Object o = this.getLiveValue(this.subcomponent);
                    if (!this.haveDefault) {
                        this.setDefaultValue(o);
                    }
                    return o;
                }
                catch (Throwable x) {
                    if (x instanceof ThreadDeath) {
                        throw (ThreadDeath)x;
                    }
                    if (this.propertySetting == null) break block7;
                    try {
                        Object o = this.propertySetting.getLiveValue();
                        return o;
                    }
                    catch (Throwable x2) {
                        Assert.println((String)"JbPropertyState.getValue: failed");
                    }
                }
            }
        }
        return null;
    }

    @Override
    public final void setValue(Object value) throws PropertyVetoException {
        this.setValue(value, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setValue(Object value, boolean setLive) throws PropertyVetoException {
        if (this.property.isWritable()) {
            if (this.isReadOnly()) {
                throw new PropertyVetoException(Res.getString(42), new PropertyChangeEvent(this.subcomponent, this.property.getName(), null, null));
            }
            CmtComponent cmtComponent = this.subcomponent.getOuterComponent();
            synchronized (cmtComponent) {
                Object oldValue = null;
                if (setLive) {
                    try {
                        if (this.isDefault(this.subcomponent, value)) {
                            this.reset();
                            return;
                        }
                        oldValue = this.getLiveValue(this.subcomponent);
                        if (!(oldValue == value || value != null && value.equals(oldValue))) {
                            this.setLiveValue(this.subcomponent, value);
                        }
                    }
                    catch (Throwable t) {
                        Assert.println((String)"JbPropertyState.setValue: failed");
                        if (t instanceof CmtPropertyChangeException) {
                            throw (CmtPropertyChangeException)t;
                        }
                        if (t instanceof PropertyVetoException) {
                            throw (PropertyVetoException)t;
                        }
                        if (t instanceof NullPointerException) {
                            throw (NullPointerException)t;
                        }
                        if (t instanceof IllegalArgumentException) {
                            throw (IllegalArgumentException)t;
                        }
                        return;
                    }
                }
                PropertyEditor transducer = this.getTransducer();
                Object source = null;
                PropertyEditor propertyEditor = transducer;
                synchronized (propertyEditor) {
                    try {
                        if (transducer instanceof CmtPropertyEditor) {
                            ((CmtPropertyEditor)transducer).setPropertyState(this);
                        }
                        transducer.setValue(value);
                        source = transducer.getJavaInitializationString();
                        if (source != null && ((String)source).equals(JbPropertyState.unsupportedJavaInitString()) && this.property.getType() != null) {
                            source = value.toString();
                            if (this.property.getType().getQualifiedName().equals("java.lang.String") && ((String)source).indexOf(34) < 0) {
                                source = "\"" + (String)source + "\"";
                            }
                        }
                    }
                    catch (Throwable t) {
                        Assert.println((String)"JbPropertyState.setLiveValue: failed");
                    }
                    if (source != null && ((String)source).length() > 0) {
                        if (this.propertySetting == null) {
                            this.propertySetting = (JbPropertySetting)this.subcomponent.addPropertySetting(this.property, (String)source);
                        } else {
                            this.propertySetting.setValueSource((String)source);
                        }
                        this.addImports();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addImports() {
        CmtComponent outer = this.subcomponent.getOuterComponent();
        SourceFile jFile = (SourceFile)outer.getFile();
        SourceTransaction transaction = jFile.getTransaction();
        boolean transactionCreated = false;
        if (transaction == null) {
            transaction = jFile.beginTransaction();
            transactionCreated = true;
        }
        try {
            if (outer != null && outer instanceof CmtComponentSource) {
                JbMethodCall method = (JbMethodCall)(this.propertySetting != null ? this.propertySetting.getMethodCall() : null);
                SourceMethodCallExpression jotExpression = method != null ? method.getJotMethodCall() : null;
                ((CmtComponentSource)outer).addImports((SourceExpression)jotExpression);
            }
            if (transactionCreated) {
                transaction.commit();
                transaction = null;
            }
        }
        finally {
            if (transactionCreated && transaction != null) {
                transaction.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getValueText() {
        if (this.property.isReadable()) {
            PropertyEditor transducer;
            PropertyEditor propertyEditor = transducer = this.getTransducer();
            synchronized (propertyEditor) {
                try {
                    Object transducerValue = transducer.getValue();
                    transducer.setValue(this.getLiveValue(this.subcomponent));
                    String textValue = transducer.getAsText();
                    if (transducerValue != null) {
                        transducer.setValue(transducerValue);
                    }
                    return textValue;
                }
                catch (Throwable x) {
                    block12: {
                        if (x instanceof ThreadDeath) {
                            throw (ThreadDeath)x;
                        }
                        if (this.propertySetting != null) {
                            try {
                                Object transducerValue = transducer.getValue();
                                transducer.setValue(this.propertySetting.getLiveValue());
                                String textValue = transducer.getAsText();
                                if (transducerValue != null) {
                                    transducer.setValue(transducerValue);
                                }
                                return textValue;
                            }
                            catch (Throwable x2) {
                                if (!(x2 instanceof ThreadDeath)) break block12;
                                throw (ThreadDeath)x2;
                            }
                        }
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setValueText(String valueText) {
        if (this.property.isWritable()) {
            CmtComponent cmtComponent = this.subcomponent.getOuterComponent();
            synchronized (cmtComponent) {
                PropertyEditor transducer;
                PropertyEditor propertyEditor = transducer = this.getTransducer();
                synchronized (propertyEditor) {
                    block12: {
                        try {
                            transducer.setAsText(valueText);
                            this.setLiveValue(this.subcomponent, transducer.getValue());
                            String source = transducer.getJavaInitializationString();
                            if (source != null && source.equals(JbPropertyState.unsupportedJavaInitString())) {
                                source = valueText;
                            }
                            if (this.propertySetting == null) {
                                this.propertySetting = (JbPropertySetting)this.subcomponent.addPropertySetting(this.property, source);
                            } else {
                                this.propertySetting.setValueSource(source);
                            }
                            this.addImports();
                        }
                        catch (Throwable t) {
                            Assert.println((String)"JbPropertyState.setValueText: failed");
                            if (this.propertySetting == null) break block12;
                            ((JbMethod)this.subcomponent.getInitMethod()).removePropertySetting(this.propertySetting);
                            this.propertySetting = null;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getValueSource() {
        if (this.property.isReadable()) {
            PropertyEditor transducer;
            if (this.propertySetting != null) {
                return this.propertySetting.getValueSource();
            }
            PropertyEditor propertyEditor = transducer = this.getTransducer();
            synchronized (propertyEditor) {
                String source = null;
                try {
                    Object value = this.getLiveValue(this.subcomponent);
                    transducer.setValue(value);
                    source = transducer.getJavaInitializationString();
                    if (source != null && source.equals(JbPropertyState.unsupportedJavaInitString())) {
                        source = value.toString();
                    }
                }
                catch (Throwable x) {
                    Assert.println((String)"JbPropertyState.getValueSource: failed");
                }
                return source;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setValueSource(String valueSrc) {
        if (this.property.isWritable()) {
            CmtComponent cmtComponent = this.subcomponent.getOuterComponent();
            synchronized (cmtComponent) {
                block8: {
                    try {
                        if (this.propertySetting == null) {
                            this.propertySetting = (JbPropertySetting)this.subcomponent.addPropertySetting(this.property, valueSrc);
                        } else {
                            this.propertySetting.setValueSource(valueSrc);
                        }
                        this.initLive();
                        this.addImports();
                    }
                    catch (Throwable x) {
                        if (!(x instanceof ThreadDeath)) break block8;
                        throw (ThreadDeath)x;
                    }
                }
            }
        }
    }

    final void initLive() {
        try {
            if (this.propertySetting != null) {
                Object value = this.propertySetting.getLiveValue();
                if (value != null) {
                    this.setLiveValue(this.subcomponent, value);
                } else if (Jot2Utils.isNull(this.propertySetting.getValueExpression())) {
                    this.setLiveValue(this.subcomponent, null);
                }
            }
        }
        catch (Throwable x) {
            Assert.println((String)"JbPropertyState.initLive: failed");
        }
    }

    @Override
    public final boolean isDefault() {
        return this.propertySetting == null;
    }

    final boolean isUsesContainerDelegate() {
        boolean b = false;
        if (this.subcomponent.getComponent().getContainerDelegate() != null) {
            String propName = this.getProperty().getName();
            for (int i = 0; i < containerProps.length; ++i) {
                if (!propName.equalsIgnoreCase(containerProps[i])) continue;
                b = true;
                break;
            }
        }
        return b;
    }

    protected final boolean isDefault(CmtSubcomponent subcomponent, Object value) {
        Object instance = this.isUsesContainerDelegate() ? subcomponent.getAsContainer() : subcomponent.getLiveInstance();
        return this.isDefault(instance, value);
    }

    protected final boolean isDefault(Object instance, Object value) {
        if (!this.haveDefault) {
            this.getDefaultValue(instance);
        }
        if (value == this.defaultValue) {
            return true;
        }
        if (value != null) {
            if (value.equals(this.defaultValue)) {
                return true;
            }
            if (this.defaultValue == null && value instanceof String && ((String)value).length() == 0) {
                return true;
            }
        } else {
            if (this.defaultValue instanceof String && ((String)this.defaultValue).length() == 0) {
                return true;
            }
            PropertyEditor transducer = this.getTransducer();
            if (transducer != null && transducer instanceof ResetsOnNull) {
                return true;
            }
        }
        return false;
    }

    protected final Object getDefaultValue(Object instance) {
        if (!this.haveDefault) {
            try {
                this.defaultValue = this.getLiveValue(instance);
            }
            catch (Throwable e) {
                return null;
            }
            this.haveDefault = true;
        }
        return this.defaultValue;
    }

    @Override
    public final void setDefaultValue(Object value) {
        if (!this.haveDefault) {
            this.defaultValue = value;
            this.haveDefault = true;
        }
    }

    @Override
    public final void reset() {
        if (this.property.isWritable()) {
            block5: {
                if (this.haveDefault) {
                    try {
                        this.setLiveValue(this.subcomponent, this.defaultValue);
                    }
                    catch (Throwable x) {
                        if (!(x instanceof ThreadDeath)) break block5;
                        throw (ThreadDeath)x;
                    }
                }
            }
            if (this.propertySetting != null) {
                ((JbMethod)this.subcomponent.getInitMethod()).removePropertySetting(this.propertySetting);
                this.propertySetting = null;
            }
        }
    }

    public static final String toValidJavaIdentifier(String text) {
        StringBuffer key = new StringBuffer(text);
        int j = 0;
        if (text.length() > 0) {
            key.setCharAt(j++, Character.isJavaIdentifierStart(text.charAt(0)) ? Character.toLowerCase(text.charAt(0)) : (char)'_');
        }
        for (int i = 1; i < text.length(); ++i) {
            if (Character.isJavaIdentifierPart(text.charAt(i))) continue;
            key.setCharAt(i, '_');
        }
        return key.toString();
    }

    protected final PropertyEditor getTransducer() {
        PropertyEditor transducer = this.property.getTransducer();
        if (transducer instanceof CmtPropertyEditor) {
            ((CmtPropertyEditor)transducer).setPropertyState(this);
        }
        return transducer;
    }

    private static final String unsupportedJavaInitString() {
        if (UNSUPPORTED_JAVA_INIT_STRING == null) {
            UNSUPPORTED_JAVA_INIT_STRING = new PropertyEditorSupportProxy().getJavaInitializationString();
        }
        return UNSUPPORTED_JAVA_INIT_STRING;
    }

    @Override
    public final boolean isReadOnly() {
        JavaFile file = this.subcomponent.getOuterComponent().getFile();
        if (file != null) {
            return URLFileSystem.isReadOnly((URL)file.getURL());
        }
        return false;
    }

    @Override
    public final boolean isPseudoPropertyState() {
        return false;
    }

    public final String toString() {
        return "JbPropertyState[property=" + this.property.getName() + ",value=" + this.getValue() + "]";
    }

    protected final Object getLiveValue(CmtSubcomponent subcomponent) throws Exception {
        Object instance = this.isUsesContainerDelegate() ? subcomponent.getAsContainer() : subcomponent.getLiveInstance();
        return this.getLiveValue(instance);
    }

    protected final Object getLiveValue(Object instance) throws Exception {
        return this.propertyAccessor.getPropertyValue(this, instance);
    }

    public final void setLiveValue(CmtSubcomponent subcomponent, Object value) throws Exception {
        Object instance = this.isUsesContainerDelegate() ? subcomponent.getAsContainer() : subcomponent.getLiveInstance();
        this.setLiveValue(instance, value);
        if (instance instanceof JComponent) {
            ((JComponent)instance).invalidate();
        } else if (instance instanceof LayoutManager) {
            CmtComponent outer = subcomponent.getOuterComponent();
            subcomponent = outer != null ? outer.getSubcomponent(null) : null;
            Object object = value = subcomponent != null ? subcomponent.getLiveInstance() : null;
            if (value instanceof Component) {
                this.invalidateSubTree((Component)value);
            }
        }
    }

    private void invalidateSubTree(Component root) {
        Component[] children;
        if (root instanceof Container && (children = ((Container)root).getComponents()) != null) {
            for (int i = 0; i < children.length; ++i) {
                this.invalidateSubTree(children[i]);
            }
        }
        if (root != null) {
            root.invalidate();
        }
    }

    public void setLiveValue(Object instance, Object value) throws Exception {
        if (!this.haveDefault) {
            this.getDefaultValue(instance);
        }
        try {
            this.propertyAccessor.setPropertyValue(this, instance, value);
        }
        catch (Exception ex) {
            if (ex instanceof InvocationTargetException) {
                Throwable t = ((InvocationTargetException)ex).getTargetException();
                if (t == null) {
                    throw ex;
                }
                Assert.println((String)"JbPropertyState.setLiveValue: failed");
                String s = t.getMessage();
                if (s == null || s.length() == 0) {
                    s = ex.getMessage();
                }
                if (s != null && s.length() > 0) {
                    Ide.getStatusBar().setText(Res.format(13, new String[]{this.property.getName(), s}));
                }
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
            }
            throw ex;
        }
    }

    public Object getPropertyValue(Object instance) throws Exception {
        if (instance == null) {
            return null;
        }
        try {
            Object o = this.property.getLiveGetter().invoke(instance, new Object[0]);
            return o;
        }
        catch (Exception e) {
            Assert.println((String)(e.toString() + " during JbPropertyState.getPropertyValue " + this.property.getName() + " for " + this.subcomponent.getName()));
            return null;
        }
    }

    @Override
    public final Object getPropertyValue(CmtPropertyState ps, Object instance) throws Exception {
        return this.getPropertyValue(instance);
    }

    public final void setPropertyValue(Object instance, Object value) throws Exception {
        Method setter = this.property.getLiveSetter();
        if (!this.primitiveValueSet(setter, instance, value)) {
            setter.invoke(instance, value);
        }
    }

    private boolean primitiveValueSet(Method setter, Object instance, Object value) throws Exception {
        Class<?>[] parameterTypes = setter.getParameterTypes();
        if (parameterTypes == null || parameterTypes.length != 1) {
            return false;
        }
        Class<?> parameterType = parameterTypes[0];
        if (!parameterType.isPrimitive()) {
            return false;
        }
        if (value == null) {
            return false;
        }
        Class<?> valueType = value.getClass();
        if (parameterType.equals(Byte.TYPE)) {
            if (valueType.equals(Byte.class)) {
                return false;
            }
            if (!(value instanceof Number)) {
                return false;
            }
            setter.invoke(instance, ((Number)value).byteValue());
            return true;
        }
        if (parameterType.equals(Short.TYPE)) {
            if (valueType.equals(Short.class)) {
                return false;
            }
            if (!(value instanceof Number)) {
                return false;
            }
            setter.invoke(instance, ((Number)value).shortValue());
            return true;
        }
        if (parameterType.equals(Integer.TYPE)) {
            if (valueType.equals(Integer.class)) {
                return false;
            }
            if (!(value instanceof Number)) {
                return false;
            }
            setter.invoke(instance, ((Number)value).intValue());
            return true;
        }
        if (parameterType.equals(Long.TYPE)) {
            if (valueType.equals(Long.class)) {
                return false;
            }
            if (!(value instanceof Number)) {
                return false;
            }
            setter.invoke(instance, ((Number)value).longValue());
            return true;
        }
        if (parameterType.equals(Float.TYPE)) {
            if (valueType.equals(Float.class)) {
                return false;
            }
            if (!(value instanceof Number)) {
                return false;
            }
            setter.invoke(instance, Float.valueOf(((Number)value).floatValue()));
            return true;
        }
        if (parameterType.equals(Double.TYPE)) {
            if (valueType.equals(Double.class)) {
                return false;
            }
            if (!(value instanceof Number)) {
                return false;
            }
            setter.invoke(instance, ((Number)value).doubleValue());
            return true;
        }
        return false;
    }

    @Override
    public final void setPropertyValue(CmtPropertyState ps, Object instance, Object value) throws Exception {
        this.setPropertyValue(instance, value);
    }
}

