/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage.event;

import java.net.URL;
import oracle.jdeveloper.usage.UsageQueryTask;

public class UsageEvent {
    protected UsageQueryTask _source;
    protected int _usageCode;
    protected URL _url;
    protected int _startOffset;
    protected int _endOffset;
    public static final int USAGE_FINISHED = 0;
    public static final int USAGE_CANCELLED = 1;
    public static final int USAGE_FAILED = 2;
    public static final int USAGE_URL_SKIPPED = 3;
    public static final int USAGE_KEYWORD_SKIPPED = 4;

    public UsageEvent(UsageQueryTask source, int usageCode) {
        this(source, usageCode, null);
    }

    public UsageEvent(UsageQueryTask source, int usageCode, URL url) {
        this(source, usageCode, url, -1, -1);
    }

    public UsageEvent(UsageQueryTask source, int usageCode, URL url, int startOffset, int endOffset) {
        this._source = source;
        this._usageCode = usageCode;
        this._url = url;
        this._startOffset = startOffset;
        this._endOffset = endOffset;
    }

    public UsageQueryTask getSource() {
        return this._source;
    }

    public int getUsageCode() {
        return this._usageCode;
    }

    public URL getURL() {
        return this._url;
    }

    public int getStartOffset() {
        return this._startOffset;
    }

    public int getEndOffset() {
        return this._endOffset;
    }

    public String toString() {
        String usage = this.usageCodeToString(this.getUsageCode());
        return "Code(" + usage + ") Start(" + this.getStartOffset() + ") End(" + this.getEndOffset() + ") ";
    }

    protected String usageCodeToString(int code) {
        switch (code) {
            case 0: {
                return "USAGE_FINISHED";
            }
            case 2: {
                return "USAGE_FAILED";
            }
            case 1: {
                return "USAGE_CANCELLED";
            }
            case 3: {
                return "USAGE_URL_SKIPPED";
            }
            case 4: {
                return "USAGE_KEYWORD_SKIPPED";
            }
        }
        return "<<unknown>>";
    }
}

