/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import oracle.ide.file.Path;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.java.JavaModelFactory;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.locator.ClassLocatorFactory;
import oracle.jdeveloper.java.locator.JdevClassLocatorFactory;
import oracle.jdeveloper.java.locator.PathClassLocator;

public class JdevPathClassLocator
extends PathClassLocator {
    protected static JdevPathClassLocator getInstance(Workspace workspace, Path sourcePath, URLPath classPath) {
        try {
            return JdevPathClassLocator.getInstanceImpl(workspace, sourcePath, classPath, false);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    protected static JdevPathClassLocator getInstanceInterruptibly(Workspace workspace, Path sourcePath, URLPath classPath) throws InterruptedException {
        return JdevPathClassLocator.getInstanceImpl(workspace, sourcePath, classPath, true);
    }

    private static JdevPathClassLocator getInstanceImpl(Workspace workspace, Path sourcePath, URLPath classPath, boolean checkInterrupt) throws InterruptedException {
        BaseClassLocator sourceLocator;
        ClassLocatorFactory factory = JavaModelFactory.getInstance().getLocatorFactory();
        if (checkInterrupt) {
            JdevPathClassLocator.checkInterrupt();
        }
        BaseClassLocator baseClassLocator = sourceLocator = checkInterrupt ? JdevPathClassLocator.ensureValid((BaseClassLocator)JdevClassLocatorFactory.getSourceLocatorInterruptibly(workspace, sourcePath)) : JdevPathClassLocator.ensureValid((BaseClassLocator)JdevClassLocatorFactory.getSourceLocator(workspace, sourcePath));
        if (checkInterrupt) {
            JdevPathClassLocator.checkInterrupt();
        }
        BaseClassLocator classLocator = checkInterrupt ? JdevPathClassLocator.ensureValid((BaseClassLocator)factory.getClassLocatorInterruptibly(classPath)) : JdevPathClassLocator.ensureValid((BaseClassLocator)factory.getClassLocator(classPath));
        return new JdevPathClassLocator(sourceLocator, classLocator);
    }

    private JdevPathClassLocator(BaseClassLocator sourceLocator, BaseClassLocator classLocator) {
        super(sourceLocator, classLocator);
    }

    protected long getSourceTimestamp(URL sourceURL) {
        long nodeTimestamp;
        Node node = NodeFactory.find((URL)sourceURL);
        if (node != null && node.isOpen() && (nodeTimestamp = node.getTimestampLoadedUnsafe()) != -1L) {
            return nodeTimestamp;
        }
        return super.getSourceTimestamp(sourceURL);
    }
}

