/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.iface;

import java.util.List;
import oracle.ide.Context;
import oracle.javatools.parser.java.v2.model.ClassKind;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.builder.cls.ClassBuilderModel;
import oracle.jdeveloper.builder.resource.BuilderArb;
import oracle.jdeveloper.java.util.SourceUtils;

public class InterfaceBuilderModel
extends ClassBuilderModel {
    private boolean _isPublic;
    private List<String> _interfaces;

    public InterfaceBuilderModel(Context ctx) {
        super(ctx);
    }

    void setSuperInterfaces(List<String> interfaces) {
        this._interfaces = interfaces;
    }

    void setPublic(boolean isPublic) {
        this._isPublic = isPublic;
    }

    @Override
    protected boolean hasDefaultConstructor() {
        return false;
    }

    protected boolean validateClass(SourceClass cls, String pkg) {
        if (cls != null && cls.isInterface()) {
            return this._isClassAccessible((JavaClass)cls, pkg);
        }
        return false;
    }

    @Override
    protected void generate(SourceFile file, SourceClass cls) {
        int modifiers = cls.getModifiers();
        if (this._isPublic) {
            cls.setModifiers(modifiers | 1);
        } else {
            cls.setModifiers(modifiers & 0xFFFFFFFE);
        }
        cls.setClassKind(ClassKind.INTERFACE);
        if (this._interfaces != null && !this._interfaces.isEmpty()) {
            for (String iface : this._interfaces) {
                SourceUtils.addSuperInterface((SourceClass)cls, (String)iface);
            }
        }
    }

    @Override
    protected String getBaseName() {
        return BuilderArb.getString(140);
    }

    @Override
    public String getBuilderType() {
        return "iface";
    }
}

