/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.Disposable;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.MetadataProcedure;
import com.adbs.ast.MetadataSynonym;
import com.adbs.ast.MetadataTable;
import com.adbs.ast.MetadataView;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SortByNameComparator;
import com.adbs.ast.SortBySchemaTypeNameComparator;
import com.adbs.ast.SortByTypeNameComparator;
import com.adbs.ast.UpdatedEvent;
import com.adbs.ast.UpdatedEventListener;
import com.adbs.querybuilder.CreateNodeAction;
import com.adbs.querybuilder.CustomTree;
import com.adbs.querybuilder.CustomTreeCellRenderer;
import com.adbs.querybuilder.CustomTreeNode;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.DataSourceObject;
import com.adbs.querybuilder.MetadataTreeOptions;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.querybuilder.UnionSubQuery;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class MetadataTree
extends CustomTree
implements UpdatedEventListener,
Disposable {
    private static final long serialVersionUID = 1L;
    private MetadataContainer metadataContainer;
    private CustomTreeNode root = null;
    private DefaultTreeModel model = null;

    public MetadataTree(QueryBuilder queryBuilder) {
        super(queryBuilder);
        this.setRootVisible(false);
        this.setDragEnabled(true);
        this.root = new CustomTreeNode("root");
        this.model = new DefaultTreeModel(this.root);
        this.root.removeAllChildren();
        this.setBorder(BorderFactory.createEmptyBorder(1, 4, 1, 1));
        this.setCellRenderer(new CustomTreeCellRenderer());
        this.setModel(this.model);
        this.expandPath(new TreePath(this.root.getPath()));
        queryBuilder.getMetadataTreeOptions().addUpdatedEventListener(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MetadataTree.this.onMouseClicked(e);
            }
        });
        this.setTransferHandler(new TransferHandler(){

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                return false;
            }

            @Override
            public int getSourceActions(JComponent c) {
                return 0x40000000;
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                MetadataTree tree = (MetadataTree)c;
                TreePath[] selectedPaths = tree.getSelectionPaths();
                if (selectedPaths.length > 0) {
                    StringBuffer buf = new StringBuffer();
                    for (TreePath path : selectedPaths) {
                        MetadataObject mo = (MetadataObject)((CustomTreeNode)path.getLastPathComponent()).tag;
                        if (mo == null) continue;
                        buf.append(mo.getFullNameStr());
                        buf.append("\n");
                    }
                    return new StringSelection(buf.toString());
                }
                return null;
            }
        });
    }

    @Override
    public void dispose() {
        this.metadataContainer.removeUpdatedEventListener(this);
    }

    @Override
    public void updatedEventOccurred(UpdatedEvent event) {
        if (event.getSource() instanceof MetadataContainer) {
            this.reloadNodes(false);
        } else if (event.getSource() instanceof MetadataTreeOptions) {
            this.reloadNodes(true);
        }
    }

    MetadataContainer getMetadataContainer() {
        return this.metadataContainer;
    }

    void setMetadataContainer(MetadataContainer metadataContainer) {
        if (this.metadataContainer != null) {
            this.metadataContainer.removeUpdatedEventListener(this);
        }
        this.metadataContainer = metadataContainer;
        metadataContainer.addUpdatedEventListener(this);
    }

    private CustomTreeNode getItemWithName(CustomTreeNode where, String name, Icon icon, Object obj) {
        CustomTreeNode t = null;
        if (obj == null) {
            if (where != null) {
                try {
                    t = (CustomTreeNode)where.getFirstChild();
                }
                catch (Exception exception) {}
            } else if (this.root.getChildCount() > 0) {
                try {
                    t = (CustomTreeNode)this.root.getFirstChild();
                }
                catch (Exception exception) {}
            } else {
                t = null;
            }
            while (t != null) {
                if (t.tag == null && t.text.equals(name)) {
                    t.icon = icon;
                    return t;
                }
                t = (CustomTreeNode)t.getNextNode();
            }
        }
        CustomTreeNode result = new CustomTreeNode(name);
        if (where != null) {
            where.add(result);
        } else {
            this.root.add(result);
        }
        result.tag = obj;
        result.icon = icon;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMouseClicked(MouseEvent e) {
        CustomTreeNode selectedNode;
        TreePath selectedPath;
        if (e.getClickCount() == 2 && (selectedPath = this.getSelectionPath()) != null && (selectedNode = (CustomTreeNode)selectedPath.getLastPathComponent()).isLeaf() && selectedNode.tag != null && this.getQueryBuilder().getActiveSubquery() != null && this.getQueryBuilder().getActiveSubquery().getActiveUnionSubquery() != null) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.addMetadataObjectFromNode(selectedNode);
            }
            catch (Exception ex) {
                Logger.getLogger(MetadataTree.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private CustomTreeNode createOrAddDatabaseNode(CustomTreeNode parent, MetadataObject obj, Parameters p, boolean allObjectsFromOneDatabaseFlag) {
        String dbName;
        if (parent == null) {
            parent = this.root;
        }
        if (allObjectsFromOneDatabaseFlag) {
            return parent;
        }
        if (Helpers.isQualifiedNameEmpty(obj.getDatabase())) {
            dbName = obj.getDBLink().getCount() == 0 ? Helpers.localizer.getString("strMetadataTreeCurrentDatabase", "(current database)") : "@" + obj.getDBLink().getSimpleSQL(obj.getSQLContext().getSQLBuilderMetadata());
        } else {
            dbName = obj.getDatabase().getSimpleSQL(this.getQueryBuilder().getSQLContext().getSQLBuilderMetadata());
            if (obj.getDBLink().getCount() > 0) {
                dbName = dbName + "@" + obj.getDBLink().getSimpleSQL(obj.getSQLContext().getSQLBuilderMetadata());
            }
        }
        return this.getItemWithName(parent, dbName, p.databaseIcon, null);
    }

    private CustomTreeNode createOrAddSchemaNode(CustomTreeNode parent, MetadataObject obj, Parameters p) {
        AstTokenIdentifier emptySchemaName;
        CustomTreeNode result = !obj.getSchema().isEmpty() ? this.getItemWithName(parent, obj.getSchema().getSimpleSQL(this.getQueryBuilder().getSQLContext().getSQLBuilderMetadata()), p.schemaIcon, null) : (this.getQueryBuilder().getSyntaxProvider().isSupportSchemas() ? ((emptySchemaName = this.getQueryBuilder().getSyntaxProvider().getEmptySchemaName(this.getQueryBuilder().getSQLContext())) != null ? this.getItemWithName(parent, emptySchemaName.getSimpleSQL(this.getQueryBuilder().getSQLContext().getSQLBuilderMetadata()), p.schemaIcon, null) : parent) : parent);
        return result;
    }

    private CustomTreeNode createOrAddTypeNode(CustomTreeNode parent, Parameters p) {
        return this.getItemWithName(parent, p.groupName, p.typeIcon, null);
    }

    private CustomTreeNode loadNodes(MetadataObject obj, CreateNodeAction[] actions, Parameters p, boolean allObjectsFromOneDatabaseFlag) {
        CustomTreeNode result = null;
        block5: for (int i = 0; i < actions.length; ++i) {
            switch (actions[i]) {
                case Type: {
                    result = this.createOrAddTypeNode(result, p);
                    continue block5;
                }
                case Database: {
                    result = this.createOrAddDatabaseNode(result, obj, p, allObjectsFromOneDatabaseFlag);
                    continue block5;
                }
                case Schema: {
                    result = this.createOrAddSchemaNode(result, obj, p);
                }
            }
        }
        return result;
    }

    private void loadObject(Parameters p, boolean allObjectsFromOneDatabaseFlag) {
        if (p.obj.isVisible() && (!p.obj.isSystem() && p.showUserObjects || p.obj.isSystem() && p.showSystemObjects)) {
            String objName;
            CustomTreeNode n;
            SQLBuilder sqlBuilderMetadata = this.getQueryBuilder().getSQLContext().getSQLBuilderMetadata();
            switch (this.getQueryBuilder().getMetadataTreeOptions().getGroupingType()) {
                case Database: {
                    n = this.loadNodes(p.obj, new CreateNodeAction[]{CreateNodeAction.Database}, p, allObjectsFromOneDatabaseFlag);
                    if (sqlBuilderMetadata.isUseAltNames() && !Str.IsNullOrEmpty(p.obj.getAltName())) {
                        objName = p.obj.getAltNameId().getSimpleSQL(sqlBuilderMetadata);
                        break;
                    }
                    objName = p.obj.getNameAsString(false, true, true, sqlBuilderMetadata);
                    break;
                }
                case Type: {
                    n = this.loadNodes(p.obj, new CreateNodeAction[]{CreateNodeAction.Type}, p, allObjectsFromOneDatabaseFlag);
                    if (sqlBuilderMetadata.isUseAltNames() && !Str.IsNullOrEmpty(p.obj.getAltName())) {
                        objName = p.obj.getAltNameId().getSimpleSQL(sqlBuilderMetadata);
                        break;
                    }
                    objName = p.obj.getNameAsString(true, true, true, sqlBuilderMetadata);
                    break;
                }
                case DatabaseType: {
                    n = this.loadNodes(p.obj, new CreateNodeAction[]{CreateNodeAction.Database, CreateNodeAction.Type}, p, allObjectsFromOneDatabaseFlag);
                    if (sqlBuilderMetadata.isUseAltNames() && !Str.IsNullOrEmpty(p.obj.getAltName())) {
                        objName = p.obj.getAltNameId().getSimpleSQL(sqlBuilderMetadata);
                        break;
                    }
                    objName = p.obj.getNameAsString(false, true, true, sqlBuilderMetadata);
                    break;
                }
                case DatabaseSchema: {
                    n = this.loadNodes(p.obj, new CreateNodeAction[]{CreateNodeAction.Database, CreateNodeAction.Schema}, p, allObjectsFromOneDatabaseFlag);
                    if (sqlBuilderMetadata.isUseAltNames() && !Str.IsNullOrEmpty(p.obj.getAltName())) {
                        objName = p.obj.getAltNameId().getSimpleSQL(sqlBuilderMetadata);
                        break;
                    }
                    objName = p.obj.getName().getSimpleSQL(sqlBuilderMetadata);
                    break;
                }
                case TypeDatabase: {
                    n = this.loadNodes(p.obj, new CreateNodeAction[]{CreateNodeAction.Type, CreateNodeAction.Database}, p, allObjectsFromOneDatabaseFlag);
                    if (sqlBuilderMetadata.isUseAltNames() && !Str.IsNullOrEmpty(p.obj.getAltName())) {
                        objName = p.obj.getAltNameId().getSimpleSQL(sqlBuilderMetadata);
                        break;
                    }
                    objName = p.obj.getNameAsString(false, true, true, sqlBuilderMetadata);
                    break;
                }
                case DatabaseSchemaType: {
                    n = this.loadNodes(p.obj, new CreateNodeAction[]{CreateNodeAction.Database, CreateNodeAction.Schema, CreateNodeAction.Type}, p, allObjectsFromOneDatabaseFlag);
                    if (sqlBuilderMetadata.isUseAltNames() && !Str.IsNullOrEmpty(p.obj.getAltName())) {
                        objName = p.obj.getAltNameId().getSimpleSQL(sqlBuilderMetadata);
                        break;
                    }
                    objName = p.obj.getName().getSimpleSQL(sqlBuilderMetadata);
                    break;
                }
                case DatabaseTypeSchema: {
                    n = this.loadNodes(p.obj, new CreateNodeAction[]{CreateNodeAction.Database, CreateNodeAction.Type, CreateNodeAction.Schema}, p, allObjectsFromOneDatabaseFlag);
                    if (sqlBuilderMetadata.isUseAltNames() && !Str.IsNullOrEmpty(p.obj.getAltName())) {
                        objName = p.obj.getAltNameId().getSimpleSQL(sqlBuilderMetadata);
                        break;
                    }
                    objName = p.obj.getName().getSimpleSQL(sqlBuilderMetadata);
                    break;
                }
                case TypeDatabaseSchema: {
                    n = this.loadNodes(p.obj, new CreateNodeAction[]{CreateNodeAction.Type, CreateNodeAction.Database, CreateNodeAction.Schema}, p, allObjectsFromOneDatabaseFlag);
                    if (sqlBuilderMetadata.isUseAltNames() && !Str.IsNullOrEmpty(p.obj.getAltName())) {
                        objName = p.obj.getAltNameId().getSimpleSQL(sqlBuilderMetadata);
                        break;
                    }
                    objName = p.obj.getName().getSimpleSQL(sqlBuilderMetadata);
                    break;
                }
                default: {
                    n = this.loadNodes(p.obj, new CreateNodeAction[0], p, allObjectsFromOneDatabaseFlag);
                    objName = sqlBuilderMetadata.isUseAltNames() && !Str.IsNullOrEmpty(p.obj.getAltName()) ? p.obj.getAltNameId().getSimpleSQL(sqlBuilderMetadata) : p.obj.getNameAsString(true, true, true, sqlBuilderMetadata);
                }
            }
            if (!p.obj.isSystem()) {
                this.getItemWithName(n, objName, p.userObjectIcon, p.obj);
            } else {
                this.getItemWithName(n, objName, p.systemObjectIcon, p.obj);
            }
        }
    }

    private boolean areAllObjectsFromOneDatabase(List<MetadataObject> list) {
        if (list.size() > 1) {
            SQLQualifiedName db = list.get(0).getDatabase();
            for (int i = 1; i < list.size(); ++i) {
                boolean result = db.getSQLContext().isQualifiedNamesEqual(db, list.get(i).getDatabase());
                if (result) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public void reloadNodes(boolean forceReload) {
        if ((forceReload || this.getMetadataContainer().getObjectsUpdated()) && this.getQueryBuilder().getSyntaxProvider() != null) {
            int i;
            ArrayList<MetadataObject> l = new ArrayList<MetadataObject>();
            MetadataContainer mc = this.getMetadataContainer();
            MetadataTreeOptions options = this.getQueryBuilder().getMetadataTreeOptions();
            l.ensureCapacity(mc.getCount());
            for (int i2 = 0; i2 < mc.getCount(); ++i2) {
                l.add(mc.get(i2));
            }
            switch (options.getSortingType()) {
                case Name: {
                    Collections.sort(l, new SortByNameComparator());
                    break;
                }
                case TypeName: {
                    Collections.sort(l, new SortByTypeNameComparator());
                    break;
                }
                case SchemaTypeName: {
                    Collections.sort(l, new SortBySchemaTypeNameComparator());
                }
            }
            boolean allObjectsFromOneDatabaseFlag = options.isHideSingleDatabaseNode() ? this.areAllObjectsFromOneDatabase(l) : false;
            this.root.removeAllChildren();
            String tablesNodeText = Str.IsNullOrEmpty(options.getTablesNodeText()) ? Helpers.localizer.getString("strTables", "Tables") : options.getTablesNodeText();
            String viewsNodeText = Str.IsNullOrEmpty(options.getViewsNodeText()) ? Helpers.localizer.getString("strViews", "Views") : options.getViewsNodeText();
            String proceduresNodeText = Str.IsNullOrEmpty(options.getProceduresNodeText()) ? Helpers.localizer.getString("strProcedures", "Procedures") : options.getProceduresNodeText();
            String synonymsNodeText = Str.IsNullOrEmpty(options.getSynonymsNodeText()) ? Helpers.localizer.getString("strSynonyms", "Synonyms") : options.getSynonymsNodeText();
            for (i = 0; i < l.size(); ++i) {
                if (l.get(i) instanceof MetadataTable) {
                    this.loadObject(new Parameters(l.get(i), tablesNodeText, options.isShowUserTables(), options.isShowSystemTables(), options.getDatabaseIcon(), options.getSchemaIcon(), options.getTablesNodeIcon(), options.getUserTablesIcon(), options.getSystemTablesIcon()), allObjectsFromOneDatabaseFlag);
                    continue;
                }
                if (l.get(i) instanceof MetadataView) {
                    this.loadObject(new Parameters(l.get(i), viewsNodeText, options.isShowUserViews(), options.isShowSystemViews(), options.getDatabaseIcon(), options.getSchemaIcon(), options.getViewsNodeIcon(), options.getUserViewsIcon(), options.getSystemViewsIcon()), allObjectsFromOneDatabaseFlag);
                    continue;
                }
                if (l.get(i) instanceof MetadataProcedure) {
                    this.loadObject(new Parameters(l.get(i), proceduresNodeText, options.isShowUserProcedures(), options.isShowSystemProcedures(), options.getDatabaseIcon(), options.getSchemaIcon(), options.getProceduresNodeIcon(), options.getUserProceduresIcon(), options.getSystemProceduresIcon()), allObjectsFromOneDatabaseFlag);
                    continue;
                }
                if (!(l.get(i) instanceof MetadataSynonym)) continue;
                this.loadObject(new Parameters(l.get(i), synonymsNodeText, options.isShowUserSynonyms(), options.isShowSystemSynonyms(), options.getDatabaseIcon(), options.getSchemaIcon(), options.getSynonymsNodeIcon(), options.getUserSynonymsIcon(), options.getSystemSynonymsIcon()), allObjectsFromOneDatabaseFlag);
            }
            this.model.reload();
            this.expandPath(new TreePath(this.root.getPath()));
            if (this.root.getChildCount() > 0) {
                if (options.getDefaultExpandLevel() < 0) {
                    for (i = 0; i < this.getRowCount(); ++i) {
                        this.expandRow(i);
                    }
                } else {
                    for (CustomTreeNode n = (CustomTreeNode)this.root.getFirstChild(); n != null; n = (CustomTreeNode)n.getNextSibling()) {
                        this.expandNode(n, 1, options.getDefaultExpandLevel());
                    }
                }
                this.scrollRowToVisible(0);
            }
        }
    }

    private void expandNode(CustomTreeNode root, int currentLevel, int lastLevel) {
        if (currentLevel <= lastLevel) {
            this.expandPath(new TreePath(root.getPath()));
            if (currentLevel < lastLevel) {
                for (CustomTreeNode n = (CustomTreeNode)root.getFirstChild(); n != null; n = (CustomTreeNode)n.getNextSibling()) {
                    this.expandNode(n, currentLevel + 1, lastLevel);
                }
            }
        }
    }

    public DataSource addMetadataObject(MetadataObject metadataObject) throws QueryBuilderException {
        return this.addMetadataObjectAt(metadataObject, new Point(0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource addMetadataObjectAt(MetadataObject metadataObject, Point point) throws QueryBuilderException {
        assert (metadataObject != null);
        DataSource result = null;
        UnionSubQuery usq = this.queryBuilder.getActiveSubquery().getActiveUnionSubquery();
        usq.beginUpdate();
        try {
            result = metadataObject instanceof MetadataProcedure ? usq.addStoredProcAt(metadataObject.getFullNameStr(), point, metadataObject.getNameStrNotQuoted() + "_") : usq.addObjectAt(metadataObject, point);
            if (result != null) {
                if (result instanceof DataSourceObject) {
                    if (this.queryBuilder.getLinkOptions().isCreateLinksFromRelations()) {
                        usq.addFKLinksForObject((DataSourceObject)result);
                    }
                    if (this.queryBuilder.getLinkOptions().isCreateLinksByIdenticalFieldNames()) {
                        usq.addIdenticalFieldsLinksForObject((DataSourceObject)result);
                    }
                }
                if (this.queryBuilder.getLinkOptions().isAddLinkedObjects()) {
                    usq.addLinkedObjectsFor(result);
                }
            }
        }
        finally {
            usq.endUpdate();
        }
        return result;
    }

    DataSource addMetadataObjectFromNode(CustomTreeNode node) throws QueryBuilderException {
        return this.addMetadataObjectFromNodeAt(node, new Point(0, 0));
    }

    DataSource addMetadataObjectFromNodeAt(CustomTreeNode node, Point point) throws QueryBuilderException {
        assert (node != null);
        if (node.tag != null) {
            return this.addMetadataObjectAt((MetadataObject)node.tag, point);
        }
        return null;
    }

    private class Parameters {
        public MetadataObject obj;
        public String groupName;
        public boolean showUserObjects;
        public boolean showSystemObjects;
        public Icon databaseIcon;
        public Icon schemaIcon;
        public Icon typeIcon;
        public Icon userObjectIcon;
        public Icon systemObjectIcon;

        public Parameters(MetadataObject obj, String groupName, boolean showUserObjects, boolean showSystemObjects, Icon databaseIcon, Icon schemaIcon, Icon typeIcon, Icon userObjectIcon, Icon systemObjectIcon) {
            this.obj = obj;
            this.groupName = groupName;
            this.showUserObjects = showUserObjects;
            this.showSystemObjects = showSystemObjects;
            this.databaseIcon = databaseIcon;
            this.schemaIcon = schemaIcon;
            this.typeIcon = typeIcon;
            this.userObjectIcon = userObjectIcon;
            this.systemObjectIcon = systemObjectIcon;
        }
    }
}

