/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.AstNode;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLExpressionAnd;
import com.adbs.ast.SQLExpressionItem;
import com.adbs.ast.SQLExpressionLogicalCollection;
import com.adbs.ast.SQLExpressionOr;
import com.adbs.ast.SQLFromClause;
import com.adbs.ast.SQLFromGroup;
import com.adbs.ast.SQLFromObject;
import com.adbs.ast.SQLFromQuery;
import com.adbs.ast.SQLFromSource;
import com.adbs.ast.SQLJoinKindInner;
import com.adbs.ast.SQLJoinKindLeft;
import com.adbs.ast.SQLJoinKindOuter;
import com.adbs.ast.SQLJoinKindRight;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SyntaxProviderChangedEvent;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.DataSourceBase;
import com.adbs.querybuilder.DataSourceObject;
import com.adbs.querybuilder.DataSourceQuery;
import com.adbs.querybuilder.DataSourcesSet;
import com.adbs.querybuilder.Link;
import com.adbs.querybuilder.LinkPlace;
import com.adbs.querybuilder.LinkSideType;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.querybuilder.UnionSubQuery;
import com.adbs.utils.Helpers;
import com.adbs.utils.Wrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DatasourceGroup
extends DataSourceBase {
    private DatasourceGroup fromClause;
    private boolean reorderNeeded;
    public final ArrayList<DataSourceBase> items = new ArrayList();
    public final ArrayList<Link> links = new ArrayList();

    public DatasourceGroup(DatasourceGroup owner, DatasourceGroup updateParent, QueryBuilder queryBuilder) {
        super(owner, updateParent, queryBuilder);
        this.fromClause = owner;
    }

    public DatasourceGroup(UnionSubQuery owner, QueryBuilder queryBuilder) {
        super(owner, owner, queryBuilder);
        this.fromClause = this;
    }

    @Override
    public void dispose() {
        this.beginUpdate();
        try {
            for (DataSourceBase dataSource : new ArrayList<DataSourceBase>(this.items)) {
                dataSource.dispose();
            }
            this.items.clear();
            for (Link link : new ArrayList<Link>(this.links)) {
                link.dispose();
            }
            this.links.clear();
        }
        finally {
            this.endUpdate();
        }
        super.dispose();
    }

    public int getCount() {
        return this.items.size();
    }

    public DataSourceBase get(int index) {
        return this.items.get(index);
    }

    public int getLinkCount() {
        return this.links.size();
    }

    public DatasourceGroup getFromClause() {
        return this.fromClause;
    }

    @Override
    protected AstNode createResultAST() {
        AstNode result = null;
        if (this.getCount() > 0) {
            result = super.createResultAST();
            if (result == null && this.getCount() > 0) {
                result = new SQLFromClause(this.sqlContext);
            }
            if (result != null && this.getCount() > 0) {
                for (int i = 0; i < this.getCount(); ++i) {
                    ((SQLFromGroup)result).add((SQLFromSource)this.items.get(i).getResultAST());
                }
            }
        }
        if (result == null && this.sqlContext.getSyntaxProvider() != null && this.sqlContext.getSyntaxProvider().isFromClauseMandatory()) {
            result = new SQLFromClause(this.sqlContext);
        }
        return result;
    }

    public void registerDatasourceBase(DataSourceBase datasourceBase) {
        this.items.add(datasourceBase);
    }

    public void unregisterDatasourceBase(DataSourceBase datasourceBase) {
        this.items.remove(datasourceBase);
    }

    public void registerLink(Link link) {
        this.links.add(link);
    }

    public void unregisterLink(Link link) {
        this.links.remove(link);
    }

    @Override
    protected void doSQLUpdated() {
        if (this.reorderNeeded) {
            this.reorderNeeded = false;
            if (!this.getQueryBuilder().isDisposing()) {
                try {
                    this.reorderDatasourcesInternal();
                }
                catch (QueryBuilderException ex) {
                    Logger.getLogger(DatasourceGroup.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        super.doSQLUpdated();
    }

    protected int addInternal(DataSourceBase datasource) {
        this.items.add(datasource);
        return this.items.size() - 1;
    }

    protected void insertInternal(int index, DataSourceBase datasource) {
        this.items.add(index, datasource);
    }

    protected int removeInternal(DataSourceBase item) {
        int x = this.items.indexOf(item);
        if (x != -1) {
            this.items.remove(x);
            item.dispose();
        }
        return x;
    }

    protected void deleteInternal(int index) {
        DataSourceBase item = this.items.get(index);
        this.items.remove(index);
        item.dispose();
    }

    protected DataSourceBase extractInternal(DataSourceBase item) {
        int x = this.items.indexOf(item);
        if (x > -1) {
            this.items.remove(x);
            return item;
        }
        return null;
    }

    protected void reorderDatasourcesInternal() throws QueryBuilderException {
        int i;
        if (this.getQueryBuilder().isCanReorderDatasources()) {
            DataSourcesSet dsset;
            Link l;
            ArrayList<Link> ll = new ArrayList<Link>();
            for (i = 0; i < this.getLinkCount(); ++i) {
                l = this.links.get(i);
                if (l.getPlace() != LinkPlace.From) continue;
                ll.add(this.links.get(i));
            }
            ArrayList<DataSourceBase> dl = new ArrayList<DataSourceBase>();
            for (i = 0; i < this.getCount(); ++i) {
                dl.add(this.items.get(i));
            }
            ArrayList<DataSourcesSet> dssets = new ArrayList<DataSourcesSet>();
            while (dl.size() > 0) {
                dsset = new DataSourcesSet();
                dssets.add(dsset);
                dsset.loadAllLinkedForDatasource((DataSourceBase)dl.get(0), dl, ll);
                assert (dsset.datasources.size() == 1 && dsset.links.isEmpty() || dsset.datasources.size() > 1 && dsset.links.size() > 0);
                dsset.reorderByTemplate(this.items);
            }
            for (i = dssets.size() - 1; i >= 0; --i) {
                dsset = (DataSourcesSet)dssets.get(i);
                if (dsset.datasources.size() != 1 || !(dsset.datasources.get(0) instanceof DatasourceGroup)) continue;
                dsset.moveFromChild(this);
            }
            if (this.getGroup() != null) {
                for (i = dssets.size() - 1; i >= 0; --i) {
                    dsset = (DataSourcesSet)dssets.get(i);
                    if (!dsset.links.isEmpty()) continue;
                    dsset.moveToParentGroup(this);
                    dssets.remove(i);
                    this.getGroup().notifyReorderNeeded();
                }
            }
            for (i = dssets.size() - 1; i >= 0; --i) {
                dsset = (DataSourcesSet)dssets.get(i);
                if (dsset.datasources.isEmpty()) {
                    dssets.remove(i);
                    continue;
                }
                if (dsset.datasources.size() != 1 || !(dsset.datasources.get(0) instanceof DatasourceGroup) || ((DatasourceGroup)dsset.datasources.get(0)).getCount() != 0) continue;
                dssets.remove(i);
            }
            for (i = this.getCount() - 1; i >= 0; --i) {
                this.extractInternal(this.get(i));
            }
            for (i = 0; i < dssets.size(); ++i) {
                dsset = (DataSourcesSet)dssets.get(i);
                dsset.writeToGroup(this);
            }
            for (i = 0; i < this.getLinkCount(); ++i) {
                l = this.links.get(i);
                if (l.getPlace() != LinkPlace.Where || !l.isSimple() || !l.newFlag) continue;
                Link lr = null;
                for (int j = 0; j < this.getLinkCount(); ++j) {
                    Link l2 = this.links.get(j);
                    if (l2.newFlag || !l2.isSimple() || (l.getLeftDatasource() != l2.getLeftDatasource() || l.getRightDatasource() != l2.getRightDatasource()) && (l.getLeftDatasource() != l2.getRightDatasource() || l.getRightDatasource() != l2.getLeftDatasource())) continue;
                    lr = l2;
                    break;
                }
                if (lr == null) continue;
                Class newJoinClass = lr.getLeftType() == LinkSideType.Inner && lr.getRightType() == LinkSideType.Inner ? SQLJoinKindInner.class : (lr.getLeftType() == LinkSideType.Outer && lr.getRightType() == LinkSideType.Outer ? SQLJoinKindOuter.class : (l.getLeftDatasource() == lr.getLeftDatasource() ? (lr.getLeftType() == LinkSideType.Inner ? SQLJoinKindRight.class : SQLJoinKindLeft.class) : (lr.getLeftType() == LinkSideType.Inner ? SQLJoinKindLeft.class : SQLJoinKindRight.class)));
                l.setJoinKindClass(newJoinClass);
            }
        }
        for (i = 0; i < this.getLinkCount(); ++i) {
            this.links.get((int)i).newFlag = false;
        }
    }

    public void notifyReorderNeeded() {
        if (this.getGroup() != null) {
            this.getQuery().getFromClause().beginUpdate();
            try {
                this.reorderNeeded = true;
                this.notifySQLUpdated();
                this.getGroup().notifyReorderNeeded();
            }
            finally {
                this.getQuery().getFromClause().endUpdate();
            }
        }
        this.beginUpdate();
        try {
            this.reorderNeeded = true;
            this.notifySQLUpdated();
        }
        finally {
            this.endUpdate();
        }
    }

    protected void getWhereJoinConditions(Wrapper<SQLExpressionAnd> and) {
        int i;
        for (i = 0; i < this.getCount(); ++i) {
            DataSourceBase ds = this.get(i);
            if (!(ds instanceof DatasourceGroup)) continue;
            ((DatasourceGroup)ds).getWhereJoinConditions(and);
        }
        for (i = 0; i < this.getLinkCount(); ++i) {
            Link l = this.links.get(i);
            if (l.getPlace() != LinkPlace.Where) continue;
            if (and.value == null) {
                and.value = new SQLExpressionAnd(this.getSQLContext());
            }
            ((SQLExpressionAnd)and.value).add(l.getLinkExpression().clone(this.getSQLContext()));
        }
    }

    public boolean containsDatasourceBefore(DataSourceBase ds, DataSourceBase before) {
        int max = this.items.indexOf(before);
        if (max > 0) {
            for (int i = 0; i < max; ++i) {
                if (!this.get(i).containsDatasource(ds, true)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void saveLayout(Document document, Element unionSubQuery, SQLBuilder sqlBuilder) {
        for (int i = 0; i < this.getCount(); ++i) {
            this.get(i).saveLayout(document, unionSubQuery, sqlBuilder);
        }
    }

    @Override
    public void loadLayout(Element unionSubQuery, SQLBuilder sqlBuilder) {
        for (int i = 0; i < this.getCount(); ++i) {
            this.get(i).loadLayout(unionSubQuery, sqlBuilder);
        }
    }

    public int indexOf(DataSourceBase item) {
        return this.items.indexOf(item);
    }

    public int add(DataSourceBase datasource) {
        int result = this.addInternal(datasource);
        if (this.astFromSource == null) {
            this.astFromSource = new SQLFromGroup(this.getSQLContext());
        }
        this.notifySQLUpdated();
        return result;
    }

    public void delete(int index) {
        this.deleteInternal(index);
        this.notifySQLUpdated();
    }

    public int remove(DataSourceBase item) {
        int result = this.removeInternal(item);
        this.notifySQLUpdated();
        return result;
    }

    @Override
    public boolean loadFromAST(SQLFromSource fs) {
        int i;
        boolean result = super.loadFromAST(fs);
        SQLFromGroup fi = (SQLFromGroup)this.astFromSource;
        for (i = 0; i < fi.getCount(); ++i) {
            if (fi.get(i) instanceof SQLFromGroup) {
                DatasourceGroup dsg = new DatasourceGroup(this.getFromClause(), this, this.getQueryBuilder());
                boolean bl = result = dsg.loadFromAST((SQLFromGroup)fi.get(i)) || result;
                if (!this.isControlsCreated() || !dsg.canCreateControls()) continue;
                dsg.createControls();
                continue;
            }
            DataSource ds = fi.get(i) instanceof SQLFromObject ? new DataSourceObject(this.getFromClause(), this, this.getQueryBuilder()) : (fi.get(i) instanceof SQLFromQuery ? new DataSourceQuery(this.getFromClause(), this, this.getQueryBuilder()) : new DataSource(this.getFromClause(), this, this.getQueryBuilder()));
            fi.get((int)i).data = ds;
            boolean bl = result = ds.loadFromAST(fi.get(i)) || result;
            if (!this.isControlsCreated() || !ds.canCreateControls()) continue;
            ds.createControls();
        }
        for (i = fi.getCount() - 1; i >= 0; --i) {
            fi.extract(i);
        }
        return result;
    }

    @Override
    public void loadJoins() {
        super.loadJoins();
        for (int i = 0; i < this.getCount(); ++i) {
            this.items.get(i).loadJoins();
        }
    }

    private boolean needDelete(List<List<DataSourceBase>> ll) {
        DataSourceBase pattern = ll.get(0).get(0);
        for (int i = 1; i < ll.size(); ++i) {
            if (pattern == ll.get(i).get(0)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Link addLinkAST(DataSource leftDatasource, DataSource rightDatasource, DataSourceBase datasourceOwner, SQLExpressionItem ast, LinkPlace place, boolean newFlag) {
        Link result;
        if (datasourceOwner == null) {
            ArrayList<DataSourceBase> l = new ArrayList<DataSourceBase>();
            ArrayList datasourcesAst = new ArrayList();
            ast.getReferencedDatasourcesRecursive(datasourcesAst);
            for (Object datasourceAst : datasourcesAst) {
                l.add((DataSourceBase)((SQLFromSource)datasourceAst).data);
            }
            if (leftDatasource != null) {
                l.add(leftDatasource);
            }
            if (rightDatasource != null) {
                l.add(rightDatasource);
            }
            for (int i = l.size() - 1; i >= 0; --i) {
                DataSourceBase dataSourceBase = (DataSourceBase)l.get(i);
                if (dataSourceBase.query == this.getQuery()) continue;
                l.remove(i);
            }
            if (l.size() > 0) {
                ArrayList<List<DataSourceBase>> ll = new ArrayList<List<DataSourceBase>>();
                for (DataSourceBase dataSourceBase : l) {
                    ArrayList<DataSourceBase> lo = new ArrayList<DataSourceBase>();
                    ll.add(lo);
                    for (DataSourceBase ds = dataSourceBase; ds != null; ds = ds.getGroup()) {
                        lo.add(0, ds);
                    }
                }
                while (this.needDelete(ll)) {
                    for (int i = 0; i < ll.size(); ++i) {
                        ((List)ll.get(i)).remove(0);
                    }
                }
                DataSourceBase dso = (DataSourceBase)((List)ll.get(0)).get(0);
                DatasourceGroup go = dso.getGroup();
                int max = go.indexOf(dso);
                for (int i = 1; i < ll.size(); ++i) {
                    dso = (DataSourceBase)((List)ll.get(i)).get(0);
                    int cmax = go.indexOf(dso);
                    if (cmax <= max) continue;
                    max = cmax;
                }
                datasourceOwner = go.get(max);
            }
        }
        assert (datasourceOwner != null) : "Invalid parameter for FromClause.AddLinkAST: can't calculate ADatasourceOwner";
        DatasourceGroup g = datasourceOwner.getGroup();
        g.beginUpdate();
        try {
            result = new Link(g, this.queryBuilder);
            result.setLinkParamsInternal(datasourceOwner, ast, place, newFlag);
            g.notifyReorderNeeded();
        }
        finally {
            g.endUpdate();
        }
        return result;
    }

    private boolean loadExpressionItem(SQLExpressionItem e) {
        boolean result = Link.canLoadExpressionAsSimpleWhereLink(this, e);
        if (result) {
            Link l = this.addLinkAST(null, null, null, e, LinkPlace.Where, false);
            if (this.isControlsCreated() && l.canCreateControls()) {
                l.createControls();
            }
        }
        return result;
    }

    private SQLExpressionItem loadJoin(SQLExpressionItem expression) {
        SQLExpressionItem result = expression;
        SQLExpressionItem e = Helpers.expressionRemoveBrackets(expression);
        if (e instanceof SQLExpressionAnd) {
            int i = 0;
            while (i < ((SQLExpressionAnd)e).getCount()) {
                SQLExpressionItem ei = ((SQLExpressionAnd)e).get(i);
                if ((ei = Helpers.expressionRemoveBrackets(ei)) instanceof SQLExpressionAnd) {
                    ei = this.loadJoin(((SQLExpressionAnd)e).get(i));
                    if (ei == null) {
                        ((SQLExpressionAnd)e).extract(i);
                        continue;
                    }
                    ((SQLExpressionAnd)e).extract(i);
                    ((SQLExpressionAnd)e).insert(i, ei);
                    ++i;
                    continue;
                }
                if (this.loadExpressionItem(((SQLExpressionAnd)e).get(i))) {
                    ((SQLExpressionAnd)e).extract(i);
                    continue;
                }
                ++i;
            }
            if (((SQLExpressionAnd)e).getCount() == 1) {
                result = ((SQLExpressionAnd)e).extract(0);
                expression.dispose();
                expression = null;
            } else if (((SQLExpressionAnd)e).getCount() == 0) {
                expression.dispose();
                expression = null;
                result = null;
            }
        } else if (!(e instanceof SQLExpressionLogicalCollection) && this.loadExpressionItem(result)) {
            result = null;
        }
        return result;
    }

    public SQLExpressionItem loadWhereJoins(SQLExpressionItem where) {
        SQLExpressionItem result;
        if (where != null) {
            this.beginUpdate();
            try {
                result = this.loadJoin(where);
            }
            finally {
                this.endUpdate();
            }
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public void updateChecks() {
        for (int i = 0; i < this.getCount(); ++i) {
            this.items.get(i).updateChecks();
        }
    }

    public void findTablesByDBName(SQLQualifiedName tableName, List list) {
        this.getDatasourceByClass(DataSourceObject.class, list);
        for (int i = list.size() - 1; i >= 0; --i) {
            if (this.getQueryBuilder().getSQLContext().isQualifiedNamesEqual(tableName, ((DataSourceObject)list.get(i)).getDatabaseObject())) continue;
            list.remove(i);
        }
    }

    public Link findLink(DataSourceBase leftDatasource, SQLQualifiedName leftField, DataSourceBase rightDatasource, SQLQualifiedName rightField) {
        Link result;
        int i;
        for (i = 0; i < this.getLinkCount(); ++i) {
            result = this.links.get(i);
            if (!result.isSimple() || result.getLeftDatasource() != leftDatasource || result.getRightDatasource() != rightDatasource || this.getQueryBuilder().getSQLContext().compareQualifiedNames(result.getLeftField(), leftField) != 0 || this.getQueryBuilder().getSQLContext().compareQualifiedNames(result.getRightField(), rightField) != 0) continue;
            return result;
        }
        for (i = 0; i < this.getCount(); ++i) {
            if (!(this.get(i) instanceof DatasourceGroup) || (result = ((DatasourceGroup)this.get(i)).findLink(leftDatasource, leftField, rightDatasource, rightField)) == null) continue;
            return result;
        }
        return null;
    }

    public DataSourceBase findDatasourceByAST(SQLFromObject fo) {
        DataSourceBase result;
        if (fo == this.astFromSource) {
            result = this;
        } else {
            result = null;
            for (int i = 0; i < this.getCount(); ++i) {
                DataSourceBase dsb = this.get(i);
                if (dsb.astFromSource == fo) {
                    result = dsb;
                    break;
                }
                if (dsb instanceof DatasourceGroup && (result = ((DatasourceGroup)dsb).findDatasourceByAST(fo)) != null) break;
            }
        }
        return result;
    }

    @Override
    public void getDatasources(List list) {
        super.getDatasources(list);
        for (int i = 0; i < this.getCount(); ++i) {
            this.items.get(i).getDatasources(list);
        }
    }

    @Override
    public void getDatasourceByClass(Class datasourceClass, List list) {
        super.getDatasourceByClass(datasourceClass, list);
        for (int i = 0; i < this.getCount(); ++i) {
            this.items.get(i).getDatasourceByClass(datasourceClass, list);
        }
    }

    @Override
    public boolean containsDatasource(DataSourceBase ds, boolean recursive) {
        boolean result = super.containsDatasource(ds, recursive);
        if (!result) {
            boolean bl = result = this.items.indexOf(ds) != -1;
        }
        if (!result && recursive) {
            for (int i = 0; i < this.getCount(); ++i) {
                if (!(this.get(i) instanceof DatasourceGroup) || !(result = ((DatasourceGroup)this.get(i)).containsDatasource(ds, recursive))) continue;
                return result;
            }
        }
        return result;
    }

    public SQLExpressionItem addWhereJoinConditions(SQLExpressionItem where) {
        SQLExpressionItem result;
        Wrapper<SQLExpressionAnd> and = new Wrapper<SQLExpressionAnd>();
        and.value = null;
        this.getWhereJoinConditions(and);
        if (and.value != null) {
            if (where != null) {
                SQLExpressionItem innerWhere = Helpers.expressionRemoveBrackets(where);
                if (innerWhere instanceof SQLExpressionOr && ((SQLExpressionOr)innerWhere).getCount() == 1) {
                    SQLExpressionOr innerOr = (SQLExpressionOr)innerWhere;
                    if ((innerWhere = Helpers.expressionRemoveBrackets(innerOr.get(0))) instanceof SQLExpressionAnd) {
                        SQLExpressionAnd innerAnd = (SQLExpressionAnd)innerWhere;
                        for (int i = ((SQLExpressionAnd)and.value).getCount() - 1; i >= 0; --i) {
                            innerAnd.insert(0, ((SQLExpressionAnd)and.value).extract(i));
                        }
                        ((SQLExpressionAnd)and.value).dispose();
                        result = where;
                    } else {
                        ((SQLExpressionAnd)and.value).add(where);
                        result = (SQLExpressionItem)and.value;
                    }
                } else if (innerWhere instanceof SQLExpressionAnd) {
                    SQLExpressionAnd innerAnd = (SQLExpressionAnd)innerWhere;
                    for (int i = ((SQLExpressionAnd)and.value).getCount() - 1; i >= 0; --i) {
                        innerAnd.insert(0, ((SQLExpressionAnd)and.value).extract(i));
                    }
                    ((SQLExpressionAnd)and.value).dispose();
                    result = where;
                } else {
                    ((SQLExpressionAnd)and.value).add(where);
                    result = (SQLExpressionItem)and.value;
                }
            } else {
                result = (SQLExpressionItem)and.value;
            }
        } else {
            result = where;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void syntaxProviderChangedEventOccurred(SyntaxProviderChangedEvent event) {
        super.syntaxProviderChangedEventOccurred(event);
        if (this.getLinkCount() > 0 && this.getSQLContext().getSyntaxProvider() != null && !this.getSQLContext().getSyntaxProvider().isSupportANSIJoins()) {
            this.getQuery().beginUpdate();
            try {
                ArrayList<Link> linksToRemove = new ArrayList<Link>();
                try {
                    int i;
                    for (i = 0; i < this.getLinkCount(); ++i) {
                        Link newLink;
                        Link l = this.links.get(i);
                        if (l.getPlace() != LinkPlace.From) continue;
                        SQLExpressionItem e = l.getLinkExpression().clone(this.getSQLContext());
                        if (l.isSimple()) {
                            newLink = this.addLinkAST(l.getLeftDatasource(), l.getRightDatasource(), l.getDatasourceOwner(), e, LinkPlace.Where, false);
                            if ((this.getSQLContext().getSyntaxProvider().isSupportOracleJoins() || this.getSQLContext().getSyntaxProvider().isSupportTransactSQLJoins()) && (l.getLeftType() != LinkSideType.Outer || l.getRightType() != LinkSideType.Outer)) {
                                newLink.setJoinKindClass(l.getDatasourceOwner().getJoinKindClass());
                            } else {
                                newLink.setJoinKindClass(SQLJoinKindInner.class);
                            }
                            if (this.isControlsCreated() && newLink.canCreateControls()) {
                                newLink.createControls();
                            }
                        } else if ((e = this.loadWhereJoins(e)) != null) {
                            newLink = this.addLinkAST(l.getLeftDatasource(), l.getRightDatasource(), l.getDatasourceOwner(), e, LinkPlace.Where, false);
                            if (this.isControlsCreated() && newLink.canCreateControls()) {
                                newLink.createControls();
                            }
                        }
                        linksToRemove.add(l);
                    }
                    for (i = 0; i < linksToRemove.size(); ++i) {
                        ((Link)linksToRemove.get(i)).dispose();
                    }
                }
                finally {
                    linksToRemove.clear();
                }
            }
            finally {
                this.getQuery().endUpdate();
            }
        }
    }

    public Link[] getLinks() {
        return this.links.toArray(new Link[0]);
    }

    public void getLinks(ArrayList list) {
        list.addAll(this.links);
    }

    public void getLinksRecursive(ArrayList list) {
        this.getLinks(list);
        for (int i = 0; i < this.getCount(); ++i) {
            DataSourceBase dataSourceBase = this.get(i);
            if (!(dataSourceBase instanceof DatasourceGroup)) continue;
            ((DatasourceGroup)dataSourceBase).getLinksRecursive(list);
        }
    }
}

