/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.AstNode;
import com.adbs.ast.MetadataField;
import com.adbs.querybuilder.CheckListItem;
import com.adbs.querybuilder.ConditionType;
import com.adbs.querybuilder.ControlOwner;
import com.adbs.querybuilder.CriteriaItem;
import com.adbs.querybuilder.CriteriaList;
import com.adbs.querybuilder.CriteriaListOptions;
import com.adbs.querybuilder.CustomExpressionBuilderColumns;
import com.adbs.querybuilder.CustomExpressionBuilderEvent;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.DataSourceFieldList;
import com.adbs.querybuilder.DatasourceFieldAddedEvent;
import com.adbs.querybuilder.DatasourceFieldAddingEvent;
import com.adbs.querybuilder.DiagramPane;
import com.adbs.querybuilder.GridCellValueChangedEvent;
import com.adbs.querybuilder.GridCellValueChangingEvent;
import com.adbs.querybuilder.ItemSortType;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.utils.Constants;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;

public class CriteriaListControl
extends JTable
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private CriteriaList criteriaList;
    private DiagramPane diagramPane;
    private CustomTableModel tableModel;
    private CustomTableColumnModel customColumnModel;
    private JTable rowHeaderTable;
    private boolean isDisposing = false;
    private TableColumn outputColumn;
    private TableColumn expressionColumn;
    private TableColumn aggregateColumn;
    private TableColumn aliasColumn;
    private TableColumn sortTypeColumn;
    private TableColumn sortOrderColumn;
    private TableColumn groupingColumn;
    private TableColumn groupingTypeColumn;
    private TableColumn conditionTypeColumn;
    private TableColumn conditionColumn;
    private CustomComboBoxCellEditor comboCellEditor;
    private CustomTextFieldCellEditor textCellEditor;
    private JComboBox comboBox;
    private JTextField textField;
    private JButton button;
    private Icon icon = new ImageIcon(this.getClass().getResource("images/dots.png"));
    private DropTarget dropTarget;

    public CriteriaListControl(ControlOwner owner) {
        this.criteriaList = (CriteriaList)owner;
        this.diagramPane = this.criteriaList.getUnionSubQuery().getDiagramPane();
        CriteriaListOptions o = this.criteriaList.getQueryBuilder().getCriteriaListOptions();
        Font f = o.getCriteriaListFont();
        if (f != null) {
            this.setFont(f);
        }
        if ((f = o.getCriteriaListHeaderFont()) != null) {
            this.getTableHeader().setFont(f);
        }
        this.setAutoCreateColumnsFromModel(false);
        this.setCellSelectionEnabled(true);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(false);
        this.setSelectionMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        this.setAutoResizeMode(o.isAutoSizeColumns() ? 4 : 0);
        this.setRowHeight(this.getFontMetrics(this.getFont()).getHeight() + 6);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.setSurrendersFocusOnKeystroke(true);
        this.setDefaultRenderer(String.class, new CustomStringCellRenderer());
        this.setDefaultRenderer(Boolean.class, new CustomBooleanCellRenderer());
        TableCellRenderer defaultRenderer = this.getTableHeader().getDefaultRenderer();
        this.getTableHeader().setDefaultRenderer(new CustomTableHeaderRenderer(defaultRenderer));
        this.comboBox = new JComboBox<Object>(new Object[10]);
        this.comboBox.setEditable(true);
        this.comboBox.setBorder(BorderFactory.createEmptyBorder());
        this.comboCellEditor = new CustomComboBoxCellEditor(this.comboBox);
        this.comboCellEditor.setClickCountToStart(1);
        this.textField = new JTextField();
        this.textField.setEditable(true);
        this.textField.setBorder(BorderFactory.createEmptyBorder());
        this.textCellEditor = new CustomTextFieldCellEditor(this.textField);
        this.textCellEditor.setClickCountToStart(1);
        this.outputColumn = new TableColumn(0);
        this.outputColumn.setPreferredWidth(o.getOutputColumnWidth());
        this.expressionColumn = new TableColumn(1);
        this.expressionColumn.setPreferredWidth(o.getExpressionColumnWidth());
        this.expressionColumn.setCellEditor(this.comboCellEditor);
        this.aggregateColumn = new TableColumn(2);
        this.aggregateColumn.setPreferredWidth(o.getAggregateColumnWidth());
        this.aggregateColumn.setCellEditor(this.comboCellEditor);
        this.aliasColumn = new TableColumn(3);
        this.aliasColumn.setPreferredWidth(o.getAliasColumnWidth());
        this.aliasColumn.setCellEditor(this.textCellEditor);
        this.sortTypeColumn = new TableColumn(4);
        this.sortTypeColumn.setPreferredWidth(o.getSortTypeColumnWidth());
        this.sortTypeColumn.setCellEditor(this.comboCellEditor);
        this.sortOrderColumn = new TableColumn(5);
        this.sortOrderColumn.setPreferredWidth(o.getSortOrderColumnWidth());
        this.sortOrderColumn.setCellEditor(this.comboCellEditor);
        this.groupingColumn = new TableColumn(6);
        this.groupingColumn.setPreferredWidth(o.getGroupingColumnWidth());
        this.groupingColumn.addPropertyChangeListener(new ColumnResizeListener());
        this.groupingTypeColumn = new TableColumn(7);
        this.groupingTypeColumn.setPreferredWidth(o.getGroupingTypeColumnWidth());
        this.groupingTypeColumn.setCellEditor(this.comboCellEditor);
        this.conditionTypeColumn = new TableColumn(8);
        this.conditionTypeColumn.setPreferredWidth(o.getConditionTypeColumnWidth());
        this.conditionTypeColumn.setCellEditor(this.comboCellEditor);
        this.conditionColumn = new TableColumn(9);
        this.conditionColumn.setPreferredWidth(o.getConditionColumnWidth());
        this.conditionColumn.setCellEditor(this.textCellEditor);
        this.dropTarget = new DropTarget(this, new CustomDropTargetListener());
        this.updateDropTarget();
        this.customColumnModel = new CustomTableColumnModel();
        this.setColumnModel(this.customColumnModel);
        this.tableModel = new CustomTableModel(this.criteriaList);
        this.setModel(this.tableModel);
        this.addColumn(this.outputColumn);
        this.addColumn(this.expressionColumn);
        this.addColumn(this.aggregateColumn);
        this.addColumn(this.aliasColumn);
        this.addColumn(this.sortTypeColumn);
        this.addColumn(this.sortOrderColumn);
        this.addColumn(this.groupingColumn);
        this.addColumn(this.groupingTypeColumn);
        this.addColumn(this.conditionTypeColumn);
        this.addColumn(this.conditionColumn);
        this.customColumnModel.setColumnVisible(this.outputColumn, o.getOutputColumnWidth() > 0);
        this.customColumnModel.setColumnVisible(this.expressionColumn, o.getExpressionColumnWidth() > 0);
        this.customColumnModel.setColumnVisible(this.aggregateColumn, o.getAggregateColumnWidth() > 0);
        this.customColumnModel.setColumnVisible(this.aliasColumn, o.getAliasColumnWidth() > 0);
        this.customColumnModel.setColumnVisible(this.sortTypeColumn, o.getSortTypeColumnWidth() > 0);
        this.customColumnModel.setColumnVisible(this.sortOrderColumn, o.getSortOrderColumnWidth() > 0);
        this.customColumnModel.setColumnVisible(this.groupingColumn, o.getGroupingColumnWidth() > 0);
        this.customColumnModel.setColumnVisible(this.groupingTypeColumn, o.getGroupingTypeColumnWidth() > 0);
        this.customColumnModel.setColumnVisible(this.conditionTypeColumn, o.getConditionTypeColumnWidth() > 0);
        this.customColumnModel.setColumnVisible(this.conditionColumn, o.getConditionColumnWidth() > 0);
        this.outputColumn.addPropertyChangeListener(new ColumnResizeListener());
        this.expressionColumn.addPropertyChangeListener(new ColumnResizeListener());
        this.aggregateColumn.addPropertyChangeListener(new ColumnResizeListener());
        this.aliasColumn.addPropertyChangeListener(new ColumnResizeListener());
        this.sortTypeColumn.addPropertyChangeListener(new ColumnResizeListener());
        this.sortOrderColumn.addPropertyChangeListener(new ColumnResizeListener());
        this.groupingTypeColumn.addPropertyChangeListener(new ColumnResizeListener());
        this.conditionTypeColumn.addPropertyChangeListener(new ColumnResizeListener());
        this.conditionColumn.addPropertyChangeListener(new ColumnResizeListener());
        for (int i = 0; i < o.getInitialOrColumnsCount(); ++i) {
            this.addConditionColumn();
        }
        ToolTipManager.sharedInstance().unregisterComponent(this);
        ToolTipManager.sharedInstance().unregisterComponent(this.getTableHeader());
        this.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "startEditing");
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                if (key == 32 || key == 10) {
                    int row = CriteriaListControl.this.getSelectedRow();
                    int column = CriteriaListControl.this.getSelectedColumn();
                    int realColumn = CriteriaListControl.this.customColumnModel.getColumn(column, true).getModelIndex();
                    if (row >= 0) {
                        if (realColumn == 0) {
                            CriteriaItem ci = CriteriaListControl.this.getCriteriaItemForRow(row);
                            if (!ci.isCanSelect()) {
                                return;
                            }
                            Boolean checked = (Boolean)CriteriaListControl.this.getValueAt(row, column);
                            CriteriaListControl.this.setValueAt(checked == false, row, column);
                            CriteriaListControl.this.setRowSelectionInterval(row, row);
                            CriteriaListControl.this.setColumnSelectionInterval(column, column);
                        } else if (realColumn == 6) {
                            CriteriaItem ci = CriteriaListControl.this.getCriteriaItemForRow(row);
                            if (!ci.isCanGrouping()) {
                                return;
                            }
                            Boolean checked = (Boolean)CriteriaListControl.this.getValueAt(row, column);
                            CriteriaListControl.this.setValueAt(checked == false, row, column);
                            CriteriaListControl.this.setRowSelectionInterval(row, row);
                            CriteriaListControl.this.setColumnSelectionInterval(column, column);
                        }
                    }
                    return;
                }
                super.keyPressed(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    int column;
                    int row;
                    Point p;
                    if (e.getButton() == 1) {
                        p = e.getPoint();
                        row = CriteriaListControl.this.rowAtPoint(p);
                        column = CriteriaListControl.this.customColumnModel.getColumn(CriteriaListControl.this.columnAtPoint(p), true).getModelIndex();
                        if (column == 0 || column == 6) {
                            CustomBooleanCellRenderer customRenderer = (CustomBooleanCellRenderer)CriteriaListControl.this.getCellRenderer(row, column).getTableCellRendererComponent(CriteriaListControl.this, CriteriaListControl.this.getValueAt(row, column), true, true, row, column);
                            Rectangle cellRect = CriteriaListControl.this.getCellRect(row, column, false);
                            Dimension preferredCheckBoxSize = customRenderer.getCheckBox().getPreferredSize();
                            Rectangle checkBoxRect = new Rectangle(cellRect.x + cellRect.width / 2 - preferredCheckBoxSize.width / 2, cellRect.y + cellRect.height / 2 - preferredCheckBoxSize.height / 2, preferredCheckBoxSize.width, preferredCheckBoxSize.height);
                            if (checkBoxRect.contains(p)) {
                                if (column == 0) {
                                    CriteriaItem ci = CriteriaListControl.this.getCriteriaItemForRow(row);
                                    if (!ci.isCanSelect()) {
                                        return;
                                    }
                                    Boolean checked = (Boolean)CriteriaListControl.this.getValueAt(row, column);
                                    CriteriaListControl.this.setValueAt(checked == false, row, column);
                                    CriteriaListControl.this.setRowSelectionInterval(row, row);
                                    CriteriaListControl.this.setColumnSelectionInterval(column, column);
                                } else {
                                    CriteriaItem ci = CriteriaListControl.this.getCriteriaItemForRow(row);
                                    if (!ci.isCanGrouping()) {
                                        return;
                                    }
                                    Boolean checked = (Boolean)CriteriaListControl.this.getValueAt(row, column);
                                    CriteriaListControl.this.setValueAt(checked == false, row, column);
                                    CriteriaListControl.this.setRowSelectionInterval(row, row);
                                    CriteriaListControl.this.setColumnSelectionInterval(column, column);
                                }
                            }
                        }
                    }
                    if (e.getButton() == 3) {
                        p = e.getPoint();
                        row = CriteriaListControl.this.rowAtPoint(p);
                        column = CriteriaListControl.this.columnAtPoint(p);
                        if (row >= 0 && row < CriteriaListControl.this.criteriaList.getCount()) {
                            CriteriaListControl.this.setRowSelectionInterval(row, row);
                            CriteriaListControl.this.setColumnSelectionInterval(column, column);
                            if (CriteriaListControl.this.isEditing()) {
                                CriteriaListControl.this.getCellEditor().stopCellEditing();
                            }
                            JPopupMenu menu = CriteriaListControl.this.criteriaList.get(row).getPopupMenu();
                            CriteriaListControl.this.criteriaList.getQueryBuilder().popupMenuPopup(menu, CriteriaListControl.this, CriteriaListControl.this.criteriaList.get(row), p);
                        }
                    }
                }
                super.mouseClicked(e);
            }
        });
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row = CriteriaListControl.this.getSelectedRow();
                if (row >= 0 && row < CriteriaListControl.this.criteriaList.getCount()) {
                    CriteriaListControl.this.criteriaList.getQueryBuilder().updateTreePosition(CriteriaListControl.this.criteriaList.get(row));
                }
            }
        });
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (ks.getKeyEventType() == 401 && e.isAltDown() && !e.isShiftDown() && !e.isControlDown()) {
            if (ks.getKeyCode() == 38) {
                int row = this.getSelectedRow();
                if (row >= 0 && row < this.criteriaList.getCount()) {
                    this.criteriaList.get(row).actionPerformed(new ActionEvent(this, 0, "move up"));
                }
                return true;
            }
            if (ks.getKeyCode() == 40) {
                int row = this.getSelectedRow();
                if (row >= 0 && row < this.criteriaList.getCount()) {
                    this.criteriaList.get(row).actionPerformed(new ActionEvent(this, 0, "move down"));
                }
                return true;
            }
            if (ks.getKeyCode() == 127) {
                int row = this.getSelectedRow();
                if (row >= 0 && row < this.criteriaList.getCount()) {
                    this.criteriaList.get(row).actionPerformed(new ActionEvent(this, 0, "remove"));
                }
                return true;
            }
            if (ks.getKeyCode() == 155) {
                int row = this.getSelectedRow();
                if (row >= 0 && row < this.criteriaList.getCount()) {
                    this.criteriaList.get(row).actionPerformed(new ActionEvent(this, 0, "insert"));
                }
                return true;
            }
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    public CriteriaList getCriteriaList() {
        return this.criteriaList;
    }

    private CriteriaItem getCriteriaItemForRow(int row) {
        if (row >= 0 && row < this.getCriteriaList().getCount()) {
            return this.getCriteriaList().get(row);
        }
        return null;
    }

    public DiagramPane getDiagramPane() {
        return this.diagramPane;
    }

    public void fillList() {
        if (this.isDisposing || this.criteriaList.getQueryBuilder().isDisposing()) {
            return;
        }
        CriteriaListOptions o = this.criteriaList.getQueryBuilder().getCriteriaListOptions();
        int conditionColumnCount = o.getInitialOrColumnsCount() + 1;
        boolean showConditionTypeColumn = false;
        for (int i = 0; i < this.criteriaList.getCount(); ++i) {
            if (this.criteriaList.get(i).getConditionCount() >= conditionColumnCount) {
                conditionColumnCount = this.criteriaList.get(i).getConditionCount() + 1;
            }
            if (!this.criteriaList.get(i).isGrouping()) continue;
            showConditionTypeColumn = o.getConditionTypeColumnWidth() > 0;
        }
        int oldColumnCount = this.customColumnModel.getColumnCount(false);
        if (oldColumnCount < conditionColumnCount + 9) {
            for (int i = oldColumnCount; i < conditionColumnCount + 9; ++i) {
                this.addConditionColumn();
            }
        }
        if (!o.isUseMSStyleGrouping()) {
            this.customColumnModel.setColumnVisible(this.aggregateColumn, o.getAggregateColumnWidth() > 0);
            this.customColumnModel.setColumnVisible(this.groupingColumn, o.getGroupingColumnWidth() > 0);
            this.customColumnModel.setColumnVisible(this.groupingTypeColumn, false);
            this.customColumnModel.setColumnVisible(this.conditionTypeColumn, showConditionTypeColumn);
        } else {
            this.customColumnModel.setColumnVisible(this.aggregateColumn, false);
            this.customColumnModel.setColumnVisible(this.groupingColumn, false);
            this.customColumnModel.setColumnVisible(this.groupingTypeColumn, o.getGroupingTypeColumnWidth() > 0);
            this.customColumnModel.setColumnVisible(this.conditionTypeColumn, false);
        }
        this.tableModel.update();
        if (this.rowHeaderTable != null) {
            ((AbstractTableModel)this.rowHeaderTable.getModel()).fireTableDataChanged();
        }
    }

    public void updateHeaders() {
        this.outputColumn.setHeaderValue(Helpers.localizer.getString("strCriteriaOutput", "Output"));
        this.expressionColumn.setHeaderValue(Helpers.localizer.getString("strCriteriaExpression", "Expression"));
        this.aggregateColumn.setHeaderValue(Helpers.localizer.getString("strCriteriaAggregate", "Aggregate"));
        this.aliasColumn.setHeaderValue(Helpers.localizer.getString("strCriteriaAlias", "Alias"));
        this.sortTypeColumn.setHeaderValue(Helpers.localizer.getString("strCriteriaSortType", "Sort Type"));
        this.sortOrderColumn.setHeaderValue(Helpers.localizer.getString("strCriteriaSortOrder", "Sort Order"));
        this.groupingColumn.setHeaderValue(Helpers.localizer.getString("strCriteriaGrouping", "Grouping"));
        this.groupingTypeColumn.setHeaderValue(Helpers.localizer.getString("strCriteriaGroupBy", "Group By"));
        this.conditionTypeColumn.setHeaderValue(Helpers.localizer.getString("strCriteriaCriteriaType", "Criteria for"));
        this.conditionColumn.setHeaderValue(Helpers.localizer.getString("strCriteriaCriteria", "Criteria"));
        String s = Helpers.localizer.getString("strCriteriaOr", "Or...");
        for (int i = 10; i < this.customColumnModel.getColumnCount(false); ++i) {
            this.customColumnModel.getColumn(i, false).setHeaderValue(s);
        }
    }

    public void addConditionColumn() {
        CriteriaListOptions o = this.criteriaList.getQueryBuilder().getCriteriaListOptions();
        TableColumn newColumn = new TableColumn(this.customColumnModel.getColumnCount(false));
        newColumn.setPreferredWidth(o.getConditionColumnWidth());
        newColumn.setCellEditor(this.textCellEditor);
        this.customColumnModel.setColumnVisible(newColumn, o.getConditionColumnWidth() > 0);
        this.addColumn(newColumn);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("insert sub-query")) {
            try {
                JTextComponent editorComponent;
                Object editor = ((JMenuItem)e.getSource()).getClientProperty("editor");
                int column = this.customColumnModel.getColumn(this.getSelectedColumn(), true).getModelIndex();
                String s = "";
                String sq = "";
                int spos = 0;
                int slen = 0;
                if (editor instanceof JComboBox) {
                    editorComponent = (JTextComponent)this.comboBox.getEditor().getEditorComponent();
                    s = editorComponent.getText();
                    spos = editorComponent.getSelectionStart();
                    slen = editorComponent.getSelectionEnd() - editorComponent.getSelectionStart();
                } else if (editor instanceof JTextField) {
                    s = this.textField.getText();
                    spos = this.textField.getSelectionStart();
                    slen = this.textField.getSelectionEnd() - this.textField.getSelectionStart();
                }
                sq = s.length() > 0 && spos > 0 && spos <= s.length() && s.charAt(spos - 1) == '(' && spos + slen < s.length() && s.charAt(spos + slen) == ')' ? "Select From" : (column >= 9 ? "In (Select From)" : "(Select From)");
                if (editor instanceof JComboBox) {
                    editorComponent = (JTextComponent)this.comboBox.getEditor().getEditorComponent();
                    editorComponent.replaceSelection(sq);
                    editorComponent.setSelectionStart(spos);
                    editorComponent.setSelectionEnd(spos + sq.length());
                } else if (editor instanceof JTextField) {
                    this.textField.replaceSelection(sq);
                    this.textField.setSelectionStart(spos);
                    this.textField.setSelectionEnd(spos + sq.length());
                }
                this.getCellEditor().stopCellEditing();
            }
            catch (Exception ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void setEditorMenu(JComponent editor, int column) {
        JPopupMenu menu = new JPopupMenu();
        if (column == 1 || column >= 9) {
            JMenuItem item = new JMenuItem(Helpers.localizer.getString("strInsertSubQuery", "Insert sub-query"));
            item.setActionCommand("insert sub-query");
            item.addActionListener(this);
            item.putClientProperty("editor", editor);
            menu.add(item);
            editor.setComponentPopupMenu(menu);
        } else {
            editor.setComponentPopupMenu(null);
        }
    }

    final void updateDropTarget() {
        DropTarget customDropTarget = this.criteriaList.getQueryBuilder().getCustomCriteriaListDropTarget();
        if (this.dropTarget != customDropTarget) {
            if (customDropTarget != null) {
                this.setDropTarget(customDropTarget);
            } else {
                this.setDropTarget(this.dropTarget);
            }
        }
    }

    public void commitChanges() {
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
    }

    public void buildGUI() {
        int COLLAPSEDWIDTH = 16;
        int EXPANDEDWIDTH = 65;
        final CriteriaListOptions options = this.criteriaList.getQueryBuilder().getCriteriaListOptions();
        final JScrollPane scrollPane = new JScrollPane(this);
        if (options.isRowControllerVisible()) {
            final ControllerCellRenderer controllerCellRenderer = new ControllerCellRenderer(this.criteriaList);
            final RowControllerToggleButton switchingButton = new RowControllerToggleButton();
            AbstractTableModel model = new AbstractTableModel(){

                @Override
                public int getRowCount() {
                    return CriteriaListControl.this.criteriaList.getCount();
                }

                @Override
                public int getColumnCount() {
                    return 1;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    return null;
                }
            };
            int width = options.isRowControllerExpanded() ? 65 : 16;
            this.rowHeaderTable = new JTable();
            this.rowHeaderTable.setAutoCreateColumnsFromModel(false);
            this.rowHeaderTable.getTableHeader().setReorderingAllowed(false);
            this.rowHeaderTable.setRowHeight(this.getRowHeight());
            this.rowHeaderTable.setModel(model);
            this.rowHeaderTable.setIntercellSpacing(new Dimension(0, 0));
            ToolTipManager.sharedInstance().unregisterComponent(this.rowHeaderTable);
            ToolTipManager.sharedInstance().unregisterComponent(this.rowHeaderTable.getTableHeader());
            controllerCellRenderer.setCollapsed(!options.isRowControllerExpanded());
            final TableColumn column = new TableColumn(0);
            column.setWidth(width);
            column.setCellRenderer(controllerCellRenderer);
            this.rowHeaderTable.addColumn(column);
            this.rowHeaderTable.setPreferredScrollableViewportSize(new Dimension(width, this.rowHeaderTable.getPreferredScrollableViewportSize().height));
            scrollPane.setRowHeaderView(this.rowHeaderTable);
            this.rowHeaderTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1 && e.getClickCount() == 1 && !switchingButton.isCollapsed()) {
                        Point mousePoint = e.getPoint();
                        int clickedRow = CriteriaListControl.this.rowHeaderTable.rowAtPoint(mousePoint);
                        CriteriaItem criteriaItem = CriteriaListControl.this.criteriaList.get(clickedRow);
                        RowControler rowControler = (RowControler)CriteriaListControl.this.rowHeaderTable.getCellRenderer(clickedRow, 0).getTableCellRendererComponent(CriteriaListControl.this.rowHeaderTable, null, false, false, clickedRow, 0);
                        Rectangle cellRect = CriteriaListControl.this.rowHeaderTable.getCellRect(clickedRow, 0, false);
                        mousePoint.y -= cellRect.y;
                        Rectangle buttonUpRect = new Rectangle(rowControler.buttonUp.getLocation(), rowControler.buttonUp.getSize());
                        Rectangle buttonDownRect = new Rectangle(rowControler.buttonDown.getLocation(), rowControler.buttonDown.getSize());
                        Rectangle buttonPlusRect = new Rectangle(rowControler.buttonPlus.getLocation(), rowControler.buttonPlus.getSize());
                        Rectangle buttonMinusRect = new Rectangle(rowControler.buttonMinus.getLocation(), rowControler.buttonMinus.getSize());
                        if (buttonUpRect.contains(mousePoint)) {
                            if (clickedRow > 0) {
                                CriteriaListControl.this.criteriaList.moveRow(clickedRow, clickedRow - 1);
                            }
                        } else if (buttonDownRect.contains(mousePoint)) {
                            if (clickedRow < CriteriaListControl.this.criteriaList.getCount() - 2) {
                                CriteriaListControl.this.criteriaList.moveRow(clickedRow, clickedRow + 1);
                            }
                        } else if (buttonPlusRect.contains(mousePoint)) {
                            if (clickedRow < CriteriaListControl.this.criteriaList.getCount() - 1) {
                                CriteriaListControl.this.criteriaList.insertEmptyRow(clickedRow);
                            }
                        } else if (buttonMinusRect.contains(mousePoint) && clickedRow < CriteriaListControl.this.criteriaList.getCount() - 1) {
                            criteriaItem.dispose();
                        }
                    }
                    super.mouseClicked(e);
                }
            });
            JPanel switchingButtonPanel = new JPanel(new BorderLayout(0, 0));
            switchingButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 1));
            switchingButtonPanel.add((Component)switchingButton, "Center");
            switchingButton.setCollapsed(!options.isRowControllerExpanded());
            switchingButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean collapsed = switchingButton.isCollapsed();
                    switchingButton.setCollapsed(!collapsed);
                    controllerCellRenderer.setCollapsed(!collapsed);
                    options.rowControllerExpanded = collapsed;
                    int newWidth = !collapsed ? 16 : 65;
                    scrollPane.getRowHeader().setSize(newWidth, scrollPane.getSize().height);
                    switchingButton.setSize(newWidth, switchingButton.getSize().height);
                    CriteriaListControl.this.rowHeaderTable.setPreferredScrollableViewportSize(new Dimension(newWidth, ((CriteriaListControl)CriteriaListControl.this).rowHeaderTable.getPreferredScrollableViewportSize().height));
                    column.setWidth(newWidth);
                    scrollPane.doLayout();
                }
            });
            scrollPane.setCorner("UPPER_LEFT_CORNER", switchingButtonPanel);
        }
        scrollPane.setPreferredSize(new Dimension(100, options.getCriteriaListHeight()));
        if (this.criteriaList.getQueryBuilder().getCriteriaListOptions().isCriteriaListVisible()) {
            this.criteriaList.getUnionSubQuery().getUnionPage().setBottomComponent(scrollPane);
        }
    }

    private final class RowControllerToggleButton
    extends JButton {
        private Icon leftIcon;
        private Icon rightIcon;
        boolean collapsed;

        public RowControllerToggleButton() {
            this.setFocusable(false);
            this.setFocusPainted(false);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.leftIcon = Helpers.createImageIcon("images/left.png");
            this.rightIcon = Helpers.createImageIcon("images/right.png");
            this.setCollapsed(this.collapsed);
        }

        public boolean isCollapsed() {
            return this.collapsed;
        }

        public void setCollapsed(boolean collapsed) {
            this.collapsed = collapsed;
            if (collapsed) {
                this.setIcon(this.rightIcon);
                this.setHorizontalAlignment(0);
            } else {
                this.setIcon(this.leftIcon);
                this.setHorizontalAlignment(4);
            }
        }
    }

    private final class ControllerCellRenderer
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;
        private RowControler rowControler;
        private CriteriaList criteriaList;
        boolean collapsed;

        public ControllerCellRenderer(CriteriaList criteriaList) {
            this.criteriaList = criteriaList;
            this.rowControler = new RowControler();
            this.setCollapsed(this.collapsed);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            CriteriaItem criteriaItem = this.criteriaList.get(row);
            this.rowControler.buttonUp.setEnabled(row > 0);
            this.rowControler.buttonDown.setEnabled(row < this.criteriaList.getCount() - 2);
            this.rowControler.buttonPlus.setEnabled(row < this.criteriaList.getCount() - 1);
            this.rowControler.buttonMinus.setEnabled(row < this.criteriaList.getCount() - 1);
            return this.rowControler;
        }

        public boolean isCollapsed() {
            return this.collapsed;
        }

        public void setCollapsed(boolean collapsed) {
            this.collapsed = collapsed;
            this.rowControler.buttonUp.setVisible(!collapsed);
            this.rowControler.buttonDown.setVisible(!collapsed);
            this.rowControler.buttonPlus.setVisible(!collapsed);
            this.rowControler.buttonMinus.setVisible(!collapsed);
        }
    }

    private class RowControler
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JPanel flowPanel;
        public JButton buttonUp;
        public JButton buttonDown;
        public JButton buttonPlus;
        public JButton buttonMinus;

        public RowControler() {
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setLayout(new GridBagLayout());
            this.flowPanel = new JPanel(new FlowLayout(1, 0, 0));
            this.flowPanel.setOpaque(false);
            this.buttonUp = new JButton();
            this.buttonDown = new JButton();
            this.buttonPlus = new JButton();
            this.buttonMinus = new JButton();
            this.buttonUp.setIcon(Helpers.createImageIcon("images/up.png"));
            this.buttonUp.setDisabledIcon(Helpers.createImageIcon("images/up_disabled.png"));
            this.buttonUp.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.buttonUp.setFocusable(false);
            this.buttonUp.setHorizontalTextPosition(0);
            this.buttonUp.setPreferredSize(new Dimension(15, 15));
            this.buttonUp.setVerticalTextPosition(3);
            this.flowPanel.add(this.buttonUp);
            this.buttonDown.setIcon(Helpers.createImageIcon("images/down.png"));
            this.buttonDown.setDisabledIcon(Helpers.createImageIcon("images/down_disabled.png"));
            this.buttonDown.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.buttonDown.setFocusable(false);
            this.buttonDown.setHorizontalTextPosition(0);
            this.buttonDown.setPreferredSize(new Dimension(15, 15));
            this.buttonDown.setVerticalTextPosition(3);
            this.flowPanel.add(this.buttonDown);
            this.buttonPlus.setIcon(Helpers.createImageIcon("images/plus2.png"));
            this.buttonPlus.setDisabledIcon(Helpers.createImageIcon("images/plus2_disabled.png"));
            this.buttonPlus.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.buttonPlus.setFocusable(false);
            this.buttonPlus.setHorizontalTextPosition(0);
            this.buttonPlus.setPreferredSize(new Dimension(15, 15));
            this.buttonPlus.setVerticalTextPosition(3);
            this.flowPanel.add(this.buttonPlus);
            this.buttonMinus.setIcon(Helpers.createImageIcon("images/minus2.png"));
            this.buttonMinus.setDisabledIcon(Helpers.createImageIcon("images/minus2_disabled.png"));
            this.buttonMinus.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.buttonMinus.setFocusable(false);
            this.buttonMinus.setHorizontalTextPosition(0);
            this.buttonMinus.setPreferredSize(new Dimension(15, 15));
            this.buttonMinus.setVerticalTextPosition(3);
            this.flowPanel.add(this.buttonMinus);
            this.add(this.flowPanel);
        }
    }

    private class CustomTableHeaderRenderer
    implements TableCellRenderer {
        private final JCheckBox checkBox = new JCheckBox();
        private final TableCellRenderer defaultRenderer;

        public CustomTableHeaderRenderer(TableCellRenderer defaultRenderer) {
            this.checkBox.setOpaque(false);
            this.defaultRenderer = defaultRenderer;
            final JTableHeader header = CriteriaListControl.this.getTableHeader();
            header.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Point mousePoint = e.getPoint();
                    int column = CriteriaListControl.this.customColumnModel.getColumn(CriteriaListControl.this.columnAtPoint(mousePoint), true).getModelIndex();
                    if (column == 6) {
                        Rectangle checkboxRectangle = header.getHeaderRect(column);
                        checkboxRectangle.width = checkboxRectangle.height;
                        if (checkboxRectangle.contains(mousePoint)) {
                            if (CriteriaListControl.this.criteriaList.isQueryWithGrouping()) {
                                for (int i = 0; i < CriteriaListControl.this.criteriaList.getCount(); ++i) {
                                    CriteriaItem criteriaItem = CriteriaListControl.this.criteriaList.get(i);
                                    criteriaItem.setGrouping(false);
                                    if (criteriaItem.isAggregatedExpression()) continue;
                                    criteriaItem.setConditionType(ConditionType.Where);
                                }
                            } else {
                                for (int i = 0; i < CriteriaListControl.this.criteriaList.getCount(); ++i) {
                                    CriteriaItem ci = CriteriaListControl.this.criteriaList.get(i);
                                    if (!ci.isCanGrouping() || !ci.isSelected() && ci.getSortType() == ItemSortType.None || ci.isAggregatedExpression()) continue;
                                    ci.setGrouping(true);
                                }
                            }
                            header.repaint();
                        }
                    }
                }
            });
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
            try {
                Component component = this.defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, rowIndex, vColIndex);
                int column = CriteriaListControl.this.customColumnModel.getColumn(vColIndex, true).getModelIndex();
                JLabel label = (JLabel)component;
                if (column == 6) {
                    label.setIcon(new CheckBoxIcon(this.checkBox));
                    this.checkBox.setSelected(CriteriaListControl.this.criteriaList.isQueryWithGrouping());
                    if (label.getPreferredSize().height > 1000) {
                        throw new Exception();
                    }
                } else {
                    label.setIcon(null);
                }
                component.invalidate();
                component.repaint();
                return component;
            }
            catch (Exception ex) {
                JTableHeader header = CriteriaListControl.this.getTableHeader();
                this.checkBox.setForeground(header.getForeground());
                this.checkBox.setBackground(header.getBackground());
                this.checkBox.setFont(header.getFont());
                this.checkBox.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                this.checkBox.setText(value.toString());
                return this.checkBox;
            }
        }
    }

    private class CheckBoxIcon
    implements Icon {
        private final JCheckBox checkBox;

        public CheckBoxIcon(JCheckBox checkBox) {
            this.checkBox = checkBox;
        }

        @Override
        public int getIconWidth() {
            return this.checkBox.getPreferredSize().width;
        }

        @Override
        public int getIconHeight() {
            return this.checkBox.getPreferredSize().height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            SwingUtilities.paintComponent(g, this.checkBox, (Container)c, x, y, this.getIconWidth(), this.getIconHeight());
        }
    }

    private class CustomBooleanCellRenderer
    extends JPanel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;
        private Color background;
        private Color selectionBackground;
        private JCheckBox checkBox;

        public CustomBooleanCellRenderer() {
            this.background = CriteriaListControl.this.getBackground();
            this.selectionBackground = CriteriaListControl.this.getSelectionBackground();
            this.setLayout(new BorderLayout());
            this.checkBox = new JCheckBox();
            this.checkBox.setHorizontalAlignment(0);
            this.add((Component)this.checkBox, "Center");
        }

        public JCheckBox getCheckBox() {
            return this.checkBox;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected || hasFocus) {
                this.setBackground(this.selectionBackground);
                this.checkBox.setBackground(this.selectionBackground);
            } else {
                this.setBackground(this.background);
                this.checkBox.setBackground(this.background);
            }
            this.checkBox.setSelected((Boolean)(null == value ? Boolean.FALSE : value));
            return this;
        }
    }

    private class CustomStringCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private CustomStringCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (isSelected || hasFocus) {
                this.setBackground(CriteriaListControl.this.getSelectionBackground());
                this.setForeground(CriteriaListControl.this.getSelectionForeground());
            } else {
                this.setBackground(CriteriaListControl.this.getBackground());
                this.setForeground(CriteriaListControl.this.getForeground());
            }
            return this;
        }
    }

    private class CustomTextFieldCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;

        public CustomTextFieldCellEditor(JTextField textField) {
            super(textField);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, final int row, final int column) {
            CriteriaListOptions o = CriteriaListControl.this.criteriaList.getQueryBuilder().getCriteriaListOptions();
            final int realColumn = CriteriaListControl.this.customColumnModel.getColumn(column, true).getModelIndex();
            CriteriaListControl.this.textField = new JTextField();
            CriteriaListControl.this.textField.setBorder(BorderFactory.createLineBorder(CriteriaListControl.this.getBackground(), 1));
            CriteriaListControl.this.textField.setText((String)value);
            CriteriaListControl.this.textField.selectAll();
            if (realColumn == 3 && o.getDisableDirectEditingIn().contains((Object)CustomExpressionBuilderColumns.Alias) || realColumn >= 9 && o.getDisableDirectEditingIn().contains((Object)CustomExpressionBuilderColumns.Conditions)) {
                CriteriaListControl.this.textField.setEditable(false);
            } else {
                CriteriaListControl.this.textField.setEditable(true);
                CriteriaListControl.this.setEditorMenu(CriteriaListControl.this.textField, realColumn);
                CriteriaListControl.this.textField.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 10) {
                            CustomTextFieldCellEditor.this.stopCellEditing();
                            CriteriaListControl.this.requestFocus();
                            CriteriaListControl.this.setRowSelectionInterval(row, row);
                            CriteriaListControl.this.setColumnSelectionInterval(column, column);
                            return;
                        }
                        super.keyPressed(e);
                    }
                });
            }
            if (realColumn == 3 && o.getUseCustomExpressionBuilderFor().contains((Object)CustomExpressionBuilderColumns.Alias) || realColumn >= 9 && o.getUseCustomExpressionBuilderFor().contains((Object)CustomExpressionBuilderColumns.Conditions)) {
                CriteriaListControl.this.button = new JButton(CriteriaListControl.this.icon);
                CriteriaListControl.this.button.setSize(19, 19);
                CriteriaListControl.this.button.setFocusable(false);
                CriteriaListControl.this.button.setFocusPainted(false);
                CriteriaListControl.this.button.setMargin(new Insets(0, 0, 0, 0));
                CriteriaListControl.this.button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        final String strValue = (String)CustomTextFieldCellEditor.this.getCellEditorValue();
                        CriteriaItem ci = CriteriaListControl.this.getCriteriaItemForRow(row);
                        if (ci == null) {
                            return;
                        }
                        AstNode re = realColumn == 1 ? ci.astExpression : (realColumn >= 9 ? (realColumn - 9 < ci.getConditionCount() ? ci.getASTCondition(realColumn - 9) : null) : null);
                        ArrayList l = new ArrayList();
                        if (re != null) {
                            ci.collectSubqueryProxiesByRootNode(l, re);
                        }
                        if (l.isEmpty()) {
                            CustomTextFieldCellEditor.this.stopCellEditing();
                            CustomExpressionBuilderEvent evt = new CustomExpressionBuilderEvent(CriteriaListControl.this.criteriaList.getQueryBuilder(), strValue, row, realColumn);
                            CriteriaListControl.this.criteriaList.getQueryBuilder().fireCustomExpressionBuilderEvent(evt);
                            if (!strValue.equals(evt.value)) {
                                CriteriaListControl.this.setValueAt(evt.value, row, column);
                                CriteriaListControl.this.requestFocus();
                                CriteriaListControl.this.setRowSelectionInterval(row, row);
                                CriteriaListControl.this.setColumnSelectionInterval(column, column);
                            }
                        } else {
                            JPopupMenu menu = new JPopupMenu();
                            JMenuItem item = new JMenuItem(Helpers.localizer.getString("strExpressionBuilder", Constants.strExpressionBuilder));
                            item.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    CustomTextFieldCellEditor.this.stopCellEditing();
                                    CustomExpressionBuilderEvent evt = new CustomExpressionBuilderEvent(CriteriaListControl.this.criteriaList.getQueryBuilder(), strValue, row, realColumn);
                                    CriteriaListControl.this.criteriaList.getQueryBuilder().fireCustomExpressionBuilderEvent(evt);
                                    if (!strValue.equals(evt.value)) {
                                        CriteriaListControl.this.setValueAt(evt.value, row, column);
                                        CriteriaListControl.this.requestFocus();
                                        CriteriaListControl.this.setRowSelectionInterval(row, row);
                                        CriteriaListControl.this.setColumnSelectionInterval(column, column);
                                    }
                                }
                            });
                            menu.add(item);
                            menu.addSeparator();
                            ci.fillQueriesMenuItems(menu, l);
                            Rectangle buttonBounds = CriteriaListControl.this.button.getBounds();
                            Point p = new Point(buttonBounds.x, buttonBounds.y + buttonBounds.height);
                            p = SwingUtilities.convertPoint(CriteriaListControl.this.button.getParent(), p, CriteriaListControl.this);
                            CriteriaListControl.this.criteriaList.getQueryBuilder().popupMenuPopup(menu, CriteriaListControl.this, CriteriaListControl.this.criteriaList.get(row), p);
                        }
                    }
                });
                JPanel panel = new JPanel(new BorderLayout()){

                    @Override
                    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                        InputMap inputMap = CriteriaListControl.this.textField.getInputMap(condition);
                        ActionMap actionMap = CriteriaListControl.this.textField.getActionMap();
                        if (inputMap != null && actionMap != null && this.isEnabled()) {
                            Action action;
                            Object binding = inputMap.get(ks);
                            Action action2 = action = binding == null ? null : actionMap.get(binding);
                            if (action != null) {
                                return SwingUtilities.notifyAction(action, ks, e, CriteriaListControl.this.textField, e.getModifiers());
                            }
                        }
                        if (!CriteriaListControl.this.textField.isFocusOwner()) {
                            CriteriaListControl.this.textField.requestFocus(true);
                        }
                        return false;
                    }
                };
                panel.setRequestFocusEnabled(true);
                panel.add(CriteriaListControl.this.textField);
                panel.add((Component)CriteriaListControl.this.button, "East");
                return panel;
            }
            return CriteriaListControl.this.textField;
        }

        @Override
        public Object getCellEditorValue() {
            return CriteriaListControl.this.textField.getText();
        }
    }

    private class CustomComboBoxCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;

        public CustomComboBoxCellEditor(JComboBox comboBox) {
            super(comboBox);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, final int row, final int column) {
            int i;
            CriteriaItem ci = CriteriaListControl.this.criteriaList.get(row);
            QueryBuilder qb = CriteriaListControl.this.criteriaList.getQueryBuilder();
            CriteriaListOptions o = qb.getCriteriaListOptions();
            ArrayList<Object> items = new ArrayList<Object>();
            final int realColumn = CriteriaListControl.this.customColumnModel.getColumn(column, true).getModelIndex();
            if (realColumn == 1) {
                if (qb.getSyntaxProvider() != null && qb.getSyntaxProvider().isSupportAllTableFieldsSelection() && !qb.getFieldListOptions().isHideAsteriskItem()) {
                    items.add(new CustomComboBoxItem("*"));
                }
                ArrayList l = new ArrayList();
                ci.criteriaList.getUnionSubQuery().getFromClause().getDatasources(l);
                for (i = 0; i < l.size(); ++i) {
                    DataSource d = (DataSource)l.get(i);
                    String s = d.getNameInQuery();
                    if (Str.IsNullOrEmpty(s)) continue;
                    if (qb.getSyntaxProvider() != null && qb.getSyntaxProvider().isSupportAllTableFieldsSelection() && !qb.getFieldListOptions().isHideAsteriskItem()) {
                        items.add(new CustomComboBoxItem(s, "*"));
                    }
                    for (int j = 0; j < d.astFromSource.getFieldList().getCount(); ++j) {
                        String fn = null;
                        MetadataField f = d.getFields().get(j);
                        if (qb.isUseAltNames() && !Str.IsNullOrEmpty(f.getAltName())) {
                            fn = f.getAltNameId().getSimpleSQL(((CriteriaListControl)CriteriaListControl.this).criteriaList.sqlContext.getSQLBuilderExpression());
                        }
                        if (Str.IsNullOrEmpty(fn)) {
                            fn = f.getName().getQualifiedName();
                        }
                        items.add(new CustomComboBoxItem(s, fn));
                    }
                }
            } else if (realColumn == 2) {
                ArrayList<String> l = new ArrayList<String>();
                ci.getAggregateStringList(l);
                for (String s : l) {
                    items.add(s);
                }
            } else if (realColumn == 4) {
                items.addAll(Arrays.asList(Helpers.sortTypeNames));
                if (((CriteriaListControl)CriteriaListControl.this).criteriaList.sqlContext.getSyntaxProvider() != null && ((CriteriaListControl)CriteriaListControl.this).criteriaList.sqlContext.getSyntaxProvider().isSupportNullOrdering() && ((CriteriaListControl)CriteriaListControl.this).criteriaList.queryBuilder.getCriteriaListOptions().getShowNullOrderingInSortTypeColumn()) {
                    items.add(Helpers.localizer.getString("strSortTypeAscending", "Ascending") + " Nulls First");
                    items.add(Helpers.localizer.getString("strSortTypeAscending", "Ascending") + " Nulls Last");
                    items.add(Helpers.localizer.getString("strSortTypeDescending", "Descending") + " Nulls First");
                    items.add(Helpers.localizer.getString("strSortTypeDescending", "Descending") + " Nulls Last");
                }
            } else if (realColumn == 5) {
                for (int i2 = 1; i2 <= CriteriaListControl.this.criteriaList.getOrderByItemsCount(); ++i2) {
                    items.add(String.valueOf(i2));
                }
                if (ci.getSortType() == ItemSortType.None) {
                    items.add(String.valueOf(CriteriaListControl.this.criteriaList.getOrderByItemsCount() + 1));
                }
            } else if (realColumn == 7) {
                ArrayList<String> l = new ArrayList<String>();
                ci.getGroupingTypeStringList(l);
                for (String s : l) {
                    items.add(s);
                }
            } else if (realColumn == 8) {
                items.add(Helpers.conditionTypes[ConditionType.Where.ordinal()]);
                items.add(Helpers.conditionTypes[ConditionType.Having.ordinal()]);
            }
            int selectedIndex = -1;
            for (i = 0; i < items.size(); ++i) {
                if (!items.get(i).toString().equals(value.toString())) continue;
                selectedIndex = i;
                break;
            }
            CriteriaListControl.this.comboBox = new JComboBox<Object>(items.toArray());
            if (realColumn == 1 && o.getDisableDirectEditingIn().contains((Object)CustomExpressionBuilderColumns.Expression) || realColumn == 2 && o.getDisableDirectEditingIn().contains((Object)CustomExpressionBuilderColumns.Aggreagate) || realColumn == 4 && o.getDisableDirectEditingIn().contains((Object)CustomExpressionBuilderColumns.SortType) || realColumn == 5 && o.getDisableDirectEditingIn().contains((Object)CustomExpressionBuilderColumns.SortOrder)) {
                CriteriaListControl.this.comboBox.setEditable(false);
                CriteriaListControl.this.comboBox.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 10) {
                            CustomComboBoxCellEditor.this.stopCellEditing();
                            CriteriaListControl.this.requestFocus();
                            CriteriaListControl.this.setRowSelectionInterval(row, row);
                            CriteriaListControl.this.setColumnSelectionInterval(column, column);
                            return;
                        }
                        super.keyPressed(e);
                    }
                });
            } else {
                CriteriaListControl.this.comboBox.setEditable(true);
                CriteriaListControl.this.setEditorMenu(CriteriaListControl.this.comboBox, realColumn);
                CriteriaListControl.this.comboBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 10) {
                            CustomComboBoxCellEditor.this.stopCellEditing();
                            CriteriaListControl.this.requestFocus();
                            CriteriaListControl.this.setRowSelectionInterval(row, row);
                            CriteriaListControl.this.setColumnSelectionInterval(column, column);
                            return;
                        }
                        super.keyPressed(e);
                    }
                });
            }
            CriteriaListControl.this.comboBox.setBorder(BorderFactory.createEmptyBorder());
            CriteriaListControl.this.comboBox.setSelectedIndex(selectedIndex);
            if (CriteriaListControl.this.comboBox.isEditable()) {
                CriteriaListControl.this.comboBox.getEditor().selectAll();
            }
            CriteriaListControl.this.comboBox.getEditor().setItem(value);
            Font f = CriteriaListControl.this.criteriaList.getQueryBuilder().getCriteriaListOptions().getCriteriaListFont();
            if (f != null) {
                CriteriaListControl.this.comboBox.setFont(f);
            }
            if (realColumn == 1 && o.getUseCustomExpressionBuilderFor().contains((Object)CustomExpressionBuilderColumns.Expression) || realColumn == 2 && o.getUseCustomExpressionBuilderFor().contains((Object)CustomExpressionBuilderColumns.Aggreagate) || realColumn == 4 && o.getUseCustomExpressionBuilderFor().contains((Object)CustomExpressionBuilderColumns.SortType) || realColumn == 5 && o.getUseCustomExpressionBuilderFor().contains((Object)CustomExpressionBuilderColumns.SortOrder)) {
                CriteriaListControl.this.button = new JButton(CriteriaListControl.this.icon);
                CriteriaListControl.this.button.setSize(19, 19);
                CriteriaListControl.this.button.setFocusable(false);
                CriteriaListControl.this.button.setFocusPainted(false);
                CriteriaListControl.this.button.setMargin(new Insets(0, 0, 0, 0));
                CriteriaListControl.this.button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        final String strValue = CustomComboBoxCellEditor.this.getCellEditorValue() instanceof CustomComboBoxItem ? ((CustomComboBoxItem)CustomComboBoxCellEditor.this.getCellEditorValue()).toString() : (String)CustomComboBoxCellEditor.this.getCellEditorValue();
                        CriteriaItem ci = CriteriaListControl.this.getCriteriaItemForRow(row);
                        if (ci == null) {
                            return;
                        }
                        AstNode re = realColumn == 1 ? ci.astExpression : (realColumn >= 9 ? (realColumn - 9 < ci.getConditionCount() ? ci.getASTCondition(realColumn - 9) : null) : null);
                        ArrayList l = new ArrayList();
                        if (re != null) {
                            ci.collectSubqueryProxiesByRootNode(l, re);
                        }
                        if (l.isEmpty()) {
                            CustomComboBoxCellEditor.this.stopCellEditing();
                            CustomExpressionBuilderEvent evt = new CustomExpressionBuilderEvent(CriteriaListControl.this.criteriaList.getQueryBuilder(), strValue, row, realColumn);
                            CriteriaListControl.this.criteriaList.getQueryBuilder().fireCustomExpressionBuilderEvent(evt);
                            if (!strValue.equals(evt.value)) {
                                CriteriaListControl.this.setValueAt(evt.value, row, column);
                                CriteriaListControl.this.requestFocus();
                                CriteriaListControl.this.setRowSelectionInterval(row, row);
                                CriteriaListControl.this.setColumnSelectionInterval(column, column);
                            }
                        } else {
                            JPopupMenu menu = new JPopupMenu();
                            JMenuItem item = new JMenuItem(Helpers.localizer.getString("strExpressionBuilder", Constants.strExpressionBuilder));
                            item.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    CustomComboBoxCellEditor.this.stopCellEditing();
                                    CustomExpressionBuilderEvent evt = new CustomExpressionBuilderEvent(CriteriaListControl.this.criteriaList.getQueryBuilder(), strValue, row, realColumn);
                                    CriteriaListControl.this.criteriaList.getQueryBuilder().fireCustomExpressionBuilderEvent(evt);
                                    if (!strValue.equals(evt.value)) {
                                        CriteriaListControl.this.setValueAt(evt.value, row, column);
                                        CriteriaListControl.this.requestFocus();
                                        CriteriaListControl.this.setRowSelectionInterval(row, row);
                                        CriteriaListControl.this.setColumnSelectionInterval(column, column);
                                    }
                                }
                            });
                            menu.add(item);
                            menu.addSeparator();
                            ci.fillQueriesMenuItems(menu, l);
                            Rectangle buttonBounds = CriteriaListControl.this.button.getBounds();
                            Point p = new Point(buttonBounds.x, buttonBounds.y + buttonBounds.height);
                            p = SwingUtilities.convertPoint(CriteriaListControl.this.button.getParent(), p, CriteriaListControl.this);
                            CriteriaListControl.this.criteriaList.getQueryBuilder().popupMenuPopup(menu, CriteriaListControl.this, CriteriaListControl.this.criteriaList.get(row), p);
                        }
                    }
                });
                JPanel panel = new JPanel(new BorderLayout()){

                    @Override
                    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                        InputMap inputMap = CriteriaListControl.this.comboBox.getInputMap(condition);
                        ActionMap actionMap = CriteriaListControl.this.comboBox.getActionMap();
                        if (inputMap != null && actionMap != null && this.isEnabled()) {
                            Action action;
                            Object binding = inputMap.get(ks);
                            Action action2 = action = binding == null ? null : actionMap.get(binding);
                            if (action != null) {
                                return SwingUtilities.notifyAction(action, ks, e, CriteriaListControl.this.comboBox, e.getModifiers());
                            }
                        }
                        if (!CriteriaListControl.this.comboBox.isPopupVisible() && !CriteriaListControl.this.comboBox.isFocusOwner()) {
                            CriteriaListControl.this.comboBox.requestFocus(true);
                        }
                        return false;
                    }
                };
                panel.setRequestFocusEnabled(true);
                panel.add(CriteriaListControl.this.comboBox);
                panel.add((Component)CriteriaListControl.this.button, "East");
                return panel;
            }
            return CriteriaListControl.this.comboBox;
        }

        @Override
        public Object getCellEditorValue() {
            if (CriteriaListControl.this.comboBox.isEditable()) {
                return CriteriaListControl.this.comboBox.getEditor().getItem();
            }
            return CriteriaListControl.this.comboBox.getSelectedItem();
        }
    }

    private class CustomDropTargetListener
    extends DropTargetAdapter {
        private CustomDropTargetListener() {
        }

        @Override
        public void dragOver(DropTargetDragEvent event) {
            Transferable transferable = event.getTransferable();
            if (transferable.isDataFlavorSupported(CheckListItem.CHECK_LIST_ITEM_FLAVOR)) {
                event.acceptDrag(0x40000000);
            } else {
                event.rejectDrag();
            }
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            event.acceptDrop(0x40000000);
            DataSourceFieldList sourceList = null;
            CheckListItem sourceItem = null;
            Transferable transferable = event.getTransferable();
            DataSource ds = null;
            MetadataField mf = null;
            if (transferable.isDataFlavorSupported(CheckListItem.CHECK_LIST_ITEM_FLAVOR)) {
                try {
                    sourceItem = (CheckListItem)transferable.getTransferData(CheckListItem.CHECK_LIST_ITEM_FLAVOR);
                    sourceList = sourceItem.list;
                    ds = sourceList.getDataSourceControl().getDataSource();
                    mf = sourceItem.field;
                }
                catch (Exception ex) {
                    Logger.getLogger(DataSourceFieldList.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (sourceList != null) {
                int row = CriteriaListControl.this.rowAtPoint(event.getLocation());
                int x = row == 0 && CriteriaListControl.this.criteriaList.getCount() == 0 ? 0 : (row >= 0 ? row : CriteriaListControl.this.criteriaList.getCount() - 1);
                DatasourceFieldAddingEvent evt1 = new DatasourceFieldAddingEvent(ds.getQueryBuilder(), ds.getQuery(), ds, mf);
                ds.getQueryBuilder().fireDatasourceFieldAddingEvent(evt1);
                if (evt1.abort) {
                    return;
                }
                CriteriaItem ci = CriteriaListControl.this.criteriaList.insertField(x, ds, mf != null ? mf.getName() : null);
                ci.setSelected(true);
                DatasourceFieldAddedEvent evt2 = new DatasourceFieldAddedEvent(ds.getQueryBuilder(), ds.getQuery(), ds, mf, ci);
                ds.getQueryBuilder().fireDatasourceFieldAddedEvent(evt2);
            }
        }
    }

    private class CustomComboBoxItem {
        public String table = null;
        public String field = null;

        public CustomComboBoxItem(String table) {
            this.table = table;
        }

        public CustomComboBoxItem(String table, String field) {
            this.table = table;
            this.field = field;
        }

        public String toString() {
            if (!this.table.equals("*") && !Str.IsNullOrEmpty(this.field)) {
                return this.table + "." + this.field;
            }
            return this.table;
        }
    }

    private class CustomTableColumnModel
    extends DefaultTableColumnModel {
        private static final long serialVersionUID = 1L;
        protected List<TableColumn> allTableColumns = new ArrayList<TableColumn>();

        private CustomTableColumnModel() {
        }

        public void setColumnVisible(TableColumn column, boolean visible) {
            if (!visible) {
                super.removeColumn(column);
            } else {
                int noVisibleColumns = this.tableColumns.size();
                int noInvisibleColumns = this.allTableColumns.size();
                int visibleIndex = 0;
                for (int invisibleIndex = 0; invisibleIndex < noInvisibleColumns; ++invisibleIndex) {
                    TableColumn visibleColumn = visibleIndex < noVisibleColumns ? (TableColumn)this.tableColumns.get(visibleIndex) : null;
                    TableColumn testColumn = this.allTableColumns.get(invisibleIndex);
                    if (testColumn == column) {
                        if (visibleColumn != column) {
                            super.addColumn(column);
                            super.moveColumn(this.tableColumns.size() - 1, visibleIndex);
                        }
                        return;
                    }
                    if (testColumn != visibleColumn) continue;
                    ++visibleIndex;
                }
            }
        }

        public void setAllColumnsVisible() {
            int noColumns = this.allTableColumns.size();
            for (int columnIndex = 0; columnIndex < noColumns; ++columnIndex) {
                TableColumn invisibleColumn;
                TableColumn visibleColumn = columnIndex < this.tableColumns.size() ? (TableColumn)this.tableColumns.get(columnIndex) : null;
                if (visibleColumn == (invisibleColumn = this.allTableColumns.get(columnIndex))) continue;
                super.addColumn(invisibleColumn);
                super.moveColumn(this.tableColumns.size() - 1, columnIndex);
            }
        }

        public TableColumn getColumnByModelIndex(int modelColumnIndex) {
            for (int columnIndex = 0; columnIndex < this.allTableColumns.size(); ++columnIndex) {
                TableColumn column = this.allTableColumns.get(columnIndex);
                if (column.getModelIndex() != modelColumnIndex) continue;
                return column;
            }
            return null;
        }

        public boolean isColumnVisible(TableColumn aColumn) {
            return this.tableColumns.indexOf(aColumn) >= 0;
        }

        @Override
        public void addColumn(TableColumn column) {
            this.allTableColumns.add(column);
            super.addColumn(column);
        }

        @Override
        public void removeColumn(TableColumn column) {
            int allColumnsIndex = this.allTableColumns.indexOf(column);
            if (allColumnsIndex != -1) {
                this.allTableColumns.remove(allColumnsIndex);
            }
            super.removeColumn(column);
        }

        @Override
        public void moveColumn(int oldIndex, int newIndex) {
            if (oldIndex < 0 || oldIndex >= this.getColumnCount() || newIndex < 0 || newIndex >= this.getColumnCount()) {
                throw new IllegalArgumentException("moveColumn() - Index out of range");
            }
            TableColumn fromColumn = (TableColumn)this.tableColumns.get(oldIndex);
            TableColumn toColumn = (TableColumn)this.tableColumns.get(newIndex);
            int allColumnsOldIndex = this.allTableColumns.indexOf(fromColumn);
            int allColumnsNewIndex = this.allTableColumns.indexOf(toColumn);
            if (oldIndex != newIndex) {
                this.allTableColumns.remove(allColumnsOldIndex);
                this.allTableColumns.add(allColumnsNewIndex, fromColumn);
            }
            super.moveColumn(oldIndex, newIndex);
        }

        public int getColumnCount(boolean onlyVisible) {
            List<Object> columns = onlyVisible ? this.tableColumns : this.allTableColumns;
            return columns.size();
        }

        public int getColumnIndex(Object identifier, boolean onlyVisible) {
            if (identifier == null) {
                throw new IllegalArgumentException("Identifier is null");
            }
            List<Object> columns = onlyVisible ? this.tableColumns : this.allTableColumns;
            int noColumns = columns.size();
            for (int columnIndex = 0; columnIndex < noColumns; ++columnIndex) {
                TableColumn column = (TableColumn)columns.get(columnIndex);
                if (!identifier.equals(column.getIdentifier())) continue;
                return columnIndex;
            }
            throw new IllegalArgumentException("Identifier not found");
        }

        public TableColumn getColumn(int columnIndex, boolean onlyVisible) {
            if (onlyVisible) {
                return (TableColumn)this.tableColumns.elementAt(columnIndex);
            }
            return this.allTableColumns.get(columnIndex);
        }
    }

    private class ColumnResizeListener
    implements PropertyChangeListener {
        private ColumnResizeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("width")) {
                TableColumn tableColumn = (TableColumn)e.getSource();
                CriteriaListOptions o = CriteriaListControl.this.getCriteriaList().getQueryBuilder().getCriteriaListOptions();
                if (!o.isAutoSizeColumns()) {
                    if (tableColumn == CriteriaListControl.this.outputColumn) {
                        o.outputColumnWidth = (Integer)e.getNewValue();
                    } else if (tableColumn == CriteriaListControl.this.expressionColumn) {
                        o.expressionColumnWidth = (Integer)e.getNewValue();
                    } else if (tableColumn == CriteriaListControl.this.aggregateColumn) {
                        o.aggregateColumnWidth = (Integer)e.getNewValue();
                    } else if (tableColumn == CriteriaListControl.this.aliasColumn) {
                        o.aliasColumnWidth = (Integer)e.getNewValue();
                    } else if (tableColumn == CriteriaListControl.this.sortTypeColumn) {
                        o.sortTypeColumnWidth = (Integer)e.getNewValue();
                    } else if (tableColumn == CriteriaListControl.this.sortOrderColumn) {
                        o.sortOrderColumnWidth = (Integer)e.getNewValue();
                    } else if (tableColumn == CriteriaListControl.this.groupingColumn) {
                        o.groupingColumnWidth = (Integer)e.getNewValue();
                    } else if (tableColumn == CriteriaListControl.this.groupingTypeColumn) {
                        o.groupingTypeColumnWidth = (Integer)e.getNewValue();
                    } else if (tableColumn == CriteriaListControl.this.conditionTypeColumn) {
                        o.conditionTypeColumnWidth = (Integer)e.getNewValue();
                    } else if (tableColumn == CriteriaListControl.this.conditionColumn) {
                        o.conditionColumnWidth = (Integer)e.getNewValue();
                    }
                }
            }
        }
    }

    private class CustomTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        public static final int OUTPUT = 0;
        public static final int EXPRESSION = 1;
        public static final int AGGREGATE = 2;
        public static final int ALIAS = 3;
        public static final int SORTTYPE = 4;
        public static final int SORTORDER = 5;
        public static final int GROUPING = 6;
        public static final int GROUPINGTYPE = 7;
        public static final int CONDITIONTYPE = 8;
        public static final int CONDITION = 9;
        CriteriaList criteriaList;

        public CustomTableModel(CriteriaList criteriaList) {
            this.criteriaList = criteriaList;
        }

        @Override
        public int getRowCount() {
            return this.criteriaList.getCount();
        }

        @Override
        public int getColumnCount() {
            return 0;
        }

        public void update() {
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return Helpers.localizer.getString("strCriteriaOutput", "Output");
                }
                case 1: {
                    return Helpers.localizer.getString("strCriteriaExpression", "Expression");
                }
                case 2: {
                    return Helpers.localizer.getString("strCriteriaAggregate", "Aggregate");
                }
                case 3: {
                    return Helpers.localizer.getString("strCriteriaAlias", "Alias");
                }
                case 4: {
                    return Helpers.localizer.getString("strCriteriaSortType", "Sort Type");
                }
                case 5: {
                    return Helpers.localizer.getString("strCriteriaSortOrder", "Sort Order");
                }
                case 6: {
                    return Helpers.localizer.getString("strCriteriaGrouping", "Grouping");
                }
                case 7: {
                    return Helpers.localizer.getString("strCriteriaGroupBy", "Group By");
                }
                case 8: {
                    return Helpers.localizer.getString("strCriteriaCriteriaType", "Criteria for");
                }
                case 9: {
                    return Helpers.localizer.getString("strCriteriaCriteria", "Criteria");
                }
            }
            return Helpers.localizer.getString("strCriteriaOr", "Or...");
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Boolean.class;
                }
                case 6: {
                    return Boolean.class;
                }
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (this.criteriaList.getQueryBuilder() != null && this.criteriaList.getQueryBuilder().isDisposing()) {
                return null;
            }
            CriteriaItem ci = this.criteriaList.get(row);
            if (ci != null) {
                switch (column) {
                    case 0: {
                        if (ci.isSelected()) {
                            return true;
                        }
                        return false;
                    }
                    case 1: {
                        return ci.getExpressionString();
                    }
                    case 2: {
                        return ci.getAggregateString();
                    }
                    case 3: {
                        return ci.getAliasString();
                    }
                    case 4: {
                        return ci.getSortTypeString();
                    }
                    case 5: {
                        return ci.getSortOrderString();
                    }
                    case 6: {
                        if (ci.isGrouping()) {
                            return true;
                        }
                        return false;
                    }
                    case 7: {
                        return ci.getGroupingTypeString();
                    }
                    case 8: {
                        return Helpers.conditionTypes[ci.getConditionType().ordinal()];
                    }
                }
                return ci.getConditionString(column - 9);
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            CriteriaItem ci = this.criteriaList.get(rowIndex);
            if (ci != null) {
                switch (columnIndex) {
                    case 0: {
                        return false;
                    }
                    case 1: {
                        return true;
                    }
                    case 2: {
                        return ci.astExpression != null && (ci.getAggregate() != null || !ci.isAggregatedExpression());
                    }
                    case 3: {
                        return ci.isSupportsAlias();
                    }
                    case 4: {
                        return ci.isCanSort();
                    }
                    case 5: {
                        return ci.isCanSort();
                    }
                    case 6: {
                        return false;
                    }
                    case 7: {
                        return ci.astExpression != null;
                    }
                    case 8: {
                        return ci.astExpression != null && ci.isSupportConditions();
                    }
                }
                if (columnIndex >= 9) {
                    return ci.astExpression != null && ci.isSupportConditions();
                }
                return false;
            }
            return false;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (value == null) {
                return;
            }
            Object oldValue = this.getValueAt(rowIndex, columnIndex);
            if (rowIndex < this.criteriaList.getCount()) {
                CriteriaItem ci = this.criteriaList.get(rowIndex);
                GridCellValueChangingEvent evt = new GridCellValueChangingEvent(ci.getQueryBuilder(), ci.getCriteriaList().getUnionSubQuery(), ci.getCriteriaList(), ci, columnIndex, rowIndex, oldValue, value);
                ci.getQueryBuilder().fireGridCellValueChangingEvent(evt);
                if (evt.abort) {
                    return;
                }
                switch (columnIndex) {
                    case 0: {
                        ci.setSelectedUI((Boolean)evt.newValue == true);
                        break;
                    }
                    case 1: {
                        try {
                            ci.setExpressionStringUI(String.valueOf(evt.newValue));
                        }
                        catch (QueryBuilderException ex) {
                            Logger.getLogger(CriteriaListControl.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        break;
                    }
                    case 2: {
                        ci.setAggregateStringUI(String.valueOf(evt.newValue));
                        break;
                    }
                    case 3: {
                        ci.setAliasStringUI(String.valueOf(evt.newValue));
                        break;
                    }
                    case 4: {
                        ci.setSortTypeString(String.valueOf(evt.newValue));
                        break;
                    }
                    case 5: {
                        ci.setSortOrderString(String.valueOf(evt.newValue));
                        break;
                    }
                    case 6: {
                        ci.setGroupingUI((Boolean)evt.newValue == true);
                        break;
                    }
                    case 7: {
                        ci.setGroupingTypeString(String.valueOf(evt.newValue));
                        break;
                    }
                    case 8: {
                        if (String.valueOf(evt.newValue).equals(Helpers.conditionTypes[ConditionType.Where.ordinal()])) {
                            ci.setConditionTypeUI(ConditionType.Where);
                            break;
                        }
                        ci.setConditionTypeUI(ConditionType.Having);
                        break;
                    }
                    default: {
                        ci.setConditionString(columnIndex - 9, String.valueOf(evt.newValue));
                    }
                }
                GridCellValueChangedEvent evt2 = new GridCellValueChangedEvent(ci.getQueryBuilder(), ci.getCriteriaList().getUnionSubQuery(), ci.getCriteriaList(), ci, columnIndex, rowIndex, oldValue, evt.newValue);
                ci.getQueryBuilder().fireGridCellValueChangedEvent(evt2);
            }
        }
    }
}

