/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.metadata;

import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseSQLContext;
import com.adbs.metadata.BaseMetadataSchemasFetcher;
import com.adbs.metadata.ResultSetWrapper;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.utils.Str;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MetadataSchemasFetcherFromResultSet
extends BaseMetadataSchemasFetcher {
    protected ResultSetWrapper resultSet = new ResultSetWrapper();
    protected int nameField;
    protected String nameFieldName;

    public MetadataSchemasFetcherFromResultSet(BaseSQLContext sqlContext) {
        super(sqlContext);
    }

    public ResultSet getResultSet() {
        return this.resultSet.getResultSet();
    }

    public void setResultSet(ResultSet resultSet) {
        this.resultSet.setResultSet(resultSet);
    }

    public String getNameFieldName() {
        return this.nameFieldName;
    }

    public void setNameFieldName(String nameFieldName) {
        this.nameFieldName = nameFieldName;
    }

    @Override
    protected void calcSchemaName(AstTokenIdentifier name) {
        if (this.nameField != -1) {
            try {
                name.setToken(this.trimName(this.resultSet.getString(this.nameField)));
                name.setCaseSensitive(this.sqlContext.getSyntaxProvider().isIdentifiersCaseSensitive());
            }
            catch (Exception ex) {
                Logger.getLogger(MetadataSchemasFetcherFromResultSet.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    protected void init() throws QueryBuilderException {
        if (!Str.IsNullOrEmpty(this.nameFieldName)) {
            try {
                this.nameField = this.resultSet.findColumn(this.nameFieldName);
            }
            catch (Exception ex) {
                this.nameField = -1;
            }
        } else {
            this.nameField = -1;
        }
    }

    @Override
    protected boolean next() throws QueryBuilderException {
        try {
            return this.resultSet.next();
        }
        catch (SQLException ex) {
            throw new QueryBuilderException("MetadataSchemasFetcherFromResultSet.nextIteration() failed.\n" + ex.getMessage(), ex);
        }
    }

    @Override
    protected void close() {
        this.resultSet.close();
    }
}

