/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.metadata;

import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataContainer;
import com.adbs.metadata.MetadataSchemasFetcherFromResultSet;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import java.sql.ResultSet;
import java.sql.SQLException;

public class MetadataSchemasFetcherFromQuery
extends MetadataSchemasFetcherFromResultSet {
    protected String query;

    public MetadataSchemasFetcherFromQuery(BaseSQLContext sqlContext) {
        super(sqlContext);
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    @Override
    protected void init() throws QueryBuilderException {
        if (!this.isResultSetCreated()) {
            this.createResultSet();
        }
        super.init();
    }

    @Override
    protected void close() {
        this.destroyResultSet();
        super.close();
    }

    @Override
    public void dispose() {
        this.destroyResultSet();
        super.dispose();
    }

    public void createResultSet() throws QueryBuilderException {
        if (!this.sqlContext.getMetadataProvider().canExecSQL()) {
            throw new QueryBuilderException(Helpers.localizer.getString("strMetadataProviderCantExecSQL", "Used metadata provider cannot execute SQL queries."));
        }
        this.resultSet.setResultSet(this.sqlContext.getMetadataProvider().execSQL(this.query, false));
    }

    public void destroyResultSet() {
        this.resultSet.close();
    }

    public boolean isResultSetCreated() {
        return this.resultSet.getResultSet() != null;
    }

    private void loadDefaults() {
        MetadataContainer metadataContainer = this.sqlContext.getMetadataContainer();
        if (this.sqlContext.getSyntaxProvider().isSupportDatabases() && Helpers.isQualifiedNameEmpty(metadataContainer.getDefaultDatabaseName())) {
            try {
                metadataContainer.setDefaultDatabaseName(this.sqlContext.getSyntaxProvider().getDefaultDatabaseName(this.sqlContext));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.sqlContext.getSyntaxProvider().isSupportSchemas() && metadataContainer.getDefaultSchemaNames().getCount() == 0) {
            this.sqlContext.getSyntaxProvider().getDefaultSchemaNames(this.sqlContext, metadataContainer.getDefaultSchemaNames());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateQuery() {
        assert (!Str.IsNullOrEmpty(this.query));
        boolean result = true;
        ResultSet rs = null;
        try {
            this.loadDefaults();
            rs = this.sqlContext.getMetadataProvider().execSQL(this.query, true);
        }
        catch (Exception ex) {
            result = false;
        }
        finally {
            try {
                if (rs != null) {
                    rs.getStatement().close();
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return result;
    }
}

