/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.scrolling.scrollBox;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import oracle.ewt.layout.DirectionalLayout;
import oracle.ewt.lwAWT.LWComponent;

final class ScrollBoxLayout
implements LayoutManager,
DirectionalLayout {
    private static final Dimension _ZERO_SIZE = new Dimension();
    private Component _hScroll;
    private Component _vScroll;
    private Component _center;

    @Override
    public void addLayoutComponent(String string, Component component) {
        if ("Hscroll".equals(string)) {
            this._hScroll = component;
        } else if ("Vscroll".equals(string)) {
            this._vScroll = component;
        } else if ("Center".equals(string)) {
            this._center = component;
        }
    }

    @Override
    public final void removeLayoutComponent(Component component) {
        if (component == this._hScroll) {
            this._hScroll = null;
        } else if (component == this._vScroll) {
            this._vScroll = null;
        } else if (component == this._center) {
            this._center = null;
        }
    }

    @Override
    public final Dimension preferredLayoutSize(Container container) {
        return this._getLayoutSize(container, true);
    }

    @Override
    public final Dimension minimumLayoutSize(Container container) {
        return this._getLayoutSize(container, false);
    }

    @Override
    public final void layoutContainer(Container container) {
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        int n = 1;
        if (container instanceof LWComponent) {
            n = ((LWComponent)container).getActualReadingDirection();
        }
        Dimension dimension2 = this._getComponentSize(this._hScroll, true, false);
        Dimension dimension3 = this._getComponentSize(this._vScroll, true, false);
        int n2 = 0;
        int n3 = 0;
        if (this._center != null) {
            n2 = dimension.width - dimension3.width;
            n3 = dimension.height - dimension2.height;
            if (n == 2) {
                this._center.setBounds(insets.left + dimension3.width, insets.top, n2, n3);
            } else {
                this._center.setBounds(insets.left, insets.top, n2, n3);
            }
        }
        if (dimension2 != _ZERO_SIZE) {
            if (n == 2) {
                this._hScroll.setBounds(insets.left + dimension3.width, insets.top + n3, n2, dimension2.height);
            } else {
                this._hScroll.setBounds(insets.left, insets.top + n3, n2, dimension2.height);
            }
        }
        if (dimension3 != _ZERO_SIZE) {
            if (n == 2) {
                this._vScroll.setBounds(insets.left, insets.top, dimension3.width, n3);
            } else {
                this._vScroll.setBounds(insets.left + n2, insets.top, dimension3.width, n3);
            }
        }
    }

    private Dimension _getLayoutSize(Container container, boolean bl) {
        Dimension dimension = new Dimension();
        Dimension dimension2 = this._getComponentSize(this._center, bl, true);
        dimension.width = dimension2.width;
        dimension.height = dimension2.height;
        Dimension dimension3 = this._getComponentSize(this._hScroll, bl, true);
        dimension.height += dimension3.height;
        if (bl) {
            dimension3 = this._getComponentSize(this._hScroll, false, true);
        }
        if (dimension.width < dimension3.width) {
            dimension.width = dimension3.width;
        }
        Dimension dimension4 = this._getComponentSize(this._vScroll, bl, true);
        dimension.width += dimension4.width;
        if (bl) {
            dimension4 = this._getComponentSize(this._vScroll, false, true);
        }
        if (dimension.height < dimension4.height) {
            dimension.height = dimension4.height;
        }
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    private Dimension _getComponentSize(Component component, boolean bl, boolean bl2) {
        return component != null && (bl2 || component.isVisible()) ? (bl ? component.getPreferredSize() : component.getMinimumSize()) : _ZERO_SIZE;
    }
}

