/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.pivot;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.bigCell.AbstractBigCell;
import oracle.ewt.header.Header;
import oracle.ewt.pivot.AbstractPivotHeaderCell;
import oracle.ewt.pivot.PivotHeader;
import oracle.ewt.util.InputEventUtils;

class LevelHighlighter
extends MouseAdapter {
    private PivotHeader _header;

    public LevelHighlighter(PivotHeader pivotHeader) {
        this._header = pivotHeader;
        this._header.getGrid().addMouseListener(this);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed() || !this._header.isEnabled()) {
            return;
        }
        if (!InputEventUtils.isLeftMouseButton(mouseEvent)) {
            return;
        }
        Grid grid = this._header.getGrid();
        Point point = grid.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
        int n = grid.getColumnAt(point.x);
        int n2 = grid.getRowAt(point.y);
        if (n != -1 && n2 != -1) {
            AbstractBigCell abstractBigCell = AbstractBigCell.getBigCell(grid, n, n2);
            if (abstractBigCell != null) {
                n = abstractBigCell.getColumn();
                n2 = abstractBigCell.getRow();
                if (abstractBigCell instanceof AbstractPivotHeaderCell) {
                    AbstractPivotHeaderCell abstractPivotHeaderCell = (AbstractPivotHeaderCell)abstractBigCell;
                    n += abstractPivotHeaderCell.getIndent();
                }
            }
            int n3 = -1;
            if (this._header.isHorizontal()) {
                n3 = n2;
                Header header = this._header.getRowHeader();
            } else {
                n3 = n;
                Header header = this._header.getColumnHeader();
            }
            this._header.setHighlightItem(n3);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this._header.setHighlightItem(-1);
    }
}

