/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.oracle;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import oracle.ewt.UIDefaults;
import oracle.ewt.painter.AbstractPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;

public class OracleWindowCaptionTile
extends AbstractPainter {
    private boolean _paletteStyle;
    private static Painter _sPainter;
    private static Painter _sPalettePainter;
    private static final int _NORMAL_HEIGHT = 12;
    private static final int _PALETTE_HEIGHT = 8;

    private OracleWindowCaptionTile(boolean bl) {
        this._paletteStyle = bl;
    }

    public static Painter getInstance() {
        if (_sPainter == null) {
            _sPainter = new OracleWindowCaptionTile(false);
        }
        return _sPainter;
    }

    public static Painter getPaletteInstance() {
        if (_sPalettePainter == null) {
            _sPalettePainter = new OracleWindowCaptionTile(true);
        }
        return _sPalettePainter;
    }

    @Override
    public int getRepaintFlags(PaintContext paintContext) {
        return 2;
    }

    @Override
    public Dimension getSize(PaintContext paintContext, int n, int n2) {
        int n3 = this._paletteStyle ? 8 : 12;
        return new Dimension(n, n3);
    }

    @Override
    public Dimension getMinimumSize(PaintContext paintContext) {
        int n = this._paletteStyle ? 8 : 12;
        return new Dimension(0, n);
    }

    @Override
    public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
        Color color = uIDefaults.getColor("Window.darkGrippy");
        Color color2 = uIDefaults.getColor("Window.lightGrippy");
        boolean bl = (paintContext.getPaintState() & 2) != 0;
        int n5 = n + n3 - 1;
        if (n % 4 != 0) {
            n -= n % 4;
        }
        while (n < n5) {
            if (n % 8 == 0) {
                if (n5 - n >= 4) {
                    this._drawDot(graphics, n, n2, color, color2, bl);
                    if (!this._paletteStyle) {
                        this._drawDot(graphics, n, n2 + 8, color, color2, bl);
                    }
                }
            } else if (n5 - n >= 8) {
                this._drawDot(graphics, n, n2 + 4, color, color2, bl);
            }
            n += 4;
        }
    }

    private void _drawDot(Graphics graphics, int n, int n2, Color color, Color color2, boolean bl) {
        if (bl) {
            graphics.setColor(color);
            graphics.drawLine(n + 1, n2, n + 1, n2);
            graphics.drawLine(n, n2 + 1, n, n2 + 1);
            graphics.setColor(color2);
            graphics.drawLine(n + 2, n2 + 1, n + 2, n2 + 1);
            graphics.drawLine(n + 1, n2 + 2, n + 2, n2 + 2);
        } else {
            graphics.setColor(color);
            graphics.drawLine(n + 2, n2 + 3, n + 2, n2 + 3);
            graphics.drawLine(n + 3, n2 + 2, n + 3, n2 + 2);
            graphics.setColor(color2);
            graphics.drawLine(n + 1, n2 + 1, n + 2, n2 + 1);
            graphics.drawLine(n + 1, n2 + 2, n + 1, n2 + 2);
        }
    }
}

