/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.generic;

import java.awt.Color;
import java.awt.Image;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.graphics.Appearance;
import oracle.ewt.graphics.ColorUtils;
import oracle.ewt.grid.Grid;
import oracle.ewt.header.Header;
import oracle.ewt.laf.generic.GenericGridUI;
import oracle.ewt.laf.generic.GenericLookAndFeel;
import oracle.ewt.laf.generic.GenericPivotCellBorderPainter;
import oracle.ewt.laf.generic.GenericPivotHeaderSeparator;
import oracle.ewt.laf.generic.GenericTableUI;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.pivot.PivotHeader;
import oracle.ewt.plaf.PivotHeaderUI;
import oracle.ewt.plaf.TableHeaderUI;

public class GenericPivotHeaderUI
extends GenericTableUI
implements PivotHeaderUI {
    public GenericPivotHeaderUI(LWComponent lWComponent) {
        super(lWComponent);
    }

    @Override
    public void installUI(LWComponent lWComponent) {
        super.installUI(lWComponent);
        UIDefaults uIDefaults = this.getUIDefaults(lWComponent);
        PivotHeader pivotHeader = (PivotHeader)lWComponent;
        pivotHeader.setBorderPainter(null);
        Grid grid = pivotHeader.getGrid();
        grid.setBorderPainter(null);
        grid.setOverlayBorderVisible(false);
        grid.setBackground(uIDefaults.getColor(LookAndFeel.CONTROL));
        Painter painter = GenericPivotHeaderSeparator.getHorizontalSeparator();
        pivotHeader.setHorizontalSeparatorPainter(painter);
        painter = GenericPivotHeaderSeparator.getVerticalSeparator();
        pivotHeader.setVerticalSeparatorPainter(painter);
    }

    @Override
    public Image getDrillImage(LWComponent lWComponent) {
        return GenericLookAndFeel.getImage("drillTriangle.gif");
    }

    @Override
    public Image getDrilledImage(LWComponent lWComponent) {
        return GenericLookAndFeel.getImage("drilledTriangle.gif");
    }

    @Override
    public Appearance getDefaultAppearance(LWComponent lWComponent) {
        PivotHeader pivotHeader = (PivotHeader)lWComponent;
        Grid grid = pivotHeader.getGrid();
        GenericGridUI genericGridUI = (GenericGridUI)grid.getUI();
        Appearance appearance = genericGridUI.getDefaultAppearance(grid);
        UIDefaults uIDefaults = this.getUIDefaults(lWComponent);
        appearance.setForeground(uIDefaults.getColor(LookAndFeel.CONTROL_TEXT));
        appearance.setBackground(uIDefaults.getColor(LookAndFeel.CONTROL));
        boolean bl = pivotHeader.isHorizontal();
        BorderPainter borderPainter = GenericPivotCellBorderPainter.getBorderPainter(bl);
        appearance.setBorderPainter(borderPainter);
        return appearance;
    }

    @Override
    public Color getSwapForegroundColor(LWComponent lWComponent, Appearance appearance) {
        return this.getUIDefaults(lWComponent).getColor(LookAndFeel.DARK_INTENSITY);
    }

    @Override
    public Color getSwapBackgroundColor(LWComponent lWComponent, Appearance appearance) {
        return ColorUtils.darkerShadeColor(appearance.getBackground());
    }

    @Override
    public Painter getDefaultHeaderItemPainter(LWComponent lWComponent, boolean bl) {
        Header header = bl ? ((PivotHeader)lWComponent).getRowHeader() : ((PivotHeader)lWComponent).getColumnHeader();
        if (header != null) {
            return ((TableHeaderUI)header.getUI()).getDefaultPainter(header);
        }
        return null;
    }
}

