/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.generic;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.graphics.Appearance;
import oracle.ewt.grid.Grid;
import oracle.ewt.laf.basic.BasicComponentUI;
import oracle.ewt.laf.basic.BasicGridSeparator;
import oracle.ewt.laf.basic.GridDisablingPainter;
import oracle.ewt.laf.basic.GridFocusPainter;
import oracle.ewt.laf.basic.GridImageSetPainter;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.painter.TruncatingTextPainter;
import oracle.ewt.plaf.GridUI;
import oracle.ewt.util.ImmInsets;

public class GenericGridUI
extends BasicComponentUI
implements GridUI {
    private static Painter _sDefaultPainter;
    private static final ImmInsets _DEFAULT_INSETS;

    public GenericGridUI(LWComponent lWComponent) {
        super(lWComponent);
    }

    @Override
    public void installUI(LWComponent lWComponent) {
        Grid grid = (Grid)lWComponent;
        grid.setOverlayBorderVisible(false);
        grid.setVerticalSeparatorPainter(BasicGridSeparator.getVerticalSeparator());
        grid.setHorizontalSeparatorPainter(BasicGridSeparator.getHorizontalSeparator());
    }

    @Override
    public Painter getDefaultPainter(LWComponent lWComponent) {
        return GenericGridUI._getDefaultPainter();
    }

    @Override
    public BorderPainter getFocusCellPainter(LWComponent lWComponent) {
        return GridFocusPainter.getBorderPainter();
    }

    public Painter getHorizontalSeparator(LWComponent lWComponent) {
        return BasicGridSeparator.getHorizontalSeparator();
    }

    public Painter getVerticalSeparator(LWComponent lWComponent) {
        return BasicGridSeparator.getVerticalSeparator();
    }

    @Override
    public BorderPainter getOverlayBorderPainter(LWComponent lWComponent) {
        return null;
    }

    @Override
    public int getDefaultRowHeight(LWComponent lWComponent) {
        Font font = lWComponent.getFont();
        int n = 0;
        if (font != null) {
            FontMetrics fontMetrics = lWComponent.getFontMetrics(font);
            n = fontMetrics.getHeight() + 3 + 3;
        }
        return n;
    }

    @Override
    public int getDefaultColumnWidth(LWComponent lWComponent) {
        Font font = lWComponent.getFont();
        int n = 0;
        if (font != null) {
            FontMetrics fontMetrics = lWComponent.getFontMetrics(font);
            n = fontMetrics.stringWidth("12345678");
        }
        return n;
    }

    @Override
    public Appearance getDefaultAppearance(LWComponent lWComponent) {
        UIDefaults uIDefaults = this.getUIDefaults(lWComponent);
        Appearance appearance = new Appearance();
        appearance.setForeground(uIDefaults.getColor(LookAndFeel.TEXT_TEXT));
        appearance.setBackground(uIDefaults.getColor(LookAndFeel.TEXT));
        appearance.setSelectForeground(uIDefaults.getColor(LookAndFeel.TEXT_HIGHLIGHT_TEXT));
        appearance.setSelectBackground(uIDefaults.getColor(LookAndFeel.TEXT_HIGHLIGHT));
        appearance.setInsets(_DEFAULT_INSETS);
        return appearance;
    }

    @Override
    public Color getSelectionBackgroundColor(LWComponent lWComponent, Color color) {
        if (!lWComponent.isActive() || !lWComponent.isEnabled()) {
            return this.getUIDefaults(lWComponent).getColor(LookAndFeel.DARK_INTENSITY);
        }
        return color;
    }

    @Override
    public Color getDisabledBackgroundColor(LWComponent lWComponent) {
        if (!lWComponent.isEnabled()) {
            return this.getUIDefaults(lWComponent).getColor(LookAndFeel.CONTROL);
        }
        return lWComponent.getBackground();
    }

    public static Object instantiate(UIDefaults uIDefaults, Object object, String string) {
        if ("DefaultCellPainter".equals(object)) {
            return GenericGridUI._getDefaultPainter();
        }
        if ("Grid.checkPainter".equals(object)) {
            return new GridImageSetPainter("checkboxSet");
        }
        if ("Grid.radioPainter".equals(object)) {
            return new GridImageSetPainter("radioButtonSet");
        }
        return null;
    }

    private static Painter _getDefaultPainter() {
        if (_sDefaultPainter == null) {
            _sDefaultPainter = new GridDisablingPainter(new TruncatingTextPainter(PaintContext.LABEL_KEY, false));
        }
        return _sDefaultPainter;
    }

    private static BorderPainter _getBorderPainter(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return null;
    }

    static {
        _DEFAULT_INSETS = new ImmInsets(3, 3, 3, 1);
    }
}

