/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.grid;

import oracle.ewt.grid.Cell;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridSelection;

public class MultipleRowSelection
implements GridSelection {
    private Grid _grid;
    private boolean[] _rows;
    private int _selectCount;

    @Override
    public void setParent(Grid grid) {
        if (this._rows != null) {
            this._rows = null;
        }
        this._selectCount = 0;
        this._grid = grid;
    }

    @Override
    public void rowsAdded(int n, int n2) {
        if (this._rows != null) {
            boolean[] blArray = this._rows;
            int n3 = blArray.length;
            boolean[] blArray2 = new boolean[n3 + n2];
            if (n != 0) {
                System.arraycopy(blArray, 0, blArray2, 0, n);
            }
            if (n != n3) {
                System.arraycopy(blArray, n, blArray2, n + n2, n3 - n);
            }
            this._rows = blArray2;
        }
    }

    @Override
    public void rowsRemoved(int n, int n2) {
        if (this._rows != null) {
            int[] nArray = this.getSelectedRows();
            if (nArray != null) {
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] < n || nArray[i] >= n + n2) continue;
                    --this._selectCount;
                }
            }
            boolean[] blArray = this._rows;
            int n3 = blArray.length;
            boolean[] blArray2 = new boolean[n3 - n2];
            if (n != 0) {
                System.arraycopy(blArray, 0, blArray2, 0, n);
            }
            if (n3 - n2 != n) {
                System.arraycopy(blArray, n + n2, blArray2, n, n3 - (n + n2));
            }
            this._rows = blArray2;
        }
    }

    @Override
    public void columnsAdded(int n, int n2) {
    }

    @Override
    public void columnsRemoved(int n, int n2) {
    }

    @Override
    public void selectAll() {
        this.deselectAll();
        int n = this._grid.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.setRowSelected(i, true);
        }
    }

    @Override
    public void deselectAll() {
        int[] nArray = this.getSelectedRows();
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                this.setRowSelected(nArray[i], false);
            }
        }
    }

    @Override
    public boolean isSomethingSelected() {
        return this._selectCount != 0;
    }

    @Override
    public void setColumnSelected(int n, boolean bl) {
    }

    @Override
    public boolean isColumnSelected(int n) {
        return false;
    }

    @Override
    public int[] getSelectedColumns() {
        return null;
    }

    @Override
    public void setRowSelected(int n, boolean bl) {
        if (this.isRowSelected(n) == bl) {
            return;
        }
        if (bl) {
            if (this._grid.fireCancelableRowEvent(n, 2005)) {
                return;
            }
            if (this._rows == null) {
                this._rows = new boolean[this._grid.getRowCount()];
            }
            this._rows[n] = true;
            ++this._selectCount;
            this._grid.fireRowEvent(n, 2006);
        } else {
            if (this._grid.fireCancelableRowEvent(n, 2007)) {
                return;
            }
            this._rows[n] = false;
            --this._selectCount;
            this._grid.fireRowEvent(n, 2008);
        }
        this._grid.paintRow(n);
    }

    @Override
    public boolean isRowSelected(int n) {
        return this._rows != null && this._rows[n];
    }

    @Override
    public int[] getSelectedRows() {
        if (this._selectCount == 0) {
            return null;
        }
        int[] nArray = new int[this._selectCount];
        int n = 0;
        for (int i = 0; i < this._rows.length; ++i) {
            if (!this.isRowSelected(i)) continue;
            nArray[n] = i;
            if (++n == this._selectCount) break;
        }
        return nArray;
    }

    @Override
    public void setCellSelected(int n, int n2, boolean bl) {
        this.setRowSelected(n2, bl);
    }

    @Override
    public boolean isCellSelected(int n, int n2) {
        return this.isRowSelected(n2);
    }

    @Override
    public Cell[] getSelectedCells() {
        return null;
    }

    @Override
    public void selectCellRange(int n, int n2, int n3, int n4) {
        this._selectRowRange(n2, n4);
    }

    @Override
    public void addCellToSelection(int n, int n2) {
        this.setRowSelected(n2, true);
    }

    @Override
    public void removeCellFromSelection(int n, int n2) {
        this.setRowSelected(n2, false);
    }

    private void _selectRowRange(int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (n <= n2) {
            n5 = n;
            n4 = n2;
        } else {
            n5 = n2;
            n4 = n;
        }
        int[] nArray = this.getSelectedRows();
        if (nArray != null) {
            for (n3 = 0; n3 < nArray.length; ++n3) {
                int n6 = nArray[n3];
                if (n6 >= n5 && n6 <= n4) continue;
                this.setRowSelected(n6, false);
            }
        }
        for (n3 = n5; n3 <= n4; ++n3) {
            if (this.isRowSelected(n3)) continue;
            this.setRowSelected(n3, true);
        }
    }
}

