/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dnd;

import java.awt.Component;
import java.util.TooManyListenersException;
import oracle.ewt.dnd.DnDUtils;
import oracle.ewt.dnd.DropTargetContext;
import oracle.ewt.dnd.DropTargetDragEvent;
import oracle.ewt.dnd.DropTargetDropEvent;
import oracle.ewt.dnd.DropTargetEvent;
import oracle.ewt.dnd.DropTargetListener;

public class DropTarget
implements DropTargetListener {
    private transient DropTargetContext _dropTargetContext;
    private Component _component;
    private int _actions;
    private boolean _active;
    private DropTargetListener _dtListener;

    public DropTarget(Component component, int n, DropTargetListener dropTargetListener, boolean bl) {
        this._component = component;
        this.setDefaultActions(n);
        this.setDefaultActions(n);
        if (dropTargetListener != null) {
            try {
                this.addDropTargetListener(dropTargetListener);
            }
            catch (TooManyListenersException tooManyListenersException) {
                // empty catch block
            }
        }
        if (component != null) {
            DnDUtils.setEWTDropTarget(component, this);
            this.setActive(bl);
        }
    }

    public DropTarget() {
        this(null, 3, null, true);
    }

    public DropTarget(Component component, DropTargetListener dropTargetListener) {
        this(component, 3, dropTargetListener, true);
    }

    public DropTarget(Component component, int n, DropTargetListener dropTargetListener) {
        this(component, n, dropTargetListener, true);
    }

    public synchronized void setComponent(Component component) {
        block5: {
            if (this._component == component) {
                return;
            }
            Component component2 = this._component;
            if (component2 != null) {
                this._cleanup();
                this._component = null;
                DnDUtils.setEWTDropTarget(component2, null);
            }
            this._component = component;
            if (component != null) {
                try {
                    DnDUtils.setEWTDropTarget(component, this);
                }
                catch (Exception exception) {
                    if (component2 == null) break block5;
                    DnDUtils.setEWTDropTarget(component2, this);
                }
            }
        }
    }

    public synchronized Component getComponent() {
        return this._component;
    }

    public synchronized void setDefaultActions(int n) {
        this._actions = n & 0x40000003;
        DropTargetContext dropTargetContext = this._dropTargetContext;
        if (dropTargetContext != null) {
            dropTargetContext.setTargetActions(this._actions);
        }
    }

    public synchronized int getDefaultActions() {
        return this._actions;
    }

    public synchronized void setActive(boolean bl) {
        if (bl != this._active) {
            if (!bl) {
                this._cleanup();
            }
            this._active = bl;
        }
    }

    public synchronized boolean isActive() {
        return this._active;
    }

    public synchronized void addDropTargetListener(DropTargetListener dropTargetListener) throws TooManyListenersException {
        if (dropTargetListener == null) {
            return;
        }
        if (this.equals(dropTargetListener)) {
            throw new IllegalArgumentException("DropTarget may not be its own Listener");
        }
        if (this._dtListener != null) {
            throw new TooManyListenersException();
        }
        this._dtListener = dropTargetListener;
    }

    public synchronized void removeDropTargetListener(DropTargetListener dropTargetListener) {
        if (dropTargetListener != null && this._dtListener != null) {
            if (this._dtListener.equals(dropTargetListener)) {
                this._dtListener = null;
            } else {
                throw new IllegalArgumentException("listener mismatch");
            }
        }
    }

    @Override
    public synchronized void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (!this._active) {
            return;
        }
        if (this._dtListener != null) {
            this._dtListener.dragEnter(dropTargetDragEvent);
        } else {
            dropTargetDragEvent.getDropTargetContext().setTargetActions(0);
        }
        this.getDropTargetContext()._initializeAutoscrolling(dropTargetDragEvent.getLocation());
    }

    @Override
    public synchronized void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (!this._active) {
            return;
        }
        if (this._dtListener != null && this.isActive()) {
            this._dtListener.dragOver(dropTargetDragEvent);
        } else {
            dropTargetDragEvent.getDropTargetContext().setTargetActions(0);
        }
        this.getDropTargetContext()._updateAutoscroll(dropTargetDragEvent.getLocation());
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (!this._active) {
            return;
        }
        if (this._dtListener != null) {
            this._dtListener.dropActionChanged(dropTargetDragEvent);
        }
    }

    @Override
    public synchronized void dragExit(DropTargetEvent dropTargetEvent) {
        if (!this._active) {
            return;
        }
        if (this._dtListener != null && this.isActive()) {
            this._dtListener.dragExit(dropTargetEvent);
        }
        this._cleanup();
    }

    @Override
    public synchronized void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (this._dtListener != null && this.isActive()) {
            this._dtListener.drop(dropTargetDropEvent);
        } else {
            dropTargetDropEvent.rejectDrop();
        }
        this._cleanup();
    }

    public DropTargetContext getDropTargetContext() {
        if (this._dropTargetContext == null) {
            this._dropTargetContext = this.createDropTargetContext();
        }
        return this._dropTargetContext;
    }

    protected DropTargetContext createDropTargetContext() {
        return new DropTargetContext(this);
    }

    private void _cleanup() {
        DropTargetContext dropTargetContext = this._dropTargetContext;
        if (dropTargetContext != null) {
            dropTargetContext._clearAutoscroll();
        }
        this._dropTargetContext = null;
    }
}

