/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dataSource;

import java.util.Enumeration;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.dataSource.TwoDDataSourceEvent;
import oracle.ewt.dataSource.TwoDDataSourceListener;
import oracle.ewt.event.ListenerManager;

public abstract class AbstractTwoDDataSource
implements TwoDDataSource {
    private ListenerManager _manager;

    @Override
    public abstract int getColumnCount();

    @Override
    public abstract int getRowCount();

    @Override
    public abstract Object getData(int var1, int var2);

    @Override
    public abstract void setData(int var1, int var2, Object var3);

    @Override
    public void addDataSourceListener(TwoDDataSourceListener twoDDataSourceListener) {
        if (this._manager == null) {
            this._manager = new ListenerManager();
        }
        this._manager.addListener(twoDDataSourceListener);
    }

    @Override
    public void removeDataSourceListener(TwoDDataSourceListener twoDDataSourceListener) {
        if (this._manager != null) {
            this._manager.removeListener(twoDDataSourceListener);
        }
    }

    protected void fireDataSourceEvent(int n, int n2, int n3) {
        if (n3 != 0) {
            this._deliverEvent(new TwoDDataSourceEvent(this, n, n2, n3));
        }
    }

    protected void fireDataSourceEvent(int n, int n2, int n3, int n4, int n5) {
        if (n3 != 0 && n5 != 0) {
            this._deliverEvent(new TwoDDataSourceEvent(this, n, n2, n3, n4, n5));
        }
    }

    private void _deliverEvent(TwoDDataSourceEvent twoDDataSourceEvent) {
        if (this._manager == null) {
            return;
        }
        Enumeration enumeration = this._manager.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (twoDDataSourceEvent.getID()) {
            case 2001: {
                while (enumeration.hasMoreElements()) {
                    TwoDDataSourceListener twoDDataSourceListener = (TwoDDataSourceListener)enumeration.nextElement();
                    twoDDataSourceListener.columnsAdded(twoDDataSourceEvent);
                }
                break;
            }
            case 2002: {
                while (enumeration.hasMoreElements()) {
                    TwoDDataSourceListener twoDDataSourceListener = (TwoDDataSourceListener)enumeration.nextElement();
                    twoDDataSourceListener.columnsRemoved(twoDDataSourceEvent);
                }
                break;
            }
            case 2003: {
                while (enumeration.hasMoreElements()) {
                    TwoDDataSourceListener twoDDataSourceListener = (TwoDDataSourceListener)enumeration.nextElement();
                    twoDDataSourceListener.invalidateColumns(twoDDataSourceEvent);
                }
                break;
            }
            case 2004: {
                while (enumeration.hasMoreElements()) {
                    TwoDDataSourceListener twoDDataSourceListener = (TwoDDataSourceListener)enumeration.nextElement();
                    twoDDataSourceListener.rowsAdded(twoDDataSourceEvent);
                }
                break;
            }
            case 2005: {
                while (enumeration.hasMoreElements()) {
                    TwoDDataSourceListener twoDDataSourceListener = (TwoDDataSourceListener)enumeration.nextElement();
                    twoDDataSourceListener.rowsRemoved(twoDDataSourceEvent);
                }
                break;
            }
            case 2006: {
                while (enumeration.hasMoreElements()) {
                    TwoDDataSourceListener twoDDataSourceListener = (TwoDDataSourceListener)enumeration.nextElement();
                    twoDDataSourceListener.invalidateRows(twoDDataSourceEvent);
                }
                break;
            }
            case 2007: {
                while (enumeration.hasMoreElements()) {
                    TwoDDataSourceListener twoDDataSourceListener = (TwoDDataSourceListener)enumeration.nextElement();
                    twoDDataSourceListener.invalidateCells(twoDDataSourceEvent);
                }
                break;
            }
        }
    }
}

