/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dTree;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import oracle.ewt.dTree.DTree;
import oracle.ewt.dTree.DTreeDecoration;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.painter.LinePainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.util.ImmInsets;

public class DTreeLineDecoration
implements DTreeDecoration {
    private Painter _hLinePainter;
    private Painter _vLinePainter;
    private Color _lineColor;

    public DTreeLineDecoration() {
        this(new LinePainter(true, false), new LinePainter(false, false), Color.black);
    }

    public DTreeLineDecoration(Painter painter, Painter painter2, Color color) {
        if (painter == null || painter2 == null) {
            throw new IllegalArgumentException();
        }
        this._hLinePainter = painter;
        this._vLinePainter = painter2;
        this._lineColor = color;
    }

    @Override
    public ImmInsets getDecorationInsets(DTree dTree) {
        return new ImmInsets(0, dTree.getIndentWidth(), 0, 0);
    }

    @Override
    public void paintDecoration(PaintContext paintContext, Graphics graphics, DTreeItem dTreeItem, int n, int n2) {
        if (this.getHasLines(dTreeItem)) {
            int n3;
            int n4;
            int n5;
            Color color = graphics.getColor();
            if (this._lineColor != null) {
                graphics.setColor(this._lineColor);
            }
            DTree dTree = dTreeItem.getTree();
            DTreeItem dTreeItem2 = dTreeItem.getParent();
            int n6 = dTree.getIndentWidth();
            DTreeItem dTreeItem3 = null;
            if (dTreeItem2 != null) {
                n5 = dTreeItem2.getItemCount();
                n4 = dTreeItem.getIndex();
                if (n4 < n5 - 1) {
                    dTreeItem3 = dTreeItem2.getItem(n4 + 1);
                }
            }
            n5 = dTreeItem.getY();
            graphics.translate(0, -n5);
            n4 = n6 / 2;
            if (dTree.getActualReadingDirection() == 2) {
                Dimension dimension = dTree.getCanvasSize();
                this._hLinePainter.paint(paintContext, graphics, dimension.width - n, n5, n4, n2);
                n3 = dimension.width - n;
            } else {
                this._hLinePainter.paint(paintContext, graphics, n - n4, n5, n4, n2);
                n3 = n - n6;
            }
            if (dTreeItem3 != null) {
                int n7 = n5 + n2 / 2;
                int n8 = dTreeItem3.getY();
                Rectangle rectangle = graphics.getClipBounds();
                if (n7 < rectangle.y) {
                    n7 = rectangle.y;
                }
                this._vLinePainter.paint(paintContext, graphics, n3, n7, n6, n8 - n7);
            }
            if (dTreeItem2 != dTree.getRoot() || dTreeItem.getIndex() != 0) {
                this._vLinePainter.paint(paintContext, graphics, n3, n5, n6, n2 / 2);
            }
            graphics.translate(0, n5);
            graphics.setColor(color);
        }
    }

    @Override
    public void processMouseEvent(MouseEvent mouseEvent, DTreeItem dTreeItem) {
    }

    protected boolean getHasLines(DTreeItem dTreeItem) {
        return true;
    }
}

