/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.button;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.graphics.ImageSet;
import oracle.ewt.graphics.SynthesizingImageSet;
import oracle.ewt.lwAWT.AbstractButton;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.ButtonUI;
import oracle.ewt.util.WindowUtils;

public class PushButton
extends AbstractButton {
    private String _label;
    private ImageSet _imageSet;
    private boolean _isArmed;
    private boolean _isDefault;
    private boolean _isLeftmost;
    private boolean _isRightmost;
    private ListenerManager _listeners;
    private Painter _painter;
    private static int _sInstanceCounter = 0;

    public PushButton() {
        this("");
    }

    public PushButton(String string) {
        this._init(string, null);
    }

    public PushButton(Image image) {
        this(new SynthesizingImageSet(image));
    }

    public PushButton(ImageSet imageSet) {
        this._init(null, imageSet);
    }

    @Override
    public Object getUIClassID() {
        return "ButtonUI";
    }

    public void setLeftmost(boolean bl) {
        if (bl != this._isLeftmost) {
            this._isLeftmost = bl;
            this.invalidate();
            this.repaint();
        }
    }

    public boolean isLeftmost() {
        return this._isLeftmost;
    }

    public void setRightmost(boolean bl) {
        if (bl != this._isRightmost) {
            this._isRightmost = bl;
            this.invalidate();
            this.repaint();
        }
    }

    public boolean isRightmost() {
        return this._isRightmost;
    }

    public void setDefault(boolean bl) {
        if (bl != this.isDefault()) {
            boolean bl2 = this._isReallyDefault();
            this._isDefault = bl;
            if (bl2 != this._isReallyDefault()) {
                this.invalidateAndRepaintIfNecessary(64);
            }
        }
    }

    public boolean isDefault() {
        return this._isDefault;
    }

    public final void setImage(Image image) {
        this.setImageSet(image == null ? null : new SynthesizingImageSet(image));
    }

    public void setImageSet(ImageSet imageSet) {
        if (this._imageSet != imageSet) {
            this._imageSet = imageSet;
            this.invalidate();
            this.repaint();
        }
    }

    public ImageSet getImageSet() {
        return this._imageSet;
    }

    public String getLabel() {
        return this._label;
    }

    public void setLabel(String string) {
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        String string2 = accessibleContext == null ? null : accessibleContext.getAccessibleName();
        String string3 = this._label;
        this._label = string;
        if (accessibleContext != null) {
            accessibleContext.firePropertyChange("AccessibleVisibleData", string3, string);
            String string4 = accessibleContext.getAccessibleName();
            if (string4 != string2) {
                accessibleContext.firePropertyChange("AccessibleName", string2, string4);
            }
        }
        this.invalidate();
        this.repaint();
    }

    public void addActionListener(ActionListener actionListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this._listeners.removeListener(actionListener);
    }

    public void setPainter(Painter painter) {
        if (painter != this._painter) {
            this._painter = painter;
            this.invalidate();
            this.repaint();
        }
    }

    @Override
    public Painter getPainter() {
        if (this._painter == null) {
            return this.getButtonUI().getPainter(this);
        }
        return this._painter;
    }

    @Override
    protected boolean interiorContains(int n, int n2, int n3, int n4) {
        return this.pointInInterior(n, n2, n3, n4);
    }

    @Override
    protected int getPaintState() {
        int n = super.getPaintState();
        if (this._isReallyDefault()) {
            n |= 0x40;
        }
        return n;
    }

    @Override
    protected Object getPaintData(Object object) {
        Object object2 = null;
        if (object == null || object == PaintContext.LABEL_KEY) {
            String string = this.getLabel();
            if (string != null && string.length() > 0) {
                object2 = string;
            }
        } else if (object == PaintContext.IMAGESET_KEY) {
            object2 = this.getImageSet();
        }
        if (object2 == null) {
            object2 = super.getPaintData(object);
        }
        return object2;
    }

    @Override
    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        Enumeration enumeration;
        ListenerManager listenerManager = this._listeners;
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                ActionListener actionListener = (ActionListener)enumeration.nextElement();
                switch (actionEvent.getID()) {
                    case 1001: {
                        actionListener.actionPerformed(actionEvent);
                        break;
                    }
                }
            }
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        this._repaintDefaultPushButton();
    }

    @Override
    protected void activate(int n) {
        this.processEvent(new ActionEvent(this, 1001, null, n));
    }

    @Override
    protected String paramString() {
        String string = super.paramString();
        String string2 = this._label;
        if (string2 != null) {
            string = string + ",label=" + string2;
        }
        return string;
    }

    @Override
    protected boolean isArmed() {
        return this._isArmed;
    }

    @Override
    protected void setArmed(boolean bl) {
        if (bl != this.isArmed()) {
            this._isArmed = bl;
            this.paintImmediate();
        }
    }

    @Override
    protected String getDefaultName() {
        return this.getBaseClassName() + _sInstanceCounter++;
    }

    @Override
    protected boolean doesKeyCausePress(KeyEvent keyEvent, boolean bl) {
        if (super.doesKeyCausePress(keyEvent, bl)) {
            return true;
        }
        return keyEvent.getKeyCode() == 10 && this._isReallyDefault();
    }

    @Override
    protected AccessibleContext createAccessibleContext() {
        return new AccessiblePushButton();
    }

    protected final ButtonUI getButtonUI() {
        return (ButtonUI)this.getUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _repaintDefaultPushButton() {
        Object object = this.getTreeLock();
        synchronized (object) {
            PushButton pushButton;
            Window window = WindowUtils.getWindow(this);
            if (window != null && window.isVisible() && (pushButton = PushButton._getDefaultButton(window)) != null) {
                pushButton.repaint();
            }
        }
    }

    private static PushButton _getDefaultButton(Container container) {
        if (container instanceof PushButton && ((PushButton)container).isDefault()) {
            return (PushButton)container;
        }
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            PushButton pushButton;
            Component component = container.getComponent(i);
            if (!component.isVisible() || !(component instanceof Container) || (pushButton = PushButton._getDefaultButton((Container)component)) == null) continue;
            return pushButton;
        }
        return null;
    }

    private boolean _isReallyDefault() {
        LWComponent lWComponent = LWComponent.getFocusedComponent();
        return lWComponent == this || !(lWComponent instanceof PushButton) && this.isDefault();
    }

    private void _init(String string, ImageSet imageSet) {
        this._label = string;
        this._imageSet = imageSet;
        this.setAlignment(3);
    }

    private class AccessiblePushButton
    extends AbstractButton.AccessibleAbstractButton {
        private AccessiblePushButton() {
            super(PushButton.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PUSH_BUTTON;
        }
    }
}

