/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.diagrammer.application;

import ilog.views.IlvGrapher;
import ilog.views.IlvManagerView;
import ilog.views.diagrammer.IlvDiagrammer;
import ilog.views.diagrammer.IlvDiagrammerException;
import ilog.views.diagrammer.IlvDiagrammerProduct;
import ilog.views.diagrammer.application.IlvDiagrammerPaletteAction;
import ilog.views.diagrammer.datasource.IlvDiagrammerDataSource;
import ilog.views.diagrammer.datasource.IlvXMLDataSource;
import ilog.views.diagrammer.project.IlvDiagrammerProject;
import ilog.views.event.InteractorChangedEvent;
import ilog.views.event.InteractorListener;
import ilog.views.event.ManagerContentChangedEvent;
import ilog.views.event.ManagerContentChangedListener;
import ilog.views.event.ManagerSelectionChangedEvent;
import ilog.views.event.ManagerSelectionListener;
import ilog.views.event.TransformerChangedEvent;
import ilog.views.event.TransformerListener;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import ilog.views.sdm.event.SDMPropertyChangeEvent;
import ilog.views.sdm.event.SDMPropertyChangeListener;
import ilog.views.sdm.renderer.maps.IlvMapsNotAvailableException;
import ilog.views.sdm.util.IlvNotAnSDMDocumentException;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.IlvResourceUtil;
import ilog.views.util.internal.IlvPopUserBrowser;
import ilog.views.util.internal.IlvSplash;
import ilog.views.util.internal.IlvURLUtil;
import ilog.views.util.swing.IlvSwingUtil;
import ilog.views.util.swing.context.ComponentAction;
import ilog.views.util.swing.context.ComponentContext;
import ilog.views.util.swing.context.ComponentContextEvent;
import ilog.views.util.swing.context.ComponentContextListener;
import ilog.views.util.swing.context.ComponentContextManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public abstract class IlvDiagrammerAction
extends ComponentAction {
    private static final String a = "_IlvDiagrammer_StyleSheetModified";
    private static final String b = "_IlvDiagrammer_ModelUpdateListener";
    public static IlvDiagrammerAction select = new MethodToggleAction("Diagrammer.Action.Select", "selectMode", null){

        @Override
        public void perform(ActionEvent actionEvent, IlvDiagrammer ilvDiagrammer) throws Exception {
            super.perform(actionEvent, ilvDiagrammer);
            if (!this.isSelected()) {
                this.setSelected(ilvDiagrammer, true);
                this.setSelected(true);
            }
        }
    };
    public static final IlvDiagrammerAction cut = new MethodAction("Diagrammer.Action.Cut", "cut", "canEdit");
    public static final IlvDiagrammerAction copy = new MethodAction("Diagrammer.Action.Copy", "copy", "canEdit");
    public static final IlvDiagrammerAction delete = new MethodAction("Diagrammer.Action.Delete", "delete", "canEdit");
    public static final IlvDiagrammerAction duplicate = new MethodAction("Diagrammer.Action.Duplicate", "duplicate", "canEdit");
    public static final IlvDiagrammerAction paste = new MethodAction("Diagrammer.Action.Paste", "paste", "canPaste");
    public static final IlvDiagrammerAction selectAll = new MethodAction("Diagrammer.Action.SelectAll", "selectAll", "canSelect");
    public static final IlvDiagrammerAction undo = new MethodAction("Diagrammer.Action.Undo", "undo", "canUndo");
    public static final IlvDiagrammerAction redo = new MethodAction("Diagrammer.Action.Redo", "redo", "canRedo");
    public static final IlvDiagrammerAction group = new MethodAction("Diagrammer.Action.Group", "group", "canGroup");
    public static final IlvDiagrammerAction ungroup = new MethodAction("Diagrammer.Action.Ungroup", "ungroup", "canUngroup");
    public static final IlvDiagrammerAction zoomIn = new MethodAction("Diagrammer.Action.ZoomIn", "zoomIn", "canZoomIn");
    public static final IlvDiagrammerAction zoomOut = new MethodAction("Diagrammer.Action.ZoomOut", "zoomOut", "canZoomOut");
    public static final IlvDiagrammerAction resetZoom = new MethodAction("Diagrammer.Action.ResetZoom", "resetZoom", "canResetZoom");
    public static final IlvDiagrammerAction fitToContents = new MethodAction("Diagrammer.Action.FitToContents", "fitToContents", null);
    public static final IlvDiagrammerAction zoom = new MethodToggleAction("Diagrammer.Action.Zoom", "zoomMode", null);
    public static final IlvDiagrammerAction pan = new MethodToggleAction("Diagrammer.Action.Pan", "panMode", null);
    public static final IlvDiagrammerAction layoutAllNodes = new MethodAction("Diagrammer.Action.LayoutAllNodes", "layoutAllNodes", "isEditingAllowed & isNodeLayoutAvailable & canSelect");
    public static final IlvDiagrammerAction layoutSelectedNodes = new MethodAction("Diagrammer.Action.LayoutSelectedNodes", "layoutSelectedNodes", "isEditingAllowed & isNodeLayoutAvailable & canEdit");
    public static final IlvDiagrammerAction autoNodeLayout = new MethodToggleAction("Diagrammer.Action.AutoNodeLayout", "automaticNodeLayout", "isNodeLayoutAvailable");
    public static final IlvDiagrammerAction autoLinkLayout = new MethodToggleAction("Diagrammer.Action.AutoLinkLayout", "automaticLinkLayout", "isLinkLayoutAvailable");
    public static final IlvDiagrammerAction autoLabelLayout = new MethodToggleAction("Diagrammer.Action.AutoLabelLayout", "automaticLabelLayout", "isLabelLayoutAvailable");
    public static final IlvDiagrammerAction editLabel = new MethodToggleAction("Diagrammer.Action.EditLabel", "editLabelMode", "isEditingAllowed");
    public static final IlvDiagrammerAction editing = new MethodToggleAction("Diagrammer.Action.Editing", "editingAllowed", "isEditable");
    public static final IlvDiagrammerAction resizing = new MethodToggleAction("Diagrammer.Action.Resizing", "resizingAllowed", "isEditable");
    public static final IlvDiagrammerAction stickyModes = new MethodToggleAction("Diagrammer.Action.StickyModes", "stickyModes", null);
    public static final IlvDiagrammerAction autoEditLabel = new MethodToggleAction("Diagrammer.Action.AutoEditLabel", "autoEditLabel", null);
    public static final IlvDiagrammerAction _new = new New();
    public static final IlvDiagrammerAction close = new Close();
    public static final IlvDiagrammerAction read = new ReadAction();
    public static final IlvDiagrammerAction open = new Open();
    public static final IlvDiagrammerAction saveAs = new SaveAsAction();
    public static final IlvDiagrammerAction save = new SaveAction();
    public static final IlvDiagrammerAction openStyleSheet = new OpenStyleSheetAction();
    public static final IlvDiagrammerAction refresh = new MethodAction("Diagrammer.Action.Refresh", "refresh", null);
    public static final IlvDiagrammerAction exit = new ExitAction();
    public static final IlvDiagrammerAction about = new AboutAction();
    public static final String ABOUT_APPLICATION_NAME = "AboutApplicationName";
    public static final IlvDiagrammerAction help = new HelpAction();
    public static final IlvDiagrammerAction pageSetup = new MethodAction("Diagrammer.Action.PageSetup", "pageSetup", "hasFrameOrDialogAncestor");
    public static final IlvDiagrammerAction printPreview = new MethodAction("Diagrammer.Action.PrintPreview", "printPreview", "hasFrameOrDialogAncestor");
    public static final IlvDiagrammerAction setPrintArea = new MethodAction("Diagrammer.Action.SetPrintArea", "setPrintArea", null);
    public static final IlvDiagrammerAction clearPrintArea = new MethodAction("Diagrammer.Action.ClearPrintArea", "clearPrintArea", null);
    public static final IlvDiagrammerAction printWithDialog = new PrintWithDialog();
    public static final IlvDiagrammerAction printWithoutDialog = new PrintWithoutDialog();
    public static final IlvDiagrammerAction printToBitmap = new PrintToBitmap();
    public static final IlvDiagrammerAction callBuilder = new CallBuilder();
    public static final IlvDiagrammerAction grid = new MethodToggleAction("Diagrammer.Action.Grid", "gridVisible", null);
    public static final IlvDiagrammerAction gridSpacing = new GridSpacingAction();
    public static final IlvDiagrammerAction alignLeft = new AlignAction("Diagrammer.Action.AlignLeft", "alignLeft", false);
    public static final IlvDiagrammerAction alignRight = new AlignAction("Diagrammer.Action.AlignRight", "alignRight", false);
    public static final IlvDiagrammerAction alignTop = new AlignAction("Diagrammer.Action.AlignTop", "alignTop", false);
    public static final IlvDiagrammerAction alignBottom = new AlignAction("Diagrammer.Action.AlignBottom", "alignBottom", false);
    public static final IlvDiagrammerAction alignHorizontalCenter = new AlignAction("Diagrammer.Action.AlignHorizontalCenter", "alignHorizontalCenter", false);
    public static final IlvDiagrammerAction alignVerticalCenter = new AlignAction("Diagrammer.Action.AlignVerticalCenter", "alignVerticalCenter", false);
    public static final IlvDiagrammerAction distributeHorizontally = new AlignAction("Diagrammer.Action.DistributeHorizontally", "distributeHorizontally", true);
    public static final IlvDiagrammerAction distributeVertically = new AlignAction("Diagrammer.Action.DistributeVertically", "distributeVertically", true);
    public static final IlvDiagrammerAction createNode = new IlvDiagrammerPaletteAction(false);
    public static final IlvDiagrammerAction createLink = new IlvDiagrammerPaletteAction(true);
    private ResourceBundle c;
    private static JFileChooser d;
    private static boolean e;
    private static File f;
    private static FileFilter g;
    private static File h;
    private static HashMap i;
    private static UpdateActionsListener j;
    private static MyComponentContextListener k;

    protected IlvDiagrammerAction(String string, ResourceBundle resourceBundle) {
        super(string, resourceBundle);
    }

    protected IlvDiagrammerAction(String string) {
        this(string, null);
    }

    protected ResourceBundle getDefaultResourceBundle() {
        if (this.c == null) {
            this.c = IlvResourceUtil.getBundle((String)"actions", IlvDiagrammerAction.class, (Locale)IlvLocaleUtil.getCurrentLocale());
        }
        return this.c;
    }

    protected final boolean isEnabled(Component component) throws Exception {
        if (component == null || component instanceof IlvDiagrammer) {
            return this.isEnabled((IlvDiagrammer)component);
        }
        return false;
    }

    protected final boolean isSelected(Component component) throws Exception {
        if (component == null || component instanceof IlvDiagrammer) {
            return this.isSelected((IlvDiagrammer)component);
        }
        return false;
    }

    public final void perform(ActionEvent actionEvent, Component component) throws Exception {
        if (component == null || component instanceof IlvDiagrammer) {
            this.perform(actionEvent, (IlvDiagrammer)component);
        }
    }

    protected final void update(Component component) {
        if (component == null || component instanceof IlvDiagrammer) {
            this.update((IlvDiagrammer)component);
        }
    }

    public abstract void perform(ActionEvent var1, IlvDiagrammer var2) throws Exception;

    public void call(IlvDiagrammer ilvDiagrammer) {
        super.call((Component)ilvDiagrammer);
    }

    protected abstract boolean isEnabled(IlvDiagrammer var1) throws Exception;

    protected boolean isSelected(IlvDiagrammer ilvDiagrammer) throws Exception {
        return false;
    }

    protected static String getString(ResourceBundle resourceBundle, String string) {
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            try {
                ResourceBundle resourceBundle2 = IlvResourceUtil.getBundle((String)"actions", IlvDiagrammerAction.class, (Locale)IlvLocaleUtil.getCurrentLocale());
                return resourceBundle2.getString(string);
            }
            catch (MissingResourceException missingResourceException2) {
                return string;
            }
        }
    }

    protected void update(IlvDiagrammer ilvDiagrammer) {
        super.update((Component)ilvDiagrammer);
    }

    public void setHandler(Handler handler) {
        super.setHandler((ComponentAction.Handler)handler);
    }

    private static boolean b(IlvDiagrammer ilvDiagrammer, String string) throws Exception {
        if (ilvDiagrammer == null) {
            return false;
        }
        if (string == null) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "& ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (((Boolean)ilvDiagrammer.getClass().getMethod(string2, new Class[0]).invoke((Object)ilvDiagrammer, new Object[0])).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private static URL c(URL uRL) throws MalformedURLException {
        return IlvDiagrammerAction.a(uRL, IlvDiagrammerProject.suffix);
    }

    private static URL d(URL uRL) throws MalformedURLException {
        return IlvDiagrammerAction.a(uRL, ".xml");
    }

    private static URL a(URL uRL, String string) throws MalformedURLException {
        String string2 = uRL.toExternalForm();
        int n = string2.lastIndexOf(46);
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        string2 = string2 + string;
        return new URL(string2);
    }

    public static JFileChooser getActionFileChooser() {
        if (d == null && !e) {
            d = new JFileChooser();
        }
        return d;
    }

    public static File getFileChooserDirectory() {
        return f;
    }

    public static void setFileChooserDirectory(File file) {
        f = file;
    }

    public static File getDefaultSelectedFile() {
        return h;
    }

    public static void setDefaultSelectedFile(File file) {
        h = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL chooseFile(Component component, boolean bl, ResourceBundle resourceBundle, String string, String[] stringArray, String[] stringArray2) throws MalformedURLException {
        Object object;
        String[] stringArray3;
        if (!e) {
            try {
                String string2;
                Object object2;
                Object object3;
                int n;
                if (d == null) {
                    d = new JFileChooser();
                }
                d.setDialogType(bl ? 1 : 0);
                if (f == null) {
                    f = new File(".");
                }
                d.setCurrentDirectory(f);
                d.setDialogTitle(IlvDiagrammerAction.getString(resourceBundle, string));
                d.resetChoosableFileFilters();
                FileFilter fileFilter = null;
                if (g != null) {
                    FileFilter fileFilter2 = d.getAcceptAllFileFilter();
                    if (g.getDescription().equals(fileFilter2.getDescription())) {
                        fileFilter = fileFilter2;
                    }
                }
                for (n = 0; n < stringArray.length; ++n) {
                    object3 = stringArray[n];
                    object2 = IlvDiagrammerAction.getString(resourceBundle, stringArray2[n]);
                    Object[] objectArray = new Object[1];
                    objectArray[0] = "*" + (String)object3;
                    string2 = MessageFormat.format((String)object2, objectArray);
                    MyFileFilter myFileFilter = new MyFileFilter((String)object3, string2);
                    d.addChoosableFileFilter(myFileFilter);
                    if (g == null || !g.getDescription().equals(((FileFilter)myFileFilter).getDescription())) continue;
                    fileFilter = myFileFilter;
                }
                if (fileFilter != null) {
                    d.setFileFilter(fileFilter);
                }
                if ((n = bl ? d.showSaveDialog(component) : d.showOpenDialog(component)) == 0) {
                    f = d.getCurrentDirectory();
                    g = d.getFileFilter();
                    object3 = d.getSelectedFile();
                    if (((File)object3).getName().indexOf(46) < 0 && (object2 = d.getFileFilter()) instanceof MyFileFilter) {
                        string2 = ((MyFileFilter)object2).getSuffix();
                        object3 = new File(((File)object3).getPath() + string2);
                    }
                    return IlvURLUtil.convertFileToAbsoluteURL((File)object3);
                }
                return null;
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                e = true;
            }
            catch (SecurityException securityException) {
                e = true;
            }
        }
        Object object4 = null;
        ComponentContext componentContext = ComponentContextManager.getSingleton().getContext(component);
        if (componentContext != null) {
            int n;
            stringArray3 = (String[])componentContext.getProperty("applet");
            if (stringArray3 != null && (n = ((String)(object = ((URL)(object4 = stringArray3.getDocumentBase())).toExternalForm())).lastIndexOf(47)) > 0 && n < ((String)object).length() - 1) {
                object = ((String)object).substring(0, n + 1);
                object4 = new URL((String)object);
            }
        }
        stringArray3 = null;
        if (object4 != null) {
            try {
                InputStream inputStream;
                try {
                    object = new URL((URL)object4, "diagrammer_files.txt");
                    inputStream = IlvURLUtil.openStream((URL)object);
                }
                catch (Exception exception) {
                    object = new URL((URL)object4, "data/diagrammer_files.txt");
                    inputStream = IlvURLUtil.openStream((URL)object);
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                try {
                    String string3;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    while ((string3 = bufferedReader.readLine()) != null) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (!string3.endsWith(stringArray[i])) continue;
                            arrayList.add(string3);
                        }
                    }
                }
                finally {
                    inputStream.close();
                }
                if (arrayList.size() > 0) {
                    stringArray3 = arrayList.toArray(new String[0]);
                }
                object4 = object;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = (String)IlvSwingUtil.showInputDialog((Component)component, (Object)(stringArray3 != null ? resourceBundle.getString("Diagrammer.Action.URLDialog.ChooseMessage") : resourceBundle.getString("Diagrammer.Action.URLDialog.EnterMessage")), (String)(stringArray3 != null ? resourceBundle.getString("Diagrammer.Action.URLDialog.ChooseTitle") : resourceBundle.getString("Diagrammer.Action.URLDialog.EnterTitle")), (int)-1, null, (Object[])stringArray3, null);
        if (object != null && ((String)object).trim().length() > 0) {
            try {
                if (object4 != null) {
                    return new URL((URL)object4, (String)object);
                }
                return new URL((String)object);
            }
            catch (MalformedURLException malformedURLException) {
                ComponentAction.error((Component)component, (ResourceBundle)resourceBundle, (String)"Diagrammer.Action.URLDialog.InvalidURL", (Object[])new Object[]{object}, (Throwable)malformedURLException);
                return null;
            }
        }
        return null;
    }

    public static ErrorHandler getErrorHandler() {
        ComponentAction.ErrorHandler errorHandler = ComponentAction.getActionErrorHandler();
        if (errorHandler instanceof ErrorAdapter) {
            return ((ErrorAdapter)errorHandler).getHandler();
        }
        if (errorHandler instanceof ErrorHandler) {
            return (ErrorHandler)errorHandler;
        }
        return null;
    }

    public static void setErrorHandler(ErrorHandler errorHandler) {
        ComponentAction.setActionErrorHandler((ComponentAction.ErrorHandler)new ErrorAdapter(errorHandler));
    }

    public static void addStatusListener(StatusListener statusListener) {
        StatusAdapter statusAdapter = new StatusAdapter(statusListener);
        i.put(statusListener, statusAdapter);
        ComponentAction.addStatusListener((ComponentAction.StatusListener)statusAdapter);
    }

    public static void removeStatusListener(StatusListener statusListener) {
        StatusAdapter statusAdapter = (StatusAdapter)i.get(statusListener);
        if (statusAdapter != null) {
            ComponentAction.removeStatusListener((ComponentAction.StatusListener)statusAdapter);
            i.remove(statusListener);
        }
    }

    public static void updateActions(Component component, IlvDiagrammer ilvDiagrammer) {
        ComponentAction.updateActions((Component)component, (Component)ilvDiagrammer);
    }

    public static void addActionToUpdate(IlvDiagrammerAction ilvDiagrammerAction) {
        ComponentAction.addActionToUpdate((ComponentAction)ilvDiagrammerAction);
    }

    public static void removeActionToUpdate(IlvDiagrammerAction ilvDiagrammerAction) {
        ComponentAction.removeActionToUpdate((ComponentAction)ilvDiagrammerAction);
    }

    static /* synthetic */ void a(JComponent jComponent) {
        ComponentAction.delayedUpdateActions((JComponent)jComponent);
    }

    static /* synthetic */ void b(JComponent jComponent) {
        ComponentAction.delayedUpdateActions((JComponent)jComponent);
    }

    static {
        e = false;
        i = new HashMap();
        j = new UpdateActionsListener();
        k = new MyComponentContextListener();
        ComponentAction.setActionErrorHandler(null);
        ComponentContextManager.getSingleton().addComponentContextListener(null, (ComponentContextListener)k);
    }

    private static class MyComponentContextListener
    implements ComponentContextListener {
        private MyComponentContextListener() {
        }

        public void targetChanged(ComponentContextEvent componentContextEvent) {
            Object object;
            IlvDiagrammer ilvDiagrammer;
            IlvDiagrammer ilvDiagrammer2 = ilvDiagrammer = componentContextEvent.getOldTarget() instanceof IlvDiagrammer ? (IlvDiagrammer)componentContextEvent.getOldTarget() : null;
            if (ilvDiagrammer != null) {
                ilvDiagrammer.getEngine().getGrapher().removeManagerTreeContentChangedListener((ManagerContentChangedListener)j);
                ilvDiagrammer.getEngine().getGrapher().removeManagerTreeSelectionListener((ManagerSelectionListener)j);
                ilvDiagrammer.getEngine().removePropertyChangeListener(j);
                ilvDiagrammer.getView().removeInteractorListener(j);
                ilvDiagrammer.getView().removeTransformerListener(j);
                object = (ModelUpdateActionsListener)ilvDiagrammer.getClientProperty(IlvDiagrammerAction.b);
                if (object != null) {
                    ilvDiagrammer.getEngine().getModel().removeSDMPropertyChangeListener((SDMPropertyChangeListener)object);
                    ilvDiagrammer.putClientProperty(IlvDiagrammerAction.b, null);
                }
            }
            Object object2 = object = componentContextEvent.getNewTarget() instanceof IlvDiagrammer ? (IlvDiagrammer)componentContextEvent.getNewTarget() : null;
            if (object != null) {
                ((IlvDiagrammer)object).getEngine().getGrapher().addManagerTreeContentChangedListener((ManagerContentChangedListener)j);
                ((IlvDiagrammer)object).getEngine().getGrapher().addManagerTreeSelectionListener((ManagerSelectionListener)j);
                ((IlvDiagrammer)object).getEngine().addPropertyChangeListener(j);
                ((IlvDiagrammer)object).getView().addInteractorListener(j);
                ((IlvDiagrammer)object).getView().addTransformerListener(j);
                ModelUpdateActionsListener modelUpdateActionsListener = new ModelUpdateActionsListener((IlvDiagrammer)object);
                ((JComponent)object).putClientProperty(IlvDiagrammerAction.b, modelUpdateActionsListener);
                ((IlvDiagrammer)object).getEngine().getModel().addSDMPropertyChangeListener(modelUpdateActionsListener);
            }
        }
    }

    private static class ModelUpdateActionsListener
    implements SDMPropertyChangeListener {
        private IlvDiagrammer a;

        public ModelUpdateActionsListener(IlvDiagrammer ilvDiagrammer) {
            this.a = ilvDiagrammer;
        }

        @Override
        public void propertyChanged(SDMPropertyChangeEvent sDMPropertyChangeEvent) {
            if (!sDMPropertyChangeEvent.isAdjusting()) {
                IlvDiagrammerAction.b(this.a);
            }
        }
    }

    private static class UpdateActionsListener
    implements ManagerContentChangedListener,
    ManagerSelectionListener,
    PropertyChangeListener,
    InteractorListener,
    TransformerListener {
        private UpdateActionsListener() {
        }

        public void contentsChanged(ManagerContentChangedEvent managerContentChangedEvent) {
            IlvSDMEngine ilvSDMEngine;
            if (!(managerContentChangedEvent.isAdjusting() && managerContentChangedEvent.getType() != 32 || (ilvSDMEngine = IlvSDMEngine.getSDMEngine((IlvGrapher)managerContentChangedEvent.getManager())) == null)) {
                this.a(ilvSDMEngine);
            }
        }

        public void selectionChanged(ManagerSelectionChangedEvent managerSelectionChangedEvent) {
            IlvSDMEngine ilvSDMEngine;
            if ((!managerSelectionChangedEvent.isAdjusting() || managerSelectionChangedEvent.isAdjustmentEnd()) && (ilvSDMEngine = IlvSDMEngine.getSDMEngine((IlvGrapher)managerSelectionChangedEvent.getManager())) != null) {
                this.a(ilvSDMEngine);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() instanceof IlvSDMEngine) {
                IlvDiagrammer ilvDiagrammer;
                this.a((IlvSDMEngine)propertyChangeEvent.getSource());
                Container container = ((IlvSDMEngine)propertyChangeEvent.getSource()).getReferenceView().getParent();
                if (container != null && (ilvDiagrammer = IlvDiagrammer.getCurrentDiagrammer(container)) != null) {
                    if ("model".equals(propertyChangeEvent.getPropertyName())) {
                        IlvSDMModel ilvSDMModel = (IlvSDMModel)propertyChangeEvent.getOldValue();
                        IlvSDMModel ilvSDMModel2 = (IlvSDMModel)propertyChangeEvent.getOldValue();
                        ModelUpdateActionsListener modelUpdateActionsListener = (ModelUpdateActionsListener)ilvDiagrammer.getClientProperty(IlvDiagrammerAction.b);
                        if (ilvSDMModel != null) {
                            ilvSDMModel.removeSDMPropertyChangeListener(modelUpdateActionsListener);
                        }
                        if (ilvSDMModel2 != null) {
                            ilvSDMModel2.addSDMPropertyChangeListener(modelUpdateActionsListener);
                        }
                    }
                }
            }
        }

        public void interactorChanged(InteractorChangedEvent interactorChangedEvent) {
            IlvSDMEngine ilvSDMEngine = IlvSDMEngine.getSDMEngine((IlvGrapher)interactorChangedEvent.getManagerView().getManager());
            if (ilvSDMEngine != null) {
                this.a(ilvSDMEngine);
            }
        }

        public void transformerChanged(TransformerChangedEvent transformerChangedEvent) {
            IlvSDMEngine ilvSDMEngine = IlvSDMEngine.getSDMEngine((IlvGrapher)((IlvManagerView)transformerChangedEvent.getSource()).getManager());
            if (ilvSDMEngine != null) {
                this.a(ilvSDMEngine);
            }
        }

        private void a(IlvSDMEngine ilvSDMEngine) {
            Container container = ilvSDMEngine.getReferenceView().getParent();
            if (container instanceof JComponent) {
                IlvDiagrammerAction.a((JComponent)container);
            }
        }
    }

    private static class StatusAdapter
    implements ComponentAction.StatusListener {
        private StatusListener a;

        public StatusAdapter(StatusListener statusListener) {
            this.a = statusListener;
        }

        public void actionDescribed(ComponentAction.StatusEvent statusEvent) {
            this.a.actionDescribed(new StatusEvent(statusEvent.getSource()));
        }

        public void actionStarted(ComponentAction.StatusEvent statusEvent) {
            this.a.actionStarted(new StatusEvent(statusEvent.getSource()));
        }

        public void actionFinished(ComponentAction.StatusEvent statusEvent) {
            this.a.actionFinished(new StatusEvent(statusEvent.getSource()));
        }
    }

    public static interface StatusListener {
        public void actionDescribed(StatusEvent var1);

        public void actionStarted(StatusEvent var1);

        public void actionFinished(StatusEvent var1);
    }

    public static class StatusEvent
    extends ComponentAction.StatusEvent {
        public StatusEvent(Object object) {
            super(object);
        }

        public IlvDiagrammerAction getDiagrammerAction() {
            return (IlvDiagrammerAction)this.getComponentAction();
        }
    }

    private static class ErrorAdapter
    implements ErrorHandler {
        private ErrorHandler a;

        public ErrorAdapter(ErrorHandler errorHandler) {
            this.a = errorHandler;
        }

        public ErrorHandler getHandler() {
            return this.a;
        }

        public void error(Component component, ResourceBundle resourceBundle, String string, Object[] objectArray, Throwable throwable) {
            if (throwable instanceof IlvMapsNotAvailableException) {
                string = "Diagrammer.MapsNotAvailable";
                throwable = null;
            }
            if (this.a != null) {
                this.a.error(component, resourceBundle, string, objectArray, throwable);
            } else {
                String string2 = IlvDiagrammerAction.getString(resourceBundle, string);
                if (objectArray != null) {
                    string2 = MessageFormat.format(string2, objectArray);
                }
                IlvSwingUtil.showErrorDialog((Component)component, (String)string2, (Throwable)throwable);
            }
        }
    }

    public static interface ErrorHandler
    extends ComponentAction.ErrorHandler {
    }

    private static class CallBuilder
    extends IlvDiagrammerAction {
        private boolean a;
        private boolean b;

        public CallBuilder() {
            super("Diagrammer.Action.CallBuilder");
        }

        @Override
        public void perform(ActionEvent actionEvent, final IlvDiagrammer ilvDiagrammer) throws Exception {
            if (ilvDiagrammer.isModified() || ilvDiagrammer.getProject() == null || ilvDiagrammer.getProject().getProjectURL() == null) {
                save.actionPerformed(actionEvent);
                if (ilvDiagrammer.isModified() || ilvDiagrammer.getProject() == null || ilvDiagrammer.getProject().getProjectURL() == null) {
                    return;
                }
            }
            Class<?> clazz = Class.forName("ilog.views.builder.IlvBuilder");
            Class[] classArray = new Class[3];
            classArray[0] = String.class;
            classArray[1] = String.class;
            classArray[2] = PropertyChangeListener.class;
            Method method = clazz.getMethod("callBuilder", classArray);
            method.invoke(null, ilvDiagrammer.getProject().getProjectURL().toExternalForm(), null, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    try {
                        ilvDiagrammer.setDataFile((URL)propertyChangeEvent.getNewValue());
                    }
                    catch (Exception exception) {
                        ComponentAction.error((Component)ilvDiagrammer, (ResourceBundle)CallBuilder.this.getResourceBundle(), (String)"Diagrammer.CannotOpenFile", (Object[])new Object[]{propertyChangeEvent.getNewValue()}, (Throwable)exception);
                    }
                }
            });
        }

        @Override
        protected boolean isEnabled(IlvDiagrammer ilvDiagrammer) throws Exception {
            if (!this.b) {
                try {
                    Class.forName("ilog.views.builder.IlvBuilder");
                    this.a = true;
                }
                catch (Exception exception) {
                    this.a = false;
                }
                this.b = true;
            }
            return this.a && ilvDiagrammer != null;
        }
    }

    private static class PrintWithDialog
    extends PrintWithoutDialog
    implements IlvDiagrammer.PrinterExceptionHandler {
        public PrintWithDialog() {
            super("Diagrammer.Action.PrintWithDialog");
        }

        @Override
        public void perform(ActionEvent actionEvent, IlvDiagrammer ilvDiagrammer) throws Exception {
            ilvDiagrammer.print(true, true, this);
        }

        @Override
        public void exceptionThrown(PrinterException printerException, IlvDiagrammer ilvDiagrammer) {
            ComponentAction.error((Component)ilvDiagrammer, (ResourceBundle)this.getResourceBundle(), (String)"Diagrammer.Action.Print.Error", null, (Throwable)printerException);
        }
    }

    private static class PrintWithoutDialog
    extends IlvDiagrammerAction {
        public PrintWithoutDialog() {
            super("Diagrammer.Action.PrintWithoutDialog");
        }

        protected PrintWithoutDialog(String string) {
            super(string);
        }

        @Override
        public void perform(ActionEvent actionEvent, IlvDiagrammer ilvDiagrammer) throws Exception {
            ilvDiagrammer.print(false, true, null);
        }

        @Override
        protected boolean isEnabled(IlvDiagrammer ilvDiagrammer) throws Exception {
            return ilvDiagrammer != null && ilvDiagrammer.canPrint();
        }
    }

    private static class HelpAction
    extends EnabledAction {
        public HelpAction() {
            super("Diagrammer.Action.Help");
        }

        @Override
        public void perform(ActionEvent actionEvent, IlvDiagrammer ilvDiagrammer) throws Exception {
            boolean bl = false;
            try {
                ResourceBundle resourceBundle = this.getResourceBundle();
                this.popBrowser(resourceBundle.getString("Diagrammer.Action.Help.File"), resourceBundle.getString("Diagrammer.Action.Help.Fallback.File"), resourceBundle.getString("Diagrammer.Action.Help.File.Missing"), resourceBundle.getString("Diagrammer.Action.Help.Failed"));
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!bl) {
                JOptionPane.showMessageDialog(ilvDiagrammer, new JLabel(IlvDiagrammerAction.getString(this.getResourceBundle(), "Diagrammer.HelpMessage")), IlvDiagrammerAction.getString(this.getResourceBundle(), "Diagrammer.HelpDialogTitle"), 1);
            }
        }

        protected void popBrowser(String string, String string2, String string3, String string4) throws IlvDiagrammerException {
            File file = null;
            try {
                if (string != null && string.trim().length() > 0) {
                    file = new File(string.trim()).getAbsoluteFile();
                }
                if (file == null || !file.exists()) {
                    string = string2;
                    file = new File(string.trim()).getAbsoluteFile();
                }
                if (!file.exists()) {
                    Object[] objectArray = new Object[]{file};
                    String string5 = MessageFormat.format(string3, objectArray);
                    throw new IlvDiagrammerException(string5);
                }
                IlvPopUserBrowser.pop((File)file);
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[]{file};
                String string6 = MessageFormat.format(string4, objectArray);
                String string7 = exception.getMessage();
                if (string7 == null || string7.trim().length() < 1) {
                    string7 = exception.toString();
                }
                throw new IlvDiagrammerException(string6 + '\n' + string7);
            }
        }
    }

    private static class AboutAction
    extends EnabledAction {
        public AboutAction() {
            super("Diagrammer.Action.About");
        }

        @Override
        public void perform(ActionEvent actionEvent, IlvDiagrammer ilvDiagrammer) throws Exception {
            IlvSplash.showSplashDialog((Component)ilvDiagrammer, null, null, null, (String)"Rogue Wave JViews Diagrammer", (String)((String)((AbstractAction)((Object)this)).getValue(IlvDiagrammerAction.ABOUT_APPLICATION_NAME)), (int)IlvDiagrammerProduct.getVersion(), (int)IlvDiagrammerProduct.getMinorVersion(), (int)IlvDiagrammerProduct.getSubMinorVersion(), (int)IlvDiagrammerProduct.getPatchLevel(), (long)IlvDiagrammerProduct.getBuildNumber(), (int)IlvDiagrammerProduct.getReleaseDate());
        }
    }

    private static class ExitAction
    extends EnabledAction {
        public ExitAction() {
            super("Diagrammer.Action.Exit");
        }

        @Override
        public void perform(ActionEvent actionEvent, IlvDiagrammer ilvDiagrammer) throws Exception {
            System.exit(0);
        }
    }

    private static class EnabledAction
    extends IlvDiagrammerAction {
        public EnabledAction(String string) {
            super(string);
        }

        @Override
        public void perform(ActionEvent actionEvent, IlvDiagrammer ilvDiagrammer) throws Exception {
        }

        @Override
        protected boolean isEnabled(IlvDiagrammer ilvDiagrammer) throws Exception {
            return true;
        }
    }

    private static class Close
    extends IlvDiagrammerAction {
        public Close() {
            super("Diagrammer.Action.Close");
        }

        @Override
        protected boolean isEnabled(IlvDiagrammer ilvDiagrammer) throws Exception {
            return ilvDiagrammer != null;
        }

        @Override
        public final void perform(ActionEvent actionEvent, IlvDiagrammer ilvDiagrammer) throws Exception {
        }
    }

    private static class New
    extends IlvDiagrammerAction {
        public New(ResourceBundle resourceBundle) {
            super("Diagrammer.Action.New", resourceBundle);
        }

        public New() {
            super("Diagrammer.Action.New");
        }

        @Override
        protected boolean isEnabled(IlvDiagrammer ilvDiagrammer) throws Exception {
            return true;
        }

        @Override
        public final void perform(ActionEvent actionEvent, IlvDiagrammer ilvDiagrammer) throws Exception {
            ilvDiagrammer.setDataFile(null);
        }
    }

    private static class Open
    extends XMLFileAction {
        public Open() {
            super("Diagrammer.Action.Open", null, false);
        }

        @Override
        protected final void openOrSave(ActionEvent actionEvent, IlvDiagrammer ilvDiagrammer, URL uRL) throws Exception {
            URL uRL2;
            if (ilvDiagrammer == null || !ilvDiagrammer.isEmpty()) {
                _new.actionPerformed(actionEvent);
                ilvDiagrammer = IlvDiagrammer.getCurrentDiagrammer((Component)actionEvent.getSource());
            }
            if (!(uRL2 = IlvDiagrammerAction.c(uRL)).equals(uRL)) {
                try {
                    IlvURLUtil.openStream((URL)uRL2);
                    int n = JOptionPane.showOptionDialog(ilvDiagrammer, IlvDiagrammerAction.getString(this.getResourceBundle(), "Diagrammer.Action.OpenProjectLabel"), IlvDiagrammerAction.getString(this.getResourceBundle(), "Diagrammer.Action.OpenProjectTitle"), 1, 3, null, null, null);
                    ComponentAction.fireActionStarted((Action)((Object)this));
                    if (n == 0) {
                        uRL = uRL2;
                    } else if (n == 2) {
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                ilvDiagrammer.setDataFile(uRL);
            }
            catch (IlvDiagrammerException ilvDiagrammerException) {
                if (ilvDiagrammerException.getCause() instanceof IlvNotAnSDMDocumentException) {
                    ComponentAction.error((Component)ilvDiagrammer, (ResourceBundle)this.getResourceBundle(), (String)"Diagrammer.Action.NotADiagrammerDocument", (Object[])new Object[]{uRL}, null);
                    ComponentAction.fireActionStarted((Action)((Object)this));
                }
                throw ilvDiagrammerException;
            }
        }

        @Override
        protected final boolean isEnabled(IlvDiagrammer ilvDiagrammer) {
            return true;
        }
    }

    private static class MyFileFilter
    extends FileFilter {
        private String a;
        private String b;

        public MyFileFilter(String string, String string2) {
            this.a = string;
            this.b = string2;
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(this.a);
        }

        @Override
        public String getDescription() {
            return this.b;
        }

        public String getSuffix() {
            return this.a;
        }
    }

    private static class PrintToBitmap
    extends FileAction {
        public PrintToBitmap() {
            String[] stringArray = new String[2];
            stringArray[0] = ".png";
            stringArray[1] = ".jpg";
            String[] stringArray2 = new String[2];
            stringArray2[0] = "Diagrammer.Action.PNGFilesDescription";
            stringArray2[1] = "Diagrammer.Action.JPEGFilesDescription";
            super("Diagrammer.Action.PrintToImage", null, true, stringArray, stringArray2);
        }

        @Override
        public void perform(ActionEvent actionEvent, IlvDiagrammer ilvDiagrammer) throws Exception {
            Object object;
            URL uRL = ilvDiagrammer.getDataFile();
            String string = null;
            if (uRL != null) {
                if ("file".equals(uRL.getProtocol())) {
                    object = IlvURLUtil.convertFileURLToFilename((URL)uRL);
                    int n = ((String)object).lastIndexOf(".");
                    if (n > 0) {
                        object = ((String)object).substring(0, n);
                    }
                    string = (String)object + ".jpg";
                }
            }
            if (string == null) {
                string = "noname.jpg";
            }
            object = IlvDiagrammerAction.getActionFileChooser().getSelectedFile();
            IlvDiagrammerAction.setDefaultSelectedFile(new File(string));
            super.perform(actionEvent, ilvDiagrammer);
            IlvDiagrammerAction.setDefaultSelectedFile((File)object);
        }

        @Override
        protected void openOrSave(ActionEvent actionEvent, IlvDiagrammer ilvDiagrammer, URL uRL) throws Exception {
            if (!uRL.getProtocol().equals("file")) {
                throw new IllegalArgumentException("Bitmaps cannot be saved to URLs");
            }
            if (IlvURLUtil.convertFileURLToFile((URL)uRL).exists()) {
                int n = JOptionPane.showOptionDialog(ilvDiagrammer, IlvDiagrammerAction.getString(this.getResourceBundle(), "Diagrammer.Action.FileExistsLabel"), IlvDiagrammerAction.getString(this.getResourceBundle(), "Diagrammer.Action.FileExistsTitle"), 0, 2, null, null, null);
                if (n == 1) {
                    return;
                }
            }
            ilvDiagrammer.printToBitmap(IlvURLUtil.convertFileURLToFile((URL)uRL));
        }

        @Override
        protected boolean isEnabled(IlvDiagrammer ilvDiagrammer) throws Exception {
            if (ilvDiagrammer == null || !ilvDiagrammer.canPrint()) {
                return false;
            }
            try {
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    securityManager.checkWrite("foo.png");
                }
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }
    }

    private static class SaveAction
    extends IlvDiagrammerAction {
        public SaveAction() {
            super("Diagrammer.Action.Save");
        }

        @Override
        public void perform(ActionEvent actionEvent, IlvDiagrammer ilvDiagrammer) throws Exception {
            if (ilvDiagrammer.getDataSource() != null && ilvDiagrammer.getDataSource().supportsWrite()) {
                IlvDiagrammerProject ilvDiagrammerProject;
                ilvDiagrammer.writeData();
                if (ilvDiagrammer.getClientProperty(IlvDiagrammerAction.a) != null && (ilvDiagrammerProject = ilvDiagrammer.getProject()) == null) {
                    int n = JOptionPane.showOptionDialog(ilvDiagrammer, IlvDiagrammerAction.getString(this.getResourceBundle(), "Diagrammer.Action.SaveProjectLabel"), IlvDiagrammerAction.getString(this.getResourceBundle(), "Diagrammer.Action.SaveProjectTitle"), 0, 3, null, null, null);
                    ComponentAction.fireActionStarted((Action)((Object)this));
                    if (n == 0) {
                        ilvDiagrammerProject = new IlvDiagrammerProject();
                        ilvDiagrammerProject.setDataSource(ilvDiagrammer.getDataSource());
                        ilvDiagrammerProject.setStyleSheet(ilvDiagrammer.getStyleSheet());
                        URL uRL = IlvDiagrammerAction.c(ilvDiagrammer.getDataFile());
                        ilvDiagrammer.writeProjectFile(uRL);
                        ilvDiagrammer.setProject(ilvDiagrammerProject, false);
                        ilvDiagrammer.putClientProperty(IlvDiagrammerAction.a, null);
                    }
                }
            } else {
                saveAs.actionPerformed(actionEvent);
            }
        }

        @Override
        protected boolean isEnabled(IlvDiagrammer ilvDiagrammer) throws Exception {
            if (ilvDiagrammer == null || !ilvDiagrammer.isModified()) {
                return false;
            }
            try {
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    securityManager.checkWrite("foo.txt");
                }
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }
    }

    private static class SaveAsAction
    extends XMLFileAction {
        public SaveAsAction() {
            super("Diagrammer.Action.SaveAs", null, true);
        }

        @Override
        protected void openOrSave(ActionEvent actionEvent, IlvDiagrammer ilvDiagrammer, URL uRL) throws Exception {
            if (uRL.getProtocol().equals("file") && IlvURLUtil.convertFileURLToFile((URL)uRL).exists()) {
                int n = JOptionPane.showOptionDialog(ilvDiagrammer, IlvDiagrammerAction.getString(this.getResourceBundle(), "Diagrammer.Action.FileExistsLabel"), IlvDiagrammerAction.getString(this.getResourceBundle(), "Diagrammer.Action.FileExistsTitle"), 0, 2, null, null, null);
                ComponentAction.fireActionStarted((Action)((Object)this));
                if (n == 1) {
                    return;
                }
            }
            if (uRL.getPath().endsWith(IlvDiagrammerProject.suffix)) {
                URL uRL2 = uRL;
                URL uRL3 = IlvDiagrammerAction.d(uRL2);
                IlvDiagrammerProject ilvDiagrammerProject = ilvDiagrammer.getProject();
                if (ilvDiagrammerProject == null) {
                    ilvDiagrammerProject = new IlvDiagrammerProject();
                    IlvDiagrammerDataSource ilvDiagrammerDataSource = ilvDiagrammer.getDataSource();
                    if (ilvDiagrammerDataSource instanceof IlvXMLDataSource) {
                        ((IlvXMLDataSource)ilvDiagrammerDataSource).setDataURL(uRL3);
                    } else {
                        ilvDiagrammerDataSource = new IlvXMLDataSource();
                        ((IlvXMLDataSource)ilvDiagrammerDataSource).setDataURL(uRL3);
                    }
                    ilvDiagrammerProject.setDataSource(ilvDiagrammerDataSource);
                    ilvDiagrammerProject.setStyleSheet(ilvDiagrammer.getStyleSheet());
                    ilvDiagrammer.assignProject(ilvDiagrammerProject);
                }
                ilvDiagrammer.writeProjectFile(uRL2);
                ilvDiagrammer.writeDataFile(uRL3);
            } else {
                ilvDiagrammer.writeDataFile(IlvURLUtil.convertFileURLToFilename((URL)uRL));
                IlvDiagrammerProject ilvDiagrammerProject = ilvDiagrammer.getProject();
                if (ilvDiagrammerProject != null) {
                    URL uRL4 = IlvDiagrammerAction.c(ilvDiagrammer.getDataFile());
                    ilvDiagrammerProject.write(uRL4);
                } else if (ilvDiagrammer.getClientProperty(IlvDiagrammerAction.a) != null && (ilvDiagrammerProject = ilvDiagrammer.getProject()) == null) {
                    int n = JOptionPane.showOptionDialog(ilvDiagrammer, IlvDiagrammerAction.getString(this.getResourceBundle(), "Diagrammer.Action.SaveProjectLabel"), IlvDiagrammerAction.getString(this.getResourceBundle(), "Diagrammer.Action.SaveProjectTitle"), 0, 3, null, null, null);
                    ComponentAction.fireActionStarted((Action)((Object)this));
                    if (n == 0) {
                        ilvDiagrammerProject = new IlvDiagrammerProject();
                        ilvDiagrammerProject.setDataSource(ilvDiagrammer.getDataSource());
                        ilvDiagrammerProject.setStyleSheet(ilvDiagrammer.getStyleSheet());
                        URL uRL5 = IlvDiagrammerAction.c(ilvDiagrammer.getDataFile());
                        ilvDiagrammerProject.write(uRL5);
                        ilvDiagrammer.setProject(ilvDiagrammerProject, false);
                        ilvDiagrammer.putClientProperty(IlvDiagrammerAction.a, null);
                    }
                }
            }
        }
    }

    private static class OpenStyleSheetAction
    extends CSSFileAction {
        public OpenStyleSheetAction() {
            super("Diagrammer.Action.OpenStyleSheet", null, false);
        }

        @Override
        protected void openOrSave(ActionEvent actionEvent, IlvDiagrammer ilvDiagrammer, URL uRL) throws Exception {
            ilvDiagrammer.setStyleSheet(uRL);
            ilvDiagrammer.putClientProperty(IlvDiagrammerAction.a, Boolean.TRUE);
        }
    }

    private static class ReadAction
    extends XMLFileAction {
        public ReadAction() {
            super("Diagrammer.Action.Read", null, false);
        }

        @Override
        protected void openOrSave(ActionEvent actionEvent, IlvDiagrammer ilvDiagrammer, URL uRL) throws Exception {
            ilvDiagrammer.setDataFile(uRL);
        }
    }

    private static abstract class CSSFileAction
    extends FileAction {
        public CSSFileAction(String string, ResourceBundle resourceBundle, boolean bl) {
            String[] stringArray = new String[1];
            stringArray[0] = ".css";
            String[] stringArray2 = new String[1];
            stringArray2[0] = "Diagrammer.Action.CSSFilesDescription";
            super(string, resourceBundle, bl, stringArray, stringArray2);
        }
    }

    static abstract class XMLFileAction
    extends FileAction {
        public XMLFileAction(String string, ResourceBundle resourceBundle, boolean bl) {
            String[] stringArray = new String[2];
            stringArray[0] = ".xml";
            stringArray[1] = IlvDiagrammerProject.suffix;
            String[] stringArray2 = new String[2];
            stringArray2[0] = "Diagrammer.Action.XMLFilesDescription";
            stringArray2[1] = "Diagrammer.Action.ProjectFilesDescription";
            super(string, resourceBundle, bl, stringArray, stringArray2);
        }
    }

    public static abstract class FileAction
    extends IlvDiagrammerAction {
        private boolean a;
        private String[] b;
        private String[] c;

        public FileAction(String string, ResourceBundle resourceBundle, boolean bl, String[] stringArray, String[] stringArray2) {
            super(string, resourceBundle);
            this.a = bl;
            this.b = stringArray;
            this.c = stringArray2;
        }

        public void setSuffixes(String[] stringArray) {
            this.b = stringArray;
        }

        public void setDescriptionKeys(String[] stringArray) {
            this.c = stringArray;
        }

        @Override
        public void perform(ActionEvent actionEvent, IlvDiagrammer ilvDiagrammer) throws Exception {
            URL uRL;
            Component component;
            if (ilvDiagrammer != null) {
                component = ilvDiagrammer;
            } else if (actionEvent.getSource() instanceof Component) {
                component = (Component)actionEvent.getSource();
                if (component instanceof JComponent && ((JComponent)component).getRootPane() != null) {
                    component = ((JComponent)component).getRootPane();
                }
            } else {
                component = null;
            }
            if (h != null) {
                d.setSelectedFile(h);
            }
            if ((uRL = IlvDiagrammerAction.chooseFile(component, this.a, this.getResourceBundle(), this.getPrefix() + ".FileChooserTitle", this.b, this.c)) != null) {
                try {
                    ComponentAction.fireActionStarted((Action)((Object)this));
                    this.openOrSave(actionEvent, ilvDiagrammer, uRL);
                }
                catch (Exception exception) {
                    ComponentAction.error((Component)ilvDiagrammer, (ResourceBundle)this.getResourceBundle(), (String)(this.a ? "Diagrammer.CannotSaveFile" : "Diagrammer.CannotOpenFile"), (Object[])new Object[]{uRL.toString()}, (Throwable)exception);
                    ComponentAction.fireActionStarted((Action)((Object)this));
                }
            }
        }

        protected abstract void openOrSave(ActionEvent var1, IlvDiagrammer var2, URL var3) throws Exception;

        @Override
        protected boolean isEnabled(IlvDiagrammer ilvDiagrammer) throws Exception {
            if (ilvDiagrammer == null) {
                return false;
            }
            if (this.a) {
                try {
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        securityManager.checkWrite("foo.txt");
                    }
                }
                catch (Exception exception) {
                    return false;
                }
            }
            return true;
        }
    }

    private static class MethodToggleAction
    extends ToggleAction {
        private String a;
        private String b;

        MethodToggleAction(String string, String string2, String string3) {
            super(string);
            this.a = Character.toUpperCase(string2.charAt(0)) + string2.substring(1);
            this.b = string3;
        }

        @Override
        protected boolean isEnabled(IlvDiagrammer ilvDiagrammer) throws Exception {
            return IlvDiagrammerAction.b(ilvDiagrammer, this.b);
        }

        @Override
        protected boolean isSelected(IlvDiagrammer ilvDiagrammer) throws Exception {
            if (ilvDiagrammer == null) {
                return false;
            }
            Method method = ilvDiagrammer.getClass().getMethod("is" + this.a, new Class[0]);
            return (Boolean)method.invoke((Object)ilvDiagrammer, new Object[0]);
        }

        @Override
        protected void setSelected(IlvDiagrammer ilvDiagrammer, boolean bl) throws Exception {
            if (ilvDiagrammer != null) {
                Method method = ilvDiagrammer.getClass().getMethod("set" + this.a, Boolean.TYPE);
                method.invoke((Object)ilvDiagrammer, bl);
            }
        }
    }

    public static abstract class ToggleAction
    extends IlvDiagrammerAction {
        public ToggleAction(String string) {
            super(string);
        }

        public ToggleAction(String string, ResourceBundle resourceBundle) {
            super(string, resourceBundle);
        }

        public boolean isSelectable() {
            return true;
        }

        @Override
        public void perform(ActionEvent actionEvent, IlvDiagrammer ilvDiagrammer) throws Exception {
            boolean bl = this.isSelected();
            bl = !bl;
            this.setSelected(ilvDiagrammer, bl);
            this.setSelected(bl);
        }

        @Override
        protected abstract boolean isSelected(IlvDiagrammer var1) throws Exception;

        protected abstract void setSelected(IlvDiagrammer var1, boolean var2) throws Exception;
    }

    private static class GridSpacingAction
    extends IlvDiagrammerAction {
        public GridSpacingAction() {
            super("Diagrammer.Action.GridSpacing");
        }

        @Override
        public void perform(ActionEvent actionEvent, IlvDiagrammer ilvDiagrammer) throws Exception {
            float f = ilvDiagrammer.getGrid().getHorizontalSpacing();
            Object object = IlvSwingUtil.showInputDialog((Component)ilvDiagrammer, (Object)this.getResourceBundle().getString("Diagrammer.Action.GridSpacingDialog.Message"), (String)this.getResourceBundle().getString("Diagrammer.Action.GridSpacingDialog.Title"), (int)-1, null, null, (Object)String.valueOf(f));
            if (object instanceof String) {
                try {
                    f = Float.parseFloat((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    f = 0.0f;
                }
                if (f > 0.0f) {
                    ilvDiagrammer.getGrid().setHorizontalSpacing(f);
                    ilvDiagrammer.getGrid().setVerticalSpacing(f);
                    ilvDiagrammer.repaint();
                } else {
                    ComponentAction.error((Component)ilvDiagrammer, (ResourceBundle)this.getResourceBundle(), (String)"Diagrammer.Action.GridSpacingDialog.InvalidSpacing", (Object[])new Object[]{object}, null);
                }
            }
        }

        @Override
        protected boolean isEnabled(IlvDiagrammer ilvDiagrammer) throws Exception {
            return ilvDiagrammer != null;
        }
    }

    private static class AlignAction
    extends MethodAction {
        private boolean a;

        public AlignAction(String string, String string2, boolean bl) {
            super(string, string2, null);
            this.a = bl;
        }

        @Override
        protected boolean isEnabled(IlvDiagrammer ilvDiagrammer) throws Exception {
            if (ilvDiagrammer == null) {
                return false;
            }
            if (this.a) {
                return ilvDiagrammer.canDistribute();
            }
            return ilvDiagrammer.canAlign();
        }
    }

    private static class MethodAction
    extends IlvDiagrammerAction {
        private String a;
        private String b;

        public MethodAction(String string, String string2, String string3) {
            super(string);
            this.a = string2;
            this.b = string3;
        }

        @Override
        protected boolean isEnabled(IlvDiagrammer ilvDiagrammer) throws Exception {
            return IlvDiagrammerAction.b(ilvDiagrammer, this.b);
        }

        @Override
        public void perform(ActionEvent actionEvent, IlvDiagrammer ilvDiagrammer) throws Exception {
            ilvDiagrammer.getClass().getMethod(this.a, new Class[0]).invoke((Object)ilvDiagrammer, new Object[0]);
        }
    }

    public static class Handler
    extends ComponentAction.Handler {
        public void perform(IlvDiagrammerAction ilvDiagrammerAction, IlvDiagrammer ilvDiagrammer, ActionEvent actionEvent) throws Exception {
            super.perform((ComponentAction)ilvDiagrammerAction, (Component)ilvDiagrammer, actionEvent);
        }

        public void update(IlvDiagrammerAction ilvDiagrammerAction, IlvDiagrammer ilvDiagrammer) throws Exception {
            super.update((ComponentAction)ilvDiagrammerAction, (Component)ilvDiagrammer);
        }

        public final void perform(ComponentAction componentAction, Component component, ActionEvent actionEvent) throws Exception {
            if (componentAction instanceof IlvDiagrammerAction && (component == null || component instanceof IlvDiagrammer)) {
                this.perform((IlvDiagrammerAction)componentAction, (IlvDiagrammer)component, actionEvent);
            }
        }

        public final void update(ComponentAction componentAction, Component component) throws Exception {
            if (componentAction instanceof IlvDiagrammerAction && (component == null || component instanceof IlvDiagrammer)) {
                this.update((IlvDiagrammerAction)componentAction, (IlvDiagrammer)component);
            }
        }
    }
}

