/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v10g;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.FailGroupOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;

public class ASMDiskOraclev10g
extends AbstractStorageObjectOracle {
    private FailGroupOraclev10g failGroup;
    private String searchString = "";
    private int size = 0;
    private static Set sizeMeasurementUnitSet = null;
    private String sizeMeasurementUnit = SIZE_MEASUREMENT_UNITS[2];
    private static final String[] SIZE_MEASUREMENT_UNITS = new String[]{"", "K", "M", "G", "T", "P", "E"};
    private String force = "NO";
    public static final String TYPE_NAME = "ASMDisk";

    public void setForce(String value) {
        if (ConstantsOracle.checkYesNo(value)) {
            this.force = value;
            this.fireDataFieldChange();
        }
    }

    public String getForce() {
        return this.force;
    }

    public String getSizeMeasurementUnit() {
        return this.sizeMeasurementUnit;
    }

    public void setSizeMeasurementUnit(String value) {
        if (this.checkSizeMeasurementUnits(value)) {
            this.sizeMeasurementUnit = value;
            this.fireDataFieldChange();
        }
    }

    private boolean checkSizeMeasurementUnits(String value) {
        if (sizeMeasurementUnitSet == null) {
            sizeMeasurementUnitSet = new HashSet();
            sizeMeasurementUnitSet.addAll(Arrays.asList(ASMDiskOraclev10g.getSizeMeasurementUnitStates()));
        }
        return sizeMeasurementUnitSet.contains(value);
    }

    public static String[] getSizeMeasurementUnitStates() {
        return SIZE_MEASUREMENT_UNITS;
    }

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "ASM";
    }

    public FailGroupOraclev10g getFailGroup() {
        return this.failGroup;
    }

    public void setFailGroup(FailGroupOraclev10g failGroup) {
        this.failGroup = failGroup;
        if (failGroup != null) {
            this.setPAC_Element(failGroup.getPAC_Element());
        }
        this.fireDataFieldChange();
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
        this.fireDataFieldChange();
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
        this.fireDataFieldChange();
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        ASMDiskOraclev10g asmDisk = null;
        StorageObject stObject = (StorageObject)((StorageDesignOraclev10g)targetDesign).getASMDiskSet().getByName(this.getName());
        if (stObject != null) {
            if (!this.isRawObject()) {
                asmDisk = (ASMDiskOraclev10g)stObject;
            }
        } else {
            asmDisk = ((StorageDesignOraclev10g)targetDesign).getASMDiskSet().createASMDisk();
        }
        if (asmDisk != null) {
            asmDisk.setName(this.getName());
            asmDisk.setSearchString(this.getSearchString());
            asmDisk.setSize(this.getSize());
            asmDisk.setSizeMeasurementUnit(this.getSizeMeasurementUnit());
            asmDisk.setForce(this.getForce());
            asmDisk.setComment(this.getComment());
            asmDisk.setRawObject(false);
        }
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }
}

