/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.sxml;

import java.util.Collection;
import java.util.List;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;

public class ObjToSXMLTransformer {
    private static final String OPEN_CHAR_SLASH = "</";
    private static final String OPEN_CHAR = "<";
    private static final String CLOSE_CHAR = ">";
    private static final String NEWLINE_OPENCHAR_SLASH = "\n</";
    private static final String OPENCHAR_SLASH = "</";
    private static final String NEWLINE_OPENCHAR = "\n<";
    private static final String NEWLINE = "\n";
    private static final String EQUAL_SLASH = "=\"";
    private static final String XMLNS_AND_VERSION = " xmlns=\"http://xmlns.oracle.com/ku\" version=\"1.0\"";
    public static String TABLE = "TABLE";
    public static String SCHEMA = "SCHEMA";
    public static String NAME = "NAME";
    public static String RELATIONAL_TABLE = "RELATIONAL_TABLE";
    public static String COL_LIST = "COL_LIST";
    public static String COL_LIST_ITEM = "COL_LIST_ITEM";
    public static String DATATYPE = "DATATYPE";
    public static String NOT_NULL = "NOT_NULL";
    public static String PRECISION = "PRECISION";
    public static String SCALE = "SCALE";
    public static String LENGTH = "LENGTH";
    public static String CHECK_CONSTRAINT_LIST = "CHECK_CONSTRAINT_LIST";
    public static String CHECK_CONSTRAINT_LIST_ITEM = "CHECK_CONSTRAINT_LIST_ITEM";
    public static String CONDITION = "CONDITION";
    public static String PRIMARY_KEY_CONSTRAINT_LIST = "PRIMARY_KEY_CONSTRAINT_LIST";
    public static String PRIMARY_KEY_CONSTRAINT_LIST_ITEM = "PRIMARY_KEY_CONSTRAINT_LIST_ITEM";
    public static String UNIQUE_KEY_CONSTRAINT_LIST = "UNIQUE_KEY_CONSTRAINT_LIST";
    public static String UNIQUE_KEY_CONSTRAINT_LIST_ITEM = "UNIQUE_KEY_CONSTRAINT_LIST_ITEM";
    public static String USING_INDEX = "USING_INDEX";
    public static String INDEX_ATTRIBUTES = "INDEX_ATTRIBUTES";
    public static String STORAGE = "STORAGE";
    public static String PCTFREE = "PCTFREE";
    public static String INITRANS = "INITRANS";
    public static String INITIAL = "INITIAL";
    public static String NEXT = "NEXT";
    public static String MINEXTENTS = "MINEXTENTS";
    public static String MAXEXTENTS = "MAXEXTENTS";
    public static String PCTINCREASE = "PCTINCREASE";
    public static String FREELISTS = "FREELISTS";
    public static String FREELIST_GROUPS = "FREELIST_GROUPS";
    public static String BUFFER_POOL = "BUFFER_POOL";
    public static String FLASH_CACHE = "FLASH_CACHE";
    public static String CELL_FLASH_CACHE = "CELL_FLASH_CACHE";
    public static String TABLESPACE = "TABLESPACE";
    public static String LOGGING = "LOGGING";
    public static String FOREIGN_KEY_CONSTRAINT_LIST = "FOREIGN_KEY_CONSTRAINT_LIST";
    public static String FOREIGN_KEY_CONSTRAINT_LIST_ITEM = "FOREIGN_KEY_CONSTRAINT_LIST_ITEM";
    public static String REFERENCES = "REFERENCES";
    public static String NOVALIDATE = "NOVALIDATE";
    public static String PHYSICAL_PROPERTIES = "PHYSICAL_PROPERTIES";
    public static String HEAP_TABLE = "HEAP_TABLE";
    public static String INDEX_ORGANIZED_TABLE = "INDEX_ORGANIZED_TABLE";
    public static String VIRTUAL = "VIRTUAL";

    public static void main(String[] args) {
    }

    public static void tarnsformTable(Table table, StringBuilder sb) {
        ObjToSXMLTransformer.addFirstRow(TABLE, sb);
        ObjToSXMLTransformer.addElement(SCHEMA, table.getSchema(), sb, 1);
        ObjToSXMLTransformer.addElement(NAME, table.getName(), sb, 1);
        ObjToSXMLTransformer.addOpenTag(RELATIONAL_TABLE, sb, 1);
        ObjToSXMLTransformer.addColumns(table, sb);
        ObjToSXMLTransformer.addCheckConstraints(table, sb);
        ObjToSXMLTransformer.addPrimaryKey(table, sb);
        ObjToSXMLTransformer.addUniqueConstraints(table, sb);
        ObjToSXMLTransformer.addFKeys(table, sb);
        ObjToSXMLTransformer.addCloseTag(RELATIONAL_TABLE, sb, 1);
        sb.append(NEWLINE);
        ObjToSXMLTransformer.addCloseTag(TABLE, sb);
    }

    private static void addColumns(Table table, StringBuilder sb) {
        Collection colc = table.getElementsCollection();
        if (colc.size() > 0) {
            ObjToSXMLTransformer.addOpenTag(COL_LIST, sb, 2);
            for (ContainedObjectWithDomain co : colc) {
                ObjToSXMLTransformer.addColumn(co, sb);
            }
            ObjToSXMLTransformer.addCloseTag(COL_LIST, sb, 2);
        }
    }

    private static void addColumnsUsage(ContainerObject co, StringBuilder sb, int bl) {
        Collection colc = co.getElementsCollection();
        if (colc.size() > 0) {
            ObjToSXMLTransformer.addOpenTag(COL_LIST, sb, bl);
            for (ContainedObjectWithDomain cob : colc) {
                ObjToSXMLTransformer.addColumnUsage(cob, sb, bl + 1);
            }
            ObjToSXMLTransformer.addCloseTag(COL_LIST, sb, bl);
        }
    }

    private static void addCheckConstraints(Table table, StringBuilder sb) {
        if (table.hasColumnOrTableCheckConstraints()) {
            String name;
            String constr;
            ObjToSXMLTransformer.addOpenTag(CHECK_CONSTRAINT_LIST, sb, 2);
            for (Column col : table.getElementsCollection()) {
                constr = col.getConstraintsText();
                if (constr == null || constr.isEmpty()) continue;
                ObjToSXMLTransformer.addOpenTag(CHECK_CONSTRAINT_LIST_ITEM, sb, 3);
                name = col.getConstraintName();
                if (name != null && !name.isEmpty()) {
                    ObjToSXMLTransformer.addElement(NAME, name, sb, 4);
                }
                ObjToSXMLTransformer.addElement(CONDITION, constr, sb, 4);
                ObjToSXMLTransformer.addCloseTag(CHECK_CONSTRAINT_LIST_ITEM, sb, 3);
            }
            for (TableLevelConstraint tc : table.getCheckConstraints()) {
                constr = tc.getRule();
                if (constr.isEmpty()) continue;
                ObjToSXMLTransformer.addOpenTag(CHECK_CONSTRAINT_LIST_ITEM, sb, 3);
                name = tc.getName();
                if (name != null && !name.isEmpty()) {
                    ObjToSXMLTransformer.addElement(NAME, name, sb, 4);
                }
                ObjToSXMLTransformer.addElement(CONDITION, constr, sb, 4);
                ObjToSXMLTransformer.addCloseTag(CHECK_CONSTRAINT_LIST_ITEM, sb, 3);
            }
            ObjToSXMLTransformer.addCloseTag(CHECK_CONSTRAINT_LIST, sb, 2);
        }
    }

    private static void addPrimaryKey(Table table, StringBuilder sb) {
        KeyObject pk = table.getPK();
        if (pk != null && pk.getElementsCollection().size() > 0) {
            ObjToSXMLTransformer.addOpenTag(PRIMARY_KEY_CONSTRAINT_LIST, sb, 2);
            ObjToSXMLTransformer.addOpenTag(PRIMARY_KEY_CONSTRAINT_LIST_ITEM, sb, 3);
            ObjToSXMLTransformer.addElement(NAME, pk.getName(), sb, 4);
            ObjToSXMLTransformer.addColumnsUsage(pk, sb, 4);
            ObjToSXMLTransformer.addCloseTag(PRIMARY_KEY_CONSTRAINT_LIST_ITEM, sb, 3);
            ObjToSXMLTransformer.addCloseTag(PRIMARY_KEY_CONSTRAINT_LIST, sb, 2);
        }
    }

    private static void addUniqueConstraints(Table table, StringBuilder sb) {
        List keys = table.getUniqueKeysList();
        if (keys.size() > 0) {
            ObjToSXMLTransformer.addOpenTag(UNIQUE_KEY_CONSTRAINT_LIST, sb, 2);
            for (KeyObject pk : keys) {
                ObjToSXMLTransformer.addOpenTag(UNIQUE_KEY_CONSTRAINT_LIST_ITEM, sb, 3);
                ObjToSXMLTransformer.addElement(NAME, pk.getName(), sb, 4);
                ObjToSXMLTransformer.addColumnsUsage(pk, sb, 4);
                ObjToSXMLTransformer.addCloseTag(UNIQUE_KEY_CONSTRAINT_LIST_ITEM, sb, 3);
            }
            ObjToSXMLTransformer.addCloseTag(UNIQUE_KEY_CONSTRAINT_LIST, sb, 2);
        }
    }

    private static void addFKeys(Table table, StringBuilder sb) {
        List<FKIndexAssociation> keys = table.getFKAssociationsList();
        if (keys.size() > 0) {
            ObjToSXMLTransformer.addOpenTag(FOREIGN_KEY_CONSTRAINT_LIST, sb, 2);
            for (FKIndexAssociation fk : keys) {
                ObjToSXMLTransformer.addOpenTag(FOREIGN_KEY_CONSTRAINT_LIST_ITEM, sb, 3);
                ObjToSXMLTransformer.addElement(NAME, fk.getName(), sb, 4);
                ObjToSXMLTransformer.addColumnsUsage(fk.getLocalFKIndex(), sb, 5);
                FKContainer rt = fk.getRemoteTable();
                if (rt != null) {
                    ObjToSXMLTransformer.addOpenTag(REFERENCES, sb, 4);
                    ObjToSXMLTransformer.addElement(SCHEMA, rt.getSchema(), sb, 5);
                    ObjToSXMLTransformer.addElement(NAME, rt.getName(), sb, 5);
                    ObjToSXMLTransformer.addColumnsUsage(fk.getRemoteIndex(), sb, 6);
                    ObjToSXMLTransformer.addCloseTag(REFERENCES, sb, 4);
                }
                ObjToSXMLTransformer.addCloseTag(FOREIGN_KEY_CONSTRAINT_LIST_ITEM, sb, 3);
            }
            ObjToSXMLTransformer.addCloseTag(FOREIGN_KEY_CONSTRAINT_LIST, sb, 2);
        }
    }

    private static void addPhysicalProperties(Table table, StringBuilder sb) {
        ObjToSXMLTransformer.addOpenTag(PHYSICAL_PROPERTIES, sb);
        ObjToSXMLTransformer.addCloseTag(PHYSICAL_PROPERTIES, sb);
    }

    private static void addColumn(ContainedObjectWithDomain col, StringBuilder sb) {
        String expr;
        ObjToSXMLTransformer.addOpenTag(COL_LIST_ITEM, sb, 3);
        ObjToSXMLTransformer.addElement(NAME, col.getName(), sb, 4);
        Datatype dt = col.getDataType();
        ObjToSXMLTransformer.addElement(DATATYPE, dt.getName(), sb, 4);
        String val = col.getDataTypeSize();
        if (val != null && !val.isEmpty()) {
            String[] vals = val.split(" ");
            ObjToSXMLTransformer.addElement(LENGTH, vals[0], sb, 4);
        } else {
            val = col.getDataTypePrecision();
            if (val != null && !val.isEmpty()) {
                ObjToSXMLTransformer.addElement(PRECISION, val, sb, 4);
                val = col.getDataTypeScale();
                if (val != null && !val.isEmpty()) {
                    ObjToSXMLTransformer.addElement(SCALE, val, sb, 4);
                } else {
                    ObjToSXMLTransformer.addElement(SCALE, "0", sb, 4);
                }
            }
        }
        if (col instanceof Column && ((Column)col).isComputed().booleanValue() && (expr = ((Column)col).getFormulaDesc()) != null && !expr.isEmpty()) {
            ObjToSXMLTransformer.addElement(VIRTUAL, expr, sb, 4);
        }
        if (col.isMandatory()) {
            Column c;
            String nncName;
            ObjToSXMLTransformer.addOpenTag(NOT_NULL, sb, 4);
            if (col instanceof Column && (nncName = (c = (Column)col).getNotNullConstraintName()) != null && !nncName.isEmpty()) {
                ObjToSXMLTransformer.addElement(NAME, nncName, sb, 5);
            }
            ObjToSXMLTransformer.addCloseTag(NOT_NULL, sb, 4);
        }
        ObjToSXMLTransformer.addCloseTag(COL_LIST_ITEM, sb, 3);
    }

    private static void addColumnUsage(ContainedObjectWithDomain col, StringBuilder sb, int bl) {
        ObjToSXMLTransformer.addOpenTag(COL_LIST_ITEM, sb, bl);
        ObjToSXMLTransformer.addElement(NAME, col.getName(), sb, bl + 1);
        ObjToSXMLTransformer.addCloseTag(COL_LIST_ITEM, sb, bl);
    }

    private static void addFirstRow(String name, StringBuilder sb) {
        sb.append(OPEN_CHAR).append(name).append(XMLNS_AND_VERSION).append(CLOSE_CHAR);
    }

    private static void addAttribute(String name, String value, StringBuilder sb) {
        sb.append(' ').append(name).append(EQUAL_SLASH).append(value).append('\"');
    }

    private static void addOpenTag(String tagname, StringBuilder sb) {
        sb.append(OPEN_CHAR).append(tagname).append(CLOSE_CHAR);
    }

    private static void addOpenTag(String tagname, StringBuilder sb, int level) {
        sb.append(NEWLINE);
        for (int k = 0; k < level; ++k) {
            sb.append("   ");
        }
        ObjToSXMLTransformer.addOpenTag(tagname, sb);
    }

    private static void addCloseTag(String tagname, StringBuilder sb) {
        sb.append("</").append(tagname).append('>');
    }

    private static void addCloseTag(String tagname, StringBuilder sb, int level) {
        sb.append(NEWLINE);
        for (int k = 0; k < level; ++k) {
            sb.append("   ");
        }
        ObjToSXMLTransformer.addCloseTag(tagname, sb);
    }

    private static void addElement(String tagname, String value, StringBuilder sb, int level) {
        sb.append(NEWLINE);
        for (int k = 0; k < level; ++k) {
            sb.append("   ");
        }
        ObjToSXMLTransformer.addElement(tagname, value, sb);
    }

    private static void addElement(String tagname, String value, StringBuilder sb) {
        sb.append(OPEN_CHAR).append(tagname).append(CLOSE_CHAR).append(value).append("</").append(tagname).append(CLOSE_CHAR);
    }
}

