/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ReservedWordsOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.util.propertymap.PropertyMap;
import oracle.dbtools.crest.util.string.StringUtilities;

public abstract class PropertiesObject
implements PropertyMap {
    private Map<String, Object> properties = new TreeMap<String, Object>();
    protected List<String> propsList = new ArrayList<String>();
    protected Map<String, String> dataTypes = new HashMap<String, String>();
    protected Map<String, String> defaults = new HashMap<String, String>();
    protected Map<String, String> excludeFromCompare = new HashMap<String, String>();
    protected Map<String, String> names = new HashMap<String, String>();
    protected Map<String, String> caseInsensitive = new HashMap<String, String>();
    protected Map<String, String> propToJsonMap = new HashMap<String, String>();
    protected Map<String, String> jsonToPropMap = new HashMap<String, String>();

    public PropertiesObject() {
        this.initPropsList();
        this.initDataTypes();
        this.initdefaults();
        this.initNames();
        this.initCaseInsensitive();
        this.initPropertyToJsonMap();
    }

    @Override
    public void setProperty(String key, String value) {
        if (key != null) {
            String nkey = this.jsonToPropMap.get(key);
            if (nkey == null) {
                nkey = key;
            }
            if (value == null) {
                this.properties.remove(nkey);
            } else {
                this.properties.put(nkey, value);
            }
        }
    }

    @Override
    public String getProperty(String key) {
        if (key != null) {
            String value = (String)this.properties.get(key);
            if (value == null) {
                value = (String)this.properties.get(key.toLowerCase());
            }
            if (value == null) {
                value = (String)this.properties.get(key.toUpperCase());
            }
            return value;
        }
        return null;
    }

    public String getJsonPropertyName(String prop) {
        String key = this.propToJsonMap.get(prop);
        return key != null ? key : prop;
    }

    public String getInternalPropertyName(String prop) {
        String key = this.jsonToPropMap.get(prop);
        return key != null ? key : prop;
    }

    @Override
    public boolean hasProperty(String key) {
        return this.properties.containsKey(key);
    }

    @Override
    public boolean hasProperty(String key, String value) {
        return this.properties.containsKey(key) && (this.getProperty(key) == null && value == null || value != null && value.equals(this.getProperty(key)));
    }

    @Override
    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    @Override
    public void clearProperties() {
        this.properties.clear();
    }

    @Override
    public Iterator getPropertyNames() {
        return this.properties.keySet().iterator();
    }

    public Collection getPropertyNamesCollection() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    public static void main(String[] args) {
    }

    public List<String> getPropsList() {
        return this.propsList;
    }

    public void initPropsList() {
    }

    public void initDataTypes() {
    }

    public void initdefaults() {
    }

    public void initNames() {
    }

    public void initCaseInsensitive() {
    }

    public void initPropertyToJsonMap() {
        if (this.propToJsonMap.size() > 0) {
            for (Map.Entry<String, String> entry : this.propToJsonMap.entrySet()) {
                this.jsonToPropMap.put(entry.getValue(), entry.getKey());
            }
        }
    }

    public String toString() {
        return this.toJSONString();
    }

    public String toJSONString() {
        return this.toJSONString(true);
    }

    public String toJSONString(boolean excludeNulls) {
        Object res = "{";
        boolean first = true;
        for (String prop : this.propsList) {
            PropertiesObject po;
            String value = this.getProperty(prop);
            String jsonKey = this.getJsonPropertyName(prop);
            if (jsonKey == null) {
                jsonKey = prop.toLowerCase(Locale.ROOT);
            }
            if (value == null) {
                if (excludeNulls) continue;
                if (!first) {
                    res = (String)res + ",";
                } else {
                    first = false;
                }
                res = (String)res + "\n\"" + jsonKey + "\":";
                res = (String)res + "null";
                continue;
            }
            if (!first) {
                res = (String)res + ",";
            } else {
                first = false;
            }
            res = (String)res + "\n\"" + jsonKey + "\":";
            String objType = this.getPropertyDataType(prop);
            if ("PropertiesObject".equalsIgnoreCase(objType) && (po = this.getObjectForProperty(objType)) != null) {
                String json = po.toJSONString(excludeNulls);
                res = (String)res + json;
                continue;
            }
            res = (String)res + "\"" + StringUtilities.encodeAttributeValueJSON(value) + "\"";
        }
        for (CollectionDescriptor cd : this.getCollectionDescriptors()) {
            List list = cd.coll.getCollection();
            String name = cd.name;
            if (name == null || name.isEmpty() || list == null || list.size() <= 0) continue;
            if (!first) {
                res = (String)res + ",";
            } else {
                first = false;
            }
            res = (String)res + "\n\"" + name + "\":[\n";
            boolean ofirst = true;
            for (Object obj : list) {
                if (!ofirst) {
                    res = (String)res + ",";
                } else {
                    ofirst = false;
                }
                if (obj instanceof PropertiesObject) {
                    res = (String)res + ((PropertiesObject)obj).toJSONString(excludeNulls);
                    continue;
                }
                res = (String)res + "\"" + obj.toString() + "\"";
            }
            res = (String)res + "\n]";
        }
        res = (String)res + "\n}";
        return res;
    }

    public static boolean isValidName(String name) {
        return !PropertiesObject.startsWithNumber(name) && !StorageDesign.hasForbiddenCharsOracle(name) && name.indexOf(95) != 0 && name.indexOf(36) != 0 && name.indexOf(35) != 0 && name.indexOf(64) <= -1 && !ReservedWordsOracle.isReservedWord(name);
    }

    public static boolean startsWithNumber(String name) {
        String[] NUMBERS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
        for (int i = 0; i < NUMBERS.length; ++i) {
            if (!name.startsWith(NUMBERS[i])) continue;
            return true;
        }
        return false;
    }

    public static String getFormatedSimpleName(String name) {
        if (name.startsWith("\"") && name.endsWith("\"")) {
            return name;
        }
        if (!PropertiesObject.isValidName(name)) {
            return "\"" + name + "\"";
        }
        return name;
    }

    public String getOwner() {
        return this.getProperty("OWNER");
    }

    public abstract String getName();

    public String getDefaultValue(String propName) {
        return this.defaults.get(propName);
    }

    public String getNameFormatted() {
        String name = this.getName();
        if (name != null && !name.isEmpty()) {
            Object res = "";
            String owner = this.getOwner();
            if (owner != null && !owner.isEmpty()) {
                res = PropertiesObject.getFormatedSimpleName(owner) + ".";
            }
            res = (String)res + PropertiesObject.getFormatedSimpleName(name);
            return res;
        }
        return null;
    }

    public String getPropertyDataType(String propName) {
        String type = this.dataTypes.get(propName);
        if (type == null && (type = this.dataTypes.get(propName.toUpperCase())) == null) {
            type = "";
        }
        return type;
    }

    public abstract boolean isMinimumDefined();

    public void copyProperties(PropertiesObject target) {
        for (String prop : this.getPropsList()) {
            target.setProperty(prop, this.getProperty(prop));
        }
    }

    public List<CollectionDescriptor> getCollectionDescriptors() {
        return Collections.EMPTY_LIST;
    }

    public boolean isNullOrEmpty(String propName) {
        String val = this.getProperty(propName);
        if (val == null) {
            return true;
        }
        return val.isEmpty();
    }

    public PropertiesObject createObjectForCollection(String collName) {
        return null;
    }

    public PropertiesObject getObjectForProperty(String prop) {
        return null;
    }

    public void addObject(String collName, PropertiesObject obj) {
    }

    public void addJSONValue(String collName, JsonValue value) {
    }

    public void validate() {
    }

    public String getFormattedName(String propOwner, String propName) {
        String name = this.getProperty(propName);
        if (name != null && !name.isEmpty()) {
            name = PropertiesObject.getFormatedSimpleName(name);
            Object res = "";
            String owner = this.getProperty(propOwner);
            if (owner != null && !owner.isEmpty()) {
                res = PropertiesObject.getFormatedSimpleName(owner) + ".";
            }
            res = (String)res + name;
            return res;
        }
        return null;
    }

    public boolean isPropertyExcludeFromCompare(String name) {
        return this.excludeFromCompare.get(name) != null;
    }

    public boolean isNameProperty(String propertyName) {
        if (propertyName != null) {
            return this.names.get(propertyName.toUpperCase()) != null;
        }
        return false;
    }

    public boolean isCaseInsensitive(String propName) {
        String val = this.caseInsensitive.get(propName);
        if (val != null) {
            return true;
        }
        val = this.caseInsensitive.get(propName.toUpperCase());
        return this.caseInsensitive.get(propName.toLowerCase()) != null;
    }

    public static interface PropsVarsSynch {
        public void propsToVars();

        public void varsToProps();
    }

    public static class CollectionDescriptor {
        public String name;
        public CollectionMethod coll;
    }

    public static interface CollectionMethod {
        public List getCollection();
    }
}

