/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.jdbc.OracleConnection;

@Restricted(level=Restricted.Level.R4)
public class ShowRelease
implements IShowCommand {
    private static final String[] SHOWRELEASE = new String[]{"rel", "rele", "relea", "releas", "release"};

    @Override
    public String[] getShowAliases() {
        return SHOWRELEASE;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowRelease(conn, ctx, cmd);
        }
        if (ctx.getCurrentConnection() != null && ctx.getCurrentConnection().getClass().getName().equals("oracle.nucleo.jdbc.impl.NucleoConnectionImpl")) {
            ctx.write("Not supported for nucleo connection\n");
            return true;
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return true;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    public boolean doShowRelease(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String banner = DBUtil.getInstance(ctx.getCurrentConnection()).executeOracleReturnOneCol("select * from v$version where banner like '%Oracle%'", null);
        if (banner != null) {
            String[] first = banner.split(" ");
            String regex = "[0-9]*\\.[0-9]*\\.[0-9]*\\.[0-9]*\\.[0-9]*";
            String result = null;
            try {
                for (String s : first) {
                    if (!Pattern.matches(regex, s)) continue;
                    result = s;
                }
            }
            catch (PatternSyntaxException e) {
                ctx.write(e.getLocalizedMessage() + "\n");
            }
            if (result != null) {
                String[] many = result.split("\\.");
                try {
                    int release = new Integer(many[0]) * 100000000;
                    release += new Integer(many[1]) * 1000000;
                    release += new Integer(many[2]) * 10000;
                    release += new Integer(many[3]) * 100;
                    ctx.write(Messages.getString("SHOWRELEASE") + " " + (release += new Integer(many[4]).intValue()) + "\n");
                }
                catch (NumberFormatException e) {
                    ctx.write(e.getLocalizedMessage() + "\n");
                }
            }
        }
        return true;
    }
}

