/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

@Restricted(level=Restricted.Level.NONE)
public class SetGetPage
extends AForAllStmtsCommand {
    public static final String GET_PAGE = "declare nlns number;\n buf_t varchar2(32767);\n lines htp.htbuf_arr;\nbegin\n  nlns := ?;\n  OWA.GET_PAGE(lines, nlns);\n  if (nlns < 1) then\n   buf_t := null;\n  else \n   for i in 1..nlns loop\n     buf_t:=buf_t||lines(i);\n   end loop;\n  end if;\n  ? := buf_t; ? := nlns;\nend;";
    public static final String RESET = "begin  DBMS_SESSION.reset_package;  end;";
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_GETPAGE;

    public SetGetPage() {
        super(m_cmdStmtSubType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doEndWatcher(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        block19: {
            if (ctx != null && ctx.getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(ctx.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
                return;
            }
            if (cmd.getStmtClass() == SQLCommand.StmtType.G_C_PLSQL || cmd.getStmtClass() == SQLCommand.StmtType.G_C_SQL) {
                try {
                    ctx.getOutputStream().write(ctx.stringToByteArrayForScriptRunnerNonStatic(this.getDataBlock(conn)));
                    if (cmd.getStmtClass() != SQLCommand.StmtType.G_C_PLSQL && cmd.getStmtClass() != SQLCommand.StmtType.G_C_SQL) break block19;
                    CallableStatement stmt = null;
                    try {
                        stmt = conn.prepareCall(RESET);
                        stmt.execute();
                    }
                    catch (SQLException e) {
                        try {
                            ctx.getOutputStream().write(ctx.stringToByteArrayForScriptRunnerNonStatic("Error calling DBMS_SESSION.reset_package;:" + e.getMessage()));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    finally {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                    }
                }
                catch (IOException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                }
                catch (SQLException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDataBlock(Connection conn) throws SQLException {
        String parcialContent;
        Statement cs = null;
        try {
            int maxLines;
            int nlines = maxLines = 128;
            cs = conn.prepareCall(GET_PAGE);
            cs.setInt(1, nlines);
            cs.registerOutParameter(2, 12);
            cs.registerOutParameter(3, -5);
            cs.execute();
            nlines = cs.getInt(3);
            if (nlines < maxLines && nlines < 1) {
                String string = "";
                return string;
            }
            parcialContent = cs.getString(2);
        }
        finally {
            if (cs != null) {
                try {
                    cs.close();
                }
                catch (Exception exception) {}
            }
        }
        return parcialContent;
    }
}

